/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBVertexBlend {
    public static final int GL_MAX_VERTEX_UNITS_ARB = 34468;
    public static final int GL_ACTIVE_VERTEX_UNITS_ARB = 34469;
    public static final int GL_WEIGHT_SUM_UNITY_ARB = 34470;
    public static final int GL_VERTEX_BLEND_ARB = 34471;
    public static final int GL_MODELVIEW0_ARB = 5888;
    public static final int GL_MODELVIEW1_ARB = 34058;
    public static final int GL_MODELVIEW2_ARB = 34594;
    public static final int GL_MODELVIEW3_ARB = 34595;
    public static final int GL_MODELVIEW4_ARB = 34596;
    public static final int GL_MODELVIEW5_ARB = 34597;
    public static final int GL_MODELVIEW6_ARB = 34598;
    public static final int GL_MODELVIEW7_ARB = 34599;
    public static final int GL_MODELVIEW8_ARB = 34600;
    public static final int GL_MODELVIEW9_ARB = 34601;
    public static final int GL_MODELVIEW10_ARB = 34602;
    public static final int GL_MODELVIEW11_ARB = 34603;
    public static final int GL_MODELVIEW12_ARB = 34604;
    public static final int GL_MODELVIEW13_ARB = 34605;
    public static final int GL_MODELVIEW14_ARB = 34606;
    public static final int GL_MODELVIEW15_ARB = 34607;
    public static final int GL_MODELVIEW16_ARB = 34608;
    public static final int GL_MODELVIEW17_ARB = 34609;
    public static final int GL_MODELVIEW18_ARB = 34610;
    public static final int GL_MODELVIEW19_ARB = 34611;
    public static final int GL_MODELVIEW20_ARB = 34612;
    public static final int GL_MODELVIEW21_ARB = 34613;
    public static final int GL_MODELVIEW22_ARB = 34614;
    public static final int GL_MODELVIEW23_ARB = 34615;
    public static final int GL_MODELVIEW24_ARB = 34616;
    public static final int GL_MODELVIEW25_ARB = 34617;
    public static final int GL_MODELVIEW26_ARB = 34618;
    public static final int GL_MODELVIEW27_ARB = 34619;
    public static final int GL_MODELVIEW28_ARB = 34620;
    public static final int GL_MODELVIEW29_ARB = 34621;
    public static final int GL_MODELVIEW30_ARB = 34622;
    public static final int GL_MODELVIEW31_ARB = 34623;
    public static final int GL_CURRENT_WEIGHT_ARB = 34472;
    public static final int GL_WEIGHT_ARRAY_TYPE_ARB = 34473;
    public static final int GL_WEIGHT_ARRAY_STRIDE_ARB = 34474;
    public static final int GL_WEIGHT_ARRAY_SIZE_ARB = 34475;
    public static final int GL_WEIGHT_ARRAY_POINTER_ARB = 34476;
    public static final int GL_WEIGHT_ARRAY_ARB = 34477;
    public final long WeightfvARB;
    public final long WeightbvARB;
    public final long WeightubvARB;
    public final long WeightsvARB;
    public final long WeightusvARB;
    public final long WeightivARB;
    public final long WeightuivARB;
    public final long WeightdvARB;
    public final long WeightPointerARB;
    public final long VertexBlendARB;

    public ARBVertexBlend(FunctionProvider provider) {
        this.WeightfvARB = provider.getFunctionAddress("glWeightfvARB");
        this.WeightbvARB = provider.getFunctionAddress("glWeightbvARB");
        this.WeightubvARB = provider.getFunctionAddress("glWeightubvARB");
        this.WeightsvARB = provider.getFunctionAddress("glWeightsvARB");
        this.WeightusvARB = provider.getFunctionAddress("glWeightusvARB");
        this.WeightivARB = provider.getFunctionAddress("glWeightivARB");
        this.WeightuivARB = provider.getFunctionAddress("glWeightuivARB");
        this.WeightdvARB = provider.getFunctionAddress("glWeightdvARB");
        this.WeightPointerARB = provider.getFunctionAddress("glWeightPointerARB");
        this.VertexBlendARB = provider.getFunctionAddress("glVertexBlendARB");
    }

    public static ARBVertexBlend getInstance() {
        return GL.getCapabilities().__ARBVertexBlend;
    }

    static ARBVertexBlend create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_vertex_blend")) {
            return null;
        }
        ARBVertexBlend funcs = new ARBVertexBlend(provider);
        boolean supported = Checks.checkFunctions(funcs.WeightfvARB, funcs.WeightbvARB, funcs.WeightubvARB, funcs.WeightsvARB, funcs.WeightusvARB, funcs.WeightivARB, funcs.WeightuivARB, funcs.WeightdvARB, funcs.WeightPointerARB, funcs.VertexBlendARB);
        return GL.checkExtension("GL_ARB_vertex_blend", funcs, supported);
    }

    public static native void nglWeightfvARB(int var0, long var1, long var3);

    public static void nglWeightfvARB(int size, long weights) {
        long __functionAddress = ARBVertexBlend.getInstance().WeightfvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBVertexBlend.nglWeightfvARB(size, weights, __functionAddress);
    }

    public static void glWeightfARB(int size, ByteBuffer weights) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)weights, size << 2);
        }
        ARBVertexBlend.nglWeightfvARB(size, MemoryUtil.memAddress(weights));
    }

    public static void glWeightARB(FloatBuffer weights) {
        ARBVertexBlend.nglWeightfvARB(weights.remaining(), MemoryUtil.memAddress(weights));
    }

    public static native void nglWeightbvARB(int var0, long var1, long var3);

    public static void nglWeightbvARB(int size, long weights) {
        long __functionAddress = ARBVertexBlend.getInstance().WeightbvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBVertexBlend.nglWeightbvARB(size, weights, __functionAddress);
    }

    public static void glWeightbARB(int size, ByteBuffer weights) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)weights, size);
        }
        ARBVertexBlend.nglWeightbvARB(size, MemoryUtil.memAddress(weights));
    }

    public static void glWeightbARB(ByteBuffer weights) {
        ARBVertexBlend.nglWeightbvARB(weights.remaining(), MemoryUtil.memAddress(weights));
    }

    public static native void nglWeightubvARB(int var0, long var1, long var3);

    public static void nglWeightubvARB(int size, long weights) {
        long __functionAddress = ARBVertexBlend.getInstance().WeightubvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBVertexBlend.nglWeightubvARB(size, weights, __functionAddress);
    }

    public static void glWeightubARB(int size, ByteBuffer weights) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)weights, size);
        }
        ARBVertexBlend.nglWeightubvARB(size, MemoryUtil.memAddress(weights));
    }

    public static void glWeightubARB(ByteBuffer weights) {
        ARBVertexBlend.nglWeightubvARB(weights.remaining(), MemoryUtil.memAddress(weights));
    }

    public static native void nglWeightsvARB(int var0, long var1, long var3);

    public static void nglWeightsvARB(int size, long weights) {
        long __functionAddress = ARBVertexBlend.getInstance().WeightsvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBVertexBlend.nglWeightsvARB(size, weights, __functionAddress);
    }

    public static void glWeightsARB(int size, ByteBuffer weights) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)weights, size << 1);
        }
        ARBVertexBlend.nglWeightsvARB(size, MemoryUtil.memAddress(weights));
    }

    public static void glWeightARB(ShortBuffer weights) {
        ARBVertexBlend.nglWeightsvARB(weights.remaining(), MemoryUtil.memAddress(weights));
    }

    public static native void nglWeightusvARB(int var0, long var1, long var3);

    public static void nglWeightusvARB(int size, long weights) {
        long __functionAddress = ARBVertexBlend.getInstance().WeightusvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBVertexBlend.nglWeightusvARB(size, weights, __functionAddress);
    }

    public static void glWeightusARB(int size, ByteBuffer weights) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)weights, size << 1);
        }
        ARBVertexBlend.nglWeightusvARB(size, MemoryUtil.memAddress(weights));
    }

    public static void glWeightuARB(ShortBuffer weights) {
        ARBVertexBlend.nglWeightusvARB(weights.remaining(), MemoryUtil.memAddress(weights));
    }

    public static native void nglWeightivARB(int var0, long var1, long var3);

    public static void nglWeightivARB(int size, long weights) {
        long __functionAddress = ARBVertexBlend.getInstance().WeightivARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBVertexBlend.nglWeightivARB(size, weights, __functionAddress);
    }

    public static void glWeightiARB(int size, ByteBuffer weights) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)weights, size << 2);
        }
        ARBVertexBlend.nglWeightivARB(size, MemoryUtil.memAddress(weights));
    }

    public static void glWeightARB(IntBuffer weights) {
        ARBVertexBlend.nglWeightivARB(weights.remaining(), MemoryUtil.memAddress(weights));
    }

    public static native void nglWeightuivARB(int var0, long var1, long var3);

    public static void nglWeightuivARB(int size, long weights) {
        long __functionAddress = ARBVertexBlend.getInstance().WeightuivARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBVertexBlend.nglWeightuivARB(size, weights, __functionAddress);
    }

    public static void glWeightuiARB(int size, ByteBuffer weights) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)weights, size << 2);
        }
        ARBVertexBlend.nglWeightuivARB(size, MemoryUtil.memAddress(weights));
    }

    public static void glWeightuARB(IntBuffer weights) {
        ARBVertexBlend.nglWeightuivARB(weights.remaining(), MemoryUtil.memAddress(weights));
    }

    public static native void nglWeightdvARB(int var0, long var1, long var3);

    public static void nglWeightdvARB(int size, long weights) {
        long __functionAddress = ARBVertexBlend.getInstance().WeightdvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBVertexBlend.nglWeightdvARB(size, weights, __functionAddress);
    }

    public static void glWeightdARB(int size, ByteBuffer weights) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)weights, size << 3);
        }
        ARBVertexBlend.nglWeightdvARB(size, MemoryUtil.memAddress(weights));
    }

    public static void glWeightARB(DoubleBuffer weights) {
        ARBVertexBlend.nglWeightdvARB(weights.remaining(), MemoryUtil.memAddress(weights));
    }

    public static native void nglWeightPointerARB(int var0, int var1, int var2, long var3, long var5);

    public static void nglWeightPointerARB(int size, int type, int stride, long pointer) {
        long __functionAddress = ARBVertexBlend.getInstance().WeightPointerARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBVertexBlend.nglWeightPointerARB(size, type, stride, pointer, __functionAddress);
    }

    public static void glWeightPointerARB(int size, int type, int stride, ByteBuffer pointer) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        ARBVertexBlend.nglWeightPointerARB(size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glWeightPointerARB(int size, int type, int stride, long pointerOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34964, true);
        }
        ARBVertexBlend.nglWeightPointerARB(size, type, stride, pointerOffset);
    }

    public static void glWeightPointerARB(int size, int stride, FloatBuffer pointer) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        ARBVertexBlend.nglWeightPointerARB(size, 5126, stride, MemoryUtil.memAddress(pointer));
    }

    public static native void nglVertexBlendARB(int var0, long var1);

    public static void glVertexBlendARB(int count) {
        long __functionAddress = ARBVertexBlend.getInstance().VertexBlendARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBVertexBlend.nglVertexBlendARB(count, __functionAddress);
    }
}

