/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL41;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBVertexAttrib64Bit {
    public static final int GL_DOUBLE_VEC2 = 36860;
    public static final int GL_DOUBLE_VEC3 = 36861;
    public static final int GL_DOUBLE_VEC4 = 36862;
    public static final int GL_DOUBLE_MAT2 = 36678;
    public static final int GL_DOUBLE_MAT3 = 36679;
    public static final int GL_DOUBLE_MAT4 = 36680;
    public static final int GL_DOUBLE_MAT2x3 = 36681;
    public static final int GL_DOUBLE_MAT2x4 = 36682;
    public static final int GL_DOUBLE_MAT3x2 = 36683;
    public static final int GL_DOUBLE_MAT3x4 = 36684;
    public static final int GL_DOUBLE_MAT4x2 = 36685;
    public static final int GL_DOUBLE_MAT4x3 = 36686;
    public final long VertexAttribL1d;
    public final long VertexAttribL2d;
    public final long VertexAttribL3d;
    public final long VertexAttribL4d;
    public final long VertexAttribL1dv;
    public final long VertexAttribL2dv;
    public final long VertexAttribL3dv;
    public final long VertexAttribL4dv;
    public final long VertexAttribLPointer;
    public final long GetVertexAttribLdv;
    public final long VertexArrayVertexAttribLOffsetEXT;

    public ARBVertexAttrib64Bit(FunctionProvider provider) {
        this.VertexAttribL1d = provider.getFunctionAddress("glVertexAttribL1d");
        this.VertexAttribL2d = provider.getFunctionAddress("glVertexAttribL2d");
        this.VertexAttribL3d = provider.getFunctionAddress("glVertexAttribL3d");
        this.VertexAttribL4d = provider.getFunctionAddress("glVertexAttribL4d");
        this.VertexAttribL1dv = provider.getFunctionAddress("glVertexAttribL1dv");
        this.VertexAttribL2dv = provider.getFunctionAddress("glVertexAttribL2dv");
        this.VertexAttribL3dv = provider.getFunctionAddress("glVertexAttribL3dv");
        this.VertexAttribL4dv = provider.getFunctionAddress("glVertexAttribL4dv");
        this.VertexAttribLPointer = provider.getFunctionAddress("glVertexAttribLPointer");
        this.GetVertexAttribLdv = provider.getFunctionAddress("glGetVertexAttribLdv");
        this.VertexArrayVertexAttribLOffsetEXT = provider.getFunctionAddress("glVertexArrayVertexAttribLOffsetEXT");
    }

    public static ARBVertexAttrib64Bit getInstance() {
        return GL.getCapabilities().__ARBVertexAttrib64Bit;
    }

    static ARBVertexAttrib64Bit create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_vertex_attrib_64bit")) {
            return null;
        }
        ARBVertexAttrib64Bit funcs = new ARBVertexAttrib64Bit(provider);
        boolean supported = Checks.checkFunctions(funcs.VertexAttribL1d, funcs.VertexAttribL2d, funcs.VertexAttribL3d, funcs.VertexAttribL4d, funcs.VertexAttribL1dv, funcs.VertexAttribL2dv, funcs.VertexAttribL3dv, funcs.VertexAttribL4dv, funcs.VertexAttribLPointer, funcs.GetVertexAttribLdv, ext.contains("GL_EXT_direct_state_access") ? funcs.VertexArrayVertexAttribLOffsetEXT : -1L);
        return GL.checkExtension("GL_ARB_vertex_attrib_64bit", funcs, supported);
    }

    public static void glVertexAttribL1d(int index, double x) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL1d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL1d(index, x, __functionAddress);
    }

    public static void glVertexAttribL2d(int index, double x, double y) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL2d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL2d(index, x, y, __functionAddress);
    }

    public static void glVertexAttribL3d(int index, double x, double y, double z) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL3d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL3d(index, x, y, z, __functionAddress);
    }

    public static void glVertexAttribL4d(int index, double x, double y, double z, double w) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL4d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL4d(index, x, y, z, w, __functionAddress);
    }

    public static void nglVertexAttribL1dv(int index, long v) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL1dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL1dv(index, v, __functionAddress);
    }

    public static void glVertexAttribL1d(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL1dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL1(int index, DoubleBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 1);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL1dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribL2dv(int index, long v) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL2dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL2dv(index, v, __functionAddress);
    }

    public static void glVertexAttribL2d(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL2dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL2(int index, DoubleBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL2dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribL3dv(int index, long v) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL3dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL3dv(index, v, __functionAddress);
    }

    public static void glVertexAttribL3d(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 24);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL3dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL3(int index, DoubleBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL3dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribL4dv(int index, long v) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribL4dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL4dv(index, v, __functionAddress);
    }

    public static void glVertexAttribL4d(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 32);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL4dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL4(int index, DoubleBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        ARBVertexAttrib64Bit.nglVertexAttribL4dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribLPointer(int index, int size, int type, int stride, long pointer) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexAttribLPointer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribLPointer(index, size, type, stride, pointer, __functionAddress);
    }

    public static void glVertexAttribLPointer(int index, int size, int type, int stride, ByteBuffer pointer) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        ARBVertexAttrib64Bit.nglVertexAttribLPointer(index, size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribLPointer(int index, int size, int type, int stride, long pointerOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34964, true);
        }
        ARBVertexAttrib64Bit.nglVertexAttribLPointer(index, size, type, stride, pointerOffset);
    }

    public static void glVertexAttribLPointer(int index, int size, int stride, DoubleBuffer pointer) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        ARBVertexAttrib64Bit.nglVertexAttribLPointer(index, size, 5130, stride, MemoryUtil.memAddress(pointer));
    }

    public static void nglGetVertexAttribLdv(int index, int pname, long params) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().GetVertexAttribLdv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglGetVertexAttribLdv(index, pname, params, __functionAddress);
    }

    public static void glGetVertexAttribLd(int index, int pname, ByteBuffer params) {
        ARBVertexAttrib64Bit.nglGetVertexAttribLdv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttribL(int index, int pname, DoubleBuffer params) {
        ARBVertexAttrib64Bit.nglGetVertexAttribLdv(index, pname, MemoryUtil.memAddress(params));
    }

    public static native void nglVertexArrayVertexAttribLOffsetEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    public static void glVertexArrayVertexAttribLOffsetEXT(int vaobj, int buffer, int index, int size, int type, int stride, long offset) {
        long __functionAddress = ARBVertexAttrib64Bit.getInstance().VertexArrayVertexAttribLOffsetEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBVertexAttrib64Bit.nglVertexArrayVertexAttribLOffsetEXT(vaobj, buffer, index, size, type, stride, offset, __functionAddress);
    }
}

