/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBTransposeMatrix {
    public static final int GL_TRANSPOSE_MODELVIEW_MATRIX_ARB = 34019;
    public static final int GL_TRANSPOSE_PROJECTION_MATRIX_ARB = 34020;
    public static final int GL_TRANSPOSE_TEXTURE_MATRIX_ARB = 34021;
    public static final int GL_TRANSPOSE_COLOR_MATRIX_ARB = 34022;
    public final long LoadTransposeMatrixfARB;
    public final long LoadTransposeMatrixdARB;
    public final long MultTransposeMatrixfARB;
    public final long MultTransposeMatrixdARB;

    public ARBTransposeMatrix(FunctionProvider provider) {
        this.LoadTransposeMatrixfARB = provider.getFunctionAddress("glLoadTransposeMatrixfARB");
        this.LoadTransposeMatrixdARB = provider.getFunctionAddress("glLoadTransposeMatrixdARB");
        this.MultTransposeMatrixfARB = provider.getFunctionAddress("glMultTransposeMatrixfARB");
        this.MultTransposeMatrixdARB = provider.getFunctionAddress("glMultTransposeMatrixdARB");
    }

    public static ARBTransposeMatrix getInstance() {
        return GL.getCapabilities().__ARBTransposeMatrix;
    }

    static ARBTransposeMatrix create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_transpose_matrix")) {
            return null;
        }
        ARBTransposeMatrix funcs = new ARBTransposeMatrix(provider);
        boolean supported = Checks.checkFunctions(funcs.LoadTransposeMatrixfARB, funcs.LoadTransposeMatrixdARB, funcs.MultTransposeMatrixfARB, funcs.MultTransposeMatrixdARB);
        return GL.checkExtension("GL_ARB_transpose_matrix", funcs, supported);
    }

    public static native void nglLoadTransposeMatrixfARB(long var0, long var2);

    public static void nglLoadTransposeMatrixfARB(long m) {
        long __functionAddress = ARBTransposeMatrix.getInstance().LoadTransposeMatrixfARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBTransposeMatrix.nglLoadTransposeMatrixfARB(m, __functionAddress);
    }

    public static void glLoadTransposeMatrixfARB(ByteBuffer m) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)m, 64);
        }
        ARBTransposeMatrix.nglLoadTransposeMatrixfARB(MemoryUtil.memAddress(m));
    }

    public static void glLoadTransposeMatrixARB(FloatBuffer m) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        ARBTransposeMatrix.nglLoadTransposeMatrixfARB(MemoryUtil.memAddress(m));
    }

    public static native void nglLoadTransposeMatrixdARB(long var0, long var2);

    public static void nglLoadTransposeMatrixdARB(long m) {
        long __functionAddress = ARBTransposeMatrix.getInstance().LoadTransposeMatrixdARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBTransposeMatrix.nglLoadTransposeMatrixdARB(m, __functionAddress);
    }

    public static void glLoadTransposeMatrixdARB(ByteBuffer m) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)m, 128);
        }
        ARBTransposeMatrix.nglLoadTransposeMatrixdARB(MemoryUtil.memAddress(m));
    }

    public static void glLoadTransposeMatrixARB(DoubleBuffer m) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        ARBTransposeMatrix.nglLoadTransposeMatrixdARB(MemoryUtil.memAddress(m));
    }

    public static native void nglMultTransposeMatrixfARB(long var0, long var2);

    public static void nglMultTransposeMatrixfARB(long m) {
        long __functionAddress = ARBTransposeMatrix.getInstance().MultTransposeMatrixfARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBTransposeMatrix.nglMultTransposeMatrixfARB(m, __functionAddress);
    }

    public static void glMultTransposeMatrixfARB(ByteBuffer m) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)m, 64);
        }
        ARBTransposeMatrix.nglMultTransposeMatrixfARB(MemoryUtil.memAddress(m));
    }

    public static void glMultTransposeMatrixARB(FloatBuffer m) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        ARBTransposeMatrix.nglMultTransposeMatrixfARB(MemoryUtil.memAddress(m));
    }

    public static native void nglMultTransposeMatrixdARB(long var0, long var2);

    public static void nglMultTransposeMatrixdARB(long m) {
        long __functionAddress = ARBTransposeMatrix.getInstance().MultTransposeMatrixdARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBTransposeMatrix.nglMultTransposeMatrixdARB(m, __functionAddress);
    }

    public static void glMultTransposeMatrixdARB(ByteBuffer m) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)m, 128);
        }
        ARBTransposeMatrix.nglMultTransposeMatrixdARB(MemoryUtil.memAddress(m));
    }

    public static void glMultTransposeMatrixARB(DoubleBuffer m) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        ARBTransposeMatrix.nglMultTransposeMatrixdARB(MemoryUtil.memAddress(m));
    }
}

