/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL32;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBSync {
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT = 37137;
    public static final int GL_OBJECT_TYPE = 37138;
    public static final int GL_SYNC_CONDITION = 37139;
    public static final int GL_SYNC_STATUS = 37140;
    public static final int GL_SYNC_FLAGS = 37141;
    public static final int GL_SYNC_FENCE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE = 37143;
    public static final int GL_UNSIGNALED = 37144;
    public static final int GL_SIGNALED = 37145;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final long GL_TIMEOUT_IGNORED = -1L;
    public static final int GL_ALREADY_SIGNALED = 37146;
    public static final int GL_TIMEOUT_EXPIRED = 37147;
    public static final int GL_CONDITION_SATISFIED = 37148;
    public static final int GL_WAIT_FAILED = 37149;
    public final long FenceSync;
    public final long IsSync;
    public final long DeleteSync;
    public final long ClientWaitSync;
    public final long WaitSync;
    public final long GetInteger64v;
    public final long GetSynciv;

    public ARBSync(FunctionProvider provider) {
        this.FenceSync = provider.getFunctionAddress("glFenceSync");
        this.IsSync = provider.getFunctionAddress("glIsSync");
        this.DeleteSync = provider.getFunctionAddress("glDeleteSync");
        this.ClientWaitSync = provider.getFunctionAddress("glClientWaitSync");
        this.WaitSync = provider.getFunctionAddress("glWaitSync");
        this.GetInteger64v = provider.getFunctionAddress("glGetInteger64v");
        this.GetSynciv = provider.getFunctionAddress("glGetSynciv");
    }

    public static ARBSync getInstance() {
        return GL.getCapabilities().__ARBSync;
    }

    static ARBSync create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_sync")) {
            return null;
        }
        ARBSync funcs = new ARBSync(provider);
        boolean supported = Checks.checkFunctions(funcs.FenceSync, funcs.IsSync, funcs.DeleteSync, funcs.ClientWaitSync, funcs.WaitSync, funcs.GetInteger64v, funcs.GetSynciv);
        return GL.checkExtension("GL_ARB_sync", funcs, supported);
    }

    public static long glFenceSync(int condition, int flags) {
        long __functionAddress = ARBSync.getInstance().FenceSync;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL32.nglFenceSync(condition, flags, __functionAddress);
    }

    public static boolean glIsSync(long sync) {
        long __functionAddress = ARBSync.getInstance().IsSync;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
        }
        return GL32.nglIsSync(sync, __functionAddress);
    }

    public static void glDeleteSync(long sync) {
        long __functionAddress = ARBSync.getInstance().DeleteSync;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
        }
        GL32.nglDeleteSync(sync, __functionAddress);
    }

    public static int glClientWaitSync(long sync, int flags, long timeout) {
        long __functionAddress = ARBSync.getInstance().ClientWaitSync;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
        }
        return GL32.nglClientWaitSync(sync, flags, timeout, __functionAddress);
    }

    public static void glWaitSync(long sync, int flags, long timeout) {
        long __functionAddress = ARBSync.getInstance().WaitSync;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
        }
        GL32.nglWaitSync(sync, flags, timeout, __functionAddress);
    }

    public static void nglGetInteger64v(int pname, long params) {
        long __functionAddress = ARBSync.getInstance().GetInteger64v;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL32.nglGetInteger64v(pname, params, __functionAddress);
    }

    public static void glGetInteger64(int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        ARBSync.nglGetInteger64v(pname, MemoryUtil.memAddress(params));
    }

    public static void glGetInteger64(int pname, LongBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBSync.nglGetInteger64v(pname, MemoryUtil.memAddress(params));
    }

    public static long glGetInteger64(int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        ARBSync.nglGetInteger64v(pname, __buffer.address() + (long)params);
        return __buffer.longValue(params);
    }

    public static void nglGetSynciv(long sync, int pname, int bufSize, long length, long values) {
        long __functionAddress = ARBSync.getInstance().GetSynciv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
        }
        GL32.nglGetSynciv(sync, pname, bufSize, length, values, __functionAddress);
    }

    public static void glGetSynci(long sync, int pname, int bufSize, ByteBuffer length, ByteBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, bufSize << 2);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        ARBSync.nglGetSynciv(sync, pname, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values));
    }

    public static void glGetSync(long sync, int pname, IntBuffer length, IntBuffer values) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ARBSync.nglGetSynciv(sync, pname, values.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values));
    }

    public static int glGetSynci(long sync, int pname, IntBuffer length) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int values = __buffer.intParam();
        ARBSync.nglGetSynciv(sync, pname, 1, MemoryUtil.memAddressSafe(length), __buffer.address() + (long)values);
        return __buffer.intValue(values);
    }
}

