/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBShaderObjects {
    public static final int GL_PROGRAM_OBJECT_ARB = 35648;
    public static final int GL_OBJECT_TYPE_ARB = 35662;
    public static final int GL_OBJECT_SUBTYPE_ARB = 35663;
    public static final int GL_OBJECT_DELETE_STATUS_ARB = 35712;
    public static final int GL_OBJECT_COMPILE_STATUS_ARB = 35713;
    public static final int GL_OBJECT_LINK_STATUS_ARB = 35714;
    public static final int GL_OBJECT_VALIDATE_STATUS_ARB = 35715;
    public static final int GL_OBJECT_INFO_LOG_LENGTH_ARB = 35716;
    public static final int GL_OBJECT_ATTACHED_OBJECTS_ARB = 35717;
    public static final int GL_OBJECT_ACTIVE_UNIFORMS_ARB = 35718;
    public static final int GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = 35719;
    public static final int GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = 35720;
    public static final int GL_SHADER_OBJECT_ARB = 35656;
    public static final int GL_FLOAT = 5126;
    public static final int GL_FLOAT_VEC2_ARB = 35664;
    public static final int GL_FLOAT_VEC3_ARB = 35665;
    public static final int GL_FLOAT_VEC4_ARB = 35666;
    public static final int GL_INT = 5124;
    public static final int GL_INT_VEC2_ARB = 35667;
    public static final int GL_INT_VEC3_ARB = 35668;
    public static final int GL_INT_VEC4_ARB = 35669;
    public static final int GL_BOOL_ARB = 35670;
    public static final int GL_BOOL_VEC2_ARB = 35671;
    public static final int GL_BOOL_VEC3_ARB = 35672;
    public static final int GL_BOOL_VEC4_ARB = 35673;
    public static final int GL_FLOAT_MAT2_ARB = 35674;
    public static final int GL_FLOAT_MAT3_ARB = 35675;
    public static final int GL_FLOAT_MAT4_ARB = 35676;
    public static final int GL_SAMPLER_1D_ARB = 35677;
    public static final int GL_SAMPLER_2D_ARB = 35678;
    public static final int GL_SAMPLER_3D_ARB = 35679;
    public static final int GL_SAMPLER_CUBE_ARB = 35680;
    public static final int GL_SAMPLER_1D_SHADOW_ARB = 35681;
    public static final int GL_SAMPLER_2D_SHADOW_ARB = 35682;
    public static final int GL_SAMPLER_2D_RECT_ARB = 35683;
    public static final int GL_SAMPLER_2D_RECT_SHADOW_ARB = 35684;
    public final long DeleteObjectARB;
    public final long GetHandleARB;
    public final long DetachObjectARB;
    public final long CreateShaderObjectARB;
    public final long ShaderSourceARB;
    public final long CompileShaderARB;
    public final long CreateProgramObjectARB;
    public final long AttachObjectARB;
    public final long LinkProgramARB;
    public final long UseProgramObjectARB;
    public final long ValidateProgramARB;
    public final long Uniform1fARB;
    public final long Uniform2fARB;
    public final long Uniform3fARB;
    public final long Uniform4fARB;
    public final long Uniform1iARB;
    public final long Uniform2iARB;
    public final long Uniform3iARB;
    public final long Uniform4iARB;
    public final long Uniform1fvARB;
    public final long Uniform2fvARB;
    public final long Uniform3fvARB;
    public final long Uniform4fvARB;
    public final long Uniform1ivARB;
    public final long Uniform2ivARB;
    public final long Uniform3ivARB;
    public final long Uniform4ivARB;
    public final long UniformMatrix2fvARB;
    public final long UniformMatrix3fvARB;
    public final long UniformMatrix4fvARB;
    public final long GetObjectParameterfvARB;
    public final long GetObjectParameterivARB;
    public final long GetInfoLogARB;
    public final long GetAttachedObjectsARB;
    public final long GetUniformLocationARB;
    public final long GetActiveUniformARB;
    public final long GetUniformfvARB;
    public final long GetUniformivARB;
    public final long GetShaderSourceARB;

    public ARBShaderObjects(FunctionProvider provider) {
        this.DeleteObjectARB = provider.getFunctionAddress("glDeleteObjectARB");
        this.GetHandleARB = provider.getFunctionAddress("glGetHandleARB");
        this.DetachObjectARB = provider.getFunctionAddress("glDetachObjectARB");
        this.CreateShaderObjectARB = provider.getFunctionAddress("glCreateShaderObjectARB");
        this.ShaderSourceARB = provider.getFunctionAddress("glShaderSourceARB");
        this.CompileShaderARB = provider.getFunctionAddress("glCompileShaderARB");
        this.CreateProgramObjectARB = provider.getFunctionAddress("glCreateProgramObjectARB");
        this.AttachObjectARB = provider.getFunctionAddress("glAttachObjectARB");
        this.LinkProgramARB = provider.getFunctionAddress("glLinkProgramARB");
        this.UseProgramObjectARB = provider.getFunctionAddress("glUseProgramObjectARB");
        this.ValidateProgramARB = provider.getFunctionAddress("glValidateProgramARB");
        this.Uniform1fARB = provider.getFunctionAddress("glUniform1fARB");
        this.Uniform2fARB = provider.getFunctionAddress("glUniform2fARB");
        this.Uniform3fARB = provider.getFunctionAddress("glUniform3fARB");
        this.Uniform4fARB = provider.getFunctionAddress("glUniform4fARB");
        this.Uniform1iARB = provider.getFunctionAddress("glUniform1iARB");
        this.Uniform2iARB = provider.getFunctionAddress("glUniform2iARB");
        this.Uniform3iARB = provider.getFunctionAddress("glUniform3iARB");
        this.Uniform4iARB = provider.getFunctionAddress("glUniform4iARB");
        this.Uniform1fvARB = provider.getFunctionAddress("glUniform1fvARB");
        this.Uniform2fvARB = provider.getFunctionAddress("glUniform2fvARB");
        this.Uniform3fvARB = provider.getFunctionAddress("glUniform3fvARB");
        this.Uniform4fvARB = provider.getFunctionAddress("glUniform4fvARB");
        this.Uniform1ivARB = provider.getFunctionAddress("glUniform1ivARB");
        this.Uniform2ivARB = provider.getFunctionAddress("glUniform2ivARB");
        this.Uniform3ivARB = provider.getFunctionAddress("glUniform3ivARB");
        this.Uniform4ivARB = provider.getFunctionAddress("glUniform4ivARB");
        this.UniformMatrix2fvARB = provider.getFunctionAddress("glUniformMatrix2fvARB");
        this.UniformMatrix3fvARB = provider.getFunctionAddress("glUniformMatrix3fvARB");
        this.UniformMatrix4fvARB = provider.getFunctionAddress("glUniformMatrix4fvARB");
        this.GetObjectParameterfvARB = provider.getFunctionAddress("glGetObjectParameterfvARB");
        this.GetObjectParameterivARB = provider.getFunctionAddress("glGetObjectParameterivARB");
        this.GetInfoLogARB = provider.getFunctionAddress("glGetInfoLogARB");
        this.GetAttachedObjectsARB = provider.getFunctionAddress("glGetAttachedObjectsARB");
        this.GetUniformLocationARB = provider.getFunctionAddress("glGetUniformLocationARB");
        this.GetActiveUniformARB = provider.getFunctionAddress("glGetActiveUniformARB");
        this.GetUniformfvARB = provider.getFunctionAddress("glGetUniformfvARB");
        this.GetUniformivARB = provider.getFunctionAddress("glGetUniformivARB");
        this.GetShaderSourceARB = provider.getFunctionAddress("glGetShaderSourceARB");
    }

    public static ARBShaderObjects getInstance() {
        return GL.getCapabilities().__ARBShaderObjects;
    }

    static ARBShaderObjects create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_shader_objects")) {
            return null;
        }
        ARBShaderObjects funcs = new ARBShaderObjects(provider);
        boolean supported = Checks.checkFunctions(funcs.DeleteObjectARB, funcs.GetHandleARB, funcs.DetachObjectARB, funcs.CreateShaderObjectARB, funcs.ShaderSourceARB, funcs.CompileShaderARB, funcs.CreateProgramObjectARB, funcs.AttachObjectARB, funcs.LinkProgramARB, funcs.UseProgramObjectARB, funcs.ValidateProgramARB, funcs.Uniform1fARB, funcs.Uniform2fARB, funcs.Uniform3fARB, funcs.Uniform4fARB, funcs.Uniform1iARB, funcs.Uniform2iARB, funcs.Uniform3iARB, funcs.Uniform4iARB, funcs.Uniform1fvARB, funcs.Uniform2fvARB, funcs.Uniform3fvARB, funcs.Uniform4fvARB, funcs.Uniform1ivARB, funcs.Uniform2ivARB, funcs.Uniform3ivARB, funcs.Uniform4ivARB, funcs.UniformMatrix2fvARB, funcs.UniformMatrix3fvARB, funcs.UniformMatrix4fvARB, funcs.GetObjectParameterfvARB, funcs.GetObjectParameterivARB, funcs.GetInfoLogARB, funcs.GetAttachedObjectsARB, funcs.GetUniformLocationARB, funcs.GetActiveUniformARB, funcs.GetUniformfvARB, funcs.GetUniformivARB, funcs.GetShaderSourceARB);
        return GL.checkExtension("GL_ARB_shader_objects", funcs, supported);
    }

    public static native void nglDeleteObjectARB(int var0, long var1);

    public static void glDeleteObjectARB(int obj) {
        long __functionAddress = ARBShaderObjects.getInstance().DeleteObjectARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglDeleteObjectARB(obj, __functionAddress);
    }

    public static native int nglGetHandleARB(int var0, long var1);

    public static int glGetHandleARB(int pname) {
        long __functionAddress = ARBShaderObjects.getInstance().GetHandleARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ARBShaderObjects.nglGetHandleARB(pname, __functionAddress);
    }

    public static native void nglDetachObjectARB(int var0, int var1, long var2);

    public static void glDetachObjectARB(int containerObj, int attachedObj) {
        long __functionAddress = ARBShaderObjects.getInstance().DetachObjectARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglDetachObjectARB(containerObj, attachedObj, __functionAddress);
    }

    public static native int nglCreateShaderObjectARB(int var0, long var1);

    public static int glCreateShaderObjectARB(int shaderType) {
        long __functionAddress = ARBShaderObjects.getInstance().CreateShaderObjectARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ARBShaderObjects.nglCreateShaderObjectARB(shaderType, __functionAddress);
    }

    public static native void nglShaderSourceARB(int var0, int var1, long var2, long var4, long var6);

    public static void nglShaderSourceARB(int shaderObj, int count, long string, long length) {
        long __functionAddress = ARBShaderObjects.getInstance().ShaderSourceARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglShaderSourceARB(shaderObj, count, string, length, __functionAddress);
    }

    public static void glShaderSourceARB(int shaderObj, int count, ByteBuffer string, ByteBuffer length) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)string, count << Pointer.POINTER_SHIFT);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, count << 2);
            }
        }
        ARBShaderObjects.nglShaderSourceARB(shaderObj, count, MemoryUtil.memAddress(string), MemoryUtil.memAddressSafe(length));
    }

    public static void glShaderSourceARB(int shaderObj, PointerBuffer string, IntBuffer length) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, string.remaining());
        }
        ARBShaderObjects.nglShaderSourceARB(shaderObj, string.remaining(), MemoryUtil.memAddress(string), MemoryUtil.memAddressSafe(length));
    }

    public static void glShaderSourceARB(int shaderObj, CharSequence ... string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringLengths = __buffer.bufferParam(string.length << 2);
        for (int i = 0; i < string.length; ++i) {
            __buffer.intParam(stringLengths, i, string[i].length());
        }
        int stringAddress = __buffer.bufferParam(string.length << Pointer.POINTER_SHIFT);
        ByteBuffer[] stringBuffers = new ByteBuffer[string.length];
        for (int i = 0; i < string.length; ++i) {
            stringBuffers[i] = MemoryUtil.memEncodeUTF8(string[i], false);
            __buffer.pointerParam(stringAddress, i, MemoryUtil.memAddress(stringBuffers[i]));
        }
        ARBShaderObjects.nglShaderSourceARB(shaderObj, string.length, __buffer.address() + (long)stringAddress, __buffer.address() + (long)stringLengths);
    }

    public static void glShaderSourceARB(int shaderObj, CharSequence string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringLengths = __buffer.intParam(string.length());
        ByteBuffer stringBuffers = MemoryUtil.memEncodeUTF8(string, false);
        int stringAddress = __buffer.pointerParam(MemoryUtil.memAddress(stringBuffers));
        ARBShaderObjects.nglShaderSourceARB(shaderObj, 1, __buffer.address() + (long)stringAddress, __buffer.address() + (long)stringLengths);
    }

    public static native void nglCompileShaderARB(int var0, long var1);

    public static void glCompileShaderARB(int shaderObj) {
        long __functionAddress = ARBShaderObjects.getInstance().CompileShaderARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglCompileShaderARB(shaderObj, __functionAddress);
    }

    public static native int nglCreateProgramObjectARB(long var0);

    public static int glCreateProgramObjectARB() {
        long __functionAddress = ARBShaderObjects.getInstance().CreateProgramObjectARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ARBShaderObjects.nglCreateProgramObjectARB(__functionAddress);
    }

    public static native void nglAttachObjectARB(int var0, int var1, long var2);

    public static void glAttachObjectARB(int containerObj, int obj) {
        long __functionAddress = ARBShaderObjects.getInstance().AttachObjectARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglAttachObjectARB(containerObj, obj, __functionAddress);
    }

    public static native void nglLinkProgramARB(int var0, long var1);

    public static void glLinkProgramARB(int programObj) {
        long __functionAddress = ARBShaderObjects.getInstance().LinkProgramARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglLinkProgramARB(programObj, __functionAddress);
    }

    public static native void nglUseProgramObjectARB(int var0, long var1);

    public static void glUseProgramObjectARB(int programObj) {
        long __functionAddress = ARBShaderObjects.getInstance().UseProgramObjectARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUseProgramObjectARB(programObj, __functionAddress);
    }

    public static native void nglValidateProgramARB(int var0, long var1);

    public static void glValidateProgramARB(int programObj) {
        long __functionAddress = ARBShaderObjects.getInstance().ValidateProgramARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglValidateProgramARB(programObj, __functionAddress);
    }

    public static native void nglUniform1fARB(int var0, float var1, long var2);

    public static void glUniform1fARB(int location, float v0) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform1fARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform1fARB(location, v0, __functionAddress);
    }

    public static native void nglUniform2fARB(int var0, float var1, float var2, long var3);

    public static void glUniform2fARB(int location, float v0, float v1) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform2fARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform2fARB(location, v0, v1, __functionAddress);
    }

    public static native void nglUniform3fARB(int var0, float var1, float var2, float var3, long var4);

    public static void glUniform3fARB(int location, float v0, float v1, float v2) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform3fARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform3fARB(location, v0, v1, v2, __functionAddress);
    }

    public static native void nglUniform4fARB(int var0, float var1, float var2, float var3, float var4, long var5);

    public static void glUniform4fARB(int location, float v0, float v1, float v2, float v3) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform4fARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform4fARB(location, v0, v1, v2, v3, __functionAddress);
    }

    public static native void nglUniform1iARB(int var0, int var1, long var2);

    public static void glUniform1iARB(int location, int v0) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform1iARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform1iARB(location, v0, __functionAddress);
    }

    public static native void nglUniform2iARB(int var0, int var1, int var2, long var3);

    public static void glUniform2iARB(int location, int v0, int v1) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform2iARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform2iARB(location, v0, v1, __functionAddress);
    }

    public static native void nglUniform3iARB(int var0, int var1, int var2, int var3, long var4);

    public static void glUniform3iARB(int location, int v0, int v1, int v2) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform3iARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform3iARB(location, v0, v1, v2, __functionAddress);
    }

    public static native void nglUniform4iARB(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glUniform4iARB(int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform4iARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform4iARB(location, v0, v1, v2, v3, __functionAddress);
    }

    public static native void nglUniform1fvARB(int var0, int var1, long var2, long var4);

    public static void nglUniform1fvARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform1fvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform1fvARB(location, count, value, __functionAddress);
    }

    public static void glUniform1fARB(int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        ARBShaderObjects.nglUniform1fvARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform1ARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform1fvARB(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglUniform2fvARB(int var0, int var1, long var2, long var4);

    public static void nglUniform2fvARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform2fvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform2fvARB(location, count, value, __functionAddress);
    }

    public static void glUniform2fARB(int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        ARBShaderObjects.nglUniform2fvARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform2ARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform2fvARB(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void nglUniform3fvARB(int var0, int var1, long var2, long var4);

    public static void nglUniform3fvARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform3fvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform3fvARB(location, count, value, __functionAddress);
    }

    public static void glUniform3fARB(int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        ARBShaderObjects.nglUniform3fvARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform3ARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform3fvARB(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static native void nglUniform4fvARB(int var0, int var1, long var2, long var4);

    public static void nglUniform4fvARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform4fvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform4fvARB(location, count, value, __functionAddress);
    }

    public static void glUniform4fARB(int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        ARBShaderObjects.nglUniform4fvARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform4ARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform4fvARB(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void nglUniform1ivARB(int var0, int var1, long var2, long var4);

    public static void nglUniform1ivARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform1ivARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform1ivARB(location, count, value, __functionAddress);
    }

    public static void glUniform1iARB(int location, int count, ByteBuffer value) {
        ARBShaderObjects.nglUniform1ivARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform1ARB(int location, int count, IntBuffer value) {
        ARBShaderObjects.nglUniform1ivARB(location, count, MemoryUtil.memAddress(value));
    }

    public static native void nglUniform2ivARB(int var0, int var1, long var2, long var4);

    public static void nglUniform2ivARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform2ivARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform2ivARB(location, count, value, __functionAddress);
    }

    public static void glUniform2iARB(int location, int count, ByteBuffer value) {
        ARBShaderObjects.nglUniform2ivARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform2ARB(int location, int count, IntBuffer value) {
        ARBShaderObjects.nglUniform2ivARB(location, count, MemoryUtil.memAddress(value));
    }

    public static native void nglUniform3ivARB(int var0, int var1, long var2, long var4);

    public static void nglUniform3ivARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform3ivARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform3ivARB(location, count, value, __functionAddress);
    }

    public static void glUniform3iARB(int location, int count, ByteBuffer value) {
        ARBShaderObjects.nglUniform3ivARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform3ARB(int location, int count, IntBuffer value) {
        ARBShaderObjects.nglUniform3ivARB(location, count, MemoryUtil.memAddress(value));
    }

    public static native void nglUniform4ivARB(int var0, int var1, long var2, long var4);

    public static void nglUniform4ivARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform4ivARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniform4ivARB(location, count, value, __functionAddress);
    }

    public static void glUniform4iARB(int location, int count, ByteBuffer value) {
        ARBShaderObjects.nglUniform4ivARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform4ARB(int location, int count, IntBuffer value) {
        ARBShaderObjects.nglUniform4ivARB(location, count, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix2fvARB(int var0, int var1, boolean var2, long var3, long var5);

    public static void nglUniformMatrix2fvARB(int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().UniformMatrix2fvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniformMatrix2fvARB(location, count, transpose, value, __functionAddress);
    }

    public static void glUniformMatrix2fARB(int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        ARBShaderObjects.nglUniformMatrix2fvARB(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix2ARB(int location, boolean transpose, FloatBuffer value) {
        ARBShaderObjects.nglUniformMatrix2fvARB(location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix3fvARB(int var0, int var1, boolean var2, long var3, long var5);

    public static void nglUniformMatrix3fvARB(int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().UniformMatrix3fvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniformMatrix3fvARB(location, count, transpose, value, __functionAddress);
    }

    public static void glUniformMatrix3fARB(int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        ARBShaderObjects.nglUniformMatrix3fvARB(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix3ARB(int location, boolean transpose, FloatBuffer value) {
        ARBShaderObjects.nglUniformMatrix3fvARB(location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix4fvARB(int var0, int var1, boolean var2, long var3, long var5);

    public static void nglUniformMatrix4fvARB(int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().UniformMatrix4fvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglUniformMatrix4fvARB(location, count, transpose, value, __functionAddress);
    }

    public static void glUniformMatrix4fARB(int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 4 << 2);
        }
        ARBShaderObjects.nglUniformMatrix4fvARB(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix4ARB(int location, boolean transpose, FloatBuffer value) {
        ARBShaderObjects.nglUniformMatrix4fvARB(location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglGetObjectParameterfvARB(int var0, int var1, long var2, long var4);

    public static void nglGetObjectParameterfvARB(int obj, int pname, long params) {
        long __functionAddress = ARBShaderObjects.getInstance().GetObjectParameterfvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglGetObjectParameterfvARB(obj, pname, params, __functionAddress);
    }

    public static void glGetObjectParameterfARB(int obj, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBShaderObjects.nglGetObjectParameterfvARB(obj, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetObjectParameterARB(int obj, int pname, FloatBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShaderObjects.nglGetObjectParameterfvARB(obj, pname, MemoryUtil.memAddress(params));
    }

    public static native void nglGetObjectParameterivARB(int var0, int var1, long var2, long var4);

    public static void nglGetObjectParameterivARB(int obj, int pname, long params) {
        long __functionAddress = ARBShaderObjects.getInstance().GetObjectParameterivARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglGetObjectParameterivARB(obj, pname, params, __functionAddress);
    }

    public static void glGetObjectParameteriARB(int obj, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBShaderObjects.nglGetObjectParameterivARB(obj, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetObjectParameterARB(int obj, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShaderObjects.nglGetObjectParameterivARB(obj, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetObjectParameteriARB(int obj, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBShaderObjects.nglGetObjectParameterivARB(obj, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static native void nglGetInfoLogARB(int var0, int var1, long var2, long var4, long var6);

    public static void nglGetInfoLogARB(int obj, int maxLength, long length, long infoLog) {
        long __functionAddress = ARBShaderObjects.getInstance().GetInfoLogARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglGetInfoLogARB(obj, maxLength, length, infoLog, __functionAddress);
    }

    public static void glGetInfoLogARB(int obj, int maxLength, ByteBuffer length, ByteBuffer infoLog) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)infoLog, maxLength);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        ARBShaderObjects.nglGetInfoLogARB(obj, maxLength, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static void glGetInfoLogARB(int obj, IntBuffer length, ByteBuffer infoLog) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ARBShaderObjects.nglGetInfoLogARB(obj, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static String glGetInfoLogARB(int obj, int maxLength) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(maxLength);
        ARBShaderObjects.nglGetInfoLogARB(obj, maxLength, __buffer.address() + (long)length, __buffer.address() + (long)infoLog);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address() + (long)infoLog, __buffer.intValue(length)));
    }

    public static String glGetInfoLogARB(int obj) {
        int maxLength = ARBShaderObjects.glGetObjectParameteriARB(obj, 35716);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(maxLength);
        ARBShaderObjects.nglGetInfoLogARB(obj, maxLength, __buffer.address() + (long)length, __buffer.address() + (long)infoLog);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address() + (long)infoLog, __buffer.intValue(length)));
    }

    public static native void nglGetAttachedObjectsARB(int var0, int var1, long var2, long var4, long var6);

    public static void nglGetAttachedObjectsARB(int containerObj, int maxCount, long count, long obj) {
        long __functionAddress = ARBShaderObjects.getInstance().GetAttachedObjectsARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglGetAttachedObjectsARB(containerObj, maxCount, count, obj, __functionAddress);
    }

    public static void glGetAttachedObjectsARB(int containerObj, int maxCount, ByteBuffer count, ByteBuffer obj) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)obj, maxCount << 2);
            if (count != null) {
                Checks.checkBuffer((Buffer)count, 4);
            }
        }
        ARBShaderObjects.nglGetAttachedObjectsARB(containerObj, maxCount, MemoryUtil.memAddressSafe(count), MemoryUtil.memAddress(obj));
    }

    public static void glGetAttachedObjectsARB(int containerObj, IntBuffer count, IntBuffer obj) {
        if (LWJGLUtil.CHECKS && count != null) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        ARBShaderObjects.nglGetAttachedObjectsARB(containerObj, obj.remaining(), MemoryUtil.memAddressSafe(count), MemoryUtil.memAddress(obj));
    }

    public static IntBuffer glGetAttachedObjectsARB(int containerObj, int maxCount) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        int obj = __buffer.bufferParam(maxCount << 2);
        ARBShaderObjects.nglGetAttachedObjectsARB(containerObj, maxCount, __buffer.address() + (long)count, __buffer.address() + (long)obj);
        return MemoryUtil.memIntBuffer(__buffer.address() + (long)obj, __buffer.intValue(count));
    }

    public static IntBuffer glGetAttachedObjectsARB(int containerObj) {
        int maxCount = ARBShaderObjects.glGetObjectParameteriARB(containerObj, 35717);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        int obj = __buffer.bufferParam(maxCount << 2);
        ARBShaderObjects.nglGetAttachedObjectsARB(containerObj, maxCount, __buffer.address() + (long)count, __buffer.address() + (long)obj);
        return MemoryUtil.memIntBuffer(__buffer.address() + (long)obj, __buffer.intValue(count));
    }

    public static native int nglGetUniformLocationARB(int var0, long var1, long var3);

    public static int nglGetUniformLocationARB(int programObj, long name) {
        long __functionAddress = ARBShaderObjects.getInstance().GetUniformLocationARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ARBShaderObjects.nglGetUniformLocationARB(programObj, name, __functionAddress);
    }

    public static int glGetUniformLocationARB(int programObj, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(name);
        }
        return ARBShaderObjects.nglGetUniformLocationARB(programObj, MemoryUtil.memAddress(name));
    }

    public static int glGetUniformLocationARB(int programObj, CharSequence name) {
        ByteBuffer nameEncoded = MemoryUtil.memEncodeUTF8(name);
        return ARBShaderObjects.nglGetUniformLocationARB(programObj, MemoryUtil.memAddress(nameEncoded));
    }

    public static native void nglGetActiveUniformARB(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public static void nglGetActiveUniformARB(int programObj, int index, int maxLength, long length, long size, long type, long name) {
        long __functionAddress = ARBShaderObjects.getInstance().GetActiveUniformARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, maxLength, length, size, type, name, __functionAddress);
    }

    public static void glGetActiveUniformARB(int programObj, int index, int maxLength, ByteBuffer length, ByteBuffer size, ByteBuffer type, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)name, maxLength);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)size, 4);
            Checks.checkBuffer((Buffer)type, 4);
        }
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, maxLength, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static void glGetActiveUniformARB(int programObj, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static String glGetActiveUniformARB(int programObj, int index, int maxLength, IntBuffer size, IntBuffer type) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(maxLength);
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, maxLength, __buffer.address() + (long)length, MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address() + (long)name);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address() + (long)name, __buffer.intValue(length)));
    }

    public static String glGetActiveUniformARB(int programObj, int index, IntBuffer size, IntBuffer type) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        int maxLength = ARBShaderObjects.glGetObjectParameteriARB(programObj, 35719);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(maxLength);
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, maxLength, __buffer.address() + (long)length, MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address() + (long)name);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address() + (long)name, __buffer.intValue(length)));
    }

    public static native void nglGetUniformfvARB(int var0, int var1, long var2, long var4);

    public static void nglGetUniformfvARB(int programObj, int location, long params) {
        long __functionAddress = ARBShaderObjects.getInstance().GetUniformfvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglGetUniformfvARB(programObj, location, params, __functionAddress);
    }

    public static void glGetUniformfARB(int programObj, int location, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBShaderObjects.nglGetUniformfvARB(programObj, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniformARB(int programObj, int location, FloatBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShaderObjects.nglGetUniformfvARB(programObj, location, MemoryUtil.memAddress(params));
    }

    public static float glGetUniformfARB(int programObj, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        ARBShaderObjects.nglGetUniformfvARB(programObj, location, __buffer.address() + (long)params);
        return __buffer.floatValue(params);
    }

    public static native void nglGetUniformivARB(int var0, int var1, long var2, long var4);

    public static void nglGetUniformivARB(int programObj, int location, long params) {
        long __functionAddress = ARBShaderObjects.getInstance().GetUniformivARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglGetUniformivARB(programObj, location, params, __functionAddress);
    }

    public static void glGetUniformiARB(int programObj, int location, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBShaderObjects.nglGetUniformivARB(programObj, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniformARB(int programObj, int location, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShaderObjects.nglGetUniformivARB(programObj, location, MemoryUtil.memAddress(params));
    }

    public static int glGetUniformiARB(int programObj, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBShaderObjects.nglGetUniformivARB(programObj, location, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static native void nglGetShaderSourceARB(int var0, int var1, long var2, long var4, long var6);

    public static void nglGetShaderSourceARB(int obj, int maxLength, long length, long source) {
        long __functionAddress = ARBShaderObjects.getInstance().GetShaderSourceARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBShaderObjects.nglGetShaderSourceARB(obj, maxLength, length, source, __functionAddress);
    }

    public static void glGetShaderSourceARB(int obj, int maxLength, ByteBuffer length, ByteBuffer source) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)source, maxLength);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        ARBShaderObjects.nglGetShaderSourceARB(obj, maxLength, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    public static void glGetShaderSourceARB(int obj, IntBuffer length, ByteBuffer source) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ARBShaderObjects.nglGetShaderSourceARB(obj, source.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    public static String glGetShaderSourceARB(int obj, int maxLength) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int source = __buffer.bufferParam(maxLength);
        ARBShaderObjects.nglGetShaderSourceARB(obj, maxLength, __buffer.address() + (long)length, __buffer.address() + (long)source);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address() + (long)source, __buffer.intValue(length)));
    }

    public static String glGetShaderSourceARB(int obj) {
        int maxLength = ARBShaderObjects.glGetObjectParameteriARB(obj, 35720);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int source = __buffer.bufferParam(maxLength);
        ARBShaderObjects.nglGetShaderSourceARB(obj, maxLength, __buffer.address() + (long)length, __buffer.address() + (long)source);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address() + (long)source, __buffer.intValue(length)));
    }
}

