/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL33;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBSamplerObjects {
    public static final int GL_SAMPLER_BINDING = 35097;
    public final long GenSamplers;
    public final long DeleteSamplers;
    public final long IsSampler;
    public final long BindSampler;
    public final long SamplerParameteri;
    public final long SamplerParameterf;
    public final long SamplerParameteriv;
    public final long SamplerParameterfv;
    public final long SamplerParameterIiv;
    public final long SamplerParameterIuiv;
    public final long GetSamplerParameteriv;
    public final long GetSamplerParameterfv;
    public final long GetSamplerParameterIiv;
    public final long GetSamplerParameterIuiv;

    public ARBSamplerObjects(FunctionProvider provider) {
        this.GenSamplers = provider.getFunctionAddress("glGenSamplers");
        this.DeleteSamplers = provider.getFunctionAddress("glDeleteSamplers");
        this.IsSampler = provider.getFunctionAddress("glIsSampler");
        this.BindSampler = provider.getFunctionAddress("glBindSampler");
        this.SamplerParameteri = provider.getFunctionAddress("glSamplerParameteri");
        this.SamplerParameterf = provider.getFunctionAddress("glSamplerParameterf");
        this.SamplerParameteriv = provider.getFunctionAddress("glSamplerParameteriv");
        this.SamplerParameterfv = provider.getFunctionAddress("glSamplerParameterfv");
        this.SamplerParameterIiv = provider.getFunctionAddress("glSamplerParameterIiv");
        this.SamplerParameterIuiv = provider.getFunctionAddress("glSamplerParameterIuiv");
        this.GetSamplerParameteriv = provider.getFunctionAddress("glGetSamplerParameteriv");
        this.GetSamplerParameterfv = provider.getFunctionAddress("glGetSamplerParameterfv");
        this.GetSamplerParameterIiv = provider.getFunctionAddress("glGetSamplerParameterIiv");
        this.GetSamplerParameterIuiv = provider.getFunctionAddress("glGetSamplerParameterIuiv");
    }

    public static ARBSamplerObjects getInstance() {
        return GL.getCapabilities().__ARBSamplerObjects;
    }

    static ARBSamplerObjects create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_sampler_objects")) {
            return null;
        }
        ARBSamplerObjects funcs = new ARBSamplerObjects(provider);
        boolean supported = Checks.checkFunctions(funcs.GenSamplers, funcs.DeleteSamplers, funcs.IsSampler, funcs.BindSampler, funcs.SamplerParameteri, funcs.SamplerParameterf, funcs.SamplerParameteriv, funcs.SamplerParameterfv, funcs.SamplerParameterIiv, funcs.SamplerParameterIuiv, funcs.GetSamplerParameteriv, funcs.GetSamplerParameterfv, funcs.GetSamplerParameterIiv, funcs.GetSamplerParameterIuiv);
        return GL.checkExtension("GL_ARB_sampler_objects", funcs, supported);
    }

    public static void nglGenSamplers(int count, long samplers) {
        long __functionAddress = ARBSamplerObjects.getInstance().GenSamplers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglGenSamplers(count, samplers, __functionAddress);
    }

    public static void glGenSamplers(int count, ByteBuffer samplers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)samplers, count << 2);
        }
        ARBSamplerObjects.nglGenSamplers(count, MemoryUtil.memAddress(samplers));
    }

    public static void glGenSamplers(IntBuffer samplers) {
        ARBSamplerObjects.nglGenSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    public static int glGenSamplers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int samplers = __buffer.intParam();
        ARBSamplerObjects.nglGenSamplers(1, __buffer.address() + (long)samplers);
        return __buffer.intValue(samplers);
    }

    public static void nglDeleteSamplers(int count, long samplers) {
        long __functionAddress = ARBSamplerObjects.getInstance().DeleteSamplers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglDeleteSamplers(count, samplers, __functionAddress);
    }

    public static void glDeleteSamplers(int count, ByteBuffer samplers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)samplers, count << 2);
        }
        ARBSamplerObjects.nglDeleteSamplers(count, MemoryUtil.memAddress(samplers));
    }

    public static void glDeleteSamplers(IntBuffer samplers) {
        ARBSamplerObjects.nglDeleteSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    public static void glDeleteSamplers(int sampler) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int samplers = __buffer.intParam(sampler);
        ARBSamplerObjects.nglDeleteSamplers(1, __buffer.address() + (long)samplers);
    }

    public static boolean glIsSampler(int sampler) {
        long __functionAddress = ARBSamplerObjects.getInstance().IsSampler;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL33.nglIsSampler(sampler, __functionAddress);
    }

    public static void glBindSampler(int unit, int sampler) {
        long __functionAddress = ARBSamplerObjects.getInstance().BindSampler;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglBindSampler(unit, sampler, __functionAddress);
    }

    public static void glSamplerParameteri(int sampler, int pname, int param) {
        long __functionAddress = ARBSamplerObjects.getInstance().SamplerParameteri;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglSamplerParameteri(sampler, pname, param, __functionAddress);
    }

    public static void glSamplerParameterf(int sampler, int pname, float param) {
        long __functionAddress = ARBSamplerObjects.getInstance().SamplerParameterf;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglSamplerParameterf(sampler, pname, param, __functionAddress);
    }

    public static void nglSamplerParameteriv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().SamplerParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglSamplerParameteriv(sampler, pname, params, __functionAddress);
    }

    public static void glSamplerParameteri(int sampler, int pname, ByteBuffer params) {
        ARBSamplerObjects.nglSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glSamplerParameter(int sampler, int pname, IntBuffer params) {
        ARBSamplerObjects.nglSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglSamplerParameterfv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().SamplerParameterfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglSamplerParameterfv(sampler, pname, params, __functionAddress);
    }

    public static void glSamplerParameterf(int sampler, int pname, ByteBuffer params) {
        ARBSamplerObjects.nglSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glSamplerParameter(int sampler, int pname, FloatBuffer params) {
        ARBSamplerObjects.nglSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglSamplerParameterIiv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().SamplerParameterIiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglSamplerParameterIiv(sampler, pname, params, __functionAddress);
    }

    public static void glSamplerParameterIi(int sampler, int pname, ByteBuffer params) {
        ARBSamplerObjects.nglSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glSamplerParameterI(int sampler, int pname, IntBuffer params) {
        ARBSamplerObjects.nglSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglSamplerParameterIuiv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().SamplerParameterIuiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglSamplerParameterIuiv(sampler, pname, params, __functionAddress);
    }

    public static void glSamplerParameterIui(int sampler, int pname, ByteBuffer params) {
        ARBSamplerObjects.nglSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glSamplerParameterIu(int sampler, int pname, IntBuffer params) {
        ARBSamplerObjects.nglSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetSamplerParameteriv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().GetSamplerParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglGetSamplerParameteriv(sampler, pname, params, __functionAddress);
    }

    public static void glGetSamplerParameteri(int sampler, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBSamplerObjects.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetSamplerParameter(int sampler, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetSamplerParameteri(int sampler, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBSamplerObjects.nglGetSamplerParameteriv(sampler, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static void nglGetSamplerParameterfv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().GetSamplerParameterfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglGetSamplerParameterfv(sampler, pname, params, __functionAddress);
    }

    public static void glGetSamplerParameterf(int sampler, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBSamplerObjects.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetSamplerParameter(int sampler, int pname, FloatBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static float glGetSamplerParameterf(int sampler, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        ARBSamplerObjects.nglGetSamplerParameterfv(sampler, pname, __buffer.address() + (long)params);
        return __buffer.floatValue(params);
    }

    public static void nglGetSamplerParameterIiv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().GetSamplerParameterIiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglGetSamplerParameterIiv(sampler, pname, params, __functionAddress);
    }

    public static void glGetSamplerParameterIi(int sampler, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBSamplerObjects.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetSamplerParameterI(int sampler, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetSamplerParameterIi(int sampler, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBSamplerObjects.nglGetSamplerParameterIiv(sampler, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static void nglGetSamplerParameterIuiv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().GetSamplerParameterIuiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglGetSamplerParameterIuiv(sampler, pname, params, __functionAddress);
    }

    public static void glGetSamplerParameterIui(int sampler, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBSamplerObjects.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetSamplerParameterIu(int sampler, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetSamplerParameterIui(int sampler, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBSamplerObjects.nglGetSamplerParameterIuiv(sampler, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }
}

