/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBPointParameters {
    public static final int GL_POINT_SIZE_MIN_ARB = 33062;
    public static final int GL_POINT_SIZE_MAX_ARB = 33063;
    public static final int GL_POINT_FADE_THRESHOLD_SIZE_ARB = 33064;
    public static final int GL_POINT_DISTANCE_ATTENUATION_ARB = 33065;
    public final long PointParameterfARB;
    public final long PointParameterfvARB;

    public ARBPointParameters(FunctionProvider provider) {
        this.PointParameterfARB = provider.getFunctionAddress("glPointParameterfARB");
        this.PointParameterfvARB = provider.getFunctionAddress("glPointParameterfvARB");
    }

    public static ARBPointParameters getInstance() {
        return GL.getCapabilities().__ARBPointParameters;
    }

    static ARBPointParameters create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_point_parameters")) {
            return null;
        }
        ARBPointParameters funcs = new ARBPointParameters(provider);
        boolean supported = Checks.checkFunctions(funcs.PointParameterfARB, funcs.PointParameterfvARB);
        return GL.checkExtension("GL_ARB_point_parameters", funcs, supported);
    }

    public static native void nglPointParameterfARB(int var0, float var1, long var2);

    public static void glPointParameterfARB(int pname, float param) {
        long __functionAddress = ARBPointParameters.getInstance().PointParameterfARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBPointParameters.nglPointParameterfARB(pname, param, __functionAddress);
    }

    public static native void nglPointParameterfvARB(int var0, long var1, long var3);

    public static void nglPointParameterfvARB(int pname, long params) {
        long __functionAddress = ARBPointParameters.getInstance().PointParameterfvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBPointParameters.nglPointParameterfvARB(pname, params, __functionAddress);
    }

    public static void glPointParameterfARB(int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 12);
        }
        ARBPointParameters.nglPointParameterfvARB(pname, MemoryUtil.memAddress(params));
    }

    public static void glPointParameterARB(int pname, FloatBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 3);
        }
        ARBPointParameters.nglPointParameterfvARB(pname, MemoryUtil.memAddress(params));
    }
}

