/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBMultiDrawIndirect {
    public final long MultiDrawArraysIndirect;
    public final long MultiDrawElementsIndirect;

    public ARBMultiDrawIndirect(FunctionProvider provider) {
        this.MultiDrawArraysIndirect = provider.getFunctionAddress("glMultiDrawArraysIndirect");
        this.MultiDrawElementsIndirect = provider.getFunctionAddress("glMultiDrawElementsIndirect");
    }

    public static ARBMultiDrawIndirect getInstance() {
        return GL.getCapabilities().__ARBMultiDrawIndirect;
    }

    static ARBMultiDrawIndirect create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_multi_draw_indirect")) {
            return null;
        }
        ARBMultiDrawIndirect funcs = new ARBMultiDrawIndirect(provider);
        boolean supported = Checks.checkFunctions(funcs.MultiDrawArraysIndirect, funcs.MultiDrawElementsIndirect);
        return GL.checkExtension("GL_ARB_multi_draw_indirect", funcs, supported);
    }

    public static void nglMultiDrawArraysIndirect(int mode, long indirect, int primcount, int stride) {
        long __functionAddress = ARBMultiDrawIndirect.getInstance().MultiDrawArraysIndirect;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglMultiDrawArraysIndirect(mode, indirect, primcount, stride, __functionAddress);
    }

    public static void glMultiDrawArraysIndirect(int mode, ByteBuffer indirect, int primcount, int stride) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, primcount * (stride == 0 ? 16 : stride));
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBMultiDrawIndirect.nglMultiDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect), primcount, stride);
    }

    public static void glMultiDrawArraysIndirect(int mode, long indirectOffset, int primcount, int stride) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(36675, true);
        }
        ARBMultiDrawIndirect.nglMultiDrawArraysIndirect(mode, indirectOffset, primcount, stride);
    }

    public static void glMultiDrawArraysIndirect(int mode, IntBuffer indirect, int primcount, int stride) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, primcount * (stride == 0 ? 16 : stride) >> 2);
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBMultiDrawIndirect.nglMultiDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect), primcount, stride);
    }

    public static void nglMultiDrawElementsIndirect(int mode, int type, long indirect, int primcount, int stride) {
        long __functionAddress = ARBMultiDrawIndirect.getInstance().MultiDrawElementsIndirect;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglMultiDrawElementsIndirect(mode, type, indirect, primcount, stride, __functionAddress);
    }

    public static void glMultiDrawElementsIndirect(int mode, int type, ByteBuffer indirect, int primcount, int stride) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, primcount * (stride == 0 ? 20 : stride));
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBMultiDrawIndirect.nglMultiDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect), primcount, stride);
    }

    public static void glMultiDrawElementsIndirect(int mode, int type, long indirectOffset, int primcount, int stride) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(36675, true);
        }
        ARBMultiDrawIndirect.nglMultiDrawElementsIndirect(mode, type, indirectOffset, primcount, stride);
    }

    public static void glMultiDrawElementsIndirect(int mode, int type, IntBuffer indirect, int primcount, int stride) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, primcount * (stride == 0 ? 20 : stride) >> 2);
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBMultiDrawIndirect.nglMultiDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect), primcount, stride);
    }
}

