/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBMatrixPalette {
    public static final int GL_MATRIX_PALETTE_ARB = 34880;
    public static final int GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = 34881;
    public static final int GL_MAX_PALETTE_MATRICES_ARB = 34882;
    public static final int GL_CURRENT_PALETTE_MATRIX_ARB = 34883;
    public static final int GL_MATRIX_INDEX_ARRAY_ARB = 34884;
    public static final int GL_CURRENT_MATRIX_INDEX_ARB = 34885;
    public static final int GL_MATRIX_INDEX_ARRAY_SIZE_ARB = 34886;
    public static final int GL_MATRIX_INDEX_ARRAY_TYPE_ARB = 34887;
    public static final int GL_MATRIX_INDEX_ARRAY_STRIDE_ARB = 34888;
    public static final int GL_MATRIX_INDEX_ARRAY_POINTER_ARB = 34889;
    public final long CurrentPaletteMatrixARB;
    public final long MatrixIndexuivARB;
    public final long MatrixIndexubvARB;
    public final long MatrixIndexusvARB;
    public final long MatrixIndexPointerARB;

    public ARBMatrixPalette(FunctionProvider provider) {
        this.CurrentPaletteMatrixARB = provider.getFunctionAddress("glCurrentPaletteMatrixARB");
        this.MatrixIndexuivARB = provider.getFunctionAddress("glMatrixIndexuivARB");
        this.MatrixIndexubvARB = provider.getFunctionAddress("glMatrixIndexubvARB");
        this.MatrixIndexusvARB = provider.getFunctionAddress("glMatrixIndexusvARB");
        this.MatrixIndexPointerARB = provider.getFunctionAddress("glMatrixIndexPointerARB");
    }

    public static ARBMatrixPalette getInstance() {
        return GL.getCapabilities().__ARBMatrixPalette;
    }

    static ARBMatrixPalette create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_matrix_palette")) {
            return null;
        }
        ARBMatrixPalette funcs = new ARBMatrixPalette(provider);
        boolean supported = Checks.checkFunctions(funcs.CurrentPaletteMatrixARB, funcs.MatrixIndexuivARB, funcs.MatrixIndexubvARB, funcs.MatrixIndexusvARB, funcs.MatrixIndexPointerARB);
        return GL.checkExtension("GL_ARB_matrix_palette", funcs, supported);
    }

    public static native void nglCurrentPaletteMatrixARB(int var0, long var1);

    public static void glCurrentPaletteMatrixARB(int index) {
        long __functionAddress = ARBMatrixPalette.getInstance().CurrentPaletteMatrixARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBMatrixPalette.nglCurrentPaletteMatrixARB(index, __functionAddress);
    }

    public static native void nglMatrixIndexuivARB(int var0, long var1, long var3);

    public static void nglMatrixIndexuivARB(int size, long indices) {
        long __functionAddress = ARBMatrixPalette.getInstance().MatrixIndexuivARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBMatrixPalette.nglMatrixIndexuivARB(size, indices, __functionAddress);
    }

    public static void glMatrixIndexuiARB(int size, ByteBuffer indices) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indices, size << 2);
        }
        ARBMatrixPalette.nglMatrixIndexuivARB(size, MemoryUtil.memAddress(indices));
    }

    public static void glMatrixIndexuARB(IntBuffer indices) {
        ARBMatrixPalette.nglMatrixIndexuivARB(indices.remaining(), MemoryUtil.memAddress(indices));
    }

    public static native void nglMatrixIndexubvARB(int var0, long var1, long var3);

    public static void nglMatrixIndexubvARB(int size, long indices) {
        long __functionAddress = ARBMatrixPalette.getInstance().MatrixIndexubvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBMatrixPalette.nglMatrixIndexubvARB(size, indices, __functionAddress);
    }

    public static void glMatrixIndexubARB(int size, ByteBuffer indices) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indices, size);
        }
        ARBMatrixPalette.nglMatrixIndexubvARB(size, MemoryUtil.memAddress(indices));
    }

    public static void glMatrixIndexubARB(ByteBuffer indices) {
        ARBMatrixPalette.nglMatrixIndexubvARB(indices.remaining(), MemoryUtil.memAddress(indices));
    }

    public static native void nglMatrixIndexusvARB(int var0, long var1, long var3);

    public static void nglMatrixIndexusvARB(int size, long indices) {
        long __functionAddress = ARBMatrixPalette.getInstance().MatrixIndexusvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBMatrixPalette.nglMatrixIndexusvARB(size, indices, __functionAddress);
    }

    public static void glMatrixIndexusARB(int size, ByteBuffer indices) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indices, size << 1);
        }
        ARBMatrixPalette.nglMatrixIndexusvARB(size, MemoryUtil.memAddress(indices));
    }

    public static void glMatrixIndexuARB(ShortBuffer indices) {
        ARBMatrixPalette.nglMatrixIndexusvARB(indices.remaining(), MemoryUtil.memAddress(indices));
    }

    public static native void nglMatrixIndexPointerARB(int var0, int var1, int var2, long var3, long var5);

    public static void nglMatrixIndexPointerARB(int size, int type, int stride, long pointer) {
        long __functionAddress = ARBMatrixPalette.getInstance().MatrixIndexPointerARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, type, stride, pointer, __functionAddress);
    }

    public static void glMatrixIndexPointerARB(int size, int type, int stride, ByteBuffer pointer) {
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glMatrixIndexPointerARB(int size, int stride, ByteBuffer pointer) {
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, 5121, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glMatrixIndexPointerARB(int size, int stride, ShortBuffer pointer) {
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, 5123, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glMatrixIndexPointerARB(int size, int stride, IntBuffer pointer) {
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, 5125, stride, MemoryUtil.memAddress(pointer));
    }
}

