/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBMapBufferRange {
    public static final int GL_MAP_READ_BIT = 1;
    public static final int GL_MAP_WRITE_BIT = 2;
    public static final int GL_MAP_INVALIDATE_RANGE_BIT = 4;
    public static final int GL_MAP_INVALIDATE_BUFFER_BIT = 8;
    public static final int GL_MAP_FLUSH_EXPLICIT_BIT = 16;
    public static final int GL_MAP_UNSYNCHRONIZED_BIT = 32;
    public final long MapBufferRange;
    public final long FlushMappedBufferRange;

    public ARBMapBufferRange(FunctionProvider provider) {
        this.MapBufferRange = provider.getFunctionAddress("glMapBufferRange");
        this.FlushMappedBufferRange = provider.getFunctionAddress("glFlushMappedBufferRange");
    }

    public static ARBMapBufferRange getInstance() {
        return GL.getCapabilities().__ARBMapBufferRange;
    }

    static ARBMapBufferRange create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_map_buffer_range")) {
            return null;
        }
        ARBMapBufferRange funcs = new ARBMapBufferRange(provider);
        boolean supported = Checks.checkFunctions(funcs.MapBufferRange, funcs.FlushMappedBufferRange);
        return GL.checkExtension("GL_ARB_map_buffer_range", funcs, supported);
    }

    public static long nglMapBufferRange(int target, long offset, long length, int access) {
        long __functionAddress = ARBMapBufferRange.getInstance().MapBufferRange;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL30.nglMapBufferRange(target, offset, length, access, __functionAddress);
    }

    public static ByteBuffer glMapBufferRange(int target, long offset, long length, int access) {
        long __result = ARBMapBufferRange.nglMapBufferRange(target, offset, length, access);
        return MemoryUtil.memByteBuffer(__result, length);
    }

    public static ByteBuffer glMapBufferRange(int target, long offset, long length, int access, ByteBuffer old_buffer) {
        long __result = ARBMapBufferRange.nglMapBufferRange(target, offset, length, access);
        return old_buffer != null && __result == MemoryUtil.memAddress0(old_buffer) && (long)old_buffer.capacity() == length ? old_buffer : MemoryUtil.memByteBuffer(__result, length);
    }

    public static void glFlushMappedBufferRange(int target, long offset, long length) {
        long __functionAddress = ARBMapBufferRange.getInstance().FlushMappedBufferRange;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglFlushMappedBufferRange(target, offset, length, __functionAddress);
    }
}

