/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBFramebufferObject {
    public static final int GL_FRAMEBUFFER = 36160;
    public static final int GL_READ_FRAMEBUFFER = 36008;
    public static final int GL_DRAW_FRAMEBUFFER = 36009;
    public static final int GL_RENDERBUFFER = 36161;
    public static final int GL_STENCIL_INDEX1 = 36166;
    public static final int GL_STENCIL_INDEX4 = 36167;
    public static final int GL_STENCIL_INDEX8 = 36168;
    public static final int GL_STENCIL_INDEX16 = 36169;
    public static final int GL_RENDERBUFFER_WIDTH = 36162;
    public static final int GL_RENDERBUFFER_HEIGHT = 36163;
    public static final int GL_RENDERBUFFER_INTERNAL_FORMAT = 36164;
    public static final int GL_RENDERBUFFER_RED_SIZE = 36176;
    public static final int GL_RENDERBUFFER_GREEN_SIZE = 36177;
    public static final int GL_RENDERBUFFER_BLUE_SIZE = 36178;
    public static final int GL_RENDERBUFFER_ALPHA_SIZE = 36179;
    public static final int GL_RENDERBUFFER_DEPTH_SIZE = 36180;
    public static final int GL_RENDERBUFFER_STENCIL_SIZE = 36181;
    public static final int GL_RENDERBUFFER_SAMPLES = 36011;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 36048;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 36049;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 36050;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 36051;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 36052;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 33296;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 33297;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = 33298;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 33299;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 33300;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 33301;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 33302;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 33303;
    public static final int GL_FRAMEBUFFER_DEFAULT = 33304;
    public static final int GL_INDEX = 33314;
    public static final int GL_COLOR_ATTACHMENT0 = 36064;
    public static final int GL_COLOR_ATTACHMENT1 = 36065;
    public static final int GL_COLOR_ATTACHMENT2 = 36066;
    public static final int GL_COLOR_ATTACHMENT3 = 36067;
    public static final int GL_COLOR_ATTACHMENT4 = 36068;
    public static final int GL_COLOR_ATTACHMENT5 = 36069;
    public static final int GL_COLOR_ATTACHMENT6 = 36070;
    public static final int GL_COLOR_ATTACHMENT7 = 36071;
    public static final int GL_COLOR_ATTACHMENT8 = 36072;
    public static final int GL_COLOR_ATTACHMENT9 = 36073;
    public static final int GL_COLOR_ATTACHMENT10 = 36074;
    public static final int GL_COLOR_ATTACHMENT11 = 36075;
    public static final int GL_COLOR_ATTACHMENT12 = 36076;
    public static final int GL_COLOR_ATTACHMENT13 = 36077;
    public static final int GL_COLOR_ATTACHMENT14 = 36078;
    public static final int GL_COLOR_ATTACHMENT15 = 36079;
    public static final int GL_DEPTH_ATTACHMENT = 36096;
    public static final int GL_STENCIL_ATTACHMENT = 36128;
    public static final int GL_DEPTH_STENCIL_ATTACHMENT = 33306;
    public static final int GL_MAX_SAMPLES = 36183;
    public static final int GL_FRAMEBUFFER_COMPLETE = 36053;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 36059;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 36060;
    public static final int GL_FRAMEBUFFER_UNSUPPORTED = 36061;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 36182;
    public static final int GL_FRAMEBUFFER_UNDEFINED = 33305;
    public static final int GL_FRAMEBUFFER_BINDING = 36006;
    public static final int GL_DRAW_FRAMEBUFFER_BINDING = 36006;
    public static final int GL_READ_FRAMEBUFFER_BINDING = 36010;
    public static final int GL_RENDERBUFFER_BINDING = 36007;
    public static final int GL_MAX_COLOR_ATTACHMENTS = 36063;
    public static final int GL_MAX_RENDERBUFFER_SIZE = 34024;
    public static final int GL_INVALID_FRAMEBUFFER_OPERATION = 1286;
    public static final int GL_DEPTH_STENCIL = 34041;
    public static final int GL_UNSIGNED_INT_24_8 = 34042;
    public static final int GL_DEPTH24_STENCIL8 = 35056;
    public static final int GL_TEXTURE_STENCIL_SIZE = 35057;
    public final long IsRenderbuffer;
    public final long BindRenderbuffer;
    public final long DeleteRenderbuffers;
    public final long GenRenderbuffers;
    public final long RenderbufferStorage;
    public final long RenderbufferStorageMultisample;
    public final long GetRenderbufferParameteriv;
    public final long IsFramebuffer;
    public final long BindFramebuffer;
    public final long DeleteFramebuffers;
    public final long GenFramebuffers;
    public final long CheckFramebufferStatus;
    public final long FramebufferTexture1D;
    public final long FramebufferTexture2D;
    public final long FramebufferTexture3D;
    public final long FramebufferTextureLayer;
    public final long FramebufferRenderbuffer;
    public final long GetFramebufferAttachmentParameteriv;
    public final long BlitFramebuffer;
    public final long GenerateMipmap;

    public ARBFramebufferObject(FunctionProvider provider) {
        this.IsRenderbuffer = provider.getFunctionAddress("glIsRenderbuffer");
        this.BindRenderbuffer = provider.getFunctionAddress("glBindRenderbuffer");
        this.DeleteRenderbuffers = provider.getFunctionAddress("glDeleteRenderbuffers");
        this.GenRenderbuffers = provider.getFunctionAddress("glGenRenderbuffers");
        this.RenderbufferStorage = provider.getFunctionAddress("glRenderbufferStorage");
        this.RenderbufferStorageMultisample = provider.getFunctionAddress("glRenderbufferStorageMultisample");
        this.GetRenderbufferParameteriv = provider.getFunctionAddress("glGetRenderbufferParameteriv");
        this.IsFramebuffer = provider.getFunctionAddress("glIsFramebuffer");
        this.BindFramebuffer = provider.getFunctionAddress("glBindFramebuffer");
        this.DeleteFramebuffers = provider.getFunctionAddress("glDeleteFramebuffers");
        this.GenFramebuffers = provider.getFunctionAddress("glGenFramebuffers");
        this.CheckFramebufferStatus = provider.getFunctionAddress("glCheckFramebufferStatus");
        this.FramebufferTexture1D = provider.getFunctionAddress("glFramebufferTexture1D");
        this.FramebufferTexture2D = provider.getFunctionAddress("glFramebufferTexture2D");
        this.FramebufferTexture3D = provider.getFunctionAddress("glFramebufferTexture3D");
        this.FramebufferTextureLayer = provider.getFunctionAddress("glFramebufferTextureLayer");
        this.FramebufferRenderbuffer = provider.getFunctionAddress("glFramebufferRenderbuffer");
        this.GetFramebufferAttachmentParameteriv = provider.getFunctionAddress("glGetFramebufferAttachmentParameteriv");
        this.BlitFramebuffer = provider.getFunctionAddress("glBlitFramebuffer");
        this.GenerateMipmap = provider.getFunctionAddress("glGenerateMipmap");
    }

    public static ARBFramebufferObject getInstance() {
        return GL.getCapabilities().__ARBFramebufferObject;
    }

    static ARBFramebufferObject create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_framebuffer_object")) {
            return null;
        }
        ARBFramebufferObject funcs = new ARBFramebufferObject(provider);
        boolean supported = Checks.checkFunctions(funcs.IsRenderbuffer, funcs.BindRenderbuffer, funcs.DeleteRenderbuffers, funcs.GenRenderbuffers, funcs.RenderbufferStorage, funcs.RenderbufferStorageMultisample, funcs.GetRenderbufferParameteriv, funcs.IsFramebuffer, funcs.BindFramebuffer, funcs.DeleteFramebuffers, funcs.GenFramebuffers, funcs.CheckFramebufferStatus, funcs.FramebufferTexture1D, funcs.FramebufferTexture2D, funcs.FramebufferTexture3D, funcs.FramebufferTextureLayer, funcs.FramebufferRenderbuffer, funcs.GetFramebufferAttachmentParameteriv, funcs.BlitFramebuffer, funcs.GenerateMipmap);
        return GL.checkExtension("GL_ARB_framebuffer_object", funcs, supported);
    }

    public static boolean glIsRenderbuffer(int renderbuffer) {
        long __functionAddress = ARBFramebufferObject.getInstance().IsRenderbuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL30.nglIsRenderbuffer(renderbuffer, __functionAddress);
    }

    public static void glBindRenderbuffer(int target, int renderbuffer) {
        long __functionAddress = ARBFramebufferObject.getInstance().BindRenderbuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglBindRenderbuffer(target, renderbuffer, __functionAddress);
    }

    public static void nglDeleteRenderbuffers(int n, long renderbuffers) {
        long __functionAddress = ARBFramebufferObject.getInstance().DeleteRenderbuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglDeleteRenderbuffers(n, renderbuffers, __functionAddress);
    }

    public static void glDeleteRenderbuffers(int n, ByteBuffer renderbuffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)renderbuffers, n << 2);
        }
        ARBFramebufferObject.nglDeleteRenderbuffers(n, MemoryUtil.memAddress(renderbuffers));
    }

    public static void glDeleteRenderbuffers(IntBuffer renderbuffers) {
        ARBFramebufferObject.nglDeleteRenderbuffers(renderbuffers.remaining(), MemoryUtil.memAddress(renderbuffers));
    }

    public static void glDeleteRenderbuffers(int renderbuffer) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int renderbuffers = __buffer.intParam(renderbuffer);
        ARBFramebufferObject.nglDeleteRenderbuffers(1, __buffer.address() + (long)renderbuffers);
    }

    public static void nglGenRenderbuffers(int n, long renderbuffers) {
        long __functionAddress = ARBFramebufferObject.getInstance().GenRenderbuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglGenRenderbuffers(n, renderbuffers, __functionAddress);
    }

    public static void glGenRenderbuffers(int n, ByteBuffer renderbuffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)renderbuffers, n << 2);
        }
        ARBFramebufferObject.nglGenRenderbuffers(n, MemoryUtil.memAddress(renderbuffers));
    }

    public static void glGenRenderbuffers(IntBuffer renderbuffers) {
        ARBFramebufferObject.nglGenRenderbuffers(renderbuffers.remaining(), MemoryUtil.memAddress(renderbuffers));
    }

    public static int glGenRenderbuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int renderbuffers = __buffer.intParam();
        ARBFramebufferObject.nglGenRenderbuffers(1, __buffer.address() + (long)renderbuffers);
        return __buffer.intValue(renderbuffers);
    }

    public static void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        long __functionAddress = ARBFramebufferObject.getInstance().RenderbufferStorage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglRenderbufferStorage(target, internalformat, width, height, __functionAddress);
    }

    public static void glRenderbufferStorageMultisample(int target, int samples, int internalformat, int width, int height) {
        long __functionAddress = ARBFramebufferObject.getInstance().RenderbufferStorageMultisample;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglRenderbufferStorageMultisample(target, samples, internalformat, width, height, __functionAddress);
    }

    public static void nglGetRenderbufferParameteriv(int target, int pname, long params) {
        long __functionAddress = ARBFramebufferObject.getInstance().GetRenderbufferParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglGetRenderbufferParameteriv(target, pname, params, __functionAddress);
    }

    public static void glGetRenderbufferParameteri(int target, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBFramebufferObject.nglGetRenderbufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetRenderbufferParameter(int target, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBFramebufferObject.nglGetRenderbufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetRenderbufferParameteri(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBFramebufferObject.nglGetRenderbufferParameteriv(target, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static boolean glIsFramebuffer(int framebuffer) {
        long __functionAddress = ARBFramebufferObject.getInstance().IsFramebuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL30.nglIsFramebuffer(framebuffer, __functionAddress);
    }

    public static void glBindFramebuffer(int target, int framebuffer) {
        long __functionAddress = ARBFramebufferObject.getInstance().BindFramebuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglBindFramebuffer(target, framebuffer, __functionAddress);
    }

    public static void nglDeleteFramebuffers(int n, long framebuffers) {
        long __functionAddress = ARBFramebufferObject.getInstance().DeleteFramebuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglDeleteFramebuffers(n, framebuffers, __functionAddress);
    }

    public static void glDeleteFramebuffers(int n, ByteBuffer framebuffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)framebuffers, n << 2);
        }
        ARBFramebufferObject.nglDeleteFramebuffers(n, MemoryUtil.memAddress(framebuffers));
    }

    public static void glDeleteFramebuffers(IntBuffer framebuffers) {
        ARBFramebufferObject.nglDeleteFramebuffers(framebuffers.remaining(), MemoryUtil.memAddress(framebuffers));
    }

    public static void glDeleteFramebuffers(int framebuffer) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int framebuffers = __buffer.intParam(framebuffer);
        ARBFramebufferObject.nglDeleteFramebuffers(1, __buffer.address() + (long)framebuffers);
    }

    public static void nglGenFramebuffers(int n, long framebuffers) {
        long __functionAddress = ARBFramebufferObject.getInstance().GenFramebuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglGenFramebuffers(n, framebuffers, __functionAddress);
    }

    public static void glGenFramebuffers(int n, ByteBuffer framebuffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)framebuffers, n << 2);
        }
        ARBFramebufferObject.nglGenFramebuffers(n, MemoryUtil.memAddress(framebuffers));
    }

    public static void glGenFramebuffers(IntBuffer framebuffers) {
        ARBFramebufferObject.nglGenFramebuffers(framebuffers.remaining(), MemoryUtil.memAddress(framebuffers));
    }

    public static int glGenFramebuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int framebuffers = __buffer.intParam();
        ARBFramebufferObject.nglGenFramebuffers(1, __buffer.address() + (long)framebuffers);
        return __buffer.intValue(framebuffers);
    }

    public static int glCheckFramebufferStatus(int target) {
        long __functionAddress = ARBFramebufferObject.getInstance().CheckFramebufferStatus;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL30.nglCheckFramebufferStatus(target, __functionAddress);
    }

    public static void glFramebufferTexture1D(int target, int attachment, int textarget, int texture, int level) {
        long __functionAddress = ARBFramebufferObject.getInstance().FramebufferTexture1D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglFramebufferTexture1D(target, attachment, textarget, texture, level, __functionAddress);
    }

    public static void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        long __functionAddress = ARBFramebufferObject.getInstance().FramebufferTexture2D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglFramebufferTexture2D(target, attachment, textarget, texture, level, __functionAddress);
    }

    public static void glFramebufferTexture3D(int target, int attachment, int textarget, int texture, int level, int layer) {
        long __functionAddress = ARBFramebufferObject.getInstance().FramebufferTexture3D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglFramebufferTexture3D(target, attachment, textarget, texture, level, layer, __functionAddress);
    }

    public static void glFramebufferTextureLayer(int target, int attachment, int texture, int level, int layer) {
        long __functionAddress = ARBFramebufferObject.getInstance().FramebufferTextureLayer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglFramebufferTextureLayer(target, attachment, texture, level, layer, __functionAddress);
    }

    public static void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        long __functionAddress = ARBFramebufferObject.getInstance().FramebufferRenderbuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer, __functionAddress);
    }

    public static void nglGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, long params) {
        long __functionAddress = ARBFramebufferObject.getInstance().GetFramebufferAttachmentParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglGetFramebufferAttachmentParameteriv(target, attachment, pname, params, __functionAddress);
    }

    public static void glGetFramebufferAttachmentParameteri(int target, int attachment, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBFramebufferObject.nglGetFramebufferAttachmentParameteriv(target, attachment, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetFramebufferAttachmentParameter(int target, int attachment, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBFramebufferObject.nglGetFramebufferAttachmentParameteriv(target, attachment, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetFramebufferAttachmentParameteri(int target, int attachment, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBFramebufferObject.nglGetFramebufferAttachmentParameteriv(target, attachment, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        long __functionAddress = ARBFramebufferObject.getInstance().BlitFramebuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglBlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter, __functionAddress);
    }

    public static void glGenerateMipmap(int target) {
        long __functionAddress = ARBFramebufferObject.getInstance().GenerateMipmap;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL30.nglGenerateMipmap(target, __functionAddress);
    }
}

