/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBFramebufferNoAttachments {
    public static final int GL_FRAMEBUFFER_DEFAULT_WIDTH = 37648;
    public static final int GL_FRAMEBUFFER_DEFAULT_HEIGHT = 37649;
    public static final int GL_FRAMEBUFFER_DEFAULT_LAYERS = 37650;
    public static final int GL_FRAMEBUFFER_DEFAULT_SAMPLES = 37651;
    public static final int GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = 37652;
    public static final int GL_MAX_FRAMEBUFFER_WIDTH = 37653;
    public static final int GL_MAX_FRAMEBUFFER_HEIGHT = 37654;
    public static final int GL_MAX_FRAMEBUFFER_LAYERS = 37655;
    public static final int GL_MAX_FRAMEBUFFER_SAMPLES = 37656;
    public final long FramebufferParameteri;
    public final long GetFramebufferParameteriv;
    public final long NamedFramebufferParameteriEXT;
    public final long GetNamedFramebufferParameterivEXT;

    public ARBFramebufferNoAttachments(FunctionProvider provider) {
        this.FramebufferParameteri = provider.getFunctionAddress("glFramebufferParameteri");
        this.GetFramebufferParameteriv = provider.getFunctionAddress("glGetFramebufferParameteriv");
        this.NamedFramebufferParameteriEXT = provider.getFunctionAddress("glNamedFramebufferParameteriEXT");
        this.GetNamedFramebufferParameterivEXT = provider.getFunctionAddress("glGetNamedFramebufferParameterivEXT");
    }

    public static ARBFramebufferNoAttachments getInstance() {
        return GL.getCapabilities().__ARBFramebufferNoAttachments;
    }

    static ARBFramebufferNoAttachments create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_framebuffer_no_attachments")) {
            return null;
        }
        ARBFramebufferNoAttachments funcs = new ARBFramebufferNoAttachments(provider);
        boolean supported = Checks.checkFunctions(funcs.FramebufferParameteri, funcs.GetFramebufferParameteriv, ext.contains("GL_EXT_direct_state_access") ? funcs.NamedFramebufferParameteriEXT : -1L, ext.contains("GL_EXT_direct_state_access") ? funcs.GetNamedFramebufferParameterivEXT : -1L);
        return GL.checkExtension("GL_ARB_framebuffer_no_attachments", funcs, supported);
    }

    public static void glFramebufferParameteri(int target, int pname, int param) {
        long __functionAddress = ARBFramebufferNoAttachments.getInstance().FramebufferParameteri;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglFramebufferParameteri(target, pname, param, __functionAddress);
    }

    public static void nglGetFramebufferParameteriv(int target, int pname, long params) {
        long __functionAddress = ARBFramebufferNoAttachments.getInstance().GetFramebufferParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglGetFramebufferParameteriv(target, pname, params, __functionAddress);
    }

    public static void glGetFramebufferParameteri(int target, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBFramebufferNoAttachments.nglGetFramebufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetFramebufferParameter(int target, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBFramebufferNoAttachments.nglGetFramebufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetFramebufferParameteri(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBFramebufferNoAttachments.nglGetFramebufferParameteriv(target, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static native void nglNamedFramebufferParameteriEXT(int var0, int var1, int var2, long var3);

    public static void glNamedFramebufferParameteriEXT(int framebuffer, int pname, int param) {
        long __functionAddress = ARBFramebufferNoAttachments.getInstance().NamedFramebufferParameteriEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBFramebufferNoAttachments.nglNamedFramebufferParameteriEXT(framebuffer, pname, param, __functionAddress);
    }

    public static native void nglGetNamedFramebufferParameterivEXT(int var0, int var1, long var2, long var4);

    public static void nglGetNamedFramebufferParameterivEXT(int framebuffer, int pname, long params) {
        long __functionAddress = ARBFramebufferNoAttachments.getInstance().GetNamedFramebufferParameterivEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBFramebufferNoAttachments.nglGetNamedFramebufferParameterivEXT(framebuffer, pname, params, __functionAddress);
    }

    public static void glGetNamedFramebufferParameteriEXT(int framebuffer, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBFramebufferNoAttachments.nglGetNamedFramebufferParameterivEXT(framebuffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedFramebufferParameterEXT(int framebuffer, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBFramebufferNoAttachments.nglGetNamedFramebufferParameterivEXT(framebuffer, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedFramebufferParameteriEXT(int framebuffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBFramebufferNoAttachments.nglGetNamedFramebufferParameterivEXT(framebuffer, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }
}

