/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBDrawInstanced {
    public final long DrawArraysInstancedARB;
    public final long DrawElementsInstancedARB;

    public ARBDrawInstanced(FunctionProvider provider) {
        this.DrawArraysInstancedARB = provider.getFunctionAddress("glDrawArraysInstancedARB");
        this.DrawElementsInstancedARB = provider.getFunctionAddress("glDrawElementsInstancedARB");
    }

    public static ARBDrawInstanced getInstance() {
        return GL.getCapabilities().__ARBDrawInstanced;
    }

    static ARBDrawInstanced create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_draw_instanced")) {
            return null;
        }
        ARBDrawInstanced funcs = new ARBDrawInstanced(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawArraysInstancedARB, funcs.DrawElementsInstancedARB);
        return GL.checkExtension("GL_ARB_draw_instanced", funcs, supported);
    }

    public static native void nglDrawArraysInstancedARB(int var0, int var1, int var2, int var3, long var4);

    public static void glDrawArraysInstancedARB(int mode, int first, int count, int primcount) {
        long __functionAddress = ARBDrawInstanced.getInstance().DrawArraysInstancedARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBDrawInstanced.nglDrawArraysInstancedARB(mode, first, count, primcount, __functionAddress);
    }

    public static native void nglDrawElementsInstancedARB(int var0, int var1, int var2, long var3, int var5, long var6);

    public static void nglDrawElementsInstancedARB(int mode, int count, int type, long indices, int primcount) {
        long __functionAddress = ARBDrawInstanced.getInstance().DrawElementsInstancedARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBDrawInstanced.nglDrawElementsInstancedARB(mode, count, type, indices, primcount, __functionAddress);
    }

    public static void glDrawElementsInstancedARB(int mode, int count, int type, ByteBuffer indices, int primcount) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count / GLChecks.typeToBytes(type));
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawInstanced.nglDrawElementsInstancedARB(mode, count, type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedARB(int mode, int count, int type, long indicesOffset, int primcount) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        ARBDrawInstanced.nglDrawElementsInstancedARB(mode, count, type, indicesOffset, primcount);
    }

    public static void glDrawElementsInstancedARB(int mode, int type, ByteBuffer indices, int primcount) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        ARBDrawInstanced.nglDrawElementsInstancedARB(mode, indices.remaining() * GLChecks.typeToBytes(type), type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedARB(int mode, ByteBuffer indices, int primcount) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawInstanced.nglDrawElementsInstancedARB(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedARB(int mode, ShortBuffer indices, int primcount) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawInstanced.nglDrawElementsInstancedARB(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedARB(int mode, IntBuffer indices, int primcount) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawInstanced.nglDrawElementsInstancedARB(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount);
    }
}

