/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL40;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBDrawIndirect {
    public static final int GL_DRAW_INDIRECT_BUFFER = 36671;
    public static final int GL_DRAW_INDIRECT_BUFFER_BINDING = 36675;
    public final long DrawArraysIndirect;
    public final long DrawElementsIndirect;

    public ARBDrawIndirect(FunctionProvider provider) {
        this.DrawArraysIndirect = provider.getFunctionAddress("glDrawArraysIndirect");
        this.DrawElementsIndirect = provider.getFunctionAddress("glDrawElementsIndirect");
    }

    public static ARBDrawIndirect getInstance() {
        return GL.getCapabilities().__ARBDrawIndirect;
    }

    static ARBDrawIndirect create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_draw_indirect")) {
            return null;
        }
        ARBDrawIndirect funcs = new ARBDrawIndirect(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawArraysIndirect, funcs.DrawElementsIndirect);
        return GL.checkExtension("GL_ARB_draw_indirect", funcs, supported);
    }

    public static void nglDrawArraysIndirect(int mode, long indirect) {
        long __functionAddress = ARBDrawIndirect.getInstance().DrawArraysIndirect;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL40.nglDrawArraysIndirect(mode, indirect, __functionAddress);
    }

    public static void glDrawArraysIndirect(int mode, ByteBuffer indirect) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 16);
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBDrawIndirect.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawArraysIndirect(int mode, long indirectOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(36675, true);
        }
        ARBDrawIndirect.nglDrawArraysIndirect(mode, indirectOffset);
    }

    public static void glDrawArraysIndirect(int mode, IntBuffer indirect) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 4);
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBDrawIndirect.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static void nglDrawElementsIndirect(int mode, int type, long indirect) {
        long __functionAddress = ARBDrawIndirect.getInstance().DrawElementsIndirect;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL40.nglDrawElementsIndirect(mode, type, indirect, __functionAddress);
    }

    public static void glDrawElementsIndirect(int mode, int type, ByteBuffer indirect) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 20);
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBDrawIndirect.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawElementsIndirect(int mode, int type, long indirectOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(36675, true);
        }
        ARBDrawIndirect.nglDrawElementsIndirect(mode, type, indirectOffset);
    }

    public static void glDrawElementsIndirect(int mode, int type, IntBuffer indirect) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 5);
            GLChecks.ensureBufferObject(36675, false);
        }
        ARBDrawIndirect.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }
}

