/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL45;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBDirectStateAccess {
    public static final int GL_TEXTURE_TARGET = 4102;
    public static final int GL_QUERY_TARGET = 33514;
    public static final int GL_TEXTURE_BINDING = 33515;
    public final long CreateTransformFeedbacks;
    public final long TransformFeedbackBufferBase;
    public final long TransformFeedbackBufferRange;
    public final long GetTransformFeedbackiv;
    public final long GetTransformFeedbacki_v;
    public final long GetTransformFeedbacki64_v;
    public final long CreateBuffers;
    public final long NamedBufferStorage;
    public final long NamedBufferData;
    public final long NamedBufferSubData;
    public final long CopyNamedBufferSubData;
    public final long ClearNamedBufferData;
    public final long ClearNamedBufferSubData;
    public final long MapNamedBuffer;
    public final long MapNamedBufferRange;
    public final long UnmapNamedBuffer;
    public final long FlushMappedNamedBufferRange;
    public final long GetNamedBufferParameteriv;
    public final long GetNamedBufferParameteri64v;
    public final long GetNamedBufferPointerv;
    public final long GetNamedBufferSubData;
    public final long CreateFramebuffers;
    public final long NamedFramebufferRenderbuffer;
    public final long NamedFramebufferParameteri;
    public final long NamedFramebufferTexture;
    public final long NamedFramebufferTextureLayer;
    public final long NamedFramebufferDrawBuffer;
    public final long NamedFramebufferDrawBuffers;
    public final long NamedFramebufferReadBuffer;
    public final long InvalidateNamedFramebufferData;
    public final long InvalidateNamedFramebufferSubData;
    public final long ClearNamedFramebufferiv;
    public final long ClearNamedFramebufferuiv;
    public final long ClearNamedFramebufferfv;
    public final long ClearNamedFramebufferfi;
    public final long BlitNamedFramebuffer;
    public final long CheckNamedFramebufferStatus;
    public final long GetNamedFramebufferParameteriv;
    public final long GetNamedFramebufferAttachmentParameteriv;
    public final long CreateRenderbuffers;
    public final long NamedRenderbufferStorage;
    public final long NamedRenderbufferStorageMultisample;
    public final long GetNamedRenderbufferParameteriv;
    public final long CreateTextures;
    public final long TextureBuffer;
    public final long TextureBufferRange;
    public final long TextureStorage1D;
    public final long TextureStorage2D;
    public final long TextureStorage3D;
    public final long TextureStorage2DMultisample;
    public final long TextureStorage3DMultisample;
    public final long TextureSubImage1D;
    public final long TextureSubImage2D;
    public final long TextureSubImage3D;
    public final long CompressedTextureSubImage1D;
    public final long CompressedTextureSubImage2D;
    public final long CompressedTextureSubImage3D;
    public final long CopyTextureSubImage1D;
    public final long CopyTextureSubImage2D;
    public final long CopyTextureSubImage3D;
    public final long TextureParameterf;
    public final long TextureParameterfv;
    public final long TextureParameteri;
    public final long TextureParameterIiv;
    public final long TextureParameterIuiv;
    public final long TextureParameteriv;
    public final long GenerateTextureMipmap;
    public final long BindTextureUnit;
    public final long GetTextureImage;
    public final long GetCompressedTextureImage;
    public final long GetTextureLevelParameterfv;
    public final long GetTextureLevelParameteriv;
    public final long GetTextureParameterfv;
    public final long GetTextureParameterIiv;
    public final long GetTextureParameterIuiv;
    public final long GetTextureParameteriv;
    public final long CreateVertexArrays;
    public final long DisableVertexArrayAttrib;
    public final long EnableVertexArrayAttrib;
    public final long VertexArrayElementBuffer;
    public final long VertexArrayVertexBuffer;
    public final long VertexArrayVertexBuffers;
    public final long VertexArrayAttribFormat;
    public final long VertexArrayAttribIFormat;
    public final long VertexArrayAttribLFormat;
    public final long VertexArrayAttribBinding;
    public final long VertexArrayBindingDivisor;
    public final long GetVertexArrayiv;
    public final long GetVertexArrayIndexediv;
    public final long GetVertexArrayIndexed64iv;
    public final long CreateSamplers;
    public final long CreateProgramPipelines;
    public final long CreateQueries;

    public ARBDirectStateAccess(FunctionProvider provider) {
        this.CreateTransformFeedbacks = provider.getFunctionAddress("glCreateTransformFeedbacks");
        this.TransformFeedbackBufferBase = provider.getFunctionAddress("glTransformFeedbackBufferBase");
        this.TransformFeedbackBufferRange = provider.getFunctionAddress("glTransformFeedbackBufferRange");
        this.GetTransformFeedbackiv = provider.getFunctionAddress("glGetTransformFeedbackiv");
        this.GetTransformFeedbacki_v = provider.getFunctionAddress("glGetTransformFeedbacki_v");
        this.GetTransformFeedbacki64_v = provider.getFunctionAddress("glGetTransformFeedbacki64_v");
        this.CreateBuffers = provider.getFunctionAddress("glCreateBuffers");
        this.NamedBufferStorage = provider.getFunctionAddress("glNamedBufferStorage");
        this.NamedBufferData = provider.getFunctionAddress("glNamedBufferData");
        this.NamedBufferSubData = provider.getFunctionAddress("glNamedBufferSubData");
        this.CopyNamedBufferSubData = provider.getFunctionAddress("glCopyNamedBufferSubData");
        this.ClearNamedBufferData = provider.getFunctionAddress("glClearNamedBufferData");
        this.ClearNamedBufferSubData = provider.getFunctionAddress("glClearNamedBufferSubData");
        this.MapNamedBuffer = provider.getFunctionAddress("glMapNamedBuffer");
        this.MapNamedBufferRange = provider.getFunctionAddress("glMapNamedBufferRange");
        this.UnmapNamedBuffer = provider.getFunctionAddress("glUnmapNamedBuffer");
        this.FlushMappedNamedBufferRange = provider.getFunctionAddress("glFlushMappedNamedBufferRange");
        this.GetNamedBufferParameteriv = provider.getFunctionAddress("glGetNamedBufferParameteriv");
        this.GetNamedBufferParameteri64v = provider.getFunctionAddress("glGetNamedBufferParameteri64v");
        this.GetNamedBufferPointerv = provider.getFunctionAddress("glGetNamedBufferPointerv");
        this.GetNamedBufferSubData = provider.getFunctionAddress("glGetNamedBufferSubData");
        this.CreateFramebuffers = provider.getFunctionAddress("glCreateFramebuffers");
        this.NamedFramebufferRenderbuffer = provider.getFunctionAddress("glNamedFramebufferRenderbuffer");
        this.NamedFramebufferParameteri = provider.getFunctionAddress("glNamedFramebufferParameteri");
        this.NamedFramebufferTexture = provider.getFunctionAddress("glNamedFramebufferTexture");
        this.NamedFramebufferTextureLayer = provider.getFunctionAddress("glNamedFramebufferTextureLayer");
        this.NamedFramebufferDrawBuffer = provider.getFunctionAddress("glNamedFramebufferDrawBuffer");
        this.NamedFramebufferDrawBuffers = provider.getFunctionAddress("glNamedFramebufferDrawBuffers");
        this.NamedFramebufferReadBuffer = provider.getFunctionAddress("glNamedFramebufferReadBuffer");
        this.InvalidateNamedFramebufferData = provider.getFunctionAddress("glInvalidateNamedFramebufferData");
        this.InvalidateNamedFramebufferSubData = provider.getFunctionAddress("glInvalidateNamedFramebufferSubData");
        this.ClearNamedFramebufferiv = provider.getFunctionAddress("glClearNamedFramebufferiv");
        this.ClearNamedFramebufferuiv = provider.getFunctionAddress("glClearNamedFramebufferuiv");
        this.ClearNamedFramebufferfv = provider.getFunctionAddress("glClearNamedFramebufferfv");
        this.ClearNamedFramebufferfi = provider.getFunctionAddress("glClearNamedFramebufferfi");
        this.BlitNamedFramebuffer = provider.getFunctionAddress("glBlitNamedFramebuffer");
        this.CheckNamedFramebufferStatus = provider.getFunctionAddress("glCheckNamedFramebufferStatus");
        this.GetNamedFramebufferParameteriv = provider.getFunctionAddress("glGetNamedFramebufferParameteriv");
        this.GetNamedFramebufferAttachmentParameteriv = provider.getFunctionAddress("glGetNamedFramebufferAttachmentParameteriv");
        this.CreateRenderbuffers = provider.getFunctionAddress("glCreateRenderbuffers");
        this.NamedRenderbufferStorage = provider.getFunctionAddress("glNamedRenderbufferStorage");
        this.NamedRenderbufferStorageMultisample = provider.getFunctionAddress("glNamedRenderbufferStorageMultisample");
        this.GetNamedRenderbufferParameteriv = provider.getFunctionAddress("glGetNamedRenderbufferParameteriv");
        this.CreateTextures = provider.getFunctionAddress("glCreateTextures");
        this.TextureBuffer = provider.getFunctionAddress("glTextureBuffer");
        this.TextureBufferRange = provider.getFunctionAddress("glTextureBufferRange");
        this.TextureStorage1D = provider.getFunctionAddress("glTextureStorage1D");
        this.TextureStorage2D = provider.getFunctionAddress("glTextureStorage2D");
        this.TextureStorage3D = provider.getFunctionAddress("glTextureStorage3D");
        this.TextureStorage2DMultisample = provider.getFunctionAddress("glTextureStorage2DMultisample");
        this.TextureStorage3DMultisample = provider.getFunctionAddress("glTextureStorage3DMultisample");
        this.TextureSubImage1D = provider.getFunctionAddress("glTextureSubImage1D");
        this.TextureSubImage2D = provider.getFunctionAddress("glTextureSubImage2D");
        this.TextureSubImage3D = provider.getFunctionAddress("glTextureSubImage3D");
        this.CompressedTextureSubImage1D = provider.getFunctionAddress("glCompressedTextureSubImage1D");
        this.CompressedTextureSubImage2D = provider.getFunctionAddress("glCompressedTextureSubImage2D");
        this.CompressedTextureSubImage3D = provider.getFunctionAddress("glCompressedTextureSubImage3D");
        this.CopyTextureSubImage1D = provider.getFunctionAddress("glCopyTextureSubImage1D");
        this.CopyTextureSubImage2D = provider.getFunctionAddress("glCopyTextureSubImage2D");
        this.CopyTextureSubImage3D = provider.getFunctionAddress("glCopyTextureSubImage3D");
        this.TextureParameterf = provider.getFunctionAddress("glTextureParameterf");
        this.TextureParameterfv = provider.getFunctionAddress("glTextureParameterfv");
        this.TextureParameteri = provider.getFunctionAddress("glTextureParameteri");
        this.TextureParameterIiv = provider.getFunctionAddress("glTextureParameterIiv");
        this.TextureParameterIuiv = provider.getFunctionAddress("glTextureParameterIuiv");
        this.TextureParameteriv = provider.getFunctionAddress("glTextureParameteriv");
        this.GenerateTextureMipmap = provider.getFunctionAddress("glGenerateTextureMipmap");
        this.BindTextureUnit = provider.getFunctionAddress("glBindTextureUnit");
        this.GetTextureImage = provider.getFunctionAddress("glGetTextureImage");
        this.GetCompressedTextureImage = provider.getFunctionAddress("glGetCompressedTextureImage");
        this.GetTextureLevelParameterfv = provider.getFunctionAddress("glGetTextureLevelParameterfv");
        this.GetTextureLevelParameteriv = provider.getFunctionAddress("glGetTextureLevelParameteriv");
        this.GetTextureParameterfv = provider.getFunctionAddress("glGetTextureParameterfv");
        this.GetTextureParameterIiv = provider.getFunctionAddress("glGetTextureParameterIiv");
        this.GetTextureParameterIuiv = provider.getFunctionAddress("glGetTextureParameterIuiv");
        this.GetTextureParameteriv = provider.getFunctionAddress("glGetTextureParameteriv");
        this.CreateVertexArrays = provider.getFunctionAddress("glCreateVertexArrays");
        this.DisableVertexArrayAttrib = provider.getFunctionAddress("glDisableVertexArrayAttrib");
        this.EnableVertexArrayAttrib = provider.getFunctionAddress("glEnableVertexArrayAttrib");
        this.VertexArrayElementBuffer = provider.getFunctionAddress("glVertexArrayElementBuffer");
        this.VertexArrayVertexBuffer = provider.getFunctionAddress("glVertexArrayVertexBuffer");
        this.VertexArrayVertexBuffers = provider.getFunctionAddress("glVertexArrayVertexBuffers");
        this.VertexArrayAttribFormat = provider.getFunctionAddress("glVertexArrayAttribFormat");
        this.VertexArrayAttribIFormat = provider.getFunctionAddress("glVertexArrayAttribIFormat");
        this.VertexArrayAttribLFormat = provider.getFunctionAddress("glVertexArrayAttribLFormat");
        this.VertexArrayAttribBinding = provider.getFunctionAddress("glVertexArrayAttribBinding");
        this.VertexArrayBindingDivisor = provider.getFunctionAddress("glVertexArrayBindingDivisor");
        this.GetVertexArrayiv = provider.getFunctionAddress("glGetVertexArrayiv");
        this.GetVertexArrayIndexediv = provider.getFunctionAddress("glGetVertexArrayIndexediv");
        this.GetVertexArrayIndexed64iv = provider.getFunctionAddress("glGetVertexArrayIndexed64iv");
        this.CreateSamplers = provider.getFunctionAddress("glCreateSamplers");
        this.CreateProgramPipelines = provider.getFunctionAddress("glCreateProgramPipelines");
        this.CreateQueries = provider.getFunctionAddress("glCreateQueries");
    }

    public static ARBDirectStateAccess getInstance() {
        return GL.getCapabilities().__ARBDirectStateAccess;
    }

    static ARBDirectStateAccess create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_direct_state_access")) {
            return null;
        }
        ARBDirectStateAccess funcs = new ARBDirectStateAccess(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateTransformFeedbacks, funcs.TransformFeedbackBufferBase, funcs.TransformFeedbackBufferRange, funcs.GetTransformFeedbackiv, funcs.GetTransformFeedbacki_v, funcs.GetTransformFeedbacki64_v, funcs.CreateBuffers, funcs.NamedBufferStorage, funcs.NamedBufferData, funcs.NamedBufferSubData, funcs.CopyNamedBufferSubData, funcs.ClearNamedBufferData, funcs.ClearNamedBufferSubData, funcs.MapNamedBuffer, funcs.MapNamedBufferRange, funcs.UnmapNamedBuffer, funcs.FlushMappedNamedBufferRange, funcs.GetNamedBufferParameteriv, funcs.GetNamedBufferParameteri64v, funcs.GetNamedBufferPointerv, funcs.GetNamedBufferSubData, funcs.CreateFramebuffers, funcs.NamedFramebufferRenderbuffer, funcs.NamedFramebufferParameteri, funcs.NamedFramebufferTexture, funcs.NamedFramebufferTextureLayer, funcs.NamedFramebufferDrawBuffer, funcs.NamedFramebufferDrawBuffers, funcs.NamedFramebufferReadBuffer, funcs.InvalidateNamedFramebufferData, funcs.InvalidateNamedFramebufferSubData, funcs.ClearNamedFramebufferiv, funcs.ClearNamedFramebufferuiv, funcs.ClearNamedFramebufferfv, funcs.ClearNamedFramebufferfi, funcs.BlitNamedFramebuffer, funcs.CheckNamedFramebufferStatus, funcs.GetNamedFramebufferParameteriv, funcs.GetNamedFramebufferAttachmentParameteriv, funcs.CreateRenderbuffers, funcs.NamedRenderbufferStorage, funcs.NamedRenderbufferStorageMultisample, funcs.GetNamedRenderbufferParameteriv, funcs.CreateTextures, funcs.TextureBuffer, funcs.TextureBufferRange, funcs.TextureStorage1D, funcs.TextureStorage2D, funcs.TextureStorage3D, funcs.TextureStorage2DMultisample, funcs.TextureStorage3DMultisample, funcs.TextureSubImage1D, funcs.TextureSubImage2D, funcs.TextureSubImage3D, funcs.CompressedTextureSubImage1D, funcs.CompressedTextureSubImage2D, funcs.CompressedTextureSubImage3D, funcs.CopyTextureSubImage1D, funcs.CopyTextureSubImage2D, funcs.CopyTextureSubImage3D, funcs.TextureParameterf, funcs.TextureParameterfv, funcs.TextureParameteri, funcs.TextureParameterIiv, funcs.TextureParameterIuiv, funcs.TextureParameteriv, funcs.GenerateTextureMipmap, funcs.BindTextureUnit, funcs.GetTextureImage, funcs.GetCompressedTextureImage, funcs.GetTextureLevelParameterfv, funcs.GetTextureLevelParameteriv, funcs.GetTextureParameterfv, funcs.GetTextureParameterIiv, funcs.GetTextureParameterIuiv, funcs.GetTextureParameteriv, funcs.CreateVertexArrays, funcs.DisableVertexArrayAttrib, funcs.EnableVertexArrayAttrib, funcs.VertexArrayElementBuffer, funcs.VertexArrayVertexBuffer, funcs.VertexArrayVertexBuffers, funcs.VertexArrayAttribFormat, funcs.VertexArrayAttribIFormat, funcs.VertexArrayAttribLFormat, funcs.VertexArrayAttribBinding, funcs.VertexArrayBindingDivisor, funcs.GetVertexArrayiv, funcs.GetVertexArrayIndexediv, funcs.GetVertexArrayIndexed64iv, funcs.CreateSamplers, funcs.CreateProgramPipelines, funcs.CreateQueries);
        return GL.checkExtension("GL_ARB_direct_state_access", funcs, supported);
    }

    public static void nglCreateTransformFeedbacks(int n, long ids) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CreateTransformFeedbacks;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateTransformFeedbacks(n, ids, __functionAddress);
    }

    public static void glCreateTransformFeedbacks(int n, ByteBuffer ids) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        ARBDirectStateAccess.nglCreateTransformFeedbacks(n, MemoryUtil.memAddress(ids));
    }

    public static void glCreateTransformFeedbacks(IntBuffer ids) {
        ARBDirectStateAccess.nglCreateTransformFeedbacks(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static int glCreateTransformFeedbacks() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam();
        ARBDirectStateAccess.nglCreateTransformFeedbacks(1, __buffer.address() + (long)ids);
        return __buffer.intValue(ids);
    }

    public static void glTransformFeedbackBufferBase(int xfb, int index, int buffer) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TransformFeedbackBufferBase;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTransformFeedbackBufferBase(xfb, index, buffer, __functionAddress);
    }

    public static void glTransformFeedbackBufferRange(int xfb, int index, int buffer, long offset, long size) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TransformFeedbackBufferRange;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTransformFeedbackBufferRange(xfb, index, buffer, offset, size, __functionAddress);
    }

    public static void nglGetTransformFeedbackiv(int xfb, int pname, long param) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetTransformFeedbackiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTransformFeedbackiv(xfb, pname, param, __functionAddress);
    }

    public static void glGetTransformFeedbacki(int xfb, int pname, ByteBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        ARBDirectStateAccess.nglGetTransformFeedbackiv(xfb, pname, MemoryUtil.memAddress(param));
    }

    public static void glGetTransformFeedback(int xfb, int pname, IntBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        ARBDirectStateAccess.nglGetTransformFeedbackiv(xfb, pname, MemoryUtil.memAddress(param));
    }

    public static int glGetTransformFeedbacki(int xfb, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.intParam();
        ARBDirectStateAccess.nglGetTransformFeedbackiv(xfb, pname, __buffer.address() + (long)param);
        return __buffer.intValue(param);
    }

    public static void nglGetTransformFeedbacki_v(int xfb, int pname, int index, long param) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetTransformFeedbacki_v;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTransformFeedbacki_v(xfb, pname, index, param, __functionAddress);
    }

    public static void glGetTransformFeedbacki(int xfb, int pname, int index, ByteBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        ARBDirectStateAccess.nglGetTransformFeedbacki_v(xfb, pname, index, MemoryUtil.memAddress(param));
    }

    public static void glGetTransformFeedback(int xfb, int pname, int index, IntBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        ARBDirectStateAccess.nglGetTransformFeedbacki_v(xfb, pname, index, MemoryUtil.memAddress(param));
    }

    public static int glGetTransformFeedbacki(int xfb, int pname, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.intParam();
        ARBDirectStateAccess.nglGetTransformFeedbacki_v(xfb, pname, index, __buffer.address() + (long)param);
        return __buffer.intValue(param);
    }

    public static void nglGetTransformFeedbacki64_v(int xfb, int pname, int index, long param) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetTransformFeedbacki64_v;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTransformFeedbacki64_v(xfb, pname, index, param, __functionAddress);
    }

    public static void glGetTransformFeedbacki64(int xfb, int pname, int index, ByteBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 8);
        }
        ARBDirectStateAccess.nglGetTransformFeedbacki64_v(xfb, pname, index, MemoryUtil.memAddress(param));
    }

    public static void glGetTransformFeedback(int xfb, int pname, int index, LongBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        ARBDirectStateAccess.nglGetTransformFeedbacki64_v(xfb, pname, index, MemoryUtil.memAddress(param));
    }

    public static long glGetTransformFeedbacki64(int xfb, int pname, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.longParam();
        ARBDirectStateAccess.nglGetTransformFeedbacki64_v(xfb, pname, index, __buffer.address() + (long)param);
        return __buffer.longValue(param);
    }

    public static void nglCreateBuffers(int n, long buffers) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CreateBuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateBuffers(n, buffers, __functionAddress);
    }

    public static void glCreateBuffers(int n, ByteBuffer buffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)buffers, n << 2);
        }
        ARBDirectStateAccess.nglCreateBuffers(n, MemoryUtil.memAddress(buffers));
    }

    public static void glCreateBuffers(IntBuffer buffers) {
        ARBDirectStateAccess.nglCreateBuffers(buffers.remaining(), MemoryUtil.memAddress(buffers));
    }

    public static int glCreateBuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int buffers = __buffer.intParam();
        ARBDirectStateAccess.nglCreateBuffers(1, __buffer.address() + (long)buffers);
        return __buffer.intValue(buffers);
    }

    public static void nglNamedBufferStorage(int buffer, long size, long data, int flags) {
        long __functionAddress = ARBDirectStateAccess.getInstance().NamedBufferStorage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedBufferStorage(buffer, size, data, flags, __functionAddress);
    }

    public static void glNamedBufferStorage(int buffer, long size, ByteBuffer data, int flags) {
        if (LWJGLUtil.CHECKS && data != null) {
            Checks.checkBuffer((Buffer)data, size);
        }
        ARBDirectStateAccess.nglNamedBufferStorage(buffer, size, MemoryUtil.memAddressSafe(data), flags);
    }

    public static void glNamedBufferStorage(int buffer, long size, int flags) {
        ARBDirectStateAccess.nglNamedBufferStorage(buffer, size, 0L, flags);
    }

    public static void glNamedBufferStorage(int buffer, ByteBuffer data, int flags) {
        ARBDirectStateAccess.nglNamedBufferStorage(buffer, data.remaining(), MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorage(int buffer, ShortBuffer data, int flags) {
        ARBDirectStateAccess.nglNamedBufferStorage(buffer, data.remaining() << 1, MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorage(int buffer, IntBuffer data, int flags) {
        ARBDirectStateAccess.nglNamedBufferStorage(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorage(int buffer, FloatBuffer data, int flags) {
        ARBDirectStateAccess.nglNamedBufferStorage(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glNamedBufferStorage(int buffer, DoubleBuffer data, int flags) {
        ARBDirectStateAccess.nglNamedBufferStorage(buffer, data.remaining() << 3, MemoryUtil.memAddress(data), flags);
    }

    public static void nglNamedBufferData(int buffer, long size, long data, int usage) {
        long __functionAddress = ARBDirectStateAccess.getInstance().NamedBufferData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedBufferData(buffer, size, data, usage, __functionAddress);
    }

    public static void glNamedBufferData(int buffer, long size, ByteBuffer data, int usage) {
        if (LWJGLUtil.CHECKS && data != null) {
            Checks.checkBuffer((Buffer)data, size);
        }
        ARBDirectStateAccess.nglNamedBufferData(buffer, size, MemoryUtil.memAddressSafe(data), usage);
    }

    public static void glNamedBufferData(int buffer, long size, int usage) {
        ARBDirectStateAccess.nglNamedBufferData(buffer, size, 0L, usage);
    }

    public static void glNamedBufferData(int buffer, ByteBuffer data, int usage) {
        ARBDirectStateAccess.nglNamedBufferData(buffer, data.remaining(), MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferData(int buffer, ShortBuffer data, int usage) {
        ARBDirectStateAccess.nglNamedBufferData(buffer, data.remaining() << 1, MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferData(int buffer, IntBuffer data, int usage) {
        ARBDirectStateAccess.nglNamedBufferData(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferData(int buffer, FloatBuffer data, int usage) {
        ARBDirectStateAccess.nglNamedBufferData(buffer, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glNamedBufferData(int buffer, DoubleBuffer data, int usage) {
        ARBDirectStateAccess.nglNamedBufferData(buffer, data.remaining() << 3, MemoryUtil.memAddress(data), usage);
    }

    public static void nglNamedBufferSubData(int buffer, long offset, long size, long data) {
        long __functionAddress = ARBDirectStateAccess.getInstance().NamedBufferSubData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedBufferSubData(buffer, offset, size, data, __functionAddress);
    }

    public static void glNamedBufferSubData(int buffer, long offset, long size, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, size);
        }
        ARBDirectStateAccess.nglNamedBufferSubData(buffer, offset, size, MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, ByteBuffer data) {
        ARBDirectStateAccess.nglNamedBufferSubData(buffer, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, ShortBuffer data) {
        ARBDirectStateAccess.nglNamedBufferSubData(buffer, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, IntBuffer data) {
        ARBDirectStateAccess.nglNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, FloatBuffer data) {
        ARBDirectStateAccess.nglNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glNamedBufferSubData(int buffer, long offset, DoubleBuffer data) {
        ARBDirectStateAccess.nglNamedBufferSubData(buffer, offset, data.remaining() << 3, MemoryUtil.memAddress(data));
    }

    public static void glCopyNamedBufferSubData(int readBuffer, int writeBuffer, long readOffset, long writeOffset, long size) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CopyNamedBufferSubData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCopyNamedBufferSubData(readBuffer, writeBuffer, readOffset, writeOffset, size, __functionAddress);
    }

    public static void nglClearNamedBufferData(int buffer, int internalformat, int format, int type, long data) {
        long __functionAddress = ARBDirectStateAccess.getInstance().ClearNamedBufferData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglClearNamedBufferData(buffer, internalformat, format, type, data, __functionAddress);
    }

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, ByteBuffer data) {
        ARBDirectStateAccess.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, ShortBuffer data) {
        ARBDirectStateAccess.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, IntBuffer data) {
        ARBDirectStateAccess.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearNamedBufferData(int buffer, int internalformat, int format, int type, FloatBuffer data) {
        ARBDirectStateAccess.nglClearNamedBufferData(buffer, internalformat, format, type, MemoryUtil.memAddress(data));
    }

    public static void nglClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, long data) {
        long __functionAddress = ARBDirectStateAccess.getInstance().ClearNamedBufferSubData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, data, __functionAddress);
    }

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, ByteBuffer data) {
        ARBDirectStateAccess.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, ShortBuffer data) {
        ARBDirectStateAccess.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, IntBuffer data) {
        ARBDirectStateAccess.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearNamedBufferSubData(int buffer, int internalformat, long offset, long size, int format, int type, FloatBuffer data) {
        ARBDirectStateAccess.nglClearNamedBufferSubData(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddress(data));
    }

    public static long nglMapNamedBuffer(int buffer, int access) {
        long __functionAddress = ARBDirectStateAccess.getInstance().MapNamedBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL45.nglMapNamedBuffer(buffer, access, __functionAddress);
    }

    public static ByteBuffer glMapNamedBuffer(int buffer, int access) {
        long __result = ARBDirectStateAccess.nglMapNamedBuffer(buffer, access);
        return MemoryUtil.memByteBuffer(__result, ARBDirectStateAccess.glGetNamedBufferParameteri(buffer, 34660));
    }

    public static ByteBuffer glMapNamedBuffer(int buffer, int access, ByteBuffer old_buffer) {
        long __result = ARBDirectStateAccess.nglMapNamedBuffer(buffer, access);
        int length = ARBDirectStateAccess.glGetNamedBufferParameteri(buffer, 34660);
        return old_buffer != null && __result == MemoryUtil.memAddress0(old_buffer) && old_buffer.capacity() == length ? old_buffer : MemoryUtil.memByteBuffer(__result, length);
    }

    public static ByteBuffer glMapNamedBuffer(int buffer, int access, int length, ByteBuffer old_buffer) {
        long __result = ARBDirectStateAccess.nglMapNamedBuffer(buffer, access);
        return old_buffer != null && __result == MemoryUtil.memAddress0(old_buffer) && old_buffer.capacity() == length ? old_buffer : MemoryUtil.memByteBuffer(__result, length);
    }

    public static long nglMapNamedBufferRange(int buffer, long offset, long length, int access) {
        long __functionAddress = ARBDirectStateAccess.getInstance().MapNamedBufferRange;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL45.nglMapNamedBufferRange(buffer, offset, length, access, __functionAddress);
    }

    public static ByteBuffer glMapNamedBufferRange(int buffer, long offset, long length, int access) {
        long __result = ARBDirectStateAccess.nglMapNamedBufferRange(buffer, offset, length, access);
        return MemoryUtil.memByteBuffer(__result, length);
    }

    public static ByteBuffer glMapNamedBufferRange(int buffer, long offset, long length, int access, ByteBuffer old_buffer) {
        long __result = ARBDirectStateAccess.nglMapNamedBufferRange(buffer, offset, length, access);
        return old_buffer != null && __result == MemoryUtil.memAddress0(old_buffer) && (long)old_buffer.capacity() == length ? old_buffer : MemoryUtil.memByteBuffer(__result, length);
    }

    public static boolean glUnmapNamedBuffer(int buffer) {
        long __functionAddress = ARBDirectStateAccess.getInstance().UnmapNamedBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL45.nglUnmapNamedBuffer(buffer, __functionAddress);
    }

    public static void glFlushMappedNamedBufferRange(int buffer, long offset, long length) {
        long __functionAddress = ARBDirectStateAccess.getInstance().FlushMappedNamedBufferRange;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglFlushMappedNamedBufferRange(buffer, offset, length, __functionAddress);
    }

    public static void nglGetNamedBufferParameteriv(int buffer, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetNamedBufferParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetNamedBufferParameteriv(buffer, pname, params, __functionAddress);
    }

    public static void glGetNamedBufferParameteri(int buffer, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBDirectStateAccess.nglGetNamedBufferParameteriv(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedBufferParameter(int buffer, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBDirectStateAccess.nglGetNamedBufferParameteriv(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedBufferParameteri(int buffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBDirectStateAccess.nglGetNamedBufferParameteriv(buffer, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static void nglGetNamedBufferParameteri64v(int buffer, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetNamedBufferParameteri64v;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetNamedBufferParameteri64v(buffer, pname, params, __functionAddress);
    }

    public static void glGetNamedBufferParameteri64(int buffer, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        ARBDirectStateAccess.nglGetNamedBufferParameteri64v(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedBufferParameter(int buffer, int pname, LongBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBDirectStateAccess.nglGetNamedBufferParameteri64v(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetNamedBufferParameteri64(int buffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        ARBDirectStateAccess.nglGetNamedBufferParameteri64v(buffer, pname, __buffer.address() + (long)params);
        return __buffer.longValue(params);
    }

    public static void nglGetNamedBufferPointerv(int buffer, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetNamedBufferPointerv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetNamedBufferPointerv(buffer, pname, params, __functionAddress);
    }

    public static void glGetNamedBufferPointer(int buffer, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1 << Pointer.POINTER_SHIFT);
        }
        ARBDirectStateAccess.nglGetNamedBufferPointerv(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedBufferPointer(int buffer, int pname, PointerBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        ARBDirectStateAccess.nglGetNamedBufferPointerv(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetNamedBufferPointer(int buffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.pointerParam();
        ARBDirectStateAccess.nglGetNamedBufferPointerv(buffer, pname, __buffer.address() + (long)params);
        return __buffer.pointerValue(params);
    }

    public static void nglGetNamedBufferSubData(int buffer, long offset, long size, long data) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetNamedBufferSubData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetNamedBufferSubData(buffer, offset, size, data, __functionAddress);
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, long size, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, size);
        }
        ARBDirectStateAccess.nglGetNamedBufferSubData(buffer, offset, size, MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, ByteBuffer data) {
        ARBDirectStateAccess.nglGetNamedBufferSubData(buffer, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, ShortBuffer data) {
        ARBDirectStateAccess.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, IntBuffer data) {
        ARBDirectStateAccess.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, FloatBuffer data) {
        ARBDirectStateAccess.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glGetNamedBufferSubData(int buffer, long offset, DoubleBuffer data) {
        ARBDirectStateAccess.nglGetNamedBufferSubData(buffer, offset, data.remaining() << 3, MemoryUtil.memAddress(data));
    }

    public static void nglCreateFramebuffers(int n, long framebuffers) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CreateFramebuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateFramebuffers(n, framebuffers, __functionAddress);
    }

    public static void glCreateFramebuffers(int n, ByteBuffer framebuffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)framebuffers, n << 2);
        }
        ARBDirectStateAccess.nglCreateFramebuffers(n, MemoryUtil.memAddress(framebuffers));
    }

    public static void glCreateFramebuffers(IntBuffer framebuffers) {
        ARBDirectStateAccess.nglCreateFramebuffers(framebuffers.remaining(), MemoryUtil.memAddress(framebuffers));
    }

    public static int glCreateFramebuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int framebuffers = __buffer.intParam();
        ARBDirectStateAccess.nglCreateFramebuffers(1, __buffer.address() + (long)framebuffers);
        return __buffer.intValue(framebuffers);
    }

    public static void glNamedFramebufferRenderbuffer(int framebuffer, int attachment, int renderbuffertarget, int renderbuffer) {
        long __functionAddress = ARBDirectStateAccess.getInstance().NamedFramebufferRenderbuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedFramebufferRenderbuffer(framebuffer, attachment, renderbuffertarget, renderbuffer, __functionAddress);
    }

    public static void glNamedFramebufferParameteri(int framebuffer, int pname, int param) {
        long __functionAddress = ARBDirectStateAccess.getInstance().NamedFramebufferParameteri;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedFramebufferParameteri(framebuffer, pname, param, __functionAddress);
    }

    public static void glNamedFramebufferTexture(int framebuffer, int attachment, int texture, int level) {
        long __functionAddress = ARBDirectStateAccess.getInstance().NamedFramebufferTexture;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedFramebufferTexture(framebuffer, attachment, texture, level, __functionAddress);
    }

    public static void glNamedFramebufferTextureLayer(int framebuffer, int attachment, int texture, int level, int layer) {
        long __functionAddress = ARBDirectStateAccess.getInstance().NamedFramebufferTextureLayer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedFramebufferTextureLayer(framebuffer, attachment, texture, level, layer, __functionAddress);
    }

    public static void glNamedFramebufferDrawBuffer(int framebuffer, int buf) {
        long __functionAddress = ARBDirectStateAccess.getInstance().NamedFramebufferDrawBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedFramebufferDrawBuffer(framebuffer, buf, __functionAddress);
    }

    public static void nglNamedFramebufferDrawBuffers(int framebuffer, int n, long bufs) {
        long __functionAddress = ARBDirectStateAccess.getInstance().NamedFramebufferDrawBuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedFramebufferDrawBuffers(framebuffer, n, bufs, __functionAddress);
    }

    public static void glNamedFramebufferDrawBuffers(int framebuffer, int n, ByteBuffer bufs) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)bufs, n << 2);
        }
        ARBDirectStateAccess.nglNamedFramebufferDrawBuffers(framebuffer, n, MemoryUtil.memAddress(bufs));
    }

    public static void glNamedFramebufferDrawBuffers(int framebuffer, IntBuffer bufs) {
        ARBDirectStateAccess.nglNamedFramebufferDrawBuffers(framebuffer, bufs.remaining(), MemoryUtil.memAddress(bufs));
    }

    public static void glNamedFramebufferDrawBuffers(int framebuffer, int buf) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int bufs = __buffer.intParam(buf);
        ARBDirectStateAccess.nglNamedFramebufferDrawBuffers(framebuffer, 1, __buffer.address() + (long)bufs);
    }

    public static void glNamedFramebufferReadBuffer(int framebuffer, int src) {
        long __functionAddress = ARBDirectStateAccess.getInstance().NamedFramebufferReadBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedFramebufferReadBuffer(framebuffer, src, __functionAddress);
    }

    public static void nglInvalidateNamedFramebufferData(int framebuffer, int numAttachments, long attachments) {
        long __functionAddress = ARBDirectStateAccess.getInstance().InvalidateNamedFramebufferData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglInvalidateNamedFramebufferData(framebuffer, numAttachments, attachments, __functionAddress);
    }

    public static void glInvalidateNamedFramebufferData(int framebuffer, int numAttachments, ByteBuffer attachments) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)attachments, numAttachments << 2);
        }
        ARBDirectStateAccess.nglInvalidateNamedFramebufferData(framebuffer, numAttachments, MemoryUtil.memAddress(attachments));
    }

    public static void glInvalidateNamedFramebufferData(int framebuffer, IntBuffer attachments) {
        ARBDirectStateAccess.nglInvalidateNamedFramebufferData(framebuffer, attachments.remaining(), MemoryUtil.memAddress(attachments));
    }

    public static void glInvalidateNamedFramebufferData(int framebuffer, int attachment) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attachments = __buffer.intParam(attachment);
        ARBDirectStateAccess.nglInvalidateNamedFramebufferData(framebuffer, 1, __buffer.address() + (long)attachments);
    }

    public static void nglInvalidateNamedFramebufferSubData(int framebuffer, int numAttachments, long attachments, int x, int y, int width, int height) {
        long __functionAddress = ARBDirectStateAccess.getInstance().InvalidateNamedFramebufferSubData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglInvalidateNamedFramebufferSubData(framebuffer, numAttachments, attachments, x, y, width, height, __functionAddress);
    }

    public static void glInvalidateNamedFramebufferSubData(int framebuffer, int numAttachments, ByteBuffer attachments, int x, int y, int width, int height) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)attachments, numAttachments << 2);
        }
        ARBDirectStateAccess.nglInvalidateNamedFramebufferSubData(framebuffer, numAttachments, MemoryUtil.memAddress(attachments), x, y, width, height);
    }

    public static void glInvalidateNamedFramebufferSubData(int framebuffer, IntBuffer attachments, int x, int y, int width, int height) {
        ARBDirectStateAccess.nglInvalidateNamedFramebufferSubData(framebuffer, attachments.remaining(), MemoryUtil.memAddress(attachments), x, y, width, height);
    }

    public static void glInvalidateNamedFramebufferSubData(int framebuffer, int attachment, int x, int y, int width, int height) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attachments = __buffer.intParam(attachment);
        ARBDirectStateAccess.nglInvalidateNamedFramebufferSubData(framebuffer, 1, __buffer.address() + (long)attachments, x, y, width, height);
    }

    public static void nglClearNamedFramebufferiv(int framebuffer, int buffer, int drawbuffer, long value) {
        long __functionAddress = ARBDirectStateAccess.getInstance().ClearNamedFramebufferiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglClearNamedFramebufferiv(framebuffer, buffer, drawbuffer, value, __functionAddress);
    }

    public static void glClearNamedFramebufferi(int framebuffer, int buffer, int drawbuffer, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        ARBDirectStateAccess.nglClearNamedFramebufferiv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void glClearNamedFramebuffer(int framebuffer, int buffer, int drawbuffer, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        ARBDirectStateAccess.nglClearNamedFramebufferiv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void nglClearNamedFramebufferuiv(int framebuffer, int buffer, int drawbuffer, long value) {
        long __functionAddress = ARBDirectStateAccess.getInstance().ClearNamedFramebufferuiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglClearNamedFramebufferuiv(framebuffer, buffer, drawbuffer, value, __functionAddress);
    }

    public static void glClearNamedFramebufferui(int framebuffer, int buffer, int drawbuffer, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 16);
        }
        ARBDirectStateAccess.nglClearNamedFramebufferuiv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void glClearNamedFramebufferu(int framebuffer, int buffer, int drawbuffer, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        ARBDirectStateAccess.nglClearNamedFramebufferuiv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void nglClearNamedFramebufferfv(int framebuffer, int buffer, int drawbuffer, long value) {
        long __functionAddress = ARBDirectStateAccess.getInstance().ClearNamedFramebufferfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglClearNamedFramebufferfv(framebuffer, buffer, drawbuffer, value, __functionAddress);
    }

    public static void glClearNamedFramebufferf(int framebuffer, int buffer, int drawbuffer, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        ARBDirectStateAccess.nglClearNamedFramebufferfv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void glClearNamedFramebuffer(int framebuffer, int buffer, int drawbuffer, FloatBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        ARBDirectStateAccess.nglClearNamedFramebufferfv(framebuffer, buffer, drawbuffer, MemoryUtil.memAddress(value));
    }

    public static void glClearNamedFramebufferfi(int framebuffer, int buffer, float depth, int stencil) {
        long __functionAddress = ARBDirectStateAccess.getInstance().ClearNamedFramebufferfi;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglClearNamedFramebufferfi(framebuffer, buffer, depth, stencil, __functionAddress);
    }

    public static void glBlitNamedFramebuffer(int readFramebuffer, int drawFramebuffer, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        long __functionAddress = ARBDirectStateAccess.getInstance().BlitNamedFramebuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglBlitNamedFramebuffer(readFramebuffer, drawFramebuffer, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter, __functionAddress);
    }

    public static int glCheckNamedFramebufferStatus(int framebuffer, int target) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CheckNamedFramebufferStatus;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL45.nglCheckNamedFramebufferStatus(framebuffer, target, __functionAddress);
    }

    public static void nglGetNamedFramebufferParameteriv(int framebuffer, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetNamedFramebufferParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetNamedFramebufferParameteriv(framebuffer, pname, params, __functionAddress);
    }

    public static void glGetNamedFramebufferParameteri(int framebuffer, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBDirectStateAccess.nglGetNamedFramebufferParameteriv(framebuffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedFramebufferParameter(int framebuffer, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBDirectStateAccess.nglGetNamedFramebufferParameteriv(framebuffer, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedFramebufferParameteri(int framebuffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBDirectStateAccess.nglGetNamedFramebufferParameteriv(framebuffer, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static void nglGetNamedFramebufferAttachmentParameteriv(int framebuffer, int attachment, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetNamedFramebufferAttachmentParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, params, __functionAddress);
    }

    public static void glGetNamedFramebufferAttachmentParameteri(int framebuffer, int attachment, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBDirectStateAccess.nglGetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedFramebufferAttachmentParameter(int framebuffer, int attachment, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBDirectStateAccess.nglGetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedFramebufferAttachmentParameteri(int framebuffer, int attachment, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBDirectStateAccess.nglGetNamedFramebufferAttachmentParameteriv(framebuffer, attachment, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static void nglCreateRenderbuffers(int n, long renderbuffers) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CreateRenderbuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateRenderbuffers(n, renderbuffers, __functionAddress);
    }

    public static void glCreateRenderbuffers(int n, ByteBuffer renderbuffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)renderbuffers, n << 2);
        }
        ARBDirectStateAccess.nglCreateRenderbuffers(n, MemoryUtil.memAddress(renderbuffers));
    }

    public static void glCreateRenderbuffers(IntBuffer renderbuffers) {
        ARBDirectStateAccess.nglCreateRenderbuffers(renderbuffers.remaining(), MemoryUtil.memAddress(renderbuffers));
    }

    public static int glCreateRenderbuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int renderbuffers = __buffer.intParam();
        ARBDirectStateAccess.nglCreateRenderbuffers(1, __buffer.address() + (long)renderbuffers);
        return __buffer.intValue(renderbuffers);
    }

    public static void glNamedRenderbufferStorage(int renderbuffer, int internalformat, int width, int height) {
        long __functionAddress = ARBDirectStateAccess.getInstance().NamedRenderbufferStorage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedRenderbufferStorage(renderbuffer, internalformat, width, height, __functionAddress);
    }

    public static void glNamedRenderbufferStorageMultisample(int renderbuffer, int samples, int internalformat, int width, int height) {
        long __functionAddress = ARBDirectStateAccess.getInstance().NamedRenderbufferStorageMultisample;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglNamedRenderbufferStorageMultisample(renderbuffer, samples, internalformat, width, height, __functionAddress);
    }

    public static void nglGetNamedRenderbufferParameteriv(int renderbuffer, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetNamedRenderbufferParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetNamedRenderbufferParameteriv(renderbuffer, pname, params, __functionAddress);
    }

    public static void glGetNamedRenderbufferParameteri(int renderbuffer, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBDirectStateAccess.nglGetNamedRenderbufferParameteriv(renderbuffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedRenderbufferParameter(int renderbuffer, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBDirectStateAccess.nglGetNamedRenderbufferParameteriv(renderbuffer, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedRenderbufferParameteri(int renderbuffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBDirectStateAccess.nglGetNamedRenderbufferParameteriv(renderbuffer, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static void nglCreateTextures(int target, int n, long textures) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CreateTextures;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateTextures(target, n, textures, __functionAddress);
    }

    public static void glCreateTextures(int target, int n, ByteBuffer textures) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)textures, n << 2);
        }
        ARBDirectStateAccess.nglCreateTextures(target, n, MemoryUtil.memAddress(textures));
    }

    public static void glCreateTextures(int target, IntBuffer textures) {
        ARBDirectStateAccess.nglCreateTextures(target, textures.remaining(), MemoryUtil.memAddress(textures));
    }

    public static int glCreateTextures(int target) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int textures = __buffer.intParam();
        ARBDirectStateAccess.nglCreateTextures(target, 1, __buffer.address() + (long)textures);
        return __buffer.intValue(textures);
    }

    public static void glTextureBuffer(int texture, int internalformat, int buffer) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureBuffer(texture, internalformat, buffer, __functionAddress);
    }

    public static void glTextureBufferRange(int texture, int internalformat, int buffer, long offset, long size) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureBufferRange;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureBufferRange(texture, internalformat, buffer, offset, size, __functionAddress);
    }

    public static void glTextureStorage1D(int texture, int levels, int internalformat, int width) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureStorage1D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureStorage1D(texture, levels, internalformat, width, __functionAddress);
    }

    public static void glTextureStorage2D(int texture, int levels, int internalformat, int width, int height) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureStorage2D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureStorage2D(texture, levels, internalformat, width, height, __functionAddress);
    }

    public static void glTextureStorage3D(int texture, int levels, int internalformat, int width, int height, int depth) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureStorage3D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureStorage3D(texture, levels, internalformat, width, height, depth, __functionAddress);
    }

    public static void glTextureStorage2DMultisample(int texture, int samples, int internalformat, int width, int height, boolean fixedsamplelocations) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureStorage2DMultisample;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureStorage2DMultisample(texture, samples, internalformat, width, height, fixedsamplelocations, __functionAddress);
    }

    public static void glTextureStorage3DMultisample(int texture, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureStorage3DMultisample;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureStorage3DMultisample(texture, samples, internalformat, width, height, depth, fixedsamplelocations, __functionAddress);
    }

    public static void nglTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, long pixels) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureSubImage1D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureSubImage1D(texture, level, xoffset, width, format, type, pixels, __functionAddress);
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        ARBDirectStateAccess.nglTextureSubImage1D(texture, level, xoffset, width, format, type, pixelsOffset);
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int type, DoubleBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglTextureSubImage1D(texture, level, xoffset, width, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void nglTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixels) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureSubImage2D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, pixels, __functionAddress);
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        ARBDirectStateAccess.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, pixelsOffset);
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int type, DoubleBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void nglTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureSubImage3D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels, __functionAddress);
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        ARBDirectStateAccess.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixelsOffset);
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void nglCompressedTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int imageSize, long data) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CompressedTextureSubImage1D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCompressedTextureSubImage1D(texture, level, xoffset, width, format, imageSize, data, __functionAddress);
    }

    public static void glCompressedTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int imageSize, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglCompressedTextureSubImage1D(texture, level, xoffset, width, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTextureSubImage1D(int texture, int level, int xoffset, int width, int format, int imageSize, long dataOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        ARBDirectStateAccess.nglCompressedTextureSubImage1D(texture, level, xoffset, width, format, imageSize, dataOffset);
    }

    public static void glCompressedTextureSubImage1D(int texture, int level, int xoffset, int width, int format, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        ARBDirectStateAccess.nglCompressedTextureSubImage1D(texture, level, xoffset, width, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglCompressedTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long data) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CompressedTextureSubImage2D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, imageSize, data, __functionAddress);
    }

    public static void glCompressedTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglCompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long dataOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        ARBDirectStateAccess.nglCompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, imageSize, dataOffset);
    }

    public static void glCompressedTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int width, int height, int format, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        ARBDirectStateAccess.nglCompressedTextureSubImage2D(texture, level, xoffset, yoffset, width, height, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglCompressedTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long data) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CompressedTextureSubImage3D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data, __functionAddress);
    }

    public static void glCompressedTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBDirectStateAccess.nglCompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long dataOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        ARBDirectStateAccess.nglCompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, dataOffset);
    }

    public static void glCompressedTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        ARBDirectStateAccess.nglCompressedTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glCopyTextureSubImage1D(int texture, int level, int xoffset, int x, int y, int width) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CopyTextureSubImage1D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCopyTextureSubImage1D(texture, level, xoffset, x, y, width, __functionAddress);
    }

    public static void glCopyTextureSubImage2D(int texture, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CopyTextureSubImage2D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCopyTextureSubImage2D(texture, level, xoffset, yoffset, x, y, width, height, __functionAddress);
    }

    public static void glCopyTextureSubImage3D(int texture, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CopyTextureSubImage3D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCopyTextureSubImage3D(texture, level, xoffset, yoffset, zoffset, x, y, width, height, __functionAddress);
    }

    public static void glTextureParameterf(int texture, int pname, float param) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureParameterf;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureParameterf(texture, pname, param, __functionAddress);
    }

    public static void nglTextureParameterfv(int texture, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureParameterfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureParameterfv(texture, pname, params, __functionAddress);
    }

    public static void glTextureParameterf(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 16);
        }
        ARBDirectStateAccess.nglTextureParameterfv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameter(int texture, int pname, FloatBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBDirectStateAccess.nglTextureParameterfv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameteri(int texture, int pname, int param) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureParameteri;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureParameteri(texture, pname, param, __functionAddress);
    }

    public static void nglTextureParameterIiv(int texture, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureParameterIiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureParameterIiv(texture, pname, params, __functionAddress);
    }

    public static void glTextureParameterIi(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBDirectStateAccess.nglTextureParameterIiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameterI(int texture, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBDirectStateAccess.nglTextureParameterIiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameterIi(int texture, int pname, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam(param);
        ARBDirectStateAccess.nglTextureParameterIiv(texture, pname, __buffer.address() + (long)params);
    }

    public static void nglTextureParameterIuiv(int texture, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureParameterIuiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureParameterIuiv(texture, pname, params, __functionAddress);
    }

    public static void glTextureParameterIui(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBDirectStateAccess.nglTextureParameterIuiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameterIu(int texture, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBDirectStateAccess.nglTextureParameterIuiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameterIui(int texture, int pname, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam(param);
        ARBDirectStateAccess.nglTextureParameterIuiv(texture, pname, __buffer.address() + (long)params);
    }

    public static void nglTextureParameteriv(int texture, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().TextureParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglTextureParameteriv(texture, pname, params, __functionAddress);
    }

    public static void glTextureParameteri(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 16);
        }
        ARBDirectStateAccess.nglTextureParameteriv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glTextureParameter(int texture, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBDirectStateAccess.nglTextureParameteriv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glGenerateTextureMipmap(int texture) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GenerateTextureMipmap;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGenerateTextureMipmap(texture, __functionAddress);
    }

    public static void glBindTextureUnit(int unit, int texture) {
        long __functionAddress = ARBDirectStateAccess.getInstance().BindTextureUnit;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglBindTextureUnit(unit, texture, __functionAddress);
    }

    public static void nglGetTextureImage(int texture, int level, int format, int type, int bufSize, long pixels) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetTextureImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureImage(texture, level, format, type, bufSize, pixels, __functionAddress);
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, int bufSize, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBDirectStateAccess.nglGetTextureImage(texture, level, format, type, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, int bufSize, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        ARBDirectStateAccess.nglGetTextureImage(texture, level, format, type, bufSize, pixelsOffset);
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBDirectStateAccess.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBDirectStateAccess.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBDirectStateAccess.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureImage(int texture, int level, int format, int type, DoubleBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBDirectStateAccess.nglGetTextureImage(texture, level, format, type, pixels.remaining() << 3, MemoryUtil.memAddress(pixels));
    }

    public static void nglGetCompressedTextureImage(int texture, int level, int bufSize, long pixels) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetCompressedTextureImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetCompressedTextureImage(texture, level, bufSize, pixels, __functionAddress);
    }

    public static void glGetCompressedTextureImage(int texture, int level, int bufSize, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            if (LWJGLUtil.DEBUG) {
                Checks.checkBuffer((Buffer)pixels, ARBDirectStateAccess.glGetTextureLevelParameteri(texture, level, 34464));
            }
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBDirectStateAccess.nglGetCompressedTextureImage(texture, level, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureImage(int texture, int level, int bufSize, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        ARBDirectStateAccess.nglGetCompressedTextureImage(texture, level, bufSize, pixelsOffset);
    }

    public static void glGetCompressedTextureImage(int texture, int level, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            if (LWJGLUtil.DEBUG) {
                Checks.checkBuffer((Buffer)pixels, ARBDirectStateAccess.glGetTextureLevelParameteri(texture, level, 34464));
            }
            GLChecks.ensureBufferObject(35053, true);
        }
        ARBDirectStateAccess.nglGetCompressedTextureImage(texture, level, pixels.remaining(), MemoryUtil.memAddress(pixels));
    }

    public static void nglGetTextureLevelParameterfv(int texture, int level, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetTextureLevelParameterfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureLevelParameterfv(texture, level, pname, params, __functionAddress);
    }

    public static void glGetTextureLevelParameterf(int texture, int level, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBDirectStateAccess.nglGetTextureLevelParameterfv(texture, level, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureLevelParameter(int texture, int level, int pname, FloatBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBDirectStateAccess.nglGetTextureLevelParameterfv(texture, level, pname, MemoryUtil.memAddress(params));
    }

    public static float glGetTextureLevelParameterf(int texture, int level, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        ARBDirectStateAccess.nglGetTextureLevelParameterfv(texture, level, pname, __buffer.address() + (long)params);
        return __buffer.floatValue(params);
    }

    public static void nglGetTextureLevelParameteriv(int texture, int level, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetTextureLevelParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureLevelParameteriv(texture, level, pname, params, __functionAddress);
    }

    public static void glGetTextureLevelParameteri(int texture, int level, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBDirectStateAccess.nglGetTextureLevelParameteriv(texture, level, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureLevelParameter(int texture, int level, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBDirectStateAccess.nglGetTextureLevelParameteriv(texture, level, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTextureLevelParameteri(int texture, int level, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBDirectStateAccess.nglGetTextureLevelParameteriv(texture, level, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static void nglGetTextureParameterfv(int texture, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetTextureParameterfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureParameterfv(texture, pname, params, __functionAddress);
    }

    public static void glGetTextureParameterf(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBDirectStateAccess.nglGetTextureParameterfv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureParameter(int texture, int pname, FloatBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBDirectStateAccess.nglGetTextureParameterfv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static float glGetTextureParameterf(int texture, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        ARBDirectStateAccess.nglGetTextureParameterfv(texture, pname, __buffer.address() + (long)params);
        return __buffer.floatValue(params);
    }

    public static void nglGetTextureParameterIiv(int texture, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetTextureParameterIiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureParameterIiv(texture, pname, params, __functionAddress);
    }

    public static void glGetTextureParameterIi(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBDirectStateAccess.nglGetTextureParameterIiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureParameterI(int texture, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBDirectStateAccess.nglGetTextureParameterIiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTextureParameterIi(int texture, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBDirectStateAccess.nglGetTextureParameterIiv(texture, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static void nglGetTextureParameterIuiv(int texture, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetTextureParameterIuiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureParameterIuiv(texture, pname, params, __functionAddress);
    }

    public static void glGetTextureParameterIui(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBDirectStateAccess.nglGetTextureParameterIuiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureParameterIu(int texture, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBDirectStateAccess.nglGetTextureParameterIuiv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTextureParameterIui(int texture, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBDirectStateAccess.nglGetTextureParameterIuiv(texture, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static void nglGetTextureParameteriv(int texture, int pname, long params) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetTextureParameteriv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureParameteriv(texture, pname, params, __functionAddress);
    }

    public static void glGetTextureParameteri(int texture, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBDirectStateAccess.nglGetTextureParameteriv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetTextureParameter(int texture, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBDirectStateAccess.nglGetTextureParameteriv(texture, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetTextureParameteri(int texture, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBDirectStateAccess.nglGetTextureParameteriv(texture, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static void nglCreateVertexArrays(int n, long arrays) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CreateVertexArrays;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateVertexArrays(n, arrays, __functionAddress);
    }

    public static void glCreateVertexArrays(int n, ByteBuffer arrays) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)arrays, n << 2);
        }
        ARBDirectStateAccess.nglCreateVertexArrays(n, MemoryUtil.memAddress(arrays));
    }

    public static void glCreateVertexArrays(IntBuffer arrays) {
        ARBDirectStateAccess.nglCreateVertexArrays(arrays.remaining(), MemoryUtil.memAddress(arrays));
    }

    public static int glCreateVertexArrays() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arrays = __buffer.intParam();
        ARBDirectStateAccess.nglCreateVertexArrays(1, __buffer.address() + (long)arrays);
        return __buffer.intValue(arrays);
    }

    public static void glDisableVertexArrayAttrib(int vaobj, int index) {
        long __functionAddress = ARBDirectStateAccess.getInstance().DisableVertexArrayAttrib;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglDisableVertexArrayAttrib(vaobj, index, __functionAddress);
    }

    public static void glEnableVertexArrayAttrib(int vaobj, int index) {
        long __functionAddress = ARBDirectStateAccess.getInstance().EnableVertexArrayAttrib;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglEnableVertexArrayAttrib(vaobj, index, __functionAddress);
    }

    public static void glVertexArrayElementBuffer(int vaobj, int buffer) {
        long __functionAddress = ARBDirectStateAccess.getInstance().VertexArrayElementBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayElementBuffer(vaobj, buffer, __functionAddress);
    }

    public static void glVertexArrayVertexBuffer(int vaobj, int bindingindex, int buffer, long offset, int stride) {
        long __functionAddress = ARBDirectStateAccess.getInstance().VertexArrayVertexBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayVertexBuffer(vaobj, bindingindex, buffer, offset, stride, __functionAddress);
    }

    public static void nglVertexArrayVertexBuffers(int vaobj, int first, int count, long buffers, long offsets, long strides) {
        long __functionAddress = ARBDirectStateAccess.getInstance().VertexArrayVertexBuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayVertexBuffers(vaobj, first, count, buffers, offsets, strides, __functionAddress);
    }

    public static void glVertexArrayVertexBuffers(int vaobj, int first, int count, ByteBuffer buffers, ByteBuffer offsets, ByteBuffer strides) {
        if (LWJGLUtil.CHECKS) {
            if (buffers != null) {
                Checks.checkBuffer((Buffer)buffers, count << 2);
            }
            if (offsets != null) {
                Checks.checkBuffer((Buffer)offsets, count << Pointer.POINTER_SHIFT);
            }
            if (strides != null) {
                Checks.checkBuffer((Buffer)strides, count << 2);
            }
        }
        ARBDirectStateAccess.nglVertexArrayVertexBuffers(vaobj, first, count, MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(strides));
    }

    public static void glVertexArrayVertexBuffers(int vaobj, int first, IntBuffer buffers, PointerBuffer offsets, IntBuffer strides) {
        if (LWJGLUtil.CHECKS) {
            if (offsets != null) {
                Checks.checkBuffer(offsets, buffers.remaining());
            }
            if (strides != null) {
                Checks.checkBuffer((Buffer)strides, buffers.remaining());
            }
        }
        ARBDirectStateAccess.nglVertexArrayVertexBuffers(vaobj, first, buffers == null ? 0 : buffers.remaining(), MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(strides));
    }

    public static void glVertexArrayAttribFormat(int vaobj, int attribindex, int size, int type, boolean normalized, int relativeoffset) {
        long __functionAddress = ARBDirectStateAccess.getInstance().VertexArrayAttribFormat;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayAttribFormat(vaobj, attribindex, size, type, normalized, relativeoffset, __functionAddress);
    }

    public static void glVertexArrayAttribIFormat(int vaobj, int attribindex, int size, int type, int relativeoffset) {
        long __functionAddress = ARBDirectStateAccess.getInstance().VertexArrayAttribIFormat;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayAttribIFormat(vaobj, attribindex, size, type, relativeoffset, __functionAddress);
    }

    public static void glVertexArrayAttribLFormat(int vaobj, int attribindex, int size, int type, int relativeoffset) {
        long __functionAddress = ARBDirectStateAccess.getInstance().VertexArrayAttribLFormat;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayAttribLFormat(vaobj, attribindex, size, type, relativeoffset, __functionAddress);
    }

    public static void glVertexArrayAttribBinding(int vaobj, int attribindex, int bindingindex) {
        long __functionAddress = ARBDirectStateAccess.getInstance().VertexArrayAttribBinding;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayAttribBinding(vaobj, attribindex, bindingindex, __functionAddress);
    }

    public static void glVertexArrayBindingDivisor(int vaobj, int bindingindex, int divisor) {
        long __functionAddress = ARBDirectStateAccess.getInstance().VertexArrayBindingDivisor;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglVertexArrayBindingDivisor(vaobj, bindingindex, divisor, __functionAddress);
    }

    public static void nglGetVertexArrayiv(int vaobj, int pname, long param) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetVertexArrayiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetVertexArrayiv(vaobj, pname, param, __functionAddress);
    }

    public static void glGetVertexArrayi(int vaobj, int pname, ByteBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        ARBDirectStateAccess.nglGetVertexArrayiv(vaobj, pname, MemoryUtil.memAddress(param));
    }

    public static void glGetVertexArray(int vaobj, int pname, IntBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        ARBDirectStateAccess.nglGetVertexArrayiv(vaobj, pname, MemoryUtil.memAddress(param));
    }

    public static int glGetVertexArrayi(int vaobj, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.intParam();
        ARBDirectStateAccess.nglGetVertexArrayiv(vaobj, pname, __buffer.address() + (long)param);
        return __buffer.intValue(param);
    }

    public static void nglGetVertexArrayIndexediv(int vaobj, int index, int pname, long param) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetVertexArrayIndexediv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetVertexArrayIndexediv(vaobj, index, pname, param, __functionAddress);
    }

    public static void glGetVertexArrayIndexedi(int vaobj, int index, int pname, ByteBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 4);
        }
        ARBDirectStateAccess.nglGetVertexArrayIndexediv(vaobj, index, pname, MemoryUtil.memAddress(param));
    }

    public static void glGetVertexArrayIndexed(int vaobj, int index, int pname, IntBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        ARBDirectStateAccess.nglGetVertexArrayIndexediv(vaobj, index, pname, MemoryUtil.memAddress(param));
    }

    public static int glGetVertexArrayIndexedi(int vaobj, int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.intParam();
        ARBDirectStateAccess.nglGetVertexArrayIndexediv(vaobj, index, pname, __buffer.address() + (long)param);
        return __buffer.intValue(param);
    }

    public static void nglGetVertexArrayIndexed64iv(int vaobj, int index, int pname, long param) {
        long __functionAddress = ARBDirectStateAccess.getInstance().GetVertexArrayIndexed64iv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetVertexArrayIndexed64iv(vaobj, index, pname, param, __functionAddress);
    }

    public static void glGetVertexArrayIndexed64i(int vaobj, int index, int pname, ByteBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 8);
        }
        ARBDirectStateAccess.nglGetVertexArrayIndexed64iv(vaobj, index, pname, MemoryUtil.memAddress(param));
    }

    public static void glGetVertexArrayIndexed64i(int vaobj, int index, int pname, LongBuffer param) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)param, 1);
        }
        ARBDirectStateAccess.nglGetVertexArrayIndexed64iv(vaobj, index, pname, MemoryUtil.memAddress(param));
    }

    public static long glGetVertexArrayIndexed64i(int vaobj, int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int param = __buffer.longParam();
        ARBDirectStateAccess.nglGetVertexArrayIndexed64iv(vaobj, index, pname, __buffer.address() + (long)param);
        return __buffer.longValue(param);
    }

    public static void nglCreateSamplers(int n, long samplers) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CreateSamplers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateSamplers(n, samplers, __functionAddress);
    }

    public static void glCreateSamplers(int n, ByteBuffer samplers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)samplers, n << 2);
        }
        ARBDirectStateAccess.nglCreateSamplers(n, MemoryUtil.memAddress(samplers));
    }

    public static void glCreateSamplers(IntBuffer samplers) {
        ARBDirectStateAccess.nglCreateSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    public static int glCreateSamplers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int samplers = __buffer.intParam();
        ARBDirectStateAccess.nglCreateSamplers(1, __buffer.address() + (long)samplers);
        return __buffer.intValue(samplers);
    }

    public static void nglCreateProgramPipelines(int n, long pipelines) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CreateProgramPipelines;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateProgramPipelines(n, pipelines, __functionAddress);
    }

    public static void glCreateProgramPipelines(int n, ByteBuffer pipelines) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pipelines, n << 2);
        }
        ARBDirectStateAccess.nglCreateProgramPipelines(n, MemoryUtil.memAddress(pipelines));
    }

    public static void glCreateProgramPipelines(IntBuffer pipelines) {
        ARBDirectStateAccess.nglCreateProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    public static int glCreateProgramPipelines() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pipelines = __buffer.intParam();
        ARBDirectStateAccess.nglCreateProgramPipelines(1, __buffer.address() + (long)pipelines);
        return __buffer.intValue(pipelines);
    }

    public static void nglCreateQueries(int target, int n, long ids) {
        long __functionAddress = ARBDirectStateAccess.getInstance().CreateQueries;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglCreateQueries(target, n, ids, __functionAddress);
    }

    public static void glCreateQueries(int target, int n, ByteBuffer ids) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        ARBDirectStateAccess.nglCreateQueries(target, n, MemoryUtil.memAddress(ids));
    }

    public static void glCreateQueries(int target, IntBuffer ids) {
        ARBDirectStateAccess.nglCreateQueries(target, ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static int glCreateQueries(int target) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam();
        ARBDirectStateAccess.nglCreateQueries(target, 1, __buffer.address() + (long)ids);
        return __buffer.intValue(ids);
    }
}

