/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL44;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBClearTexture {
    public static final int GL_CLEAR_TEXTURE = 37733;
    public final long ClearTexSubImage;
    public final long ClearTexImage;

    public ARBClearTexture(FunctionProvider provider) {
        this.ClearTexSubImage = provider.getFunctionAddress("glClearTexSubImage");
        this.ClearTexImage = provider.getFunctionAddress("glClearTexImage");
    }

    public static ARBClearTexture getInstance() {
        return GL.getCapabilities().__ARBClearTexture;
    }

    static ARBClearTexture create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_clear_texture")) {
            return null;
        }
        ARBClearTexture funcs = new ARBClearTexture(provider);
        boolean supported = Checks.checkFunctions(funcs.ClearTexSubImage, funcs.ClearTexImage);
        return GL.checkExtension("GL_ARB_clear_texture", funcs, supported);
    }

    public static void nglClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long data) {
        long __functionAddress = ARBClearTexture.getInstance().ClearTexSubImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL44.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data, __functionAddress);
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer data) {
        ARBClearTexture.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer data) {
        ARBClearTexture.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer data) {
        ARBClearTexture.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer data) {
        ARBClearTexture.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer data) {
        ARBClearTexture.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void nglClearTexImage(int texture, int level, int format, int type, long data) {
        long __functionAddress = ARBClearTexture.getInstance().ClearTexImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL44.nglClearTexImage(texture, level, format, type, data, __functionAddress);
    }

    public static void glClearTexImage(int texture, int level, int format, int type, ByteBuffer data) {
        ARBClearTexture.nglClearTexImage(texture, level, format, type, MemoryUtil.memAddress(data));
    }
}

