/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBClearBufferObject {
    public final long ClearBufferData;
    public final long ClearBufferSubData;
    public final long ClearNamedBufferDataEXT;
    public final long ClearNamedBufferSubDataEXT;

    public ARBClearBufferObject(FunctionProvider provider) {
        this.ClearBufferData = provider.getFunctionAddress("glClearBufferData");
        this.ClearBufferSubData = provider.getFunctionAddress("glClearBufferSubData");
        this.ClearNamedBufferDataEXT = provider.getFunctionAddress("glClearNamedBufferDataEXT");
        this.ClearNamedBufferSubDataEXT = provider.getFunctionAddress("glClearNamedBufferSubDataEXT");
    }

    public static ARBClearBufferObject getInstance() {
        return GL.getCapabilities().__ARBClearBufferObject;
    }

    static ARBClearBufferObject create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_clear_buffer_object")) {
            return null;
        }
        ARBClearBufferObject funcs = new ARBClearBufferObject(provider);
        boolean supported = Checks.checkFunctions(funcs.ClearBufferData, funcs.ClearBufferSubData, ext.contains("GL_EXT_direct_state_access") ? funcs.ClearNamedBufferDataEXT : -1L, ext.contains("GL_EXT_direct_state_access") ? funcs.ClearNamedBufferSubDataEXT : -1L);
        return GL.checkExtension("GL_ARB_clear_buffer_object", funcs, supported);
    }

    public static void nglClearBufferData(int target, int internalformat, int format, int type, long data) {
        long __functionAddress = ARBClearBufferObject.getInstance().ClearBufferData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglClearBufferData(target, internalformat, format, type, data, __functionAddress);
    }

    public static void glClearBufferData(int target, int internalformat, int format, int type, ByteBuffer data) {
        ARBClearBufferObject.nglClearBufferData(target, internalformat, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearBufferData(int target, int internalformat, int format, int type, ShortBuffer data) {
        ARBClearBufferObject.nglClearBufferData(target, internalformat, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearBufferData(int target, int internalformat, int format, int type, IntBuffer data) {
        ARBClearBufferObject.nglClearBufferData(target, internalformat, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearBufferData(int target, int internalformat, int format, int type, FloatBuffer data) {
        ARBClearBufferObject.nglClearBufferData(target, internalformat, format, type, MemoryUtil.memAddress(data));
    }

    public static void nglClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, long data) {
        long __functionAddress = ARBClearBufferObject.getInstance().ClearBufferSubData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglClearBufferSubData(target, internalformat, offset, size, format, type, data, __functionAddress);
    }

    public static void glClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, ByteBuffer data) {
        ARBClearBufferObject.nglClearBufferSubData(target, internalformat, offset, size, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, ShortBuffer data) {
        ARBClearBufferObject.nglClearBufferSubData(target, internalformat, offset, size, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, IntBuffer data) {
        ARBClearBufferObject.nglClearBufferSubData(target, internalformat, offset, size, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, FloatBuffer data) {
        ARBClearBufferObject.nglClearBufferSubData(target, internalformat, offset, size, format, type, MemoryUtil.memAddress(data));
    }

    public static native void nglClearNamedBufferDataEXT(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void nglClearNamedBufferDataEXT(int buffer, int internalformat, int format, int type, long data) {
        long __functionAddress = ARBClearBufferObject.getInstance().ClearNamedBufferDataEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBClearBufferObject.nglClearNamedBufferDataEXT(buffer, internalformat, format, type, data, __functionAddress);
    }

    public static void glClearNamedBufferDataEXT(int buffer, int internalformat, int format, int type, ByteBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferDataEXT(buffer, internalformat, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearNamedBufferDataEXT(int buffer, int internalformat, int format, int type, ShortBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferDataEXT(buffer, internalformat, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearNamedBufferDataEXT(int buffer, int internalformat, int format, int type, IntBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferDataEXT(buffer, internalformat, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearNamedBufferDataEXT(int buffer, int internalformat, int format, int type, FloatBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferDataEXT(buffer, internalformat, format, type, MemoryUtil.memAddress(data));
    }

    public static native void nglClearNamedBufferSubDataEXT(int var0, int var1, long var2, long var4, int var6, int var7, long var8, long var10);

    public static void nglClearNamedBufferSubDataEXT(int buffer, int internalformat, long offset, long size, int format, int type, long data) {
        long __functionAddress = ARBClearBufferObject.getInstance().ClearNamedBufferSubDataEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBClearBufferObject.nglClearNamedBufferSubDataEXT(buffer, internalformat, offset, size, format, type, data, __functionAddress);
    }

    public static void glClearNamedBufferSubDataEXT(int buffer, int internalformat, long offset, long size, int format, int type, ByteBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferSubDataEXT(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearNamedBufferSubDataEXT(int buffer, int internalformat, long offset, long size, int format, int type, ShortBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferSubDataEXT(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearNamedBufferSubDataEXT(int buffer, int internalformat, long offset, long size, int format, int type, IntBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferSubDataEXT(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddress(data));
    }

    public static void glClearNamedBufferSubDataEXT(int buffer, int internalformat, long offset, long size, int format, int type, FloatBuffer data) {
        ARBClearBufferObject.nglClearNamedBufferSubDataEXT(buffer, internalformat, offset, size, format, type, MemoryUtil.memAddress(data));
    }
}

