/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL33;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBBlendFuncExtended {
    public static final int GL_SRC1_COLOR = 35065;
    public static final int GL_ONE_MINUS_SRC1_COLOR = 35066;
    public static final int GL_ONE_MINUS_SRC1_ALPHA = 35067;
    public static final int GL_MAX_DUAL_SOURCE_DRAW_BUFFERS = 35068;
    public final long BindFragDataLocationIndexed;
    public final long GetFragDataIndex;

    public ARBBlendFuncExtended(FunctionProvider provider) {
        this.BindFragDataLocationIndexed = provider.getFunctionAddress("glBindFragDataLocationIndexed");
        this.GetFragDataIndex = provider.getFunctionAddress("glGetFragDataIndex");
    }

    public static ARBBlendFuncExtended getInstance() {
        return GL.getCapabilities().__ARBBlendFuncExtended;
    }

    static ARBBlendFuncExtended create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_blend_func_extended")) {
            return null;
        }
        ARBBlendFuncExtended funcs = new ARBBlendFuncExtended(provider);
        boolean supported = Checks.checkFunctions(funcs.BindFragDataLocationIndexed, funcs.GetFragDataIndex);
        return GL.checkExtension("GL_ARB_blend_func_extended", funcs, supported);
    }

    public static void nglBindFragDataLocationIndexed(int program, int colorNumber, int index, long name) {
        long __functionAddress = ARBBlendFuncExtended.getInstance().BindFragDataLocationIndexed;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL33.nglBindFragDataLocationIndexed(program, colorNumber, index, name, __functionAddress);
    }

    public static void glBindFragDataLocationIndexed(int program, int colorNumber, int index, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(name);
        }
        ARBBlendFuncExtended.nglBindFragDataLocationIndexed(program, colorNumber, index, MemoryUtil.memAddress(name));
    }

    public static void glBindFragDataLocationIndexed(int program, int colorNumber, int index, CharSequence name) {
        ByteBuffer nameEncoded = MemoryUtil.memEncodeASCII(name);
        ARBBlendFuncExtended.nglBindFragDataLocationIndexed(program, colorNumber, index, MemoryUtil.memAddress(nameEncoded));
    }

    public static int nglGetFragDataIndex(int program, long name) {
        long __functionAddress = ARBBlendFuncExtended.getInstance().GetFragDataIndex;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL33.nglGetFragDataIndex(program, name, __functionAddress);
    }

    public static int glGetFragDataIndex(int program, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(name);
        }
        return ARBBlendFuncExtended.nglGetFragDataIndex(program, MemoryUtil.memAddress(name));
    }

    public static int glGetFragDataIndex(int program, CharSequence name) {
        ByteBuffer nameEncoded = MemoryUtil.memEncodeASCII(name);
        return ARBBlendFuncExtended.nglGetFragDataIndex(program, MemoryUtil.memAddress(nameEncoded));
    }
}

