/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.DEBUGPROCAMD;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class AMDDebugOutput {
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH_AMD = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES_AMD = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES_AMD = 37189;
    public static final int GL_DEBUG_SEVERITY_HIGH_AMD = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM_AMD = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW_AMD = 37192;
    public static final int GL_DEBUG_CATEGORY_API_ERROR_AMD = 37193;
    public static final int GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD = 37194;
    public static final int GL_DEBUG_CATEGORY_DEPRECATION_AMD = 37195;
    public static final int GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD = 37196;
    public static final int GL_DEBUG_CATEGORY_PERFORMANCE_AMD = 37197;
    public static final int GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD = 37198;
    public static final int GL_DEBUG_CATEGORY_APPLICATION_AMD = 37199;
    public static final int GL_DEBUG_CATEGORY_OTHER_AMD = 37200;
    public final long DebugMessageEnableAMD;
    public final long DebugMessageInsertAMD;
    public final long DebugMessageCallbackAMD;
    public final long GetDebugMessageLogAMD;
    long refDEBUGPROCAMD;

    public AMDDebugOutput(FunctionProvider provider) {
        this.DebugMessageEnableAMD = provider.getFunctionAddress("glDebugMessageEnableAMD");
        this.DebugMessageInsertAMD = provider.getFunctionAddress("glDebugMessageInsertAMD");
        this.DebugMessageCallbackAMD = provider.getFunctionAddress("glDebugMessageCallbackAMD");
        this.GetDebugMessageLogAMD = provider.getFunctionAddress("glGetDebugMessageLogAMD");
    }

    public static AMDDebugOutput getInstance() {
        return GL.getCapabilities().__AMDDebugOutput;
    }

    static AMDDebugOutput create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_AMD_debug_output")) {
            return null;
        }
        AMDDebugOutput funcs = new AMDDebugOutput(provider);
        boolean supported = Checks.checkFunctions(funcs.DebugMessageEnableAMD, funcs.DebugMessageInsertAMD, funcs.DebugMessageCallbackAMD, funcs.GetDebugMessageLogAMD);
        return GL.checkExtension("GL_AMD_debug_output", funcs, supported);
    }

    public static native void nglDebugMessageEnableAMD(int var0, int var1, int var2, long var3, boolean var5, long var6);

    public static void nglDebugMessageEnableAMD(int category, int severity, int count, long ids, boolean enabled) {
        long __functionAddress = AMDDebugOutput.getInstance().DebugMessageEnableAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AMDDebugOutput.nglDebugMessageEnableAMD(category, severity, count, ids, enabled, __functionAddress);
    }

    public static void glDebugMessageEnableAMD(int category, int severity, int count, ByteBuffer ids, boolean enabled) {
        if (LWJGLUtil.CHECKS && ids != null) {
            Checks.checkBuffer((Buffer)ids, count << 2);
        }
        AMDDebugOutput.nglDebugMessageEnableAMD(category, severity, count, MemoryUtil.memAddressSafe(ids), enabled);
    }

    public static void glDebugMessageEnableAMD(int category, int severity, IntBuffer ids, boolean enabled) {
        AMDDebugOutput.nglDebugMessageEnableAMD(category, severity, ids == null ? 0 : ids.remaining(), MemoryUtil.memAddressSafe(ids), enabled);
    }

    public static native void nglDebugMessageInsertAMD(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void nglDebugMessageInsertAMD(int category, int severity, int id, int length, long buf) {
        long __functionAddress = AMDDebugOutput.getInstance().DebugMessageInsertAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AMDDebugOutput.nglDebugMessageInsertAMD(category, severity, id, length, buf, __functionAddress);
    }

    public static void glDebugMessageInsertAMD(int category, int severity, int id, int length, ByteBuffer buf) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)buf, length);
            Checks.checkNT1(buf);
        }
        AMDDebugOutput.nglDebugMessageInsertAMD(category, severity, id, length, MemoryUtil.memAddress(buf));
    }

    public static void glDebugMessageInsertAMD(int category, int severity, int id, ByteBuffer buf) {
        AMDDebugOutput.nglDebugMessageInsertAMD(category, severity, id, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static void glDebugMessageInsertAMD(int category, int severity, int id, CharSequence buf) {
        ByteBuffer bufEncoded = MemoryUtil.memEncodeUTF8(buf);
        AMDDebugOutput.nglDebugMessageInsertAMD(category, severity, id, buf.length(), MemoryUtil.memAddress(bufEncoded));
    }

    public static native void nglDebugMessageCallbackAMD(long var0, long var2, long var4);

    public static void glDebugMessageCallbackAMD(long callback, long userParam) {
        AMDDebugOutput __instance = AMDDebugOutput.getInstance();
        long __functionAddress = __instance.DebugMessageCallbackAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AMDDebugOutput.nglDebugMessageCallbackAMD(callback, userParam, __functionAddress);
    }

    public static void glDebugMessageCallbackAMD(DEBUGPROCAMD callback) {
        AMDDebugOutput __instance = AMDDebugOutput.getInstance();
        long __functionAddress = __instance.DebugMessageCallbackAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AMDDebugOutput.nglDebugMessageCallbackAMD(callback == null ? 0L : DEBUGPROCAMD.Util.CALLBACK, DEBUGPROCAMD.Util.register(__instance, callback), __functionAddress);
    }

    public static native int nglGetDebugMessageLogAMD(int var0, int var1, long var2, long var4, long var6, long var8, long var10, long var12);

    public static int nglGetDebugMessageLogAMD(int count, int bufsize, long categories, long severities, long ids, long lengths, long messageLog) {
        long __functionAddress = AMDDebugOutput.getInstance().GetDebugMessageLogAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return AMDDebugOutput.nglGetDebugMessageLogAMD(count, bufsize, categories, severities, ids, lengths, messageLog, __functionAddress);
    }

    public static int glGetDebugMessageLogAMD(int count, int bufsize, ByteBuffer categories, ByteBuffer severities, ByteBuffer ids, ByteBuffer lengths, ByteBuffer messageLog) {
        if (LWJGLUtil.CHECKS) {
            if (messageLog != null) {
                Checks.checkBuffer((Buffer)messageLog, bufsize);
            }
            if (categories != null) {
                Checks.checkBuffer((Buffer)categories, count << 2);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count << 2);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count << 2);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count << 2);
            }
        }
        return AMDDebugOutput.nglGetDebugMessageLogAMD(count, bufsize, MemoryUtil.memAddressSafe(categories), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static int glGetDebugMessageLogAMD(int count, IntBuffer categories, IntBuffer severities, IntBuffer ids, IntBuffer lengths, ByteBuffer messageLog) {
        if (LWJGLUtil.CHECKS) {
            if (categories != null) {
                Checks.checkBuffer((Buffer)categories, count);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count);
            }
        }
        return AMDDebugOutput.nglGetDebugMessageLogAMD(count, messageLog == null ? 0 : messageLog.remaining(), MemoryUtil.memAddressSafe(categories), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static int glGetDebugMessageLogAMD(int count, IntBuffer categories, IntBuffer severities, IntBuffer ids, IntBuffer lengths, CharSequence messageLog) {
        if (LWJGLUtil.CHECKS) {
            if (categories != null) {
                Checks.checkBuffer((Buffer)categories, count);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count);
            }
        }
        ByteBuffer messageLogEncoded = MemoryUtil.memEncodeUTF8(messageLog);
        return AMDDebugOutput.nglGetDebugMessageLogAMD(count, messageLog == null ? 0 : messageLog.length(), MemoryUtil.memAddressSafe(categories), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLogEncoded));
    }
}

