/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;

public final class cl_image_desc {
    public static final int SIZEOF;
    public static final int IMAGE_TYPE;
    public static final int IMAGE_WIDTH;
    public static final int IMAGE_HEIGHT;
    public static final int IMAGE_DEPTH;
    public static final int IMAGE_ARRAY_SIZE;
    public static final int IMAGE_ROW_PITCH;
    public static final int IMAGE_SLICE_PITCH;
    public static final int NUM_MIP_LEVELS;
    public static final int NUM_SAMPLES;
    public static final int BUFFER;

    private cl_image_desc() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int image_type, long image_width, long image_height, long image_depth, long image_array_size, long image_row_pitch, long image_slice_pitch, int num_mip_levels, int num_samples, long buffer) {
        ByteBuffer cl_image_desc2 = cl_image_desc.malloc();
        cl_image_desc.image_type(cl_image_desc2, image_type);
        cl_image_desc.image_width(cl_image_desc2, image_width);
        cl_image_desc.image_height(cl_image_desc2, image_height);
        cl_image_desc.image_depth(cl_image_desc2, image_depth);
        cl_image_desc.image_array_size(cl_image_desc2, image_array_size);
        cl_image_desc.image_row_pitch(cl_image_desc2, image_row_pitch);
        cl_image_desc.image_slice_pitch(cl_image_desc2, image_slice_pitch);
        cl_image_desc.num_mip_levels(cl_image_desc2, num_mip_levels);
        cl_image_desc.num_samples(cl_image_desc2, num_samples);
        cl_image_desc.buffer(cl_image_desc2, buffer);
        return cl_image_desc2;
    }

    public static void image_type(ByteBuffer cl_image_desc2, int image_type) {
        cl_image_desc2.putInt(cl_image_desc2.position() + IMAGE_TYPE, image_type);
    }

    public static void image_width(ByteBuffer cl_image_desc2, long image_width) {
        PointerBuffer.put(cl_image_desc2, cl_image_desc2.position() + IMAGE_WIDTH, image_width);
    }

    public static void image_height(ByteBuffer cl_image_desc2, long image_height) {
        PointerBuffer.put(cl_image_desc2, cl_image_desc2.position() + IMAGE_HEIGHT, image_height);
    }

    public static void image_depth(ByteBuffer cl_image_desc2, long image_depth) {
        PointerBuffer.put(cl_image_desc2, cl_image_desc2.position() + IMAGE_DEPTH, image_depth);
    }

    public static void image_array_size(ByteBuffer cl_image_desc2, long image_array_size) {
        PointerBuffer.put(cl_image_desc2, cl_image_desc2.position() + IMAGE_ARRAY_SIZE, image_array_size);
    }

    public static void image_row_pitch(ByteBuffer cl_image_desc2, long image_row_pitch) {
        PointerBuffer.put(cl_image_desc2, cl_image_desc2.position() + IMAGE_ROW_PITCH, image_row_pitch);
    }

    public static void image_slice_pitch(ByteBuffer cl_image_desc2, long image_slice_pitch) {
        PointerBuffer.put(cl_image_desc2, cl_image_desc2.position() + IMAGE_SLICE_PITCH, image_slice_pitch);
    }

    public static void num_mip_levels(ByteBuffer cl_image_desc2, int num_mip_levels) {
        cl_image_desc2.putInt(cl_image_desc2.position() + NUM_MIP_LEVELS, num_mip_levels);
    }

    public static void num_samples(ByteBuffer cl_image_desc2, int num_samples) {
        cl_image_desc2.putInt(cl_image_desc2.position() + NUM_SAMPLES, num_samples);
    }

    public static void buffer(ByteBuffer cl_image_desc2, long buffer) {
        PointerBuffer.put(cl_image_desc2, cl_image_desc2.position() + BUFFER, buffer);
    }

    public static int image_type(ByteBuffer cl_image_desc2) {
        return cl_image_desc2.getInt(cl_image_desc2.position() + IMAGE_TYPE);
    }

    public static long image_width(ByteBuffer cl_image_desc2) {
        return PointerBuffer.get(cl_image_desc2, cl_image_desc2.position() + IMAGE_WIDTH);
    }

    public static long image_height(ByteBuffer cl_image_desc2) {
        return PointerBuffer.get(cl_image_desc2, cl_image_desc2.position() + IMAGE_HEIGHT);
    }

    public static long image_depth(ByteBuffer cl_image_desc2) {
        return PointerBuffer.get(cl_image_desc2, cl_image_desc2.position() + IMAGE_DEPTH);
    }

    public static long image_array_size(ByteBuffer cl_image_desc2) {
        return PointerBuffer.get(cl_image_desc2, cl_image_desc2.position() + IMAGE_ARRAY_SIZE);
    }

    public static long image_row_pitch(ByteBuffer cl_image_desc2) {
        return PointerBuffer.get(cl_image_desc2, cl_image_desc2.position() + IMAGE_ROW_PITCH);
    }

    public static long image_slice_pitch(ByteBuffer cl_image_desc2) {
        return PointerBuffer.get(cl_image_desc2, cl_image_desc2.position() + IMAGE_SLICE_PITCH);
    }

    public static int num_mip_levels(ByteBuffer cl_image_desc2) {
        return cl_image_desc2.getInt(cl_image_desc2.position() + NUM_MIP_LEVELS);
    }

    public static int num_samples(ByteBuffer cl_image_desc2) {
        return cl_image_desc2.getInt(cl_image_desc2.position() + NUM_SAMPLES);
    }

    public static long buffer(ByteBuffer cl_image_desc2) {
        return PointerBuffer.get(cl_image_desc2, cl_image_desc2.position() + BUFFER);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(10);
        SIZEOF = cl_image_desc.offsets(MemoryUtil.memAddress(offsets));
        IMAGE_TYPE = offsets.get(0);
        IMAGE_WIDTH = offsets.get(1);
        IMAGE_HEIGHT = offsets.get(2);
        IMAGE_DEPTH = offsets.get(3);
        IMAGE_ARRAY_SIZE = offsets.get(4);
        IMAGE_ROW_PITCH = offsets.get(5);
        IMAGE_SLICE_PITCH = offsets.get(6);
        NUM_MIP_LEVELS = offsets.get(7);
        NUM_SAMPLES = offsets.get(8);
        BUFFER = offsets.get(9);
    }
}

