/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class KHRGLSharing {
    public static final int CL_INVALID_GL_SHAREGROUP_REFERENCE_KHR = -1000;
    public static final int CL_DEVICES_FOR_GL_CONTEXT_KHR = 8199;
    public static final int CL_CURRENT_DEVICE_FOR_GL_CONTEXT_KHR = 8198;
    public static final int CL_GL_CONTEXT_KHR = 8200;
    public static final int CL_EGL_DISPLAY_KHR = 8201;
    public static final int CL_GLX_DISPLAY_KHR = 8202;
    public static final int CL_WGL_HDC_KHR = 8203;
    public static final int CL_CGL_SHAREGROUP_KHR = 8204;
    public final long GetGLContextInfoKHR;

    public KHRGLSharing(FunctionProvider provider) {
        this.GetGLContextInfoKHR = provider.getFunctionAddress("clGetGLContextInfoKHR");
    }

    public static KHRGLSharing getInstance() {
        return CL.getICD().__KHRGLSharing;
    }

    static KHRGLSharing create(FunctionProvider provider) {
        KHRGLSharing funcs = new KHRGLSharing(provider);
        boolean supported = Checks.checkFunctions(funcs.GetGLContextInfoKHR);
        return supported ? funcs : null;
    }

    public static native int nclGetGLContextInfoKHR(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int nclGetGLContextInfoKHR(long properties, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = KHRGLSharing.getInstance().GetGLContextInfoKHR;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return KHRGLSharing.nclGetGLContextInfoKHR(properties, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetGLContextInfoKHR(ByteBuffer properties, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)properties, 5 << Pointer.POINTER_SHIFT);
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return KHRGLSharing.nclGetGLContextInfoKHR(MemoryUtil.memAddress(properties), param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetGLContextInfoKHR(PointerBuffer properties, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(properties, 5);
            if (param_value_size_ret != null) {
                Checks.checkBuffer(param_value_size_ret, 1);
            }
        }
        return KHRGLSharing.nclGetGLContextInfoKHR(MemoryUtil.memAddress(properties), param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetGLContextInfoKHR(PointerBuffer properties, int param_name, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(properties, 5);
            if (param_value_size_ret != null) {
                Checks.checkBuffer(param_value_size_ret, 1);
            }
        }
        return KHRGLSharing.nclGetGLContextInfoKHR(MemoryUtil.memAddress(properties), param_name, (param_value == null ? 0 : param_value.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }
}

