/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.lang.reflect.Method;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryUtil;

public interface CLProgramCallback {
    public void invoke(long var1);

    public static final class Util {
        static final long CALLBACK = Util.setCallback(APIUtil.apiCallbackMethod(CLProgramCallback.class, Long.TYPE));
        private static final CLProgramCallback DEFAULT_BUILD = new CLProgramCallback(){

            @Override
            public void invoke(long cl_program) {
                System.out.printf("[LWJGL] cl_program [0x%X] built\n", cl_program);
            }
        };
        private static final CLProgramCallback DEFAULT_COMPILE = new CLProgramCallback(){

            @Override
            public void invoke(long cl_program) {
                System.out.printf("[LWJGL] cl_program [0x%X] compiled\n", cl_program);
            }
        };
        private static final CLProgramCallback DEFAULT_LINK = new CLProgramCallback(){

            @Override
            public void invoke(long cl_program) {
                System.out.printf("[LWJGL] cl_program [0x%X] linked\n", cl_program);
            }
        };

        private Util() {
        }

        private static native long setCallback(Method var0);

        static long register(CLProgramCallback proc) {
            if (proc == null) {
                return 0L;
            }
            return MemoryUtil.memGlobalRefNew(proc);
        }

        public static CLProgramCallback getDefaultBuild() {
            return DEFAULT_BUILD;
        }

        public static CLProgramCallback getDefaultCompile() {
            return DEFAULT_COMPILE;
        }

        public static CLProgramCallback getDefaultLink() {
            return DEFAULT_LINK;
        }
    }
}

