/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryUtil;

public interface CLNativeKernel {
    public void invoke(long var1, int var3);

    public static final class Util {
        static final long CALLBACK = Util.setCallback(APIUtil.apiCallbackMethod(CLNativeKernel.class, Long.TYPE, Integer.TYPE));

        private Util() {
        }

        private static native long setCallback(Method var0);

        static long register(CLNativeKernel kernel, ByteBuffer args) {
            if (kernel == null) {
                return 0L;
            }
            if (LWJGLUtil.DEBUG && args.remaining() < Pointer.POINTER_SIZE * 2) {
                throw new IllegalArgumentException("The arguments buffer must have enough space for 2 pointer values.");
            }
            long globalRef = MemoryUtil.memGlobalRefNew(kernel);
            PointerBuffer.put(args, 0, globalRef);
            args.putInt(Pointer.POINTER_SIZE, args.remaining() - Pointer.POINTER_SIZE * 2);
            return globalRef;
        }
    }

    public static abstract class BufAdapter
    implements Buf {
        @Override
        public void invoke(long args, int cb_args) {
            this.invoke(cb_args == 0 ? null : MemoryUtil.memByteBuffer(args, cb_args));
        }
    }

    public static interface Buf
    extends CLNativeKernel {
        public void invoke(ByteBuffer var1);
    }
}

