/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opencl.CL10;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryUtil;

public interface CLContextCallback {
    public void invoke(long var1, long var3, long var5);

    public static final class Util {
        static final long CALLBACK = Util.setCallback(APIUtil.apiCallbackMethod(CLContextCallback.class, Long.TYPE, Long.TYPE, Long.TYPE));
        private static final CLContextCallback DEFAULT = new StrAdapter(){

            @Override
            public void invoke(String errinfo, ByteBuffer private_info) {
                System.err.println("[LWJGL] cl_create_context_callback");
                System.err.println("\tInfo: " + errinfo);
            }
        };
        private static final Map<Long, Long> contextCallbacks = new HashMap<Long, Long>(8);

        private Util() {
        }

        private static native long setCallback(Method var0);

        static long register(CLContextCallback proc) {
            return proc == null ? 0L : MemoryUtil.memGlobalRefNew(proc);
        }

        static void retain(long context, long proc) {
            if (proc == 0L) {
                return;
            }
            if (context == 0L) {
                MemoryUtil.memGlobalRefDelete(proc);
            } else {
                contextCallbacks.put(context, proc);
            }
        }

        static int getReferenceCount(long context) {
            APIBuffer __buffer = APIUtil.apiBuffer();
            int __result = CL10.nclGetContextInfo(context, 4224, 4L, __buffer.address(), 0L);
            return __result == 0 ? __buffer.intValue(0) : -1;
        }

        static void release(long context) {
            Long proc = contextCallbacks.get(context);
            if (proc == null) {
                return;
            }
            MemoryUtil.memGlobalRefDelete(proc);
            contextCallbacks.remove(context);
        }

        public static CLContextCallback getDefault() {
            return DEFAULT;
        }
    }

    public static abstract class StrAdapter
    implements Str {
        @Override
        public void invoke(long errinfo, long private_info, long cb) {
            this.invoke(MemoryUtil.memByteBufferNT1(errinfo), private_info == 0L ? null : MemoryUtil.memByteBuffer(private_info, cb));
        }

        public void invoke(ByteBuffer errinfo, ByteBuffer private_info) {
            this.invoke(MemoryUtil.memDecodeUTF8(errinfo), private_info);
        }

        @Override
        public void invoke(String errinfo, ByteBuffer private_info) {
        }
    }

    public static interface Str
    extends CLContextCallback {
        public void invoke(String var1, ByteBuffer var2);
    }
}

