/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLEventCallback;
import org.lwjgl.opencl.CLMemObjectDestructorCallback;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class CL11 {
    public static final int CL_MISALIGNED_SUB_BUFFER_OFFSET = -13;
    public static final int CL_EXEC_STATUS_ERROR_FOR_EVENTS_IN_WAIT_LIST = -14;
    public static final int CL_INVALID_PROPERTY = -64;
    public static final int CL_VERSION_1_1 = 1;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_HALF = 4148;
    public static final int CL_DEVICE_HOST_UNIFIED_MEMORY = 4149;
    public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_CHAR = 4150;
    public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_SHORT = 4151;
    public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_INT = 4152;
    public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_LONG = 4153;
    public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_FLOAT = 4154;
    public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_DOUBLE = 4155;
    public static final int CL_DEVICE_NATIVE_VECTOR_WIDTH_HALF = 4156;
    public static final int CL_DEVICE_OPENCL_C_VERSION = 4157;
    public static final int CL_FP_SOFT_FLOAT = 64;
    public static final int CL_CONTEXT_NUM_DEVICES = 4227;
    public static final int CL_Rx = 4282;
    public static final int CL_RGx = 4283;
    public static final int CL_RGBx = 4284;
    public static final int CL_MEM_ASSOCIATED_MEMOBJECT = 4359;
    public static final int CL_MEM_OFFSET = 4360;
    public static final int CL_ADDRESS_MIRRORED_REPEAT = 4404;
    public static final int CL_KERNEL_PREFERRED_WORK_GROUP_SIZE_MULTIPLE = 4531;
    public static final int CL_KERNEL_PRIVATE_MEM_SIZE = 4532;
    public static final int CL_EVENT_CONTEXT = 4564;
    public static final int CL_COMMAND_READ_BUFFER_RECT = 4609;
    public static final int CL_COMMAND_WRITE_BUFFER_RECT = 4610;
    public static final int CL_COMMAND_COPY_BUFFER_RECT = 4611;
    public static final int CL_COMMAND_USER = 4612;
    public static final int CL_BUFFER_CREATE_TYPE_REGION = 4640;
    public final long CreateSubBuffer;
    public final long SetMemObjectDestructorCallback;
    public final long EnqueueReadBufferRect;
    public final long EnqueueWriteBufferRect;
    public final long EnqueueCopyBufferRect;
    public final long CreateUserEvent;
    public final long SetUserEventStatus;
    public final long SetEventCallback;

    public CL11(FunctionProvider provider) {
        this.CreateSubBuffer = provider.getFunctionAddress("clCreateSubBuffer");
        this.SetMemObjectDestructorCallback = provider.getFunctionAddress("clSetMemObjectDestructorCallback");
        this.EnqueueReadBufferRect = provider.getFunctionAddress("clEnqueueReadBufferRect");
        this.EnqueueWriteBufferRect = provider.getFunctionAddress("clEnqueueWriteBufferRect");
        this.EnqueueCopyBufferRect = provider.getFunctionAddress("clEnqueueCopyBufferRect");
        this.CreateUserEvent = provider.getFunctionAddress("clCreateUserEvent");
        this.SetUserEventStatus = provider.getFunctionAddress("clSetUserEventStatus");
        this.SetEventCallback = provider.getFunctionAddress("clSetEventCallback");
    }

    public static CL11 getInstance() {
        return CL.getICD().__CL11;
    }

    static CL11 create(FunctionProvider provider) {
        CL11 funcs = new CL11(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateSubBuffer, funcs.SetMemObjectDestructorCallback, funcs.EnqueueReadBufferRect, funcs.EnqueueWriteBufferRect, funcs.EnqueueCopyBufferRect, funcs.CreateUserEvent, funcs.SetUserEventStatus, funcs.SetEventCallback);
        return supported ? funcs : null;
    }

    public static native long nclCreateSubBuffer(long var0, long var2, int var4, long var5, long var7, long var9);

    public static long nclCreateSubBuffer(long buffer, long flags, int buffer_create_type, long buffer_create_info, long errcode_ret) {
        long __functionAddress = CL11.getInstance().CreateSubBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(buffer);
        }
        return CL11.nclCreateSubBuffer(buffer, flags, buffer_create_type, buffer_create_info, errcode_ret, __functionAddress);
    }

    public static long clCreateSubBuffer(long buffer, long flags, int buffer_create_type, ByteBuffer buffer_create_info, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 4);
        }
        return CL11.nclCreateSubBuffer(buffer, flags, buffer_create_type, MemoryUtil.memAddress(buffer_create_info), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateSubBuffer(long buffer, long flags, int buffer_create_type, ByteBuffer buffer_create_info, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL11.nclCreateSubBuffer(buffer, flags, buffer_create_type, MemoryUtil.memAddress(buffer_create_info), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native int nclSetMemObjectDestructorCallback(long var0, long var2, long var4, long var6);

    public static int clSetMemObjectDestructorCallback(long memobj, long pfn_notify, long user_data) {
        long __functionAddress = CL11.getInstance().SetMemObjectDestructorCallback;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(memobj);
        }
        return CL11.nclSetMemObjectDestructorCallback(memobj, pfn_notify, user_data, __functionAddress);
    }

    public static int clSetMemObjectDestructorCallback(long memobj, CLMemObjectDestructorCallback pfn_notify) {
        long user_data;
        int __result;
        long __functionAddress = CL11.getInstance().SetMemObjectDestructorCallback;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(memobj);
        }
        if ((__result = CL11.nclSetMemObjectDestructorCallback(memobj, CLMemObjectDestructorCallback.Util.CALLBACK, user_data = MemoryUtil.memGlobalRefNew(pfn_notify), __functionAddress)) != 0) {
            MemoryUtil.memGlobalRefDelete(user_data);
        }
        return __result;
    }

    public static native int nclEnqueueReadBufferRect(long var0, long var2, int var4, long var5, long var7, long var9, long var11, long var13, long var15, long var17, long var19, int var21, long var22, long var24, long var26);

    public static int nclEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, long buffer_offset, long host_offset, long region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL11.getInstance().EnqueueReadBufferRect;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
        }
        return CL11.nclEnqueueReadBufferRect(command_queue, buffer, blocking_read, buffer_offset, host_offset, region, buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, ByteBuffer buffer_offset, ByteBuffer host_offset, ByteBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, ByteBuffer ptr, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)buffer_offset, 3 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)host_offset, 3 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)region, 3 << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL11.nclEnqueueReadBufferRect(command_queue, buffer, blocking_read, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, ByteBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueReadBufferRect(command_queue, buffer, blocking_read, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, ShortBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueReadBufferRect(command_queue, buffer, blocking_read, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, IntBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueReadBufferRect(command_queue, buffer, blocking_read, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, FloatBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueReadBufferRect(command_queue, buffer, blocking_read, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBufferRect(long command_queue, long buffer, int blocking_read, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, DoubleBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueReadBufferRect(command_queue, buffer, blocking_read, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueWriteBufferRect(long var0, long var2, int var4, long var5, long var7, long var9, long var11, long var13, long var15, long var17, long var19, int var21, long var22, long var24, long var26);

    public static int nclEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, long buffer_offset, long host_offset, long region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL11.getInstance().EnqueueWriteBufferRect;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
        }
        return CL11.nclEnqueueWriteBufferRect(command_queue, buffer, blocking_write, buffer_offset, host_offset, region, buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, ByteBuffer buffer_offset, ByteBuffer host_offset, ByteBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, ByteBuffer ptr, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)buffer_offset, 3 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)host_offset, 3 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)region, 3 << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL11.nclEnqueueWriteBufferRect(command_queue, buffer, blocking_write, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, ByteBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueWriteBufferRect(command_queue, buffer, blocking_write, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, ShortBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueWriteBufferRect(command_queue, buffer, blocking_write, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, IntBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueWriteBufferRect(command_queue, buffer, blocking_write, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, FloatBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueWriteBufferRect(command_queue, buffer, blocking_write, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBufferRect(long command_queue, long buffer, int blocking_write, PointerBuffer buffer_offset, PointerBuffer host_offset, PointerBuffer region, long buffer_row_pitch, long buffer_slice_pitch, long host_row_pitch, long host_slice_pitch, DoubleBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(buffer_offset, 3);
            Checks.checkBuffer(host_offset, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueWriteBufferRect(command_queue, buffer, blocking_write, MemoryUtil.memAddress(buffer_offset), MemoryUtil.memAddress(host_offset), MemoryUtil.memAddress(region), buffer_row_pitch, buffer_slice_pitch, host_row_pitch, host_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueCopyBufferRect(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, int var20, long var21, long var23, long var25);

    public static int nclEnqueueCopyBufferRect(long command_queue, long src_buffer, long dst_buffer, long src_origin, long dst_origin, long region, long src_row_pitch, long src_slice_pitch, long dst_row_pitch, long dst_slice_pitch, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL11.getInstance().EnqueueCopyBufferRect;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(src_buffer);
            Checks.checkPointer(dst_buffer);
        }
        return CL11.nclEnqueueCopyBufferRect(command_queue, src_buffer, dst_buffer, src_origin, dst_origin, region, src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueCopyBufferRect(long command_queue, long src_buffer, long dst_buffer, ByteBuffer src_origin, ByteBuffer dst_origin, ByteBuffer region, long src_row_pitch, long src_slice_pitch, long dst_row_pitch, long dst_slice_pitch, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)src_origin, 3 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)dst_origin, 3 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)region, 3 << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL11.nclEnqueueCopyBufferRect(command_queue, src_buffer, dst_buffer, MemoryUtil.memAddress(src_origin), MemoryUtil.memAddress(dst_origin), MemoryUtil.memAddress(region), src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueCopyBufferRect(long command_queue, long src_buffer, long dst_buffer, PointerBuffer src_origin, PointerBuffer dst_origin, PointerBuffer region, long src_row_pitch, long src_slice_pitch, long dst_row_pitch, long dst_slice_pitch, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(src_origin, 3);
            Checks.checkBuffer(dst_origin, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL11.nclEnqueueCopyBufferRect(command_queue, src_buffer, dst_buffer, MemoryUtil.memAddress(src_origin), MemoryUtil.memAddress(dst_origin), MemoryUtil.memAddress(region), src_row_pitch, src_slice_pitch, dst_row_pitch, dst_slice_pitch, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native long nclCreateUserEvent(long var0, long var2, long var4);

    public static long nclCreateUserEvent(long context, long errcode_ret) {
        long __functionAddress = CL11.getInstance().CreateUserEvent;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL11.nclCreateUserEvent(context, errcode_ret, __functionAddress);
    }

    public static long clCreateUserEvent(long context, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 4);
        }
        return CL11.nclCreateUserEvent(context, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateUserEvent(long context, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL11.nclCreateUserEvent(context, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native int nclSetUserEventStatus(long var0, int var2, long var3);

    public static int clSetUserEventStatus(long event, int execution_status) {
        long __functionAddress = CL11.getInstance().SetUserEventStatus;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(event);
        }
        return CL11.nclSetUserEventStatus(event, execution_status, __functionAddress);
    }

    public static native int nclSetEventCallback(long var0, int var2, long var3, long var5, long var7);

    public static int clSetEventCallback(long event, int command_exec_callback_type, long pfn_notify, long user_data) {
        long __functionAddress = CL11.getInstance().SetEventCallback;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(event);
        }
        return CL11.nclSetEventCallback(event, command_exec_callback_type, pfn_notify, user_data, __functionAddress);
    }

    public static int clSetEventCallback(long event, int command_exec_callback_type, CLEventCallback pfn_notify) {
        long user_data;
        int __result;
        long __functionAddress = CL11.getInstance().SetEventCallback;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(event);
        }
        if ((__result = CL11.nclSetEventCallback(event, command_exec_callback_type, CLEventCallback.Util.CALLBACK, user_data = MemoryUtil.memGlobalRefNew(pfn_notify), __functionAddress)) != 0) {
            MemoryUtil.memGlobalRefDelete(user_data);
        }
        return __result;
    }
}

