/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class CL10GL {
    public static final int CL_INVALID_GL_OBJECT = -60;
    public static final int CL_INVALID_MIP_LEVEL = -62;
    public static final int CL_GL_OBJECT_BUFFER = 8192;
    public static final int CL_GL_OBJECT_TEXTURE2D = 8193;
    public static final int CL_GL_OBJECT_TEXTURE3D = 8194;
    public static final int CL_GL_OBJECT_RENDERBUFFER = 8195;
    public static final int CL_GL_TEXTURE_TARGET = 8196;
    public static final int CL_GL_MIPMAP_LEVEL = 8197;
    public final long CreateFromGLBuffer;
    public final long CreateFromGLTexture2D;
    public final long CreateFromGLTexture3D;
    public final long CreateFromGLRenderbuffer;
    public final long GetGLObjectInfo;
    public final long GetGLTextureInfo;
    public final long EnqueueAcquireGLObjects;
    public final long EnqueueReleaseGLObjects;

    public CL10GL(FunctionProvider provider) {
        this.CreateFromGLBuffer = provider.getFunctionAddress("clCreateFromGLBuffer");
        this.CreateFromGLTexture2D = provider.getFunctionAddress("clCreateFromGLTexture2D");
        this.CreateFromGLTexture3D = provider.getFunctionAddress("clCreateFromGLTexture3D");
        this.CreateFromGLRenderbuffer = provider.getFunctionAddress("clCreateFromGLRenderbuffer");
        this.GetGLObjectInfo = provider.getFunctionAddress("clGetGLObjectInfo");
        this.GetGLTextureInfo = provider.getFunctionAddress("clGetGLTextureInfo");
        this.EnqueueAcquireGLObjects = provider.getFunctionAddress("clEnqueueAcquireGLObjects");
        this.EnqueueReleaseGLObjects = provider.getFunctionAddress("clEnqueueReleaseGLObjects");
    }

    public static CL10GL getInstance() {
        return CL.getICD().__CL10GL;
    }

    static CL10GL create(FunctionProvider provider) {
        CL10GL funcs = new CL10GL(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateFromGLBuffer, funcs.CreateFromGLTexture2D, funcs.CreateFromGLTexture3D, funcs.CreateFromGLRenderbuffer, funcs.GetGLObjectInfo, funcs.GetGLTextureInfo, funcs.EnqueueAcquireGLObjects, funcs.EnqueueReleaseGLObjects);
        return supported ? funcs : null;
    }

    public static native long nclCreateFromGLBuffer(long var0, long var2, int var4, long var5, long var7);

    public static long nclCreateFromGLBuffer(long context, long flags, int bufobj, long errcode_ret) {
        long __functionAddress = CL10GL.getInstance().CreateFromGLBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL10GL.nclCreateFromGLBuffer(context, flags, bufobj, errcode_ret, __functionAddress);
    }

    public static long clCreateFromGLBuffer(long context, long flags, int bufobj, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 4);
        }
        return CL10GL.nclCreateFromGLBuffer(context, flags, bufobj, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateFromGLBuffer(long context, long flags, int bufobj, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLBuffer(context, flags, bufobj, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native long nclCreateFromGLTexture2D(long var0, long var2, int var4, int var5, int var6, long var7, long var9);

    public static long nclCreateFromGLTexture2D(long context, long flags, int texture_target, int miplevel, int texture, long errcode_ret) {
        long __functionAddress = CL10GL.getInstance().CreateFromGLTexture2D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL10GL.nclCreateFromGLTexture2D(context, flags, texture_target, miplevel, texture, errcode_ret, __functionAddress);
    }

    public static long clCreateFromGLTexture2D(long context, long flags, int texture_target, int miplevel, int texture, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 4);
        }
        return CL10GL.nclCreateFromGLTexture2D(context, flags, texture_target, miplevel, texture, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateFromGLTexture2D(long context, long flags, int texture_target, int miplevel, int texture, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLTexture2D(context, flags, texture_target, miplevel, texture, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native long nclCreateFromGLTexture3D(long var0, long var2, int var4, int var5, int var6, long var7, long var9);

    public static long nclCreateFromGLTexture3D(long context, long flags, int texture_target, int miplevel, int texture, long errcode_ret) {
        long __functionAddress = CL10GL.getInstance().CreateFromGLTexture3D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL10GL.nclCreateFromGLTexture3D(context, flags, texture_target, miplevel, texture, errcode_ret, __functionAddress);
    }

    public static long clCreateFromGLTexture3D(long context, long flags, int texture_target, int miplevel, int texture, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 4);
        }
        return CL10GL.nclCreateFromGLTexture3D(context, flags, texture_target, miplevel, texture, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateFromGLTexture3D(long context, long flags, int texture_target, int miplevel, int texture, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLTexture3D(context, flags, texture_target, miplevel, texture, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native long nclCreateFromGLRenderbuffer(long var0, long var2, int var4, long var5, long var7);

    public static long nclCreateFromGLRenderbuffer(long context, long flags, int renderbuffer, long errcode_ret) {
        long __functionAddress = CL10GL.getInstance().CreateFromGLRenderbuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL10GL.nclCreateFromGLRenderbuffer(context, flags, renderbuffer, errcode_ret, __functionAddress);
    }

    public static long clCreateFromGLRenderbuffer(long context, long flags, int renderbuffer, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 4);
        }
        return CL10GL.nclCreateFromGLRenderbuffer(context, flags, renderbuffer, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateFromGLRenderbuffer(long context, long flags, int renderbuffer, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLRenderbuffer(context, flags, renderbuffer, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native int nclGetGLObjectInfo(long var0, long var2, long var4, long var6);

    public static int nclGetGLObjectInfo(long memobj, long gl_object_type, long gl_object_name) {
        long __functionAddress = CL10GL.getInstance().GetGLObjectInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(memobj);
        }
        return CL10GL.nclGetGLObjectInfo(memobj, gl_object_type, gl_object_name, __functionAddress);
    }

    public static int clGetGLObjectInfo(long memobj, ByteBuffer gl_object_type, ByteBuffer gl_object_name) {
        return CL10GL.nclGetGLObjectInfo(memobj, MemoryUtil.memAddressSafe(gl_object_type), MemoryUtil.memAddressSafe(gl_object_name));
    }

    public static int clGetGLObjectInfo(long memobj, IntBuffer gl_object_type, IntBuffer gl_object_name) {
        return CL10GL.nclGetGLObjectInfo(memobj, MemoryUtil.memAddressSafe(gl_object_type), MemoryUtil.memAddressSafe(gl_object_name));
    }

    public static native int nclGetGLTextureInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int nclGetGLTextureInfo(long memobj, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL10GL.getInstance().GetGLTextureInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(memobj);
        }
        return CL10GL.nclGetGLTextureInfo(memobj, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetGLTextureInfo(long memobj, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10GL.nclGetGLTextureInfo(memobj, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetGLTextureInfo(long memobj, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10GL.nclGetGLTextureInfo(memobj, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetGLTextureInfo(long memobj, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10GL.nclGetGLTextureInfo(memobj, param_name, (param_value == null ? 0 : param_value.remaining()) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native int nclEnqueueAcquireGLObjects(long var0, int var2, long var3, int var5, long var6, long var8, long var10);

    public static int nclEnqueueAcquireGLObjects(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10GL.getInstance().EnqueueAcquireGLObjects;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL10GL.nclEnqueueAcquireGLObjects(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueAcquireGLObjects(long command_queue, int num_objects, ByteBuffer mem_objects, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)mem_objects, num_objects << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10GL.nclEnqueueAcquireGLObjects(command_queue, num_objects, MemoryUtil.memAddress(mem_objects), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueAcquireGLObjects(long command_queue, PointerBuffer mem_objects, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10GL.nclEnqueueAcquireGLObjects(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueAcquireGLObjects(long command_queue, long mem_object, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int mem_objects = __buffer.pointerParam(mem_object);
        return CL10GL.nclEnqueueAcquireGLObjects(command_queue, 1, __buffer.address() + (long)mem_objects, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueReleaseGLObjects(long var0, int var2, long var3, int var5, long var6, long var8, long var10);

    public static int nclEnqueueReleaseGLObjects(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10GL.getInstance().EnqueueReleaseGLObjects;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL10GL.nclEnqueueReleaseGLObjects(command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueReleaseGLObjects(long command_queue, int num_objects, ByteBuffer mem_objects, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)mem_objects, num_objects << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10GL.nclEnqueueReleaseGLObjects(command_queue, num_objects, MemoryUtil.memAddress(mem_objects), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReleaseGLObjects(long command_queue, PointerBuffer mem_objects, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10GL.nclEnqueueReleaseGLObjects(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReleaseGLObjects(long command_queue, long mem_object, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int mem_objects = __buffer.pointerParam(mem_object);
        return CL10GL.nclEnqueueReleaseGLObjects(command_queue, 1, __buffer.address() + (long)mem_objects, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }
}

