/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLContextCallback;
import org.lwjgl.opencl.CLNativeKernel;
import org.lwjgl.opencl.CLProgramCallback;
import org.lwjgl.opencl.Info;
import org.lwjgl.opencl.cl_image_format;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class CL10 {
    public static final int CL_SUCCESS = 0;
    public static final int CL_DEVICE_NOT_FOUND = -1;
    public static final int CL_DEVICE_NOT_AVAILABLE = -2;
    public static final int CL_COMPILER_NOT_AVAILABLE = -3;
    public static final int CL_MEM_OBJECT_ALLOCATION_FAILURE = -4;
    public static final int CL_OUT_OF_RESOURCES = -5;
    public static final int CL_OUT_OF_HOST_MEMORY = -6;
    public static final int CL_PROFILING_INFO_NOT_AVAILABLE = -7;
    public static final int CL_MEM_COPY_OVERLAP = -8;
    public static final int CL_IMAGE_FORMAT_MISMATCH = -9;
    public static final int CL_IMAGE_FORMAT_NOT_SUPPORTED = -10;
    public static final int CL_BUILD_PROGRAM_FAILURE = -11;
    public static final int CL_MAP_FAILURE = -12;
    public static final int CL_INVALID_VALUE = -30;
    public static final int CL_INVALID_DEVICE_TYPE = -31;
    public static final int CL_INVALID_PLATFORM = -32;
    public static final int CL_INVALID_DEVICE = -33;
    public static final int CL_INVALID_CONTEXT = -34;
    public static final int CL_INVALID_QUEUE_PROPERTIES = -35;
    public static final int CL_INVALID_COMMAND_QUEUE = -36;
    public static final int CL_INVALID_HOST_PTR = -37;
    public static final int CL_INVALID_MEM_OBJECT = -38;
    public static final int CL_INVALID_IMAGE_FORMAT_DESCRIPTOR = -39;
    public static final int CL_INVALID_IMAGE_SIZE = -40;
    public static final int CL_INVALID_SAMPLER = -41;
    public static final int CL_INVALID_BINARY = -42;
    public static final int CL_INVALID_BUILD_OPTIONS = -43;
    public static final int CL_INVALID_PROGRAM = -44;
    public static final int CL_INVALID_PROGRAM_EXECUTABLE = -45;
    public static final int CL_INVALID_KERNEL_NAME = -46;
    public static final int CL_INVALID_KERNEL_DEFINITION = -47;
    public static final int CL_INVALID_KERNEL = -48;
    public static final int CL_INVALID_ARG_INDEX = -49;
    public static final int CL_INVALID_ARG_VALUE = -50;
    public static final int CL_INVALID_ARG_SIZE = -51;
    public static final int CL_INVALID_KERNEL_ARGS = -52;
    public static final int CL_INVALID_WORK_DIMENSION = -53;
    public static final int CL_INVALID_WORK_GROUP_SIZE = -54;
    public static final int CL_INVALID_WORK_ITEM_SIZE = -55;
    public static final int CL_INVALID_GLOBAL_OFFSET = -56;
    public static final int CL_INVALID_EVENT_WAIT_LIST = -57;
    public static final int CL_INVALID_EVENT = -58;
    public static final int CL_INVALID_OPERATION = -59;
    public static final int CL_INVALID_BUFFER_SIZE = -61;
    public static final int CL_INVALID_GLOBAL_WORK_SIZE = -63;
    public static final int CL_VERSION_1_0 = 1;
    public static final int CL_FALSE = 0;
    public static final int CL_TRUE = 1;
    public static final int CL_PLATFORM_PROFILE = 2304;
    public static final int CL_PLATFORM_VERSION = 2305;
    public static final int CL_PLATFORM_NAME = 2306;
    public static final int CL_PLATFORM_VENDOR = 2307;
    public static final int CL_PLATFORM_EXTENSIONS = 2308;
    public static final int CL_DEVICE_TYPE_DEFAULT = 1;
    public static final int CL_DEVICE_TYPE_CPU = 2;
    public static final int CL_DEVICE_TYPE_GPU = 4;
    public static final int CL_DEVICE_TYPE_ACCELERATOR = 8;
    public static final int CL_DEVICE_TYPE_ALL = -1;
    public static final int CL_DEVICE_TYPE = 4096;
    public static final int CL_DEVICE_VENDOR_ID = 4097;
    public static final int CL_DEVICE_MAX_COMPUTE_UNITS = 4098;
    public static final int CL_DEVICE_MAX_WORK_ITEM_DIMENSIONS = 4099;
    public static final int CL_DEVICE_MAX_WORK_GROUP_SIZE = 4100;
    public static final int CL_DEVICE_MAX_WORK_ITEM_SIZES = 4101;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_CHAR = 4102;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_SHORT = 4103;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_ = 4104;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_LONG = 4105;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_FLOAT = 4106;
    public static final int CL_DEVICE_PREFERRED_VECTOR_WIDTH_DOUBLE = 4107;
    public static final int CL_DEVICE_MAX_CLOCK_FREQUENCY = 4108;
    public static final int CL_DEVICE_ADDRESS_BITS = 4109;
    public static final int CL_DEVICE_MAX_READ_IMAGE_ARGS = 4110;
    public static final int CL_DEVICE_MAX_WRITE_IMAGE_ARGS = 4111;
    public static final int CL_DEVICE_MAX_MEM_ALLOC_SIZE = 4112;
    public static final int CL_DEVICE_IMAGE2D_MAX_WIDTH = 4113;
    public static final int CL_DEVICE_IMAGE2D_MAX_HEIGHT = 4114;
    public static final int CL_DEVICE_IMAGE3D_MAX_WIDTH = 4115;
    public static final int CL_DEVICE_IMAGE3D_MAX_HEIGHT = 4116;
    public static final int CL_DEVICE_IMAGE3D_MAX_DEPTH = 4117;
    public static final int CL_DEVICE_IMAGE_SUPPORT = 4118;
    public static final int CL_DEVICE_MAX_PARAMETER_SIZE = 4119;
    public static final int CL_DEVICE_MAX_SAMPLERS = 4120;
    public static final int CL_DEVICE_MEM_BASE_ADDR_ALIGN = 4121;
    public static final int CL_DEVICE_MIN_DATA_TYPE_ALIGN_SIZE = 4122;
    public static final int CL_DEVICE_SINGLE_FP_CONFIG = 4123;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHE_TYPE = 4124;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHELINE_SIZE = 4125;
    public static final int CL_DEVICE_GLOBAL_MEM_CACHE_SIZE = 4126;
    public static final int CL_DEVICE_GLOBAL_MEM_SIZE = 4127;
    public static final int CL_DEVICE_MAX_CONSTANT_BUFFER_SIZE = 4128;
    public static final int CL_DEVICE_MAX_CONSTANT_ARGS = 4129;
    public static final int CL_DEVICE_LOCAL_MEM_TYPE = 4130;
    public static final int CL_DEVICE_LOCAL_MEM_SIZE = 4131;
    public static final int CL_DEVICE_ERROR_CORRECTION_SUPPORT = 4132;
    public static final int CL_DEVICE_PROFILING_TIMER_RESOLUTION = 4133;
    public static final int CL_DEVICE_ENDIAN_LITTLE = 4134;
    public static final int CL_DEVICE_AVAILABLE = 4135;
    public static final int CL_DEVICE_COMPILER_AVAILABLE = 4136;
    public static final int CL_DEVICE_EXECUTION_CAPABILITIES = 4137;
    public static final int CL_DEVICE_QUEUE_PROPERTIES = 4138;
    public static final int CL_DEVICE_NAME = 4139;
    public static final int CL_DEVICE_VENDOR = 4140;
    public static final int CL_DRIVER_VERSION = 4141;
    public static final int CL_DEVICE_PROFILE = 4142;
    public static final int CL_DEVICE_VERSION = 4143;
    public static final int CL_DEVICE_EXTENSIONS = 4144;
    public static final int CL_DEVICE_PLATFORM = 4145;
    public static final int CL_FP_DENORM = 1;
    public static final int CL_FP_INF_NAN = 2;
    public static final int CL_FP_ROUND_TO_NEAREST = 4;
    public static final int CL_FP_ROUND_TO_ZERO = 8;
    public static final int CL_FP_ROUND_TO_INF = 16;
    public static final int CL_FP_FMA = 32;
    public static final int CL_NONE = 0;
    public static final int CL_READ_ONLY_CACHE = 1;
    public static final int CL_READ_WRITE_CACHE = 2;
    public static final int CL_LOCAL = 1;
    public static final int CL_GLOBAL = 2;
    public static final int CL_EXEC_KERNEL = 1;
    public static final int CL_EXEC_NATIVE_KERNEL = 2;
    public static final int CL_QUEUE_OUT_OF_ORDER_EXEC_MODE_ENABLE = 1;
    public static final int CL_QUEUE_PROFILING_ENABLE = 2;
    public static final int CL_CONTEXT_REFERENCE_COUNT = 4224;
    public static final int CL_CONTEXT_DEVICES = 4225;
    public static final int CL_CONTEXT_PROPERTIES = 4226;
    public static final int CL_CONTEXT_PLATFORM = 4228;
    public static final int CL_QUEUE_CONTEXT = 4240;
    public static final int CL_QUEUE_DEVICE = 4241;
    public static final int CL_QUEUE_REFERENCE_COUNT = 4242;
    public static final int CL_QUEUE_PROPERTIES = 4243;
    public static final int CL_MEM_READ_WRITE = 1;
    public static final int CL_MEM_WRITE_ONLY = 2;
    public static final int CL_MEM_READ_ONLY = 4;
    public static final int CL_MEM_USE_HOST_PTR = 8;
    public static final int CL_MEM_ALLOC_HOST_PTR = 16;
    public static final int CL_MEM_COPY_HOST_PTR = 32;
    public static final int CL_R = 4272;
    public static final int CL_A = 4273;
    public static final int CL_RG = 4274;
    public static final int CL_RA = 4275;
    public static final int CL_RGB = 4276;
    public static final int CL_RGBA = 4277;
    public static final int CL_BGRA = 4278;
    public static final int CL_ARGB = 4279;
    public static final int CL_INTENSITY = 4280;
    public static final int CL_LUMINANCE = 4281;
    public static final int CL_SNORM_INT8 = 4304;
    public static final int CL_SNORM_INT16 = 4305;
    public static final int CL_UNORM_INT8 = 4306;
    public static final int CL_UNORM_INT16 = 4307;
    public static final int CL_UNORM_SHORT_565 = 4308;
    public static final int CL_UNORM_SHORT_555 = 4309;
    public static final int CL_UNORM_INT_101010 = 4310;
    public static final int CL_SIGNED_INT8 = 4311;
    public static final int CL_SIGNED_INT16 = 4312;
    public static final int CL_SIGNED_INT32 = 4313;
    public static final int CL_UNSIGNED_INT8 = 4314;
    public static final int CL_UNSIGNED_INT16 = 4315;
    public static final int CL_UNSIGNED_INT32 = 4316;
    public static final int CL_HALF_FLOAT = 4317;
    public static final int CL_FLOAT = 4318;
    public static final int CL_MEM_OBJECT_BUFFER = 4336;
    public static final int CL_MEM_OBJECT_IMAGE2D = 4337;
    public static final int CL_MEM_OBJECT_IMAGE3D = 4338;
    public static final int CL_MEM_TYPE = 4352;
    public static final int CL_MEM_FLAGS = 4353;
    public static final int CL_MEM_SIZE = 4354;
    public static final int CL_MEM_HOST_PTR = 4355;
    public static final int CL_MEM_MAP_COUNT = 4356;
    public static final int CL_MEM_REFERENCE_COUNT = 4357;
    public static final int CL_MEM_CONTEXT = 4358;
    public static final int CL_IMAGE_FORMAT = 4368;
    public static final int CL_IMAGE_ELEMENT_SIZE = 4369;
    public static final int CL_IMAGE_ROW_PITCH = 4370;
    public static final int CL_IMAGE_SLICE_PITCH = 4371;
    public static final int CL_IMAGE_WIDTH = 4372;
    public static final int CL_IMAGE_HEIGHT = 4373;
    public static final int CL_IMAGE_DEPTH = 4374;
    public static final int CL_ADDRESS_NONE = 4400;
    public static final int CL_ADDRESS_CLAMP_TO_EDGE = 4401;
    public static final int CL_ADDRESS_CLAMP = 4402;
    public static final int CL_ADDRESS_REPEAT = 4403;
    public static final int CL_FILTER_NEAREST = 4416;
    public static final int CL_FILTER_LINEAR = 4417;
    public static final int CL_SAMPLER_REFERENCE_COUNT = 4432;
    public static final int CL_SAMPLER_CONTEXT = 4433;
    public static final int CL_SAMPLER_NORMALIZED_COORDS = 4434;
    public static final int CL_SAMPLER_ADDRESSING_MODE = 4435;
    public static final int CL_SAMPLER_FILTER_MODE = 4436;
    public static final int CL_MAP_READ = 1;
    public static final int CL_MAP_WRITE = 2;
    public static final int CL_PROGRAM_REFERENCE_COUNT = 4448;
    public static final int CL_PROGRAM_CONTEXT = 4449;
    public static final int CL_PROGRAM_NUM_DEVICES = 4450;
    public static final int CL_PROGRAM_DEVICES = 4451;
    public static final int CL_PROGRAM_SOURCE = 4452;
    public static final int CL_PROGRAM_BINARY_SIZES = 4453;
    public static final int CL_PROGRAM_BINARIES = 4454;
    public static final int CL_PROGRAM_BUILD_STATUS = 4481;
    public static final int CL_PROGRAM_BUILD_OPTIONS = 4482;
    public static final int CL_PROGRAM_BUILD_LOG = 4483;
    public static final int CL_BUILD_SUCCESS = 0;
    public static final int CL_BUILD_NONE = -1;
    public static final int CL_BUILD_ERROR = -2;
    public static final int CL_BUILD_IN_PROGRESS = -3;
    public static final int CL_KERNEL_FUNCTION_NAME = 4496;
    public static final int CL_KERNEL_NUM_ARGS = 4497;
    public static final int CL_KERNEL_REFERENCE_COUNT = 4498;
    public static final int CL_KERNEL_CONTEXT = 4499;
    public static final int CL_KERNEL_PROGRAM = 4500;
    public static final int CL_KERNEL_WORK_GROUP_SIZE = 4528;
    public static final int CL_KERNEL_COMPILE_WORK_GROUP_SIZE = 4529;
    public static final int CL_KERNEL_LOCAL_MEM_SIZE = 4530;
    public static final int CL_EVENT_COMMAND_QUEUE = 4560;
    public static final int CL_EVENT_COMMAND_TYPE = 4561;
    public static final int CL_EVENT_REFERENCE_COUNT = 4562;
    public static final int CL_EVENT_COMMAND_EXECUTION_STATUS = 4563;
    public static final int CL_COMMAND_NDRANGE_KERNEL = 4592;
    public static final int CL_COMMAND_TASK = 4593;
    public static final int CL_COMMAND_NATIVE_KERNEL = 4594;
    public static final int CL_COMMAND_READ_BUFFER = 4595;
    public static final int CL_COMMAND_WRITE_BUFFER = 4596;
    public static final int CL_COMMAND_COPY_BUFFER = 4597;
    public static final int CL_COMMAND_READ_IMAGE = 4598;
    public static final int CL_COMMAND_WRITE_IMAGE = 4599;
    public static final int CL_COMMAND_COPY_IMAGE = 4600;
    public static final int CL_COMMAND_COPY_IMAGE_TO_BUFFER = 4601;
    public static final int CL_COMMAND_COPY_BUFFER_TO_IMAGE = 4602;
    public static final int CL_COMMAND_MAP_BUFFER = 4603;
    public static final int CL_COMMAND_MAP_IMAGE = 4604;
    public static final int CL_COMMAND_UNMAP_MEM_OBJECT = 4605;
    public static final int CL_COMMAND_MARKER = 4606;
    public static final int CL_COMMAND_ACQUIRE_GL_OBJECTS = 4607;
    public static final int CL_COMMAND_RELEASE_GL_OBJECTS = 4608;
    public static final int CL_COMPLETE = 0;
    public static final int CL_RUNNING = 1;
    public static final int CL_SUBMITTED = 2;
    public static final int CL_QUEUED = 3;
    public static final int CL_PROFILING_COMMAND_QUEUED = 4736;
    public static final int CL_PROFILING_COMMAND_SUBMIT = 4737;
    public static final int CL_PROFILING_COMMAND_START = 4738;
    public static final int CL_PROFILING_COMMAND_END = 4739;
    public final long GetPlatformIDs;
    public final long GetPlatformInfo;
    public final long GetDeviceIDs;
    public final long GetDeviceInfo;
    public final long CreateContext;
    public final long CreateContextFromType;
    public final long RetainContext;
    public final long ReleaseContext;
    public final long GetContextInfo;
    public final long CreateCommandQueue;
    public final long RetainCommandQueue;
    public final long ReleaseCommandQueue;
    public final long GetCommandQueueInfo;
    public final long CreateBuffer;
    public final long EnqueueReadBuffer;
    public final long EnqueueWriteBuffer;
    public final long EnqueueCopyBuffer;
    public final long EnqueueMapBuffer;
    public final long CreateImage2D;
    public final long CreateImage3D;
    public final long GetSupportedImageFormats;
    public final long EnqueueReadImage;
    public final long EnqueueWriteImage;
    public final long EnqueueCopyImage;
    public final long EnqueueCopyImageToBuffer;
    public final long EnqueueCopyBufferToImage;
    public final long EnqueueMapImage;
    public final long GetImageInfo;
    public final long RetainMemObject;
    public final long ReleaseMemObject;
    public final long EnqueueUnmapMemObject;
    public final long GetMemObjectInfo;
    public final long CreateSampler;
    public final long RetainSampler;
    public final long ReleaseSampler;
    public final long GetSamplerInfo;
    public final long CreateProgramWithSource;
    public final long CreateProgramWithBinary;
    public final long RetainProgram;
    public final long ReleaseProgram;
    public final long BuildProgram;
    public final long UnloadCompiler;
    public final long GetProgramInfo;
    public final long GetProgramBuildInfo;
    public final long CreateKernel;
    public final long CreateKernelsInProgram;
    public final long RetainKernel;
    public final long ReleaseKernel;
    public final long SetKernelArg;
    public final long GetKernelInfo;
    public final long GetKernelWorkGroupInfo;
    public final long EnqueueNDRangeKernel;
    public final long EnqueueTask;
    public final long EnqueueNativeKernel;
    public final long WaitForEvents;
    public final long GetEventInfo;
    public final long RetainEvent;
    public final long ReleaseEvent;
    public final long EnqueueMarker;
    public final long EnqueueBarrier;
    public final long EnqueueWaitForEvents;
    public final long GetEventProfilingInfo;
    public final long Flush;
    public final long Finish;
    public final long GetExtensionFunctionAddress;

    public CL10(FunctionProvider provider) {
        this.GetPlatformIDs = provider.getFunctionAddress("clGetPlatformIDs");
        this.GetPlatformInfo = provider.getFunctionAddress("clGetPlatformInfo");
        this.GetDeviceIDs = provider.getFunctionAddress("clGetDeviceIDs");
        this.GetDeviceInfo = provider.getFunctionAddress("clGetDeviceInfo");
        this.CreateContext = provider.getFunctionAddress("clCreateContext");
        this.CreateContextFromType = provider.getFunctionAddress("clCreateContextFromType");
        this.RetainContext = provider.getFunctionAddress("clRetainContext");
        this.ReleaseContext = provider.getFunctionAddress("clReleaseContext");
        this.GetContextInfo = provider.getFunctionAddress("clGetContextInfo");
        this.CreateCommandQueue = provider.getFunctionAddress("clCreateCommandQueue");
        this.RetainCommandQueue = provider.getFunctionAddress("clRetainCommandQueue");
        this.ReleaseCommandQueue = provider.getFunctionAddress("clReleaseCommandQueue");
        this.GetCommandQueueInfo = provider.getFunctionAddress("clGetCommandQueueInfo");
        this.CreateBuffer = provider.getFunctionAddress("clCreateBuffer");
        this.EnqueueReadBuffer = provider.getFunctionAddress("clEnqueueReadBuffer");
        this.EnqueueWriteBuffer = provider.getFunctionAddress("clEnqueueWriteBuffer");
        this.EnqueueCopyBuffer = provider.getFunctionAddress("clEnqueueCopyBuffer");
        this.EnqueueMapBuffer = provider.getFunctionAddress("clEnqueueMapBuffer");
        this.CreateImage2D = provider.getFunctionAddress("clCreateImage2D");
        this.CreateImage3D = provider.getFunctionAddress("clCreateImage3D");
        this.GetSupportedImageFormats = provider.getFunctionAddress("clGetSupportedImageFormats");
        this.EnqueueReadImage = provider.getFunctionAddress("clEnqueueReadImage");
        this.EnqueueWriteImage = provider.getFunctionAddress("clEnqueueWriteImage");
        this.EnqueueCopyImage = provider.getFunctionAddress("clEnqueueCopyImage");
        this.EnqueueCopyImageToBuffer = provider.getFunctionAddress("clEnqueueCopyImageToBuffer");
        this.EnqueueCopyBufferToImage = provider.getFunctionAddress("clEnqueueCopyBufferToImage");
        this.EnqueueMapImage = provider.getFunctionAddress("clEnqueueMapImage");
        this.GetImageInfo = provider.getFunctionAddress("clGetImageInfo");
        this.RetainMemObject = provider.getFunctionAddress("clRetainMemObject");
        this.ReleaseMemObject = provider.getFunctionAddress("clReleaseMemObject");
        this.EnqueueUnmapMemObject = provider.getFunctionAddress("clEnqueueUnmapMemObject");
        this.GetMemObjectInfo = provider.getFunctionAddress("clGetMemObjectInfo");
        this.CreateSampler = provider.getFunctionAddress("clCreateSampler");
        this.RetainSampler = provider.getFunctionAddress("clRetainSampler");
        this.ReleaseSampler = provider.getFunctionAddress("clReleaseSampler");
        this.GetSamplerInfo = provider.getFunctionAddress("clGetSamplerInfo");
        this.CreateProgramWithSource = provider.getFunctionAddress("clCreateProgramWithSource");
        this.CreateProgramWithBinary = provider.getFunctionAddress("clCreateProgramWithBinary");
        this.RetainProgram = provider.getFunctionAddress("clRetainProgram");
        this.ReleaseProgram = provider.getFunctionAddress("clReleaseProgram");
        this.BuildProgram = provider.getFunctionAddress("clBuildProgram");
        this.UnloadCompiler = provider.getFunctionAddress("clUnloadCompiler");
        this.GetProgramInfo = provider.getFunctionAddress("clGetProgramInfo");
        this.GetProgramBuildInfo = provider.getFunctionAddress("clGetProgramBuildInfo");
        this.CreateKernel = provider.getFunctionAddress("clCreateKernel");
        this.CreateKernelsInProgram = provider.getFunctionAddress("clCreateKernelsInProgram");
        this.RetainKernel = provider.getFunctionAddress("clRetainKernel");
        this.ReleaseKernel = provider.getFunctionAddress("clReleaseKernel");
        this.SetKernelArg = provider.getFunctionAddress("clSetKernelArg");
        this.GetKernelInfo = provider.getFunctionAddress("clGetKernelInfo");
        this.GetKernelWorkGroupInfo = provider.getFunctionAddress("clGetKernelWorkGroupInfo");
        this.EnqueueNDRangeKernel = provider.getFunctionAddress("clEnqueueNDRangeKernel");
        this.EnqueueTask = provider.getFunctionAddress("clEnqueueTask");
        this.EnqueueNativeKernel = provider.getFunctionAddress("clEnqueueNativeKernel");
        this.WaitForEvents = provider.getFunctionAddress("clWaitForEvents");
        this.GetEventInfo = provider.getFunctionAddress("clGetEventInfo");
        this.RetainEvent = provider.getFunctionAddress("clRetainEvent");
        this.ReleaseEvent = provider.getFunctionAddress("clReleaseEvent");
        this.EnqueueMarker = provider.getFunctionAddress("clEnqueueMarker");
        this.EnqueueBarrier = provider.getFunctionAddress("clEnqueueBarrier");
        this.EnqueueWaitForEvents = provider.getFunctionAddress("clEnqueueWaitForEvents");
        this.GetEventProfilingInfo = provider.getFunctionAddress("clGetEventProfilingInfo");
        this.Flush = provider.getFunctionAddress("clFlush");
        this.Finish = provider.getFunctionAddress("clFinish");
        this.GetExtensionFunctionAddress = provider.getFunctionAddress("clGetExtensionFunctionAddress");
    }

    public static CL10 getInstance() {
        return CL.getICD().__CL10;
    }

    static CL10 create(FunctionProvider provider) {
        CL10 funcs = new CL10(provider);
        boolean supported = Checks.checkFunctions(funcs.GetPlatformIDs, funcs.GetPlatformInfo, funcs.GetDeviceIDs, funcs.GetDeviceInfo, funcs.CreateContext, funcs.CreateContextFromType, funcs.RetainContext, funcs.ReleaseContext, funcs.GetContextInfo, funcs.CreateCommandQueue, funcs.RetainCommandQueue, funcs.ReleaseCommandQueue, funcs.GetCommandQueueInfo, funcs.CreateBuffer, funcs.EnqueueReadBuffer, funcs.EnqueueWriteBuffer, funcs.EnqueueCopyBuffer, funcs.EnqueueMapBuffer, funcs.CreateImage2D, funcs.CreateImage3D, funcs.GetSupportedImageFormats, funcs.EnqueueReadImage, funcs.EnqueueWriteImage, funcs.EnqueueCopyImage, funcs.EnqueueCopyImageToBuffer, funcs.EnqueueCopyBufferToImage, funcs.EnqueueMapImage, funcs.GetImageInfo, funcs.RetainMemObject, funcs.ReleaseMemObject, funcs.EnqueueUnmapMemObject, funcs.GetMemObjectInfo, funcs.CreateSampler, funcs.RetainSampler, funcs.ReleaseSampler, funcs.GetSamplerInfo, funcs.CreateProgramWithSource, funcs.CreateProgramWithBinary, funcs.RetainProgram, funcs.ReleaseProgram, funcs.BuildProgram, funcs.UnloadCompiler, funcs.GetProgramInfo, funcs.GetProgramBuildInfo, funcs.CreateKernel, funcs.CreateKernelsInProgram, funcs.RetainKernel, funcs.ReleaseKernel, funcs.SetKernelArg, funcs.GetKernelInfo, funcs.GetKernelWorkGroupInfo, funcs.EnqueueNDRangeKernel, funcs.EnqueueTask, funcs.EnqueueNativeKernel, funcs.WaitForEvents, funcs.GetEventInfo, funcs.RetainEvent, funcs.ReleaseEvent, funcs.EnqueueMarker, funcs.EnqueueBarrier, funcs.EnqueueWaitForEvents, funcs.GetEventProfilingInfo, funcs.Flush, funcs.Finish, funcs.GetExtensionFunctionAddress);
        return supported ? funcs : null;
    }

    public static native int nclGetPlatformIDs(int var0, long var1, long var3, long var5);

    public static int nclGetPlatformIDs(int num_entries, long platforms, long num_platforms) {
        long __functionAddress = CL10.getInstance().GetPlatformIDs;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return CL10.nclGetPlatformIDs(num_entries, platforms, num_platforms, __functionAddress);
    }

    public static int clGetPlatformIDs(int num_entries, ByteBuffer platforms, ByteBuffer num_platforms) {
        if (LWJGLUtil.CHECKS) {
            if (platforms != null) {
                Checks.checkBuffer((Buffer)platforms, num_entries << Pointer.POINTER_SHIFT);
            }
            if (num_platforms != null) {
                Checks.checkBuffer((Buffer)num_platforms, 4);
            }
        }
        return CL10.nclGetPlatformIDs(num_entries, MemoryUtil.memAddressSafe(platforms), MemoryUtil.memAddressSafe(num_platforms));
    }

    public static int clGetPlatformIDs(PointerBuffer platforms, IntBuffer num_platforms) {
        if (LWJGLUtil.CHECKS && num_platforms != null) {
            Checks.checkBuffer((Buffer)num_platforms, 1);
        }
        return CL10.nclGetPlatformIDs(platforms == null ? 0 : platforms.remaining(), MemoryUtil.memAddressSafe(platforms), MemoryUtil.memAddressSafe(num_platforms));
    }

    public static native int nclGetPlatformInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int nclGetPlatformInfo(long platform, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL10.getInstance().GetPlatformInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(platform);
        }
        return CL10.nclGetPlatformInfo(platform, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetPlatformInfo(long platform, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclGetPlatformInfo(platform, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetPlatformInfo(long platform, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetPlatformInfo(platform, param_name, param_value == null ? 0L : (long)param_value.remaining(), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native int nclGetDeviceIDs(long var0, long var2, int var4, long var5, long var7, long var9);

    public static int nclGetDeviceIDs(long platform, long device_type, int num_entries, long devices, long num_devices) {
        long __functionAddress = CL10.getInstance().GetDeviceIDs;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(platform);
        }
        return CL10.nclGetDeviceIDs(platform, device_type, num_entries, devices, num_devices, __functionAddress);
    }

    public static int clGetDeviceIDs(long platform, long device_type, int num_entries, ByteBuffer devices, ByteBuffer num_devices) {
        if (LWJGLUtil.CHECKS) {
            if (devices != null) {
                Checks.checkBuffer((Buffer)devices, num_entries << Pointer.POINTER_SHIFT);
            }
            if (num_devices != null) {
                Checks.checkBuffer((Buffer)num_devices, 4);
            }
        }
        return CL10.nclGetDeviceIDs(platform, device_type, num_entries, MemoryUtil.memAddressSafe(devices), MemoryUtil.memAddressSafe(num_devices));
    }

    public static int clGetDeviceIDs(long platform, long device_type, PointerBuffer devices, IntBuffer num_devices) {
        if (LWJGLUtil.CHECKS && num_devices != null) {
            Checks.checkBuffer((Buffer)num_devices, 1);
        }
        return CL10.nclGetDeviceIDs(platform, device_type, devices == null ? 0 : devices.remaining(), MemoryUtil.memAddressSafe(devices), MemoryUtil.memAddressSafe(num_devices));
    }

    public static native int nclGetDeviceInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int nclGetDeviceInfo(long device, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL10.getInstance().GetDeviceInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(device);
        }
        return CL10.nclGetDeviceInfo(device, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetDeviceInfo(long device, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclGetDeviceInfo(device, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetDeviceInfo(long device, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetDeviceInfo(device, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetDeviceInfo(long device, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetDeviceInfo(device, param_name, (param_value == null ? 0 : param_value.remaining()) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetDeviceInfo(long device, int param_name, LongBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetDeviceInfo(device, param_name, (param_value == null ? 0 : param_value.remaining()) << 3, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetDeviceInfo(long device, int param_name, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetDeviceInfo(device, param_name, (param_value == null ? 0 : param_value.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native long nclCreateContext(long var0, int var2, long var3, long var5, long var7, long var9, long var11);

    public static long nclCreateContext(long properties, int num_devices, long devices, long pfn_notify, long user_data, long errcode_ret) {
        long __functionAddress = CL10.getInstance().CreateContext;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return CL10.nclCreateContext(properties, num_devices, devices, pfn_notify, user_data, errcode_ret, __functionAddress);
    }

    public static long clCreateContext(ByteBuffer properties, int num_devices, ByteBuffer devices, long pfn_notify, long user_data, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)properties, 3 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)devices, num_devices << Pointer.POINTER_SHIFT);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        return CL10.nclCreateContext(MemoryUtil.memAddress(properties), num_devices, MemoryUtil.memAddress(devices), pfn_notify, user_data, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateContext(PointerBuffer properties, PointerBuffer devices, CLContextCallback pfn_notify, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(properties, 3);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        long user_data = CLContextCallback.Util.register(pfn_notify);
        long __result = CL10.nclCreateContext(MemoryUtil.memAddress(properties), devices.remaining(), MemoryUtil.memAddress(devices), pfn_notify == null ? 0L : CLContextCallback.Util.CALLBACK, user_data, MemoryUtil.memAddressSafe(errcode_ret));
        CLContextCallback.Util.retain(__result, user_data);
        return __result;
    }

    public static long clCreateContext(PointerBuffer properties, long device, CLContextCallback pfn_notify, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(properties, 3);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int devices = __buffer.pointerParam(device);
        long user_data = CLContextCallback.Util.register(pfn_notify);
        long __result = CL10.nclCreateContext(MemoryUtil.memAddress(properties), 1, __buffer.address() + (long)devices, pfn_notify == null ? 0L : CLContextCallback.Util.CALLBACK, user_data, MemoryUtil.memAddressSafe(errcode_ret));
        CLContextCallback.Util.retain(__result, user_data);
        return __result;
    }

    public static native long nclCreateContextFromType(long var0, long var2, long var4, long var6, long var8, long var10);

    public static long nclCreateContextFromType(long properties, long device_type, long pfn_notify, long user_data, long errcode_ret) {
        long __functionAddress = CL10.getInstance().CreateContextFromType;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return CL10.nclCreateContextFromType(properties, device_type, pfn_notify, user_data, errcode_ret, __functionAddress);
    }

    public static long clCreateContextFromType(ByteBuffer properties, long device_type, long pfn_notify, long user_data, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)properties, 3 << Pointer.POINTER_SHIFT);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        return CL10.nclCreateContextFromType(MemoryUtil.memAddress(properties), device_type, pfn_notify, user_data, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateContextFromType(PointerBuffer properties, long device_type, CLContextCallback pfn_notify, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(properties, 3);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        long user_data = CLContextCallback.Util.register(pfn_notify);
        long __result = CL10.nclCreateContextFromType(MemoryUtil.memAddress(properties), device_type, pfn_notify == null ? 0L : CLContextCallback.Util.CALLBACK, user_data, MemoryUtil.memAddressSafe(errcode_ret));
        CLContextCallback.Util.retain(__result, user_data);
        return __result;
    }

    public static native int nclRetainContext(long var0, long var2);

    public static int clRetainContext(long context) {
        long __functionAddress = CL10.getInstance().RetainContext;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL10.nclRetainContext(context, __functionAddress);
    }

    public static native int nclReleaseContext(long var0, long var2);

    public static int clReleaseContext(long context) {
        long __functionAddress = CL10.getInstance().ReleaseContext;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        int contextRefs = CLContextCallback.Util.getReferenceCount(context);
        int __result = CL10.nclReleaseContext(context, __functionAddress);
        if (__result == 0 && contextRefs == 1) {
            CLContextCallback.Util.release(context);
        }
        return __result;
    }

    public static native int nclGetContextInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int nclGetContextInfo(long context, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL10.getInstance().GetContextInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL10.nclGetContextInfo(context, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetContextInfo(long context, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclGetContextInfo(context, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetContextInfo(long context, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetContextInfo(context, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetContextInfo(long context, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetContextInfo(context, param_name, (param_value == null ? 0 : param_value.remaining()) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetContextInfo(long context, int param_name, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetContextInfo(context, param_name, (param_value == null ? 0 : param_value.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native long nclCreateCommandQueue(long var0, long var2, long var4, long var6, long var8);

    public static long nclCreateCommandQueue(long context, long device, long properties, long errcode_ret) {
        long __functionAddress = CL10.getInstance().CreateCommandQueue;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
            Checks.checkPointer(device);
        }
        return CL10.nclCreateCommandQueue(context, device, properties, errcode_ret, __functionAddress);
    }

    public static long clCreateCommandQueue(long context, long device, long properties, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 4);
        }
        return CL10.nclCreateCommandQueue(context, device, properties, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateCommandQueue(long context, long device, long properties, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateCommandQueue(context, device, properties, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native int nclRetainCommandQueue(long var0, long var2);

    public static int clRetainCommandQueue(long command_queue) {
        long __functionAddress = CL10.getInstance().RetainCommandQueue;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL10.nclRetainCommandQueue(command_queue, __functionAddress);
    }

    public static native int nclReleaseCommandQueue(long var0, long var2);

    public static int clReleaseCommandQueue(long command_queue) {
        long __functionAddress = CL10.getInstance().ReleaseCommandQueue;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL10.nclReleaseCommandQueue(command_queue, __functionAddress);
    }

    public static native int nclGetCommandQueueInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int nclGetCommandQueueInfo(long command_queue, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL10.getInstance().GetCommandQueueInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL10.nclGetCommandQueueInfo(command_queue, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetCommandQueueInfo(long command_queue, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclGetCommandQueueInfo(command_queue, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetCommandQueueInfo(long command_queue, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetCommandQueueInfo(command_queue, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetCommandQueueInfo(long command_queue, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetCommandQueueInfo(command_queue, param_name, (param_value == null ? 0 : param_value.remaining()) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetCommandQueueInfo(long command_queue, int param_name, LongBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetCommandQueueInfo(command_queue, param_name, (param_value == null ? 0 : param_value.remaining()) << 3, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetCommandQueueInfo(long command_queue, int param_name, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetCommandQueueInfo(command_queue, param_name, (param_value == null ? 0 : param_value.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native long nclCreateBuffer(long var0, long var2, long var4, long var6, long var8, long var10);

    public static long nclCreateBuffer(long context, long flags, long size, long host_ptr, long errcode_ret) {
        long __functionAddress = CL10.getInstance().CreateBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL10.nclCreateBuffer(context, flags, size, host_ptr, errcode_ret, __functionAddress);
    }

    public static long clCreateBuffer(long context, long flags, long size, ByteBuffer host_ptr, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            if (host_ptr != null) {
                Checks.checkBuffer((Buffer)host_ptr, size);
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        return CL10.nclCreateBuffer(context, flags, size, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateBuffer(long context, long flags, long size, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateBuffer(context, flags, size, 0L, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateBuffer(long context, long flags, ByteBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateBuffer(context, flags, host_ptr.remaining(), MemoryUtil.memAddress(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateBuffer(long context, long flags, ShortBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateBuffer(context, flags, host_ptr.remaining() << 1, MemoryUtil.memAddress(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateBuffer(long context, long flags, IntBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateBuffer(context, flags, host_ptr.remaining() << 2, MemoryUtil.memAddress(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateBuffer(long context, long flags, FloatBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateBuffer(context, flags, host_ptr.remaining() << 2, MemoryUtil.memAddress(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateBuffer(long context, long flags, DoubleBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateBuffer(context, flags, host_ptr.remaining() << 3, MemoryUtil.memAddress(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native int nclEnqueueReadBuffer(long var0, long var2, int var4, long var5, long var7, long var9, int var11, long var12, long var14, long var16);

    public static int nclEnqueueReadBuffer(long command_queue, long buffer, int blocking_read, long offset, long size, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10.getInstance().EnqueueReadBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read, offset, size, ptr, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueReadBuffer(long command_queue, long buffer, int blocking_read, long offset, long size, ByteBuffer ptr, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)ptr, size);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read, offset, size, MemoryUtil.memAddress(ptr), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBuffer(long command_queue, long buffer, int blocking_read, long offset, long size, ByteBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read, offset, size, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBuffer(long command_queue, long buffer, int blocking_read, long offset, ByteBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read, offset, ptr.remaining(), MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBuffer(long command_queue, long buffer, int blocking_read, long offset, ShortBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read, offset, ptr.remaining() << 1, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBuffer(long command_queue, long buffer, int blocking_read, long offset, IntBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read, offset, ptr.remaining() << 2, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBuffer(long command_queue, long buffer, int blocking_read, long offset, FloatBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read, offset, ptr.remaining() << 2, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadBuffer(long command_queue, long buffer, int blocking_read, long offset, DoubleBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueReadBuffer(command_queue, buffer, blocking_read, offset, ptr.remaining() << 3, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueWriteBuffer(long var0, long var2, int var4, long var5, long var7, long var9, int var11, long var12, long var14, long var16);

    public static int nclEnqueueWriteBuffer(long command_queue, long buffer, int blocking_write, long offset, long size, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10.getInstance().EnqueueWriteBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write, offset, size, ptr, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueWriteBuffer(long command_queue, long buffer, int blocking_write, long offset, long size, ByteBuffer ptr, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)ptr, size);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write, offset, size, MemoryUtil.memAddress(ptr), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBuffer(long command_queue, long buffer, int blocking_write, long offset, long size, ByteBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write, offset, size, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBuffer(long command_queue, long buffer, int blocking_write, long offset, ByteBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write, offset, ptr.remaining(), MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBuffer(long command_queue, long buffer, int blocking_write, long offset, ShortBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write, offset, ptr.remaining() << 1, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBuffer(long command_queue, long buffer, int blocking_write, long offset, IntBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write, offset, ptr.remaining() << 2, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBuffer(long command_queue, long buffer, int blocking_write, long offset, FloatBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write, offset, ptr.remaining() << 2, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteBuffer(long command_queue, long buffer, int blocking_write, long offset, DoubleBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueWriteBuffer(command_queue, buffer, blocking_write, offset, ptr.remaining() << 3, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueCopyBuffer(long var0, long var2, long var4, long var6, long var8, long var10, int var12, long var13, long var15, long var17);

    public static int nclEnqueueCopyBuffer(long command_queue, long src_buffer, long dst_buffer, long src_offset, long dst_offset, long size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10.getInstance().EnqueueCopyBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(src_buffer);
            Checks.checkPointer(dst_buffer);
        }
        return CL10.nclEnqueueCopyBuffer(command_queue, src_buffer, dst_buffer, src_offset, dst_offset, size, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueCopyBuffer(long command_queue, long src_buffer, long dst_buffer, long src_offset, long dst_offset, long size, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclEnqueueCopyBuffer(command_queue, src_buffer, dst_buffer, src_offset, dst_offset, size, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueCopyBuffer(long command_queue, long src_buffer, long dst_buffer, long src_offset, long dst_offset, long size, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueCopyBuffer(command_queue, src_buffer, dst_buffer, src_offset, dst_offset, size, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native long nclEnqueueMapBuffer(long var0, long var2, int var4, long var5, long var7, long var9, int var11, long var12, long var14, long var16, long var18);

    public static long nclEnqueueMapBuffer(long command_queue, long buffer, int blocking_map, long map_flags, long offset, long size, int num_events_in_wait_list, long event_wait_list, long event, long errcode_ret) {
        long __functionAddress = CL10.getInstance().EnqueueMapBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(buffer);
        }
        return CL10.nclEnqueueMapBuffer(command_queue, buffer, blocking_map, map_flags, offset, size, num_events_in_wait_list, event_wait_list, event, errcode_ret, __functionAddress);
    }

    public static ByteBuffer clEnqueueMapBuffer(long command_queue, long buffer, int blocking_map, long map_flags, long offset, long size, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        long __result = CL10.nclEnqueueMapBuffer(command_queue, buffer, blocking_map, map_flags, offset, size, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), MemoryUtil.memAddressSafe(errcode_ret));
        return MemoryUtil.memByteBuffer(__result, size);
    }

    public static ByteBuffer clEnqueueMapBuffer(long command_queue, long buffer, int blocking_map, long map_flags, long offset, long size, PointerBuffer event_wait_list, PointerBuffer event, IntBuffer errcode_ret, ByteBuffer old_buffer) {
        if (LWJGLUtil.CHECKS) {
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        long __result = CL10.nclEnqueueMapBuffer(command_queue, buffer, blocking_map, map_flags, offset, size, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), MemoryUtil.memAddressSafe(errcode_ret));
        return old_buffer != null && __result == MemoryUtil.memAddress0(old_buffer) && (long)old_buffer.capacity() == size ? old_buffer : MemoryUtil.memByteBuffer(__result, size);
    }

    public static native long nclCreateImage2D(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16);

    public static long nclCreateImage2D(long context, long flags, long image_format, long image_width, long image_height, long image_row_pitch, long host_ptr, long errcode_ret) {
        long __functionAddress = CL10.getInstance().CreateImage2D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL10.nclCreateImage2D(context, flags, image_format, image_width, image_height, image_row_pitch, host_ptr, errcode_ret, __functionAddress);
    }

    public static long clCreateImage2D(long context, long flags, ByteBuffer image_format, long image_width, long image_height, long image_row_pitch, ByteBuffer host_ptr, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image_format, cl_image_format.SIZEOF);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        return CL10.nclCreateImage2D(context, flags, MemoryUtil.memAddress(image_format), image_width, image_height, image_row_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateImage2D(long context, long flags, ByteBuffer image_format, long image_width, long image_height, long image_row_pitch, ByteBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image_format, cl_image_format.SIZEOF);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return CL10.nclCreateImage2D(context, flags, MemoryUtil.memAddress(image_format), image_width, image_height, image_row_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateImage2D(long context, long flags, ByteBuffer image_format, long image_width, long image_height, long image_row_pitch, ShortBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image_format, cl_image_format.SIZEOF);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return CL10.nclCreateImage2D(context, flags, MemoryUtil.memAddress(image_format), image_width, image_height, image_row_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateImage2D(long context, long flags, ByteBuffer image_format, long image_width, long image_height, long image_row_pitch, IntBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image_format, cl_image_format.SIZEOF);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return CL10.nclCreateImage2D(context, flags, MemoryUtil.memAddress(image_format), image_width, image_height, image_row_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateImage2D(long context, long flags, ByteBuffer image_format, long image_width, long image_height, long image_row_pitch, FloatBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image_format, cl_image_format.SIZEOF);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return CL10.nclCreateImage2D(context, flags, MemoryUtil.memAddress(image_format), image_width, image_height, image_row_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native long nclCreateImage3D(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20);

    public static long nclCreateImage3D(long context, long flags, long image_format, long image_width, long image_height, long image_depth, long image_row_pitch, long image_slice_pitch, long host_ptr, long errcode_ret) {
        long __functionAddress = CL10.getInstance().CreateImage3D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL10.nclCreateImage3D(context, flags, image_format, image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, host_ptr, errcode_ret, __functionAddress);
    }

    public static long clCreateImage3D(long context, long flags, ByteBuffer image_format, long image_width, long image_height, long image_depth, long image_row_pitch, long image_slice_pitch, ByteBuffer host_ptr, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image_format, cl_image_format.SIZEOF);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        return CL10.nclCreateImage3D(context, flags, MemoryUtil.memAddress(image_format), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateImage3D(long context, long flags, ByteBuffer image_format, long image_width, long image_height, long image_depth, long image_row_pitch, long image_slice_pitch, ByteBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image_format, cl_image_format.SIZEOF);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return CL10.nclCreateImage3D(context, flags, MemoryUtil.memAddress(image_format), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateImage3D(long context, long flags, ByteBuffer image_format, long image_width, long image_height, long image_depth, long image_row_pitch, long image_slice_pitch, ShortBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image_format, cl_image_format.SIZEOF);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return CL10.nclCreateImage3D(context, flags, MemoryUtil.memAddress(image_format), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateImage3D(long context, long flags, ByteBuffer image_format, long image_width, long image_height, long image_depth, long image_row_pitch, long image_slice_pitch, IntBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image_format, cl_image_format.SIZEOF);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return CL10.nclCreateImage3D(context, flags, MemoryUtil.memAddress(image_format), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateImage3D(long context, long flags, ByteBuffer image_format, long image_width, long image_height, long image_depth, long image_row_pitch, long image_slice_pitch, FloatBuffer host_ptr, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image_format, cl_image_format.SIZEOF);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return CL10.nclCreateImage3D(context, flags, MemoryUtil.memAddress(image_format), image_width, image_height, image_depth, image_row_pitch, image_slice_pitch, MemoryUtil.memAddressSafe(host_ptr), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native int nclGetSupportedImageFormats(long var0, long var2, int var4, int var5, long var6, long var8, long var10);

    public static int nclGetSupportedImageFormats(long context, long flags, int image_type, int num_entries, long image_formats, long num_image_formats) {
        long __functionAddress = CL10.getInstance().GetSupportedImageFormats;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL10.nclGetSupportedImageFormats(context, flags, image_type, num_entries, image_formats, num_image_formats, __functionAddress);
    }

    public static int clGetSupportedImageFormats(long context, long flags, int image_type, int num_entries, ByteBuffer image_formats, ByteBuffer num_image_formats) {
        if (LWJGLUtil.CHECKS) {
            if (image_formats != null) {
                Checks.checkBuffer((Buffer)image_formats, num_entries * cl_image_format.SIZEOF);
            }
            if (image_formats != null) {
                Checks.checkBuffer((Buffer)image_formats, cl_image_format.SIZEOF);
            }
            if (num_image_formats != null) {
                Checks.checkBuffer((Buffer)num_image_formats, 4);
            }
        }
        return CL10.nclGetSupportedImageFormats(context, flags, image_type, num_entries, MemoryUtil.memAddressSafe(image_formats), MemoryUtil.memAddressSafe(num_image_formats));
    }

    public static int clGetSupportedImageFormats(long context, long flags, int image_type, ByteBuffer image_formats, IntBuffer num_image_formats) {
        if (LWJGLUtil.CHECKS) {
            if (image_formats != null) {
                Checks.checkBuffer((Buffer)image_formats, cl_image_format.SIZEOF);
            }
            if (num_image_formats != null) {
                Checks.checkBuffer((Buffer)num_image_formats, 1);
            }
        }
        return CL10.nclGetSupportedImageFormats(context, flags, image_type, image_formats == null ? 0 : image_formats.remaining() / cl_image_format.SIZEOF, MemoryUtil.memAddressSafe(image_formats), MemoryUtil.memAddressSafe(num_image_formats));
    }

    public static native int nclEnqueueReadImage(long var0, long var2, int var4, long var5, long var7, long var9, long var11, long var13, int var15, long var16, long var18, long var20);

    public static int nclEnqueueReadImage(long command_queue, long image, int blocking_read, long origin, long region, long row_pitch, long slice_pitch, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10.getInstance().EnqueueReadImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(image);
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read, origin, region, row_pitch, slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueReadImage(long command_queue, long image, int blocking_read, ByteBuffer origin, ByteBuffer region, long row_pitch, long slice_pitch, ByteBuffer ptr, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)origin, 3 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)region, 3 << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), row_pitch, slice_pitch, MemoryUtil.memAddress(ptr), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadImage(long command_queue, long image, int blocking_read, PointerBuffer origin, PointerBuffer region, long row_pitch, long slice_pitch, ByteBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(origin, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), row_pitch, slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadImage(long command_queue, long image, int blocking_read, PointerBuffer origin, PointerBuffer region, long row_pitch, long slice_pitch, ShortBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(origin, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), row_pitch, slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadImage(long command_queue, long image, int blocking_read, PointerBuffer origin, PointerBuffer region, long row_pitch, long slice_pitch, IntBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(origin, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), row_pitch, slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadImage(long command_queue, long image, int blocking_read, PointerBuffer origin, PointerBuffer region, long row_pitch, long slice_pitch, FloatBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(origin, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), row_pitch, slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReadImage(long command_queue, long image, int blocking_read, PointerBuffer origin, PointerBuffer region, long row_pitch, long slice_pitch, DoubleBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(origin, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL10.nclEnqueueReadImage(command_queue, image, blocking_read, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), row_pitch, slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueWriteImage(long var0, long var2, int var4, long var5, long var7, long var9, long var11, long var13, int var15, long var16, long var18, long var20);

    public static int nclEnqueueWriteImage(long command_queue, long image, int blocking_write, long origin, long region, long input_row_pitch, long input_slice_pitch, long ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10.getInstance().EnqueueWriteImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(image);
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write, origin, region, input_row_pitch, input_slice_pitch, ptr, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueWriteImage(long command_queue, long image, int blocking_write, ByteBuffer origin, ByteBuffer region, long input_row_pitch, long input_slice_pitch, ByteBuffer ptr, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)origin, 3 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)region, 3 << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress(ptr), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteImage(long command_queue, long image, int blocking_write, PointerBuffer origin, PointerBuffer region, long input_row_pitch, long input_slice_pitch, ByteBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(origin, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteImage(long command_queue, long image, int blocking_write, PointerBuffer origin, PointerBuffer region, long input_row_pitch, long input_slice_pitch, ShortBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(origin, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteImage(long command_queue, long image, int blocking_write, PointerBuffer origin, PointerBuffer region, long input_row_pitch, long input_slice_pitch, IntBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(origin, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteImage(long command_queue, long image, int blocking_write, PointerBuffer origin, PointerBuffer region, long input_row_pitch, long input_slice_pitch, FloatBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(origin, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteImage(long command_queue, long image, int blocking_write, PointerBuffer origin, PointerBuffer region, long input_row_pitch, long input_slice_pitch, DoubleBuffer ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(origin, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL10.nclEnqueueWriteImage(command_queue, image, blocking_write, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), input_row_pitch, input_slice_pitch, MemoryUtil.memAddress(ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueCopyImage(long var0, long var2, long var4, long var6, long var8, long var10, int var12, long var13, long var15, long var17);

    public static int nclEnqueueCopyImage(long command_queue, long src_image, long dst_image, long src_origin, long dst_origin, long region, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10.getInstance().EnqueueCopyImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(src_image);
            Checks.checkPointer(dst_image);
        }
        return CL10.nclEnqueueCopyImage(command_queue, src_image, dst_image, src_origin, dst_origin, region, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueCopyImage(long command_queue, long src_image, long dst_image, ByteBuffer src_origin, ByteBuffer dst_origin, ByteBuffer region, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)src_origin, 3 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)dst_origin, 3 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)region, 3 << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclEnqueueCopyImage(command_queue, src_image, dst_image, MemoryUtil.memAddress(src_origin), MemoryUtil.memAddress(dst_origin), MemoryUtil.memAddress(region), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueCopyImage(long command_queue, long src_image, long dst_image, PointerBuffer src_origin, PointerBuffer dst_origin, PointerBuffer region, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(src_origin, 3);
            Checks.checkBuffer(dst_origin, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL10.nclEnqueueCopyImage(command_queue, src_image, dst_image, MemoryUtil.memAddress(src_origin), MemoryUtil.memAddress(dst_origin), MemoryUtil.memAddress(region), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueCopyImageToBuffer(long var0, long var2, long var4, long var6, long var8, long var10, int var12, long var13, long var15, long var17);

    public static int nclEnqueueCopyImageToBuffer(long command_queue, long src_image, long dst_buffer, long src_origin, long region, long dst_offset, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10.getInstance().EnqueueCopyImageToBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(src_image);
            Checks.checkPointer(dst_buffer);
        }
        return CL10.nclEnqueueCopyImageToBuffer(command_queue, src_image, dst_buffer, src_origin, region, dst_offset, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueCopyImageToBuffer(long command_queue, long src_image, long dst_buffer, ByteBuffer src_origin, ByteBuffer region, long dst_offset, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)src_origin, 3 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)region, 3 << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclEnqueueCopyImageToBuffer(command_queue, src_image, dst_buffer, MemoryUtil.memAddress(src_origin), MemoryUtil.memAddress(region), dst_offset, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueCopyImageToBuffer(long command_queue, long src_image, long dst_buffer, PointerBuffer src_origin, PointerBuffer region, long dst_offset, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(src_origin, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL10.nclEnqueueCopyImageToBuffer(command_queue, src_image, dst_buffer, MemoryUtil.memAddress(src_origin), MemoryUtil.memAddress(region), dst_offset, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueCopyBufferToImage(long var0, long var2, long var4, long var6, long var8, long var10, int var12, long var13, long var15, long var17);

    public static int nclEnqueueCopyBufferToImage(long command_queue, long src_buffer, long dst_image, long src_offset, long dst_origin, long region, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10.getInstance().EnqueueCopyBufferToImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(src_buffer);
            Checks.checkPointer(dst_image);
        }
        return CL10.nclEnqueueCopyBufferToImage(command_queue, src_buffer, dst_image, src_offset, dst_origin, region, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueCopyBufferToImage(long command_queue, long src_buffer, long dst_image, long src_offset, ByteBuffer dst_origin, ByteBuffer region, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)dst_origin, 3 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)region, 3 << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclEnqueueCopyBufferToImage(command_queue, src_buffer, dst_image, src_offset, MemoryUtil.memAddress(dst_origin), MemoryUtil.memAddress(region), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueCopyBufferToImage(long command_queue, long src_buffer, long dst_image, long src_offset, PointerBuffer dst_origin, PointerBuffer region, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(dst_origin, 3);
            Checks.checkBuffer(region, 3);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL10.nclEnqueueCopyBufferToImage(command_queue, src_buffer, dst_image, src_offset, MemoryUtil.memAddress(dst_origin), MemoryUtil.memAddress(region), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native long nclEnqueueMapImage(long var0, long var2, int var4, long var5, long var7, long var9, long var11, long var13, int var15, long var16, long var18, long var20, long var22);

    public static long nclEnqueueMapImage(long command_queue, long image, int blocking_map, long map_flags, long origin, long region, long image_row_pitch, long image_slice_pitch, int num_events_in_wait_list, long event_wait_list, long event, long errcode_ret) {
        long __functionAddress = CL10.getInstance().EnqueueMapImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(image);
        }
        return CL10.nclEnqueueMapImage(command_queue, image, blocking_map, map_flags, origin, region, image_row_pitch, image_slice_pitch, num_events_in_wait_list, event_wait_list, event, errcode_ret, __functionAddress);
    }

    public static ByteBuffer clEnqueueMapImage(long command_queue, long image, int blocking_map, long map_flags, ByteBuffer origin, ByteBuffer region, ByteBuffer image_row_pitch, ByteBuffer image_slice_pitch, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)origin, 3 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)region, 3 << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)image_row_pitch, 1 << Pointer.POINTER_SHIFT);
            if (image_slice_pitch != null) {
                Checks.checkBuffer((Buffer)image_slice_pitch, 1 << Pointer.POINTER_SHIFT);
            }
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        long __result = CL10.nclEnqueueMapImage(command_queue, image, blocking_map, map_flags, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), MemoryUtil.memAddress(image_row_pitch), MemoryUtil.memAddressSafe(image_slice_pitch), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), MemoryUtil.memAddressSafe(errcode_ret));
        return MemoryUtil.memByteBuffer(__result, (int)Info.clGetMemObjectInfoPointer(image, 4354));
    }

    public static ByteBuffer clEnqueueMapImage(long command_queue, long image, int blocking_map, long map_flags, PointerBuffer origin, PointerBuffer region, PointerBuffer image_row_pitch, PointerBuffer image_slice_pitch, PointerBuffer event_wait_list, PointerBuffer event, IntBuffer errcode_ret, ByteBuffer old_buffer) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(origin, 3);
            Checks.checkBuffer(region, 3);
            Checks.checkBuffer(image_row_pitch, 1);
            if (image_slice_pitch != null) {
                Checks.checkBuffer(image_slice_pitch, 1);
            }
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        long __result = CL10.nclEnqueueMapImage(command_queue, image, blocking_map, map_flags, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), MemoryUtil.memAddress(image_row_pitch), MemoryUtil.memAddressSafe(image_slice_pitch), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), MemoryUtil.memAddressSafe(errcode_ret));
        int length = (int)Info.clGetMemObjectInfoPointer(image, 4354);
        return old_buffer != null && __result == MemoryUtil.memAddress0(old_buffer) && old_buffer.capacity() == length ? old_buffer : MemoryUtil.memByteBuffer(__result, length);
    }

    public static ByteBuffer clEnqueueMapImage(long command_queue, long image, int blocking_map, long map_flags, PointerBuffer origin, PointerBuffer region, PointerBuffer image_row_pitch, PointerBuffer image_slice_pitch, PointerBuffer event_wait_list, PointerBuffer event, IntBuffer errcode_ret, int length, ByteBuffer old_buffer) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(origin, 3);
            Checks.checkBuffer(region, 3);
            Checks.checkBuffer(image_row_pitch, 1);
            if (image_slice_pitch != null) {
                Checks.checkBuffer(image_slice_pitch, 1);
            }
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        long __result = CL10.nclEnqueueMapImage(command_queue, image, blocking_map, map_flags, MemoryUtil.memAddress(origin), MemoryUtil.memAddress(region), MemoryUtil.memAddress(image_row_pitch), MemoryUtil.memAddressSafe(image_slice_pitch), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event), MemoryUtil.memAddressSafe(errcode_ret));
        return old_buffer != null && __result == MemoryUtil.memAddress0(old_buffer) && old_buffer.capacity() == length ? old_buffer : MemoryUtil.memByteBuffer(__result, length);
    }

    public static native int nclGetImageInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int nclGetImageInfo(long image, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL10.getInstance().GetImageInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(image);
        }
        return CL10.nclGetImageInfo(image, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetImageInfo(long image, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclGetImageInfo(image, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetImageInfo(long image, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetImageInfo(image, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetImageInfo(long image, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetImageInfo(image, param_name, (param_value == null ? 0 : param_value.remaining()) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetImageInfo(long image, int param_name, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetImageInfo(image, param_name, (param_value == null ? 0 : param_value.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native int nclRetainMemObject(long var0, long var2);

    public static int clRetainMemObject(long memobj) {
        long __functionAddress = CL10.getInstance().RetainMemObject;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(memobj);
        }
        return CL10.nclRetainMemObject(memobj, __functionAddress);
    }

    public static native int nclReleaseMemObject(long var0, long var2);

    public static int clReleaseMemObject(long memobj) {
        long __functionAddress = CL10.getInstance().ReleaseMemObject;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(memobj);
        }
        return CL10.nclReleaseMemObject(memobj, __functionAddress);
    }

    public static native int nclEnqueueUnmapMemObject(long var0, long var2, long var4, int var6, long var7, long var9, long var11);

    public static int nclEnqueueUnmapMemObject(long command_queue, long memobj, long mapped_ptr, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10.getInstance().EnqueueUnmapMemObject;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(memobj);
        }
        return CL10.nclEnqueueUnmapMemObject(command_queue, memobj, mapped_ptr, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueUnmapMemObject(long command_queue, long memobj, ByteBuffer mapped_ptr, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclEnqueueUnmapMemObject(command_queue, memobj, MemoryUtil.memAddress(mapped_ptr), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueUnmapMemObject(long command_queue, long memobj, ByteBuffer mapped_ptr, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueUnmapMemObject(command_queue, memobj, MemoryUtil.memAddress(mapped_ptr), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclGetMemObjectInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int nclGetMemObjectInfo(long memobj, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL10.getInstance().GetMemObjectInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(memobj);
        }
        return CL10.nclGetMemObjectInfo(memobj, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetMemObjectInfo(long memobj, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclGetMemObjectInfo(memobj, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetMemObjectInfo(long memobj, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetMemObjectInfo(memobj, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetMemObjectInfo(long memobj, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetMemObjectInfo(memobj, param_name, (param_value == null ? 0 : param_value.remaining()) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetMemObjectInfo(long memobj, int param_name, LongBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetMemObjectInfo(memobj, param_name, (param_value == null ? 0 : param_value.remaining()) << 3, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetMemObjectInfo(long memobj, int param_name, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetMemObjectInfo(memobj, param_name, (param_value == null ? 0 : param_value.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native long nclCreateSampler(long var0, int var2, int var3, int var4, long var5, long var7);

    public static long nclCreateSampler(long context, int normalized_coords, int addressing_mode, int filter_mode, long errcode_ret) {
        long __functionAddress = CL10.getInstance().CreateSampler;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL10.nclCreateSampler(context, normalized_coords, addressing_mode, filter_mode, errcode_ret, __functionAddress);
    }

    public static long clCreateSampler(long context, int normalized_coords, int addressing_mode, int filter_mode, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 4);
        }
        return CL10.nclCreateSampler(context, normalized_coords, addressing_mode, filter_mode, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateSampler(long context, int normalized_coords, int addressing_mode, int filter_mode, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateSampler(context, normalized_coords, addressing_mode, filter_mode, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native int nclRetainSampler(long var0, long var2);

    public static int clRetainSampler(long sampler) {
        long __functionAddress = CL10.getInstance().RetainSampler;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sampler);
        }
        return CL10.nclRetainSampler(sampler, __functionAddress);
    }

    public static native int nclReleaseSampler(long var0, long var2);

    public static int clReleaseSampler(long sampler) {
        long __functionAddress = CL10.getInstance().ReleaseSampler;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sampler);
        }
        return CL10.nclReleaseSampler(sampler, __functionAddress);
    }

    public static native int nclGetSamplerInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int nclGetSamplerInfo(long sampler, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL10.getInstance().GetSamplerInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sampler);
        }
        return CL10.nclGetSamplerInfo(sampler, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetSamplerInfo(long sampler, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclGetSamplerInfo(sampler, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetSamplerInfo(long sampler, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetSamplerInfo(sampler, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetSamplerInfo(long sampler, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetSamplerInfo(sampler, param_name, (param_value == null ? 0 : param_value.remaining()) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetSamplerInfo(long sampler, int param_name, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetSamplerInfo(sampler, param_name, (param_value == null ? 0 : param_value.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native long nclCreateProgramWithSource(long var0, int var2, long var3, long var5, long var7, long var9);

    public static long nclCreateProgramWithSource(long context, int count, long strings, long lengths, long errcode_ret) {
        long __functionAddress = CL10.getInstance().CreateProgramWithSource;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL10.nclCreateProgramWithSource(context, count, strings, lengths, errcode_ret, __functionAddress);
    }

    public static long clCreateProgramWithSource(long context, int count, ByteBuffer strings, ByteBuffer lengths, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)strings, count << Pointer.POINTER_SHIFT);
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count << Pointer.POINTER_SHIFT);
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        return CL10.nclCreateProgramWithSource(context, count, MemoryUtil.memAddress(strings), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateProgramWithSource(long context, PointerBuffer strings, PointerBuffer lengths, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            if (lengths != null) {
                Checks.checkBuffer(lengths, strings.remaining());
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return CL10.nclCreateProgramWithSource(context, strings.remaining(), MemoryUtil.memAddress(strings), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateProgramWithSource(long context, CharSequence[] strings, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringsLengths = __buffer.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        for (int i = 0; i < strings.length; ++i) {
            __buffer.pointerParam(stringsLengths, i, strings[i].length());
        }
        int stringsAddress = __buffer.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        ByteBuffer[] stringsBuffers = new ByteBuffer[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            stringsBuffers[i] = MemoryUtil.memEncodeUTF8(strings[i], false);
            __buffer.pointerParam(stringsAddress, i, MemoryUtil.memAddress(stringsBuffers[i]));
        }
        return CL10.nclCreateProgramWithSource(context, strings.length, __buffer.address() + (long)stringsAddress, __buffer.address() + (long)stringsLengths, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateProgramWithSource(long context, CharSequence string, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringsLengths = __buffer.pointerParam(string.length());
        ByteBuffer stringBuffers = MemoryUtil.memEncodeUTF8(string, false);
        int stringsAddress = __buffer.pointerParam(MemoryUtil.memAddress(stringBuffers));
        return CL10.nclCreateProgramWithSource(context, 1, __buffer.address() + (long)stringsAddress, __buffer.address() + (long)stringsLengths, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native long nclCreateProgramWithBinary(long var0, int var2, long var3, long var5, long var7, long var9, long var11, long var13);

    public static long nclCreateProgramWithBinary(long context, int num_devices, long device_list, long lengths, long binaries, long binary_status, long errcode_ret) {
        long __functionAddress = CL10.getInstance().CreateProgramWithBinary;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return CL10.nclCreateProgramWithBinary(context, num_devices, device_list, lengths, binaries, binary_status, errcode_ret, __functionAddress);
    }

    public static long clCreateProgramWithBinary(long context, int num_devices, ByteBuffer device_list, ByteBuffer lengths, ByteBuffer binaries, ByteBuffer binary_status, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)binaries, num_devices << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)device_list, num_devices << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)lengths, num_devices << Pointer.POINTER_SHIFT);
            if (binary_status != null) {
                Checks.checkBuffer((Buffer)binary_status, num_devices << 2);
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        return CL10.nclCreateProgramWithBinary(context, num_devices, MemoryUtil.memAddress(device_list), MemoryUtil.memAddress(lengths), MemoryUtil.memAddress(binaries), MemoryUtil.memAddressSafe(binary_status), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateProgramWithBinary(long context, PointerBuffer device_list, PointerBuffer lengths, PointerBuffer binaries, IntBuffer binary_status, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(device_list, binaries.remaining());
            Checks.checkBuffer(lengths, binaries.remaining());
            if (binary_status != null) {
                Checks.checkBuffer((Buffer)binary_status, binaries.remaining());
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        return CL10.nclCreateProgramWithBinary(context, binaries.remaining(), MemoryUtil.memAddress(device_list), MemoryUtil.memAddress(lengths), MemoryUtil.memAddress(binaries), MemoryUtil.memAddressSafe(binary_status), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateProgramWithBinary(long context, PointerBuffer device_list, ByteBuffer[] binaries, IntBuffer binary_status, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(device_list, binaries.length);
            if (binary_status != null) {
                Checks.checkBuffer((Buffer)binary_status, binaries.length);
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int binariesLengths = __buffer.bufferParam(binaries.length << Pointer.POINTER_SHIFT);
        for (int i = 0; i < binaries.length; ++i) {
            __buffer.pointerParam(binariesLengths, i, binaries[i].remaining());
        }
        int binariesAddress = __buffer.bufferParam(binaries.length << Pointer.POINTER_SHIFT);
        for (int i = 0; i < binaries.length; ++i) {
            __buffer.pointerParam(binariesAddress, i, MemoryUtil.memAddress(binaries[i]));
        }
        return CL10.nclCreateProgramWithBinary(context, binaries.length, MemoryUtil.memAddress(device_list), __buffer.address() + (long)binariesLengths, __buffer.address() + (long)binariesAddress, MemoryUtil.memAddressSafe(binary_status), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateProgramWithBinary(long context, PointerBuffer device_list, ByteBuffer binary, IntBuffer binary_status, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(device_list, 1);
            if (binary_status != null) {
                Checks.checkBuffer((Buffer)binary_status, 1);
            }
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 1);
            }
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int binariesLengths = __buffer.pointerParam(binary.remaining());
        int binariesAddress = __buffer.pointerParam(MemoryUtil.memAddress(binary));
        return CL10.nclCreateProgramWithBinary(context, 1, MemoryUtil.memAddress(device_list), __buffer.address() + (long)binariesLengths, __buffer.address() + (long)binariesAddress, MemoryUtil.memAddressSafe(binary_status), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native int nclRetainProgram(long var0, long var2);

    public static int clRetainProgram(long program) {
        long __functionAddress = CL10.getInstance().RetainProgram;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(program);
        }
        return CL10.nclRetainProgram(program, __functionAddress);
    }

    public static native int nclReleaseProgram(long var0, long var2);

    public static int clReleaseProgram(long program) {
        long __functionAddress = CL10.getInstance().ReleaseProgram;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(program);
        }
        return CL10.nclReleaseProgram(program, __functionAddress);
    }

    public static native int nclBuildProgram(long var0, int var2, long var3, long var5, long var7, long var9, long var11);

    public static int nclBuildProgram(long program, int num_devices, long device_list, long options, long pfn_notify, long user_data) {
        long __functionAddress = CL10.getInstance().BuildProgram;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(program);
        }
        return CL10.nclBuildProgram(program, num_devices, device_list, options, pfn_notify, user_data, __functionAddress);
    }

    public static int clBuildProgram(long program, int num_devices, ByteBuffer device_list, ByteBuffer options, long pfn_notify, long user_data) {
        if (LWJGLUtil.CHECKS) {
            if (device_list != null) {
                Checks.checkBuffer((Buffer)device_list, num_devices << Pointer.POINTER_SHIFT);
            }
            Checks.checkNT1(options);
        }
        return CL10.nclBuildProgram(program, num_devices, MemoryUtil.memAddressSafe(device_list), MemoryUtil.memAddress(options), pfn_notify, user_data);
    }

    public static int clBuildProgram(long program, PointerBuffer device_list, ByteBuffer options, CLProgramCallback pfn_notify) {
        long user_data = CLProgramCallback.Util.register(pfn_notify);
        int __result = CL10.nclBuildProgram(program, device_list == null ? 0 : device_list.remaining(), MemoryUtil.memAddressSafe(device_list), MemoryUtil.memAddress(options), pfn_notify == null ? 0L : CLProgramCallback.Util.CALLBACK, user_data);
        if (__result != 0 && user_data != 0L) {
            MemoryUtil.memGlobalRefDelete(user_data);
        }
        return __result;
    }

    public static int clBuildProgram(long program, PointerBuffer device_list, CharSequence options, CLProgramCallback pfn_notify) {
        ByteBuffer optionsEncoded = MemoryUtil.memEncodeASCII(options);
        long user_data = CLProgramCallback.Util.register(pfn_notify);
        int __result = CL10.nclBuildProgram(program, device_list == null ? 0 : device_list.remaining(), MemoryUtil.memAddressSafe(device_list), MemoryUtil.memAddress(optionsEncoded), pfn_notify == null ? 0L : CLProgramCallback.Util.CALLBACK, user_data);
        if (__result != 0 && user_data != 0L) {
            MemoryUtil.memGlobalRefDelete(user_data);
        }
        return __result;
    }

    public static int clBuildProgram(long program, long device, CharSequence options, CLProgramCallback pfn_notify) {
        ByteBuffer optionsEncoded = MemoryUtil.memEncodeASCII(options);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int device_list = __buffer.pointerParam(device);
        long user_data = CLProgramCallback.Util.register(pfn_notify);
        int __result = CL10.nclBuildProgram(program, 1, __buffer.address() + (long)device_list, MemoryUtil.memAddress(optionsEncoded), pfn_notify == null ? 0L : CLProgramCallback.Util.CALLBACK, user_data);
        if (__result != 0 && user_data != 0L) {
            MemoryUtil.memGlobalRefDelete(user_data);
        }
        return __result;
    }

    public static native int nclUnloadCompiler(long var0);

    public static int clUnloadCompiler() {
        long __functionAddress = CL10.getInstance().UnloadCompiler;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return CL10.nclUnloadCompiler(__functionAddress);
    }

    public static native int nclGetProgramInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int nclGetProgramInfo(long program, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL10.getInstance().GetProgramInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(program);
        }
        return CL10.nclGetProgramInfo(program, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetProgramInfo(long program, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclGetProgramInfo(program, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetProgramInfo(long program, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetProgramInfo(program, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetProgramInfo(long program, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetProgramInfo(program, param_name, (param_value == null ? 0 : param_value.remaining()) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetProgramInfo(long program, int param_name, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetProgramInfo(program, param_name, (param_value == null ? 0 : param_value.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native int nclGetProgramBuildInfo(long var0, long var2, int var4, long var5, long var7, long var9, long var11);

    public static int nclGetProgramBuildInfo(long program, long device, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL10.getInstance().GetProgramBuildInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(program);
            Checks.checkPointer(device);
        }
        return CL10.nclGetProgramBuildInfo(program, device, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetProgramBuildInfo(long program, long device, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclGetProgramBuildInfo(program, device, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetProgramBuildInfo(long program, long device, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetProgramBuildInfo(program, device, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetProgramBuildInfo(long program, long device, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetProgramBuildInfo(program, device, param_name, (param_value == null ? 0 : param_value.remaining()) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetProgramBuildInfo(long program, long device, int param_name, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetProgramBuildInfo(program, device, param_name, (param_value == null ? 0 : param_value.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native long nclCreateKernel(long var0, long var2, long var4, long var6);

    public static long nclCreateKernel(long program, long kernel_name, long errcode_ret) {
        long __functionAddress = CL10.getInstance().CreateKernel;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(program);
        }
        return CL10.nclCreateKernel(program, kernel_name, errcode_ret, __functionAddress);
    }

    public static long clCreateKernel(long program, ByteBuffer kernel_name, ByteBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(kernel_name);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        return CL10.nclCreateKernel(program, MemoryUtil.memAddress(kernel_name), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateKernel(long program, ByteBuffer kernel_name, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10.nclCreateKernel(program, MemoryUtil.memAddress(kernel_name), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateKernel(long program, CharSequence kernel_name, IntBuffer errcode_ret) {
        if (LWJGLUtil.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        ByteBuffer kernel_nameEncoded = MemoryUtil.memEncodeASCII(kernel_name);
        return CL10.nclCreateKernel(program, MemoryUtil.memAddress(kernel_nameEncoded), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static native int nclCreateKernelsInProgram(long var0, int var2, long var3, long var5, long var7);

    public static int nclCreateKernelsInProgram(long program, int num_kernels, long kernels, long num_kernels_ret) {
        long __functionAddress = CL10.getInstance().CreateKernelsInProgram;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(program);
        }
        return CL10.nclCreateKernelsInProgram(program, num_kernels, kernels, num_kernels_ret, __functionAddress);
    }

    public static int clCreateKernelsInProgram(long program, int num_kernels, ByteBuffer kernels, ByteBuffer num_kernels_ret) {
        if (LWJGLUtil.CHECKS) {
            if (kernels != null) {
                Checks.checkBuffer((Buffer)kernels, num_kernels << Pointer.POINTER_SHIFT);
            }
            if (num_kernels_ret != null) {
                Checks.checkBuffer((Buffer)num_kernels_ret, 4);
            }
        }
        return CL10.nclCreateKernelsInProgram(program, num_kernels, MemoryUtil.memAddressSafe(kernels), MemoryUtil.memAddressSafe(num_kernels_ret));
    }

    public static int clCreateKernelsInProgram(long program, PointerBuffer kernels, IntBuffer num_kernels_ret) {
        if (LWJGLUtil.CHECKS && num_kernels_ret != null) {
            Checks.checkBuffer((Buffer)num_kernels_ret, 1);
        }
        return CL10.nclCreateKernelsInProgram(program, kernels == null ? 0 : kernels.remaining(), MemoryUtil.memAddressSafe(kernels), MemoryUtil.memAddressSafe(num_kernels_ret));
    }

    public static native int nclRetainKernel(long var0, long var2);

    public static int clRetainKernel(long kernel) {
        long __functionAddress = CL10.getInstance().RetainKernel;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(kernel);
        }
        return CL10.nclRetainKernel(kernel, __functionAddress);
    }

    public static native int nclReleaseKernel(long var0, long var2);

    public static int clReleaseKernel(long kernel) {
        long __functionAddress = CL10.getInstance().ReleaseKernel;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(kernel);
        }
        return CL10.nclReleaseKernel(kernel, __functionAddress);
    }

    public static native int nclSetKernelArg(long var0, int var2, long var3, long var5, long var7);

    public static int nclSetKernelArg(long kernel, int arg_index, long arg_size, long arg_value) {
        long __functionAddress = CL10.getInstance().SetKernelArg;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(kernel);
        }
        return CL10.nclSetKernelArg(kernel, arg_index, arg_size, arg_value, __functionAddress);
    }

    public static int clSetKernelArg(long kernel, int arg_index, long arg_size, ByteBuffer arg_value) {
        if (LWJGLUtil.CHECKS && arg_value != null) {
            Checks.checkBuffer((Buffer)arg_value, arg_size);
        }
        return CL10.nclSetKernelArg(kernel, arg_index, arg_size, MemoryUtil.memAddressSafe(arg_value));
    }

    public static int clSetKernelArg(long kernel, int arg_index, long arg_size) {
        return CL10.nclSetKernelArg(kernel, arg_index, arg_size, 0L);
    }

    public static int clSetKernelArg(long kernel, int arg_index, ByteBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, arg_value.remaining(), MemoryUtil.memAddress(arg_value));
    }

    public static int clSetKernelArg(long kernel, int arg_index, ShortBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, arg_value.remaining() << 1, MemoryUtil.memAddress(arg_value));
    }

    public static int clSetKernelArg(long kernel, int arg_index, IntBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, arg_value.remaining() << 2, MemoryUtil.memAddress(arg_value));
    }

    public static int clSetKernelArg(long kernel, int arg_index, LongBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, arg_value.remaining() << 3, MemoryUtil.memAddress(arg_value));
    }

    public static int clSetKernelArg(long kernel, int arg_index, FloatBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, arg_value.remaining() << 2, MemoryUtil.memAddress(arg_value));
    }

    public static int clSetKernelArg(long kernel, int arg_index, DoubleBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, arg_value.remaining() << 3, MemoryUtil.memAddress(arg_value));
    }

    public static int clSetKernelArg(long kernel, int arg_index, PointerBuffer arg_value) {
        return CL10.nclSetKernelArg(kernel, arg_index, arg_value.remaining() << Pointer.POINTER_SHIFT, MemoryUtil.memAddress(arg_value));
    }

    public static int clSetKernelArg1b(long kernel, int arg_index, byte arg0) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.byteParam(arg0);
        return CL10.nclSetKernelArg(kernel, arg_index, 1L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg2b(long kernel, int arg_index, byte arg0, byte arg1) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.byteParam(arg0);
        __buffer.byteParam(arg1);
        return CL10.nclSetKernelArg(kernel, arg_index, 2L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg3b(long kernel, int arg_index, byte arg0, byte arg1, byte arg2) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.byteParam(arg0);
        __buffer.byteParam(arg1);
        __buffer.byteParam(arg2);
        return CL10.nclSetKernelArg(kernel, arg_index, 3L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg4b(long kernel, int arg_index, byte arg0, byte arg1, byte arg2, byte arg3) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.byteParam(arg0);
        __buffer.byteParam(arg1);
        __buffer.byteParam(arg2);
        __buffer.byteParam(arg3);
        return CL10.nclSetKernelArg(kernel, arg_index, 4L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg1s(long kernel, int arg_index, short arg0) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.shortParam(arg0);
        return CL10.nclSetKernelArg(kernel, arg_index, 2L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg2s(long kernel, int arg_index, short arg0, short arg1) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.shortParam(arg0);
        __buffer.shortParam(arg1);
        return CL10.nclSetKernelArg(kernel, arg_index, 4L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg3s(long kernel, int arg_index, short arg0, short arg1, short arg2) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.shortParam(arg0);
        __buffer.shortParam(arg1);
        __buffer.shortParam(arg2);
        return CL10.nclSetKernelArg(kernel, arg_index, 6L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg4s(long kernel, int arg_index, short arg0, short arg1, short arg2, short arg3) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.shortParam(arg0);
        __buffer.shortParam(arg1);
        __buffer.shortParam(arg2);
        __buffer.shortParam(arg3);
        return CL10.nclSetKernelArg(kernel, arg_index, 8L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg1i(long kernel, int arg_index, int arg0) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.intParam(arg0);
        return CL10.nclSetKernelArg(kernel, arg_index, 4L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg2i(long kernel, int arg_index, int arg0, int arg1) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.intParam(arg0);
        __buffer.intParam(arg1);
        return CL10.nclSetKernelArg(kernel, arg_index, 8L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg3i(long kernel, int arg_index, int arg0, int arg1, int arg2) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.intParam(arg0);
        __buffer.intParam(arg1);
        __buffer.intParam(arg2);
        return CL10.nclSetKernelArg(kernel, arg_index, 12L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg4i(long kernel, int arg_index, int arg0, int arg1, int arg2, int arg3) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.intParam(arg0);
        __buffer.intParam(arg1);
        __buffer.intParam(arg2);
        __buffer.intParam(arg3);
        return CL10.nclSetKernelArg(kernel, arg_index, 16L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg1l(long kernel, int arg_index, long arg0) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.longParam(arg0);
        return CL10.nclSetKernelArg(kernel, arg_index, 8L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg2l(long kernel, int arg_index, long arg0, long arg1) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.longParam(arg0);
        __buffer.longParam(arg1);
        return CL10.nclSetKernelArg(kernel, arg_index, 16L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg3l(long kernel, int arg_index, long arg0, long arg1, long arg2) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.longParam(arg0);
        __buffer.longParam(arg1);
        __buffer.longParam(arg2);
        return CL10.nclSetKernelArg(kernel, arg_index, 24L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg4l(long kernel, int arg_index, long arg0, long arg1, long arg2, long arg3) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.longParam(arg0);
        __buffer.longParam(arg1);
        __buffer.longParam(arg2);
        __buffer.longParam(arg3);
        return CL10.nclSetKernelArg(kernel, arg_index, 32L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg1f(long kernel, int arg_index, float arg0) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.floatParam(arg0);
        return CL10.nclSetKernelArg(kernel, arg_index, 4L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg2f(long kernel, int arg_index, float arg0, float arg1) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.floatParam(arg0);
        __buffer.floatParam(arg1);
        return CL10.nclSetKernelArg(kernel, arg_index, 8L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg3f(long kernel, int arg_index, float arg0, float arg1, float arg2) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.floatParam(arg0);
        __buffer.floatParam(arg1);
        __buffer.floatParam(arg2);
        return CL10.nclSetKernelArg(kernel, arg_index, 12L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg4f(long kernel, int arg_index, float arg0, float arg1, float arg2, float arg3) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.floatParam(arg0);
        __buffer.floatParam(arg1);
        __buffer.floatParam(arg2);
        __buffer.floatParam(arg3);
        return CL10.nclSetKernelArg(kernel, arg_index, 16L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg1d(long kernel, int arg_index, double arg0) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.doubleParam(arg0);
        return CL10.nclSetKernelArg(kernel, arg_index, 8L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg2d(long kernel, int arg_index, double arg0, double arg1) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.doubleParam(arg0);
        __buffer.doubleParam(arg1);
        return CL10.nclSetKernelArg(kernel, arg_index, 16L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg3d(long kernel, int arg_index, double arg0, double arg1, double arg2) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.doubleParam(arg0);
        __buffer.doubleParam(arg1);
        __buffer.doubleParam(arg2);
        return CL10.nclSetKernelArg(kernel, arg_index, 24L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg4d(long kernel, int arg_index, double arg0, double arg1, double arg2, double arg3) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.doubleParam(arg0);
        __buffer.doubleParam(arg1);
        __buffer.doubleParam(arg2);
        __buffer.doubleParam(arg3);
        return CL10.nclSetKernelArg(kernel, arg_index, 32L, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg1p(long kernel, int arg_index, long arg0) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.pointerParam(arg0);
        return CL10.nclSetKernelArg(kernel, arg_index, (1 << Pointer.POINTER_SHIFT) * 1, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg2p(long kernel, int arg_index, long arg0, long arg1) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.pointerParam(arg0);
        __buffer.pointerParam(arg1);
        return CL10.nclSetKernelArg(kernel, arg_index, (1 << Pointer.POINTER_SHIFT) * 2, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg3p(long kernel, int arg_index, long arg0, long arg1, long arg2) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.pointerParam(arg0);
        __buffer.pointerParam(arg1);
        __buffer.pointerParam(arg2);
        return CL10.nclSetKernelArg(kernel, arg_index, (1 << Pointer.POINTER_SHIFT) * 3, __buffer.address() + (long)arg_value);
    }

    public static int clSetKernelArg4p(long kernel, int arg_index, long arg0, long arg1, long arg2, long arg3) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int arg_value = __buffer.pointerParam(arg0);
        __buffer.pointerParam(arg1);
        __buffer.pointerParam(arg2);
        __buffer.pointerParam(arg3);
        return CL10.nclSetKernelArg(kernel, arg_index, (1 << Pointer.POINTER_SHIFT) * 4, __buffer.address() + (long)arg_value);
    }

    public static native int nclGetKernelInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int nclGetKernelInfo(long kernel, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL10.getInstance().GetKernelInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(kernel);
        }
        return CL10.nclGetKernelInfo(kernel, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetKernelInfo(long kernel, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclGetKernelInfo(kernel, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetKernelInfo(long kernel, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetKernelInfo(kernel, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetKernelInfo(long kernel, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetKernelInfo(kernel, param_name, (param_value == null ? 0 : param_value.remaining()) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetKernelInfo(long kernel, int param_name, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetKernelInfo(kernel, param_name, (param_value == null ? 0 : param_value.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native int nclGetKernelWorkGroupInfo(long var0, long var2, int var4, long var5, long var7, long var9, long var11);

    public static int nclGetKernelWorkGroupInfo(long kernel, long device, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL10.getInstance().GetKernelWorkGroupInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(kernel);
            Checks.checkPointer(device);
        }
        return CL10.nclGetKernelWorkGroupInfo(kernel, device, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetKernelWorkGroupInfo(long kernel, long device, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclGetKernelWorkGroupInfo(kernel, device, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetKernelWorkGroupInfo(long kernel, long device, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetKernelWorkGroupInfo(kernel, device, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetKernelWorkGroupInfo(long kernel, long device, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetKernelWorkGroupInfo(kernel, device, param_name, (param_value == null ? 0 : param_value.remaining()) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetKernelWorkGroupInfo(long kernel, long device, int param_name, LongBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetKernelWorkGroupInfo(kernel, device, param_name, (param_value == null ? 0 : param_value.remaining()) << 3, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetKernelWorkGroupInfo(long kernel, long device, int param_name, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetKernelWorkGroupInfo(kernel, device, param_name, (param_value == null ? 0 : param_value.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native int nclEnqueueNDRangeKernel(long var0, long var2, int var4, long var5, long var7, long var9, int var11, long var12, long var14, long var16);

    public static int nclEnqueueNDRangeKernel(long command_queue, long kernel, int work_dim, long global_work_offset, long global_work_size, long local_work_size, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10.getInstance().EnqueueNDRangeKernel;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(kernel);
        }
        return CL10.nclEnqueueNDRangeKernel(command_queue, kernel, work_dim, global_work_offset, global_work_size, local_work_size, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueNDRangeKernel(long command_queue, long kernel, int work_dim, ByteBuffer global_work_offset, ByteBuffer global_work_size, ByteBuffer local_work_size, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            if (global_work_offset != null) {
                Checks.checkBuffer((Buffer)global_work_offset, work_dim << Pointer.POINTER_SHIFT);
            }
            if (global_work_size != null) {
                Checks.checkBuffer((Buffer)global_work_size, work_dim << Pointer.POINTER_SHIFT);
            }
            if (local_work_size != null) {
                Checks.checkBuffer((Buffer)local_work_size, work_dim << Pointer.POINTER_SHIFT);
            }
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclEnqueueNDRangeKernel(command_queue, kernel, work_dim, MemoryUtil.memAddressSafe(global_work_offset), MemoryUtil.memAddressSafe(global_work_size), MemoryUtil.memAddressSafe(local_work_size), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueNDRangeKernel(long command_queue, long kernel, int work_dim, PointerBuffer global_work_offset, PointerBuffer global_work_size, PointerBuffer local_work_size, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            if (global_work_offset != null) {
                Checks.checkBuffer(global_work_offset, work_dim);
            }
            if (global_work_size != null) {
                Checks.checkBuffer(global_work_size, work_dim);
            }
            if (local_work_size != null) {
                Checks.checkBuffer(local_work_size, work_dim);
            }
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL10.nclEnqueueNDRangeKernel(command_queue, kernel, work_dim, MemoryUtil.memAddressSafe(global_work_offset), MemoryUtil.memAddressSafe(global_work_size), MemoryUtil.memAddressSafe(local_work_size), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueTask(long var0, long var2, int var4, long var5, long var7, long var9);

    public static int nclEnqueueTask(long command_queue, long kernel, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10.getInstance().EnqueueTask;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(kernel);
        }
        return CL10.nclEnqueueTask(command_queue, kernel, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueTask(long command_queue, long kernel, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclEnqueueTask(command_queue, kernel, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueTask(long command_queue, long kernel, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueTask(command_queue, kernel, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueNativeKernel(long var0, long var2, long var4, long var6, int var8, long var9, long var11, int var13, long var14, long var16, long var18);

    public static int nclEnqueueNativeKernel(long command_queue, long user_func, long args, long cb_args, int num_mem_objects, long mem_list, long args_mem_loc, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10.getInstance().EnqueueNativeKernel;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL10.nclEnqueueNativeKernel(command_queue, user_func, args, cb_args, num_mem_objects, mem_list, args_mem_loc, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueNativeKernel(long command_queue, long user_func, ByteBuffer args, long cb_args, int num_mem_objects, ByteBuffer mem_list, ByteBuffer args_mem_loc, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            if (args != null) {
                Checks.checkBuffer((Buffer)args, Pointer.POINTER_SIZE * 2);
            }
            if (args != null) {
                Checks.checkBuffer((Buffer)args, cb_args);
            }
            if (mem_list != null) {
                Checks.checkBuffer((Buffer)mem_list, num_mem_objects << Pointer.POINTER_SHIFT);
            }
            if (args_mem_loc != null) {
                Checks.checkBuffer((Buffer)args_mem_loc, num_mem_objects << Pointer.POINTER_SHIFT);
            }
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclEnqueueNativeKernel(command_queue, user_func, MemoryUtil.memAddressSafe(args), cb_args, num_mem_objects, MemoryUtil.memAddressSafe(mem_list), MemoryUtil.memAddressSafe(args_mem_loc), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueNativeKernel(long command_queue, CLNativeKernel user_func, ByteBuffer args, PointerBuffer mem_list, PointerBuffer args_mem_loc, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            if (args != null) {
                Checks.checkBuffer((Buffer)args, Pointer.POINTER_SIZE * 2);
            }
            if (args_mem_loc != null) {
                Checks.checkBuffer(args_mem_loc, mem_list.remaining());
            }
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        long user_data = CLNativeKernel.Util.register(user_func, args);
        int __result = CL10.nclEnqueueNativeKernel(command_queue, CLNativeKernel.Util.CALLBACK, MemoryUtil.memAddressSafe(args), args == null ? 0L : (long)args.remaining(), mem_list == null ? 0 : mem_list.remaining(), MemoryUtil.memAddressSafe(mem_list), MemoryUtil.memAddressSafe(args_mem_loc), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
        if (__result != 0 && user_data != 0L) {
            MemoryUtil.memGlobalRefDelete(user_data);
        }
        return __result;
    }

    public static int clEnqueueNativeKernel(long command_queue, CLNativeKernel user_func, ByteBuffer args, long memobj, long memobj_loc, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            if (args != null) {
                Checks.checkBuffer((Buffer)args, Pointer.POINTER_SIZE * 2);
            }
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int mem_list = __buffer.pointerParam(memobj);
        int args_mem_loc = __buffer.pointerParam(memobj_loc);
        long user_data = CLNativeKernel.Util.register(user_func, args);
        int __result = CL10.nclEnqueueNativeKernel(command_queue, CLNativeKernel.Util.CALLBACK, MemoryUtil.memAddressSafe(args), args == null ? 0L : (long)args.remaining(), 1, __buffer.address() + (long)mem_list, __buffer.address() + (long)args_mem_loc, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
        if (__result != 0 && user_data != 0L) {
            MemoryUtil.memGlobalRefDelete(user_data);
        }
        return __result;
    }

    public static native int nclWaitForEvents(int var0, long var1, long var3);

    public static int nclWaitForEvents(int num_events, long event_list) {
        long __functionAddress = CL10.getInstance().WaitForEvents;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return CL10.nclWaitForEvents(num_events, event_list, __functionAddress);
    }

    public static int clWaitForEvents(int num_events, ByteBuffer event_list) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)event_list, num_events << Pointer.POINTER_SHIFT);
        }
        return CL10.nclWaitForEvents(num_events, MemoryUtil.memAddress(event_list));
    }

    public static int clWaitForEvents(PointerBuffer event_list) {
        return CL10.nclWaitForEvents(event_list.remaining(), MemoryUtil.memAddress(event_list));
    }

    public static int clWaitForEvents(long event) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int event_list = __buffer.pointerParam(event);
        return CL10.nclWaitForEvents(1, __buffer.address() + (long)event_list);
    }

    public static native int nclGetEventInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int nclGetEventInfo(long event, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL10.getInstance().GetEventInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(event);
        }
        return CL10.nclGetEventInfo(event, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetEventInfo(long event, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclGetEventInfo(event, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetEventInfo(long event, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetEventInfo(event, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetEventInfo(long event, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetEventInfo(event, param_name, (param_value == null ? 0 : param_value.remaining()) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetEventInfo(long event, int param_name, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetEventInfo(event, param_name, (param_value == null ? 0 : param_value.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native int nclRetainEvent(long var0, long var2);

    public static int clRetainEvent(long event) {
        long __functionAddress = CL10.getInstance().RetainEvent;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(event);
        }
        return CL10.nclRetainEvent(event, __functionAddress);
    }

    public static native int nclReleaseEvent(long var0, long var2);

    public static int clReleaseEvent(long event) {
        long __functionAddress = CL10.getInstance().ReleaseEvent;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(event);
        }
        return CL10.nclReleaseEvent(event, __functionAddress);
    }

    public static native int nclEnqueueMarker(long var0, long var2, long var4);

    public static int nclEnqueueMarker(long command_queue, long event) {
        long __functionAddress = CL10.getInstance().EnqueueMarker;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL10.nclEnqueueMarker(command_queue, event, __functionAddress);
    }

    public static int clEnqueueMarker(long command_queue, ByteBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
        }
        return CL10.nclEnqueueMarker(command_queue, MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueMarker(long command_queue, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10.nclEnqueueMarker(command_queue, MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueBarrier(long var0, long var2);

    public static int clEnqueueBarrier(long command_queue) {
        long __functionAddress = CL10.getInstance().EnqueueBarrier;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL10.nclEnqueueBarrier(command_queue, __functionAddress);
    }

    public static native int nclEnqueueWaitForEvents(long var0, int var2, long var3, long var5);

    public static int nclEnqueueWaitForEvents(long command_queue, int num_events, long event_list) {
        long __functionAddress = CL10.getInstance().EnqueueWaitForEvents;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL10.nclEnqueueWaitForEvents(command_queue, num_events, event_list, __functionAddress);
    }

    public static int clEnqueueWaitForEvents(long command_queue, int num_events, ByteBuffer event_list) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)event_list, num_events << Pointer.POINTER_SHIFT);
        }
        return CL10.nclEnqueueWaitForEvents(command_queue, num_events, MemoryUtil.memAddress(event_list));
    }

    public static int clEnqueueWaitForEvents(long command_queue, PointerBuffer event_list) {
        return CL10.nclEnqueueWaitForEvents(command_queue, event_list.remaining(), MemoryUtil.memAddress(event_list));
    }

    public static int clEnqueueWaitForEvents(long command_queue, long event) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int event_list = __buffer.pointerParam(event);
        return CL10.nclEnqueueWaitForEvents(command_queue, 1, __buffer.address() + (long)event_list);
    }

    public static native int nclGetEventProfilingInfo(long var0, int var2, long var3, long var5, long var7, long var9);

    public static int nclGetEventProfilingInfo(long event, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL10.getInstance().GetEventProfilingInfo;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(event);
        }
        return CL10.nclGetEventProfilingInfo(event, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    public static int clGetEventProfilingInfo(long event, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10.nclGetEventProfilingInfo(event, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetEventProfilingInfo(long event, int param_name, long param_value_size, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetEventProfilingInfo(event, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetEventProfilingInfo(long event, int param_name, LongBuffer param_value, PointerBuffer param_value_size_ret) {
        if (LWJGLUtil.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10.nclGetEventProfilingInfo(event, param_name, (param_value == null ? 0 : param_value.remaining()) << 3, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static native int nclFlush(long var0, long var2);

    public static int clFlush(long command_queue) {
        long __functionAddress = CL10.getInstance().Flush;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL10.nclFlush(command_queue, __functionAddress);
    }

    public static native int nclFinish(long var0, long var2);

    public static int clFinish(long command_queue) {
        long __functionAddress = CL10.getInstance().Finish;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return CL10.nclFinish(command_queue, __functionAddress);
    }

    public static native long nclGetExtensionFunctionAddress(long var0, long var2);

    public static long nclGetExtensionFunctionAddress(long funcname) {
        long __functionAddress = CL10.getInstance().GetExtensionFunctionAddress;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return CL10.nclGetExtensionFunctionAddress(funcname, __functionAddress);
    }

    public static long clGetExtensionFunctionAddress(ByteBuffer funcname) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(funcname);
        }
        return CL10.nclGetExtensionFunctionAddress(MemoryUtil.memAddress(funcname));
    }

    public static long clGetExtensionFunctionAddress(CharSequence funcname) {
        ByteBuffer funcnameEncoded = MemoryUtil.memEncodeASCII(funcname);
        return CL10.nclGetExtensionFunctionAddress(MemoryUtil.memAddress(funcnameEncoded));
    }
}

