/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.cl_bus_address_amd;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class AMDBusAddressableMemory {
    public static final int CL_MEM_BUS_ADDRESSABLE_AMD = 0x40000000;
    public static final int CL_MEM_EXTERNAL_PHYSICAL_AMD = Integer.MIN_VALUE;
    public static final int CL_COMMAND_WAIT_SIGNAL_AMD = 16512;
    public static final int CL_COMMAND_WRITE_SIGNAL_AMD = 16513;
    public static final int CL_COMMAND_MAKE_BUFFERS_RESIDENT_AMD = 16514;
    public final long EnqueueWaitSignalAMD;
    public final long EnqueueWriteSignalAMD;
    public final long EnqueueMakeBuffersResidentAMD;

    public AMDBusAddressableMemory(FunctionProvider provider) {
        this.EnqueueWaitSignalAMD = provider.getFunctionAddress("clEnqueueWaitSignalAMD");
        this.EnqueueWriteSignalAMD = provider.getFunctionAddress("clEnqueueWriteSignalAMD");
        this.EnqueueMakeBuffersResidentAMD = provider.getFunctionAddress("clEnqueueMakeBuffersResidentAMD");
    }

    public static AMDBusAddressableMemory getInstance() {
        return CL.getICD().__AMDBusAddressableMemory;
    }

    static AMDBusAddressableMemory create(FunctionProvider provider) {
        AMDBusAddressableMemory funcs = new AMDBusAddressableMemory(provider);
        boolean supported = Checks.checkFunctions(funcs.EnqueueWaitSignalAMD, funcs.EnqueueWriteSignalAMD, funcs.EnqueueMakeBuffersResidentAMD);
        return supported ? funcs : null;
    }

    public static native int nclEnqueueWaitSignalAMD(long var0, long var2, int var4, int var5, long var6, long var8, long var10);

    public static int nclEnqueueWaitSignalAMD(long command_queue, long mem_object, int value, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = AMDBusAddressableMemory.getInstance().EnqueueWaitSignalAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(mem_object);
        }
        return AMDBusAddressableMemory.nclEnqueueWaitSignalAMD(command_queue, mem_object, value, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueWaitSignalAMD(long command_queue, long mem_object, int value, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return AMDBusAddressableMemory.nclEnqueueWaitSignalAMD(command_queue, mem_object, value, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWaitSignalAMD(long command_queue, long mem_object, int value, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return AMDBusAddressableMemory.nclEnqueueWaitSignalAMD(command_queue, mem_object, value, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueWriteSignalAMD(long var0, long var2, int var4, long var5, int var7, long var8, long var10, long var12);

    public static int nclEnqueueWriteSignalAMD(long command_queue, long mem_object, int value, long offset, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = AMDBusAddressableMemory.getInstance().EnqueueWriteSignalAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
            Checks.checkPointer(mem_object);
        }
        return AMDBusAddressableMemory.nclEnqueueWriteSignalAMD(command_queue, mem_object, value, offset, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueWriteSignalAMD(long command_queue, long mem_object, int value, long offset, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return AMDBusAddressableMemory.nclEnqueueWriteSignalAMD(command_queue, mem_object, value, offset, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteSignalAMD(long command_queue, long mem_object, int value, long offset, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return AMDBusAddressableMemory.nclEnqueueWriteSignalAMD(command_queue, mem_object, value, offset, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static native int nclEnqueueMakeBuffersResidentAMD(long var0, int var2, long var3, int var5, long var6, int var8, long var9, long var11, long var13);

    public static int nclEnqueueMakeBuffersResidentAMD(long command_queue, int num_mem_objs, long mem_objects, int blocking_make_resident, long bus_addresses, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = AMDBusAddressableMemory.getInstance().EnqueueMakeBuffersResidentAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(command_queue);
        }
        return AMDBusAddressableMemory.nclEnqueueMakeBuffersResidentAMD(command_queue, num_mem_objs, mem_objects, blocking_make_resident, bus_addresses, num_events_in_wait_list, event_wait_list, event, __functionAddress);
    }

    public static int clEnqueueMakeBuffersResidentAMD(long command_queue, int num_mem_objs, ByteBuffer mem_objects, int blocking_make_resident, ByteBuffer bus_addresses, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)mem_objects, num_mem_objs << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)bus_addresses, cl_bus_address_amd.SIZEOF);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return AMDBusAddressableMemory.nclEnqueueMakeBuffersResidentAMD(command_queue, num_mem_objs, MemoryUtil.memAddress(mem_objects), blocking_make_resident, MemoryUtil.memAddress(bus_addresses), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueMakeBuffersResidentAMD(long command_queue, PointerBuffer mem_objects, int blocking_make_resident, ByteBuffer bus_addresses, PointerBuffer event_wait_list, PointerBuffer event) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)bus_addresses, cl_bus_address_amd.SIZEOF);
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return AMDBusAddressableMemory.nclEnqueueMakeBuffersResidentAMD(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), blocking_make_resident, MemoryUtil.memAddress(bus_addresses), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }
}

