/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.openal.AL;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class AL10 {
    public static final int AL_INVALID = -1;
    public static final int AL_NONE = 0;
    public static final int AL_FALSE = 0;
    public static final int AL_TRUE = 1;
    public static final int AL_NO_ERROR = 0;
    public static final int AL_INVALID_NAME = 40961;
    public static final int AL_INVALID_ENUM = 40962;
    public static final int AL_INVALID_VALUE = 40963;
    public static final int AL_INVALID_OPERATION = 40964;
    public static final int AL_OUT_OF_MEMORY = 40965;
    public static final int AL_DOPPLER_FACTOR = 49152;
    public static final int AL_DISTANCE_MODEL = 53248;
    public static final int AL_VENDOR = 45057;
    public static final int AL_VERSION = 45058;
    public static final int AL_RENDERER = 45059;
    public static final int AL_EXTENSIONS = 45060;
    public static final int AL_INVERSE_DISTANCE = 53249;
    public static final int AL_INVERSE_DISTANCE_CLAMPED = 53250;
    public static final int AL_SOURCE_ABSOLUTE = 513;
    public static final int AL_SOURCE_RELATIVE = 514;
    public static final int AL_POSITION = 4100;
    public static final int AL_VELOCITY = 4102;
    public static final int AL_GAIN = 4106;
    public static final int AL_CONE_INNER_ANGLE = 4097;
    public static final int AL_CONE_OUTER_ANGLE = 4098;
    public static final int AL_PITCH = 4099;
    public static final int AL_DIRECTION = 4101;
    public static final int AL_LOOPING = 4103;
    public static final int AL_BUFFER = 4105;
    public static final int AL_SOURCE_STATE = 4112;
    public static final int AL_CONE_OUTER_GAIN = 4130;
    public static final int AL_SOURCE_TYPE = 4135;
    public static final int AL_INITIAL = 4113;
    public static final int AL_PLAYING = 4114;
    public static final int AL_PAUSED = 4115;
    public static final int AL_STOPPED = 4116;
    public static final int AL_ORIENTATION = 4111;
    public static final int AL_BUFFERS_QUEUED = 4117;
    public static final int AL_BUFFERS_PROCESSED = 4118;
    public static final int AL_MIN_GAIN = 4109;
    public static final int AL_MAX_GAIN = 4110;
    public static final int AL_REFERENCE_DISTANCE = 4128;
    public static final int AL_ROLLOFF_FACTOR = 4129;
    public static final int AL_MAX_DISTANCE = 4131;
    public static final int AL_FREQUENCY = 8193;
    public static final int AL_BITS = 8194;
    public static final int AL_CHANNELS = 8195;
    public static final int AL_SIZE = 8196;
    public static final int AL_FORMAT_MONO8 = 4352;
    public static final int AL_FORMAT_MONO16 = 4353;
    public static final int AL_FORMAT_STEREO8 = 4354;
    public static final int AL_FORMAT_STEREO16 = 4355;
    public static final int AL_UNUSED = 8208;
    public static final int AL_PENDING = 8209;
    public static final int AL_PROCESSED = 8210;
    public final long GetError;
    public final long Enable;
    public final long Disable;
    public final long IsEnabled;
    public final long GetBoolean;
    public final long GetInteger;
    public final long GetFloat;
    public final long GetDouble;
    public final long GetBooleanv;
    public final long GetIntegerv;
    public final long GetFloatv;
    public final long GetDoublev;
    public final long GetString;
    public final long DistanceModel;
    public final long DopplerFactor;
    public final long DopplerVelocity;
    public final long Listenerf;
    public final long Listeneri;
    public final long Listener3f;
    public final long Listenerfv;
    public final long GetListenerf;
    public final long GetListeneri;
    public final long GetListener3f;
    public final long GetListenerfv;
    public final long GenSources;
    public final long DeleteSources;
    public final long IsSource;
    public final long Sourcef;
    public final long Source3f;
    public final long Sourcefv;
    public final long Sourcei;
    public final long GetSourcef;
    public final long GetSource3f;
    public final long GetSourcefv;
    public final long GetSourcei;
    public final long SourceQueueBuffers;
    public final long SourceUnqueueBuffers;
    public final long SourcePlay;
    public final long SourcePause;
    public final long SourceStop;
    public final long SourceRewind;
    public final long SourcePlayv;
    public final long SourcePausev;
    public final long SourceStopv;
    public final long SourceRewindv;
    public final long GenBuffers;
    public final long DeleteBuffers;
    public final long IsBuffer;
    public final long GetBufferf;
    public final long GetBufferi;
    public final long BufferData;
    public final long GetEnumValue;
    public final long GetProcAddress;
    public final long IsExtensionPresent;

    public AL10(FunctionProvider provider) {
        this.GetError = provider.getFunctionAddress("alGetError");
        this.Enable = provider.getFunctionAddress("alEnable");
        this.Disable = provider.getFunctionAddress("alDisable");
        this.IsEnabled = provider.getFunctionAddress("alIsEnabled");
        this.GetBoolean = provider.getFunctionAddress("alGetBoolean");
        this.GetInteger = provider.getFunctionAddress("alGetInteger");
        this.GetFloat = provider.getFunctionAddress("alGetFloat");
        this.GetDouble = provider.getFunctionAddress("alGetDouble");
        this.GetBooleanv = provider.getFunctionAddress("alGetBooleanv");
        this.GetIntegerv = provider.getFunctionAddress("alGetIntegerv");
        this.GetFloatv = provider.getFunctionAddress("alGetFloatv");
        this.GetDoublev = provider.getFunctionAddress("alGetDoublev");
        this.GetString = provider.getFunctionAddress("alGetString");
        this.DistanceModel = provider.getFunctionAddress("alDistanceModel");
        this.DopplerFactor = provider.getFunctionAddress("alDopplerFactor");
        this.DopplerVelocity = provider.getFunctionAddress("alDopplerVelocity");
        this.Listenerf = provider.getFunctionAddress("alListenerf");
        this.Listeneri = provider.getFunctionAddress("alListeneri");
        this.Listener3f = provider.getFunctionAddress("alListener3f");
        this.Listenerfv = provider.getFunctionAddress("alListenerfv");
        this.GetListenerf = provider.getFunctionAddress("alGetListenerf");
        this.GetListeneri = provider.getFunctionAddress("alGetListeneri");
        this.GetListener3f = provider.getFunctionAddress("alGetListener3f");
        this.GetListenerfv = provider.getFunctionAddress("alGetListenerfv");
        this.GenSources = provider.getFunctionAddress("alGenSources");
        this.DeleteSources = provider.getFunctionAddress("alDeleteSources");
        this.IsSource = provider.getFunctionAddress("alIsSource");
        this.Sourcef = provider.getFunctionAddress("alSourcef");
        this.Source3f = provider.getFunctionAddress("alSource3f");
        this.Sourcefv = provider.getFunctionAddress("alSourcefv");
        this.Sourcei = provider.getFunctionAddress("alSourcei");
        this.GetSourcef = provider.getFunctionAddress("alGetSourcef");
        this.GetSource3f = provider.getFunctionAddress("alGetSource3f");
        this.GetSourcefv = provider.getFunctionAddress("alGetSourcefv");
        this.GetSourcei = provider.getFunctionAddress("alGetSourcei");
        this.SourceQueueBuffers = provider.getFunctionAddress("alSourceQueueBuffers");
        this.SourceUnqueueBuffers = provider.getFunctionAddress("alSourceUnqueueBuffers");
        this.SourcePlay = provider.getFunctionAddress("alSourcePlay");
        this.SourcePause = provider.getFunctionAddress("alSourcePause");
        this.SourceStop = provider.getFunctionAddress("alSourceStop");
        this.SourceRewind = provider.getFunctionAddress("alSourceRewind");
        this.SourcePlayv = provider.getFunctionAddress("alSourcePlayv");
        this.SourcePausev = provider.getFunctionAddress("alSourcePausev");
        this.SourceStopv = provider.getFunctionAddress("alSourceStopv");
        this.SourceRewindv = provider.getFunctionAddress("alSourceRewindv");
        this.GenBuffers = provider.getFunctionAddress("alGenBuffers");
        this.DeleteBuffers = provider.getFunctionAddress("alDeleteBuffers");
        this.IsBuffer = provider.getFunctionAddress("alIsBuffer");
        this.GetBufferf = provider.getFunctionAddress("alGetBufferf");
        this.GetBufferi = provider.getFunctionAddress("alGetBufferi");
        this.BufferData = provider.getFunctionAddress("alBufferData");
        this.GetEnumValue = provider.getFunctionAddress("alGetEnumValue");
        this.GetProcAddress = provider.getFunctionAddress("alGetProcAddress");
        this.IsExtensionPresent = provider.getFunctionAddress("alIsExtensionPresent");
    }

    public static AL10 getInstance() {
        return AL.getCapabilities().__AL10;
    }

    static AL10 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("OpenAL10")) {
            return null;
        }
        AL10 funcs = new AL10(provider);
        boolean supported = Checks.checkFunctions(funcs.GetError, funcs.Enable, funcs.Disable, funcs.IsEnabled, funcs.GetBoolean, funcs.GetInteger, funcs.GetFloat, funcs.GetDouble, funcs.GetBooleanv, funcs.GetIntegerv, funcs.GetFloatv, funcs.GetDoublev, funcs.GetString, funcs.DistanceModel, funcs.DopplerFactor, funcs.DopplerVelocity, funcs.Listenerf, funcs.Listeneri, funcs.Listener3f, funcs.Listenerfv, funcs.GetListenerf, funcs.GetListeneri, funcs.GetListener3f, funcs.GetListenerfv, funcs.GenSources, funcs.DeleteSources, funcs.IsSource, funcs.Sourcef, funcs.Source3f, funcs.Sourcefv, funcs.Sourcei, funcs.GetSourcef, funcs.GetSource3f, funcs.GetSourcefv, funcs.GetSourcei, funcs.SourceQueueBuffers, funcs.SourceUnqueueBuffers, funcs.SourcePlay, funcs.SourcePause, funcs.SourceStop, funcs.SourceRewind, funcs.SourcePlayv, funcs.SourcePausev, funcs.SourceStopv, funcs.SourceRewindv, funcs.GenBuffers, funcs.DeleteBuffers, funcs.IsBuffer, funcs.GetBufferf, funcs.GetBufferi, funcs.BufferData, funcs.GetEnumValue, funcs.GetProcAddress, funcs.IsExtensionPresent);
        return AL.checkExtension("OpenAL10", funcs, supported);
    }

    public static native int nalGetError(long var0);

    public static int alGetError() {
        long __functionAddress = AL10.getInstance().GetError;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return AL10.nalGetError(__functionAddress);
    }

    public static native void nalEnable(int var0, long var1);

    public static void alEnable(int target) {
        long __functionAddress = AL10.getInstance().Enable;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalEnable(target, __functionAddress);
    }

    public static native void nalDisable(int var0, long var1);

    public static void alDisable(int target) {
        long __functionAddress = AL10.getInstance().Disable;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalDisable(target, __functionAddress);
    }

    public static native boolean nalIsEnabled(int var0, long var1);

    public static boolean alIsEnabled(int target) {
        long __functionAddress = AL10.getInstance().IsEnabled;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return AL10.nalIsEnabled(target, __functionAddress);
    }

    public static native boolean nalGetBoolean(int var0, long var1);

    public static boolean alGetBoolean(int paramName) {
        long __functionAddress = AL10.getInstance().GetBoolean;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return AL10.nalGetBoolean(paramName, __functionAddress);
    }

    public static native int nalGetInteger(int var0, long var1);

    public static int alGetInteger(int paramName) {
        long __functionAddress = AL10.getInstance().GetInteger;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return AL10.nalGetInteger(paramName, __functionAddress);
    }

    public static native float nalGetFloat(int var0, long var1);

    public static float alGetFloat(int paramName) {
        long __functionAddress = AL10.getInstance().GetFloat;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return AL10.nalGetFloat(paramName, __functionAddress);
    }

    public static native double nalGetDouble(int var0, long var1);

    public static double alGetDouble(int paramName) {
        long __functionAddress = AL10.getInstance().GetDouble;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return AL10.nalGetDouble(paramName, __functionAddress);
    }

    public static native void nalGetBooleanv(int var0, long var1, long var3);

    public static void nalGetBooleanv(int paramName, long dest) {
        long __functionAddress = AL10.getInstance().GetBooleanv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGetBooleanv(paramName, dest, __functionAddress);
    }

    public static void alGetBoolean(int paramName, ByteBuffer dest) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)dest, 1);
        }
        AL10.nalGetBooleanv(paramName, MemoryUtil.memAddress(dest));
    }

    public static native void nalGetIntegerv(int var0, long var1, long var3);

    public static void nalGetIntegerv(int paramName, long dest) {
        long __functionAddress = AL10.getInstance().GetIntegerv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGetIntegerv(paramName, dest, __functionAddress);
    }

    public static void alGetInteger(int paramName, ByteBuffer dest) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)dest, 4);
        }
        AL10.nalGetIntegerv(paramName, MemoryUtil.memAddress(dest));
    }

    public static void alGetInteger(int paramName, IntBuffer dest) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)dest, 1);
        }
        AL10.nalGetIntegerv(paramName, MemoryUtil.memAddress(dest));
    }

    public static native void nalGetFloatv(int var0, long var1, long var3);

    public static void nalGetFloatv(int paramName, long dest) {
        long __functionAddress = AL10.getInstance().GetFloatv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGetFloatv(paramName, dest, __functionAddress);
    }

    public static void alGetFloat(int paramName, ByteBuffer dest) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)dest, 4);
        }
        AL10.nalGetFloatv(paramName, MemoryUtil.memAddress(dest));
    }

    public static void alGetFloat(int paramName, FloatBuffer dest) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)dest, 1);
        }
        AL10.nalGetFloatv(paramName, MemoryUtil.memAddress(dest));
    }

    public static native void nalGetDoublev(int var0, long var1, long var3);

    public static void nalGetDoublev(int paramName, long dest) {
        long __functionAddress = AL10.getInstance().GetDoublev;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGetDoublev(paramName, dest, __functionAddress);
    }

    public static void alGetDouble(int paramName, ByteBuffer dest) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)dest, 8);
        }
        AL10.nalGetDoublev(paramName, MemoryUtil.memAddress(dest));
    }

    public static void alGetDouble(int paramName, DoubleBuffer dest) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)dest, 1);
        }
        AL10.nalGetDoublev(paramName, MemoryUtil.memAddress(dest));
    }

    public static native long nalGetString(int var0, long var1);

    public static long nalGetString(int paramName) {
        long __functionAddress = AL10.getInstance().GetString;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return AL10.nalGetString(paramName, __functionAddress);
    }

    public static String alGetString(int paramName) {
        long __result = AL10.nalGetString(paramName);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native void nalDistanceModel(int var0, long var1);

    public static void alDistanceModel(int modelName) {
        long __functionAddress = AL10.getInstance().DistanceModel;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalDistanceModel(modelName, __functionAddress);
    }

    public static native void nalDopplerFactor(float var0, long var1);

    public static void alDopplerFactor(float dopplerFactor) {
        long __functionAddress = AL10.getInstance().DopplerFactor;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalDopplerFactor(dopplerFactor, __functionAddress);
    }

    public static native void nalDopplerVelocity(float var0, long var1);

    public static void alDopplerVelocity(float dopplerVelocity) {
        long __functionAddress = AL10.getInstance().DopplerVelocity;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalDopplerVelocity(dopplerVelocity, __functionAddress);
    }

    public static native void nalListenerf(int var0, float var1, long var2);

    public static void alListenerf(int paramName, float value) {
        long __functionAddress = AL10.getInstance().Listenerf;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalListenerf(paramName, value, __functionAddress);
    }

    public static native void nalListeneri(int var0, int var1, long var2);

    public static void alListeneri(int paramName, int values) {
        long __functionAddress = AL10.getInstance().Listeneri;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalListeneri(paramName, values, __functionAddress);
    }

    public static native void nalListener3f(int var0, float var1, float var2, float var3, long var4);

    public static void alListener3f(int paramName, float value1, float value2, float value3) {
        long __functionAddress = AL10.getInstance().Listener3f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalListener3f(paramName, value1, value2, value3, __functionAddress);
    }

    public static native void nalListenerfv(int var0, long var1, long var3);

    public static void nalListenerfv(int paramName, long values) {
        long __functionAddress = AL10.getInstance().Listenerfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalListenerfv(paramName, values, __functionAddress);
    }

    public static void alListenerf(int paramName, ByteBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        AL10.nalListenerfv(paramName, MemoryUtil.memAddress(values));
    }

    public static void alListener(int paramName, FloatBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        AL10.nalListenerfv(paramName, MemoryUtil.memAddress(values));
    }

    public static native void nalGetListenerf(int var0, long var1, long var3);

    public static void nalGetListenerf(int paramName, long value) {
        long __functionAddress = AL10.getInstance().GetListenerf;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGetListenerf(paramName, value, __functionAddress);
    }

    public static void alGetListenerf(int paramName, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        AL10.nalGetListenerf(paramName, MemoryUtil.memAddress(value));
    }

    public static void alGetListener(int paramName, FloatBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        AL10.nalGetListenerf(paramName, MemoryUtil.memAddress(value));
    }

    public static float alGetListenerf(int paramName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.floatParam();
        AL10.nalGetListenerf(paramName, __buffer.address() + (long)value);
        return __buffer.floatValue(value);
    }

    public static native void nalGetListeneri(int var0, long var1, long var3);

    public static void nalGetListeneri(int paramName, long value) {
        long __functionAddress = AL10.getInstance().GetListeneri;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGetListeneri(paramName, value, __functionAddress);
    }

    public static void alGetListeneri(int paramName, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        AL10.nalGetListeneri(paramName, MemoryUtil.memAddress(value));
    }

    public static void alGetListener(int paramName, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        AL10.nalGetListeneri(paramName, MemoryUtil.memAddress(value));
    }

    public static int alGetListeneri(int paramName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.intParam();
        AL10.nalGetListeneri(paramName, __buffer.address() + (long)value);
        return __buffer.intValue(value);
    }

    public static native void nalGetListener3f(int var0, long var1, long var3, long var5, long var7);

    public static void nalGetListener3f(int paramName, long value1, long value2, long value3) {
        long __functionAddress = AL10.getInstance().GetListener3f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGetListener3f(paramName, value1, value2, value3, __functionAddress);
    }

    public static void alGetListener3f(int paramName, ByteBuffer value1, ByteBuffer value2, ByteBuffer value3) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value1, 4);
            Checks.checkBuffer((Buffer)value2, 4);
            Checks.checkBuffer((Buffer)value3, 4);
        }
        AL10.nalGetListener3f(paramName, MemoryUtil.memAddress(value1), MemoryUtil.memAddress(value2), MemoryUtil.memAddress(value3));
    }

    public static void alGetListener3(int paramName, FloatBuffer value1, FloatBuffer value2, FloatBuffer value3) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value1, 1);
            Checks.checkBuffer((Buffer)value2, 1);
            Checks.checkBuffer((Buffer)value3, 1);
        }
        AL10.nalGetListener3f(paramName, MemoryUtil.memAddress(value1), MemoryUtil.memAddress(value2), MemoryUtil.memAddress(value3));
    }

    public static native void nalGetListenerfv(int var0, long var1, long var3);

    public static void nalGetListenerfv(int paramName, long values) {
        long __functionAddress = AL10.getInstance().GetListenerfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGetListenerfv(paramName, values, __functionAddress);
    }

    public static void alGetListenerfv(int paramName, ByteBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        AL10.nalGetListenerfv(paramName, MemoryUtil.memAddress(values));
    }

    public static void alGetListenerfv(int paramName, FloatBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        AL10.nalGetListenerfv(paramName, MemoryUtil.memAddress(values));
    }

    public static native void nalGenSources(int var0, long var1, long var3);

    public static void nalGenSources(int n, long srcNames) {
        long __functionAddress = AL10.getInstance().GenSources;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGenSources(n, srcNames, __functionAddress);
    }

    public static void alGenSources(int n, ByteBuffer srcNames) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)srcNames, n << 2);
        }
        AL10.nalGenSources(n, MemoryUtil.memAddress(srcNames));
    }

    public static void alGenSources(IntBuffer srcNames) {
        AL10.nalGenSources(srcNames.remaining(), MemoryUtil.memAddress(srcNames));
    }

    public static int alGenSources() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int srcNames = __buffer.intParam();
        AL10.nalGenSources(1, __buffer.address() + (long)srcNames);
        return __buffer.intValue(srcNames);
    }

    public static native void nalDeleteSources(int var0, long var1, long var3);

    public static void nalDeleteSources(int n, long sources) {
        long __functionAddress = AL10.getInstance().DeleteSources;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalDeleteSources(n, sources, __functionAddress);
    }

    public static void alDeleteSources(int n, ByteBuffer sources) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)sources, n << 2);
        }
        AL10.nalDeleteSources(n, MemoryUtil.memAddress(sources));
    }

    public static void alDeleteSources(IntBuffer sources) {
        AL10.nalDeleteSources(sources.remaining(), MemoryUtil.memAddress(sources));
    }

    public static void alDeleteSources(int source) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int sources = __buffer.intParam(source);
        AL10.nalDeleteSources(1, __buffer.address() + (long)sources);
    }

    public static native boolean nalIsSource(int var0, long var1);

    public static boolean alIsSource(int sourceName) {
        long __functionAddress = AL10.getInstance().IsSource;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return AL10.nalIsSource(sourceName, __functionAddress);
    }

    public static native void nalSourcef(int var0, int var1, float var2, long var3);

    public static void alSourcef(int source, int param, float value) {
        long __functionAddress = AL10.getInstance().Sourcef;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalSourcef(source, param, value, __functionAddress);
    }

    public static native void nalSource3f(int var0, int var1, float var2, float var3, float var4, long var5);

    public static void alSource3f(int source, int param, float v1, float v2, float v3) {
        long __functionAddress = AL10.getInstance().Source3f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalSource3f(source, param, v1, v2, v3, __functionAddress);
    }

    public static native void nalSourcefv(int var0, int var1, long var2, long var4);

    public static void nalSourcefv(int source, int param, long values) {
        long __functionAddress = AL10.getInstance().Sourcefv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalSourcefv(source, param, values, __functionAddress);
    }

    public static void alSourcef(int source, int param, ByteBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        AL10.nalSourcefv(source, param, MemoryUtil.memAddress(values));
    }

    public static void alSource(int source, int param, FloatBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        AL10.nalSourcefv(source, param, MemoryUtil.memAddress(values));
    }

    public static native void nalSourcei(int var0, int var1, int var2, long var3);

    public static void alSourcei(int source, int param, int value) {
        long __functionAddress = AL10.getInstance().Sourcei;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalSourcei(source, param, value, __functionAddress);
    }

    public static native void nalGetSourcef(int var0, int var1, long var2, long var4);

    public static void nalGetSourcef(int source, int param, long value) {
        long __functionAddress = AL10.getInstance().GetSourcef;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGetSourcef(source, param, value, __functionAddress);
    }

    public static void alGetSourcef(int source, int param, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        AL10.nalGetSourcef(source, param, MemoryUtil.memAddress(value));
    }

    public static void alGetSource(int source, int param, FloatBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        AL10.nalGetSourcef(source, param, MemoryUtil.memAddress(value));
    }

    public static float alGetSourcef(int source, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.floatParam();
        AL10.nalGetSourcef(source, param, __buffer.address() + (long)value);
        return __buffer.floatValue(value);
    }

    public static native void nalGetSource3f(int var0, int var1, long var2, long var4, long var6, long var8);

    public static void nalGetSource3f(int source, int param, long v1, long v2, long v3) {
        long __functionAddress = AL10.getInstance().GetSource3f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGetSource3f(source, param, v1, v2, v3, __functionAddress);
    }

    public static void alGetSource3f(int source, int param, ByteBuffer v1, ByteBuffer v2, ByteBuffer v3) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v1, 4);
            Checks.checkBuffer((Buffer)v2, 4);
            Checks.checkBuffer((Buffer)v3, 4);
        }
        AL10.nalGetSource3f(source, param, MemoryUtil.memAddress(v1), MemoryUtil.memAddress(v2), MemoryUtil.memAddress(v3));
    }

    public static void alGetSource3(int source, int param, FloatBuffer v1, FloatBuffer v2, FloatBuffer v3) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v1, 1);
            Checks.checkBuffer((Buffer)v2, 1);
            Checks.checkBuffer((Buffer)v3, 1);
        }
        AL10.nalGetSource3f(source, param, MemoryUtil.memAddress(v1), MemoryUtil.memAddress(v2), MemoryUtil.memAddress(v3));
    }

    public static native void nalGetSourcefv(int var0, int var1, long var2, long var4);

    public static void nalGetSourcefv(int source, int param, long values) {
        long __functionAddress = AL10.getInstance().GetSourcefv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGetSourcefv(source, param, values, __functionAddress);
    }

    public static void alGetSourcefv(int source, int param, ByteBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        AL10.nalGetSourcefv(source, param, MemoryUtil.memAddress(values));
    }

    public static void alGetSourcefv(int source, int param, FloatBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        AL10.nalGetSourcefv(source, param, MemoryUtil.memAddress(values));
    }

    public static native void nalGetSourcei(int var0, int var1, long var2, long var4);

    public static void nalGetSourcei(int source, int param, long value) {
        long __functionAddress = AL10.getInstance().GetSourcei;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGetSourcei(source, param, value, __functionAddress);
    }

    public static void alGetSourcei(int source, int param, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        AL10.nalGetSourcei(source, param, MemoryUtil.memAddress(value));
    }

    public static void alGetSource(int source, int param, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        AL10.nalGetSourcei(source, param, MemoryUtil.memAddress(value));
    }

    public static int alGetSourcei(int source, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.intParam();
        AL10.nalGetSourcei(source, param, __buffer.address() + (long)value);
        return __buffer.intValue(value);
    }

    public static native void nalSourceQueueBuffers(int var0, int var1, long var2, long var4);

    public static void nalSourceQueueBuffers(int sourceName, int numBuffers, long bufferNames) {
        long __functionAddress = AL10.getInstance().SourceQueueBuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalSourceQueueBuffers(sourceName, numBuffers, bufferNames, __functionAddress);
    }

    public static void alSourceQueueBuffers(int sourceName, int numBuffers, ByteBuffer bufferNames) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)bufferNames, numBuffers << 2);
        }
        AL10.nalSourceQueueBuffers(sourceName, numBuffers, MemoryUtil.memAddress(bufferNames));
    }

    public static void alSourceQueueBuffers(int sourceName, IntBuffer bufferNames) {
        AL10.nalSourceQueueBuffers(sourceName, bufferNames.remaining(), MemoryUtil.memAddress(bufferNames));
    }

    public static void alSourceQueueBuffers(int sourceName, int bufferName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int bufferNames = __buffer.intParam(bufferName);
        AL10.nalSourceQueueBuffers(sourceName, 1, __buffer.address() + (long)bufferNames);
    }

    public static native void nalSourceUnqueueBuffers(int var0, int var1, long var2, long var4);

    public static void nalSourceUnqueueBuffers(int sourceName, int numEntries, long bufferNames) {
        long __functionAddress = AL10.getInstance().SourceUnqueueBuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalSourceUnqueueBuffers(sourceName, numEntries, bufferNames, __functionAddress);
    }

    public static void alSourceUnqueueBuffers(int sourceName, int numEntries, ByteBuffer bufferNames) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)bufferNames, numEntries << 2);
        }
        AL10.nalSourceUnqueueBuffers(sourceName, numEntries, MemoryUtil.memAddress(bufferNames));
    }

    public static void alSourceUnqueueBuffers(int sourceName, IntBuffer bufferNames) {
        AL10.nalSourceUnqueueBuffers(sourceName, bufferNames.remaining(), MemoryUtil.memAddress(bufferNames));
    }

    public static int alSourceUnqueueBuffers(int sourceName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int bufferNames = __buffer.intParam();
        AL10.nalSourceUnqueueBuffers(sourceName, 1, __buffer.address() + (long)bufferNames);
        return __buffer.intValue(bufferNames);
    }

    public static native void nalSourcePlay(int var0, long var1);

    public static void alSourcePlay(int source) {
        long __functionAddress = AL10.getInstance().SourcePlay;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalSourcePlay(source, __functionAddress);
    }

    public static native void nalSourcePause(int var0, long var1);

    public static void alSourcePause(int source) {
        long __functionAddress = AL10.getInstance().SourcePause;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalSourcePause(source, __functionAddress);
    }

    public static native void nalSourceStop(int var0, long var1);

    public static void alSourceStop(int source) {
        long __functionAddress = AL10.getInstance().SourceStop;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalSourceStop(source, __functionAddress);
    }

    public static native void nalSourceRewind(int var0, long var1);

    public static void alSourceRewind(int source) {
        long __functionAddress = AL10.getInstance().SourceRewind;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalSourceRewind(source, __functionAddress);
    }

    public static native void nalSourcePlayv(int var0, long var1, long var3);

    public static void nalSourcePlayv(int n, long sources) {
        long __functionAddress = AL10.getInstance().SourcePlayv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalSourcePlayv(n, sources, __functionAddress);
    }

    public static void alSourcePlay(int n, ByteBuffer sources) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)sources, n << 2);
        }
        AL10.nalSourcePlayv(n, MemoryUtil.memAddress(sources));
    }

    public static void alSourcePlay(IntBuffer sources) {
        AL10.nalSourcePlayv(sources.remaining(), MemoryUtil.memAddress(sources));
    }

    public static native void nalSourcePausev(int var0, long var1, long var3);

    public static void nalSourcePausev(int n, long sources) {
        long __functionAddress = AL10.getInstance().SourcePausev;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalSourcePausev(n, sources, __functionAddress);
    }

    public static void alSourcePause(int n, ByteBuffer sources) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)sources, n << 2);
        }
        AL10.nalSourcePausev(n, MemoryUtil.memAddress(sources));
    }

    public static void alSourcePause(IntBuffer sources) {
        AL10.nalSourcePausev(sources.remaining(), MemoryUtil.memAddress(sources));
    }

    public static native void nalSourceStopv(int var0, long var1, long var3);

    public static void nalSourceStopv(int n, long sources) {
        long __functionAddress = AL10.getInstance().SourceStopv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalSourceStopv(n, sources, __functionAddress);
    }

    public static void alSourceStop(int n, ByteBuffer sources) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)sources, n << 2);
        }
        AL10.nalSourceStopv(n, MemoryUtil.memAddress(sources));
    }

    public static void alSourceStop(IntBuffer sources) {
        AL10.nalSourceStopv(sources.remaining(), MemoryUtil.memAddress(sources));
    }

    public static native void nalSourceRewindv(int var0, long var1, long var3);

    public static void nalSourceRewindv(int n, long sources) {
        long __functionAddress = AL10.getInstance().SourceRewindv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalSourceRewindv(n, sources, __functionAddress);
    }

    public static void alSourceRewind(int n, ByteBuffer sources) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)sources, n << 2);
        }
        AL10.nalSourceRewindv(n, MemoryUtil.memAddress(sources));
    }

    public static void alSourceRewind(IntBuffer sources) {
        AL10.nalSourceRewindv(sources.remaining(), MemoryUtil.memAddress(sources));
    }

    public static native void nalGenBuffers(int var0, long var1, long var3);

    public static void nalGenBuffers(int n, long bufferNames) {
        long __functionAddress = AL10.getInstance().GenBuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGenBuffers(n, bufferNames, __functionAddress);
    }

    public static void alGenBuffers(int n, ByteBuffer bufferNames) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)bufferNames, n << 2);
        }
        AL10.nalGenBuffers(n, MemoryUtil.memAddress(bufferNames));
    }

    public static void alGenBuffers(IntBuffer bufferNames) {
        AL10.nalGenBuffers(bufferNames.remaining(), MemoryUtil.memAddress(bufferNames));
    }

    public static int alGenBuffers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int bufferNames = __buffer.intParam();
        AL10.nalGenBuffers(1, __buffer.address() + (long)bufferNames);
        return __buffer.intValue(bufferNames);
    }

    public static native void nalDeleteBuffers(int var0, long var1, long var3);

    public static void nalDeleteBuffers(int n, long bufferNames) {
        long __functionAddress = AL10.getInstance().DeleteBuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalDeleteBuffers(n, bufferNames, __functionAddress);
    }

    public static void alDeleteBuffers(int n, ByteBuffer bufferNames) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)bufferNames, n << 2);
        }
        AL10.nalDeleteBuffers(n, MemoryUtil.memAddress(bufferNames));
    }

    public static void alDeleteBuffers(IntBuffer bufferNames) {
        AL10.nalDeleteBuffers(bufferNames.remaining(), MemoryUtil.memAddress(bufferNames));
    }

    public static void alDeleteBuffers(int bufferName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int bufferNames = __buffer.intParam(bufferName);
        AL10.nalDeleteBuffers(1, __buffer.address() + (long)bufferNames);
    }

    public static native boolean nalIsBuffer(int var0, long var1);

    public static boolean alIsBuffer(int bufferName) {
        long __functionAddress = AL10.getInstance().IsBuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return AL10.nalIsBuffer(bufferName, __functionAddress);
    }

    public static native void nalGetBufferf(int var0, int var1, long var2, long var4);

    public static void nalGetBufferf(int bufferName, int paramName, long value) {
        long __functionAddress = AL10.getInstance().GetBufferf;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGetBufferf(bufferName, paramName, value, __functionAddress);
    }

    public static void alGetBufferf(int bufferName, int paramName, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        AL10.nalGetBufferf(bufferName, paramName, MemoryUtil.memAddress(value));
    }

    public static void alGetBuffer(int bufferName, int paramName, FloatBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        AL10.nalGetBufferf(bufferName, paramName, MemoryUtil.memAddress(value));
    }

    public static float alGetBufferf(int bufferName, int paramName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.floatParam();
        AL10.nalGetBufferf(bufferName, paramName, __buffer.address() + (long)value);
        return __buffer.floatValue(value);
    }

    public static native void nalGetBufferi(int var0, int var1, long var2, long var4);

    public static void nalGetBufferi(int bufferName, int paramName, long value) {
        long __functionAddress = AL10.getInstance().GetBufferi;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalGetBufferi(bufferName, paramName, value, __functionAddress);
    }

    public static void alGetBufferi(int bufferName, int paramName, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        AL10.nalGetBufferi(bufferName, paramName, MemoryUtil.memAddress(value));
    }

    public static void alGetBuffer(int bufferName, int paramName, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        AL10.nalGetBufferi(bufferName, paramName, MemoryUtil.memAddress(value));
    }

    public static int alGetBufferi(int bufferName, int paramName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.intParam();
        AL10.nalGetBufferi(bufferName, paramName, __buffer.address() + (long)value);
        return __buffer.intValue(value);
    }

    public static native void nalBufferData(int var0, int var1, long var2, int var4, int var5, long var6);

    public static void nalBufferData(int bufferName, int format, long data, int size, int frequency) {
        long __functionAddress = AL10.getInstance().BufferData;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        AL10.nalBufferData(bufferName, format, data, size, frequency, __functionAddress);
    }

    public static void alBufferData(int bufferName, int format, ByteBuffer data, int size, int frequency) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, size);
        }
        AL10.nalBufferData(bufferName, format, MemoryUtil.memAddress(data), size, frequency);
    }

    public static void alBufferData(int bufferName, int format, ByteBuffer data, int frequency) {
        AL10.nalBufferData(bufferName, format, MemoryUtil.memAddress(data), data.remaining(), frequency);
    }

    public static void alBufferData(int bufferName, int format, ShortBuffer data, int frequency) {
        AL10.nalBufferData(bufferName, format, MemoryUtil.memAddress(data), data.remaining() << 1, frequency);
    }

    public static void alBufferData(int bufferName, int format, IntBuffer data, int frequency) {
        AL10.nalBufferData(bufferName, format, MemoryUtil.memAddress(data), data.remaining() << 2, frequency);
    }

    public static native int nalGetEnumValue(long var0, long var2);

    public static int nalGetEnumValue(long enumName) {
        long __functionAddress = AL10.getInstance().GetEnumValue;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return AL10.nalGetEnumValue(enumName, __functionAddress);
    }

    public static int alGetEnumValue(ByteBuffer enumName) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(enumName);
        }
        return AL10.nalGetEnumValue(MemoryUtil.memAddress(enumName));
    }

    public static int alGetEnumValue(CharSequence enumName) {
        ByteBuffer enumNameEncoded = MemoryUtil.memEncodeASCII(enumName);
        return AL10.nalGetEnumValue(MemoryUtil.memAddress(enumNameEncoded));
    }

    public static native long nalGetProcAddress(long var0, long var2);

    public static long nalGetProcAddress(long funcName) {
        long __functionAddress = AL10.getInstance().GetProcAddress;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return AL10.nalGetProcAddress(funcName, __functionAddress);
    }

    public static long alGetProcAddress(ByteBuffer funcName) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(funcName);
        }
        return AL10.nalGetProcAddress(MemoryUtil.memAddress(funcName));
    }

    public static long alGetProcAddress(CharSequence funcName) {
        ByteBuffer funcNameEncoded = MemoryUtil.memEncodeASCII(funcName);
        return AL10.nalGetProcAddress(MemoryUtil.memAddress(funcNameEncoded));
    }

    public static native boolean nalIsExtensionPresent(long var0, long var2);

    public static boolean nalIsExtensionPresent(long extName) {
        long __functionAddress = AL10.getInstance().IsExtensionPresent;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return AL10.nalIsExtensionPresent(extName, __functionAddress);
    }

    public static boolean alIsExtensionPresent(ByteBuffer extName) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(extName);
        }
        return AL10.nalIsExtensionPresent(MemoryUtil.memAddress(extName));
    }

    public static boolean alIsExtensionPresent(CharSequence extName) {
        ByteBuffer extNameEncoded = MemoryUtil.memEncodeASCII(extName);
        return AL10.nalIsExtensionPresent(MemoryUtil.memAddress(extNameEncoded));
    }
}

