/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.EventListenerList;
import org.apache.batik.apps.svgbrowser.DOMViewerController;
import org.apache.batik.apps.svgbrowser.UndoableCommand;

public class HistoryBrowser {
    public static final int EXECUTING = 1;
    public static final int UNDOING = 2;
    public static final int REDOING = 3;
    public static final int IDLE = 4;
    protected EventListenerList eventListeners = new EventListenerList();
    protected ArrayList history = new ArrayList();
    protected int currentCommandIndex = -1;
    protected int historySize = 1000;
    protected int state = 4;
    protected CommandController commandController;
    static /* synthetic */ Class class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener;

    public HistoryBrowser(CommandController commandController) {
        this.commandController = commandController;
    }

    public HistoryBrowser(int historySize) {
        this.setHistorySize(historySize);
    }

    protected void setHistorySize(int size) {
        this.historySize = size;
    }

    public void setCommandController(CommandController newCommandController) {
        this.commandController = newCommandController;
    }

    public void addCommand(UndoableCommand command) {
        int n = this.history.size();
        int i = n - 1;
        while (i > this.currentCommandIndex) {
            this.history.remove(i);
            --i;
        }
        if (this.commandController != null) {
            this.commandController.execute(command);
        } else {
            this.state = 1;
            command.execute();
            this.state = 4;
        }
        this.history.add(command);
        this.currentCommandIndex = this.history.size() - 1;
        if (this.currentCommandIndex >= this.historySize) {
            this.history.remove(0);
            --this.currentCommandIndex;
        }
        this.fireExecutePerformed(new HistoryBrowserEvent(new CommandNamesInfo(command.getName(), this.getLastUndoableCommandName(), this.getLastRedoableCommandName())));
    }

    public void undo() {
        if (this.history.isEmpty() || this.currentCommandIndex < 0) {
            return;
        }
        UndoableCommand command = (UndoableCommand)this.history.get(this.currentCommandIndex);
        if (this.commandController != null) {
            this.commandController.undo(command);
        } else {
            this.state = 2;
            command.undo();
            this.state = 4;
        }
        --this.currentCommandIndex;
        this.fireUndoPerformed(new HistoryBrowserEvent(new CommandNamesInfo(command.getName(), this.getLastUndoableCommandName(), this.getLastRedoableCommandName())));
    }

    public void redo() {
        if (this.history.isEmpty() || this.currentCommandIndex == this.history.size() - 1) {
            return;
        }
        UndoableCommand command = (UndoableCommand)this.history.get(++this.currentCommandIndex);
        if (this.commandController != null) {
            this.commandController.redo(command);
        } else {
            this.state = 3;
            command.redo();
            this.state = 4;
        }
        this.fireRedoPerformed(new HistoryBrowserEvent(new CommandNamesInfo(command.getName(), this.getLastUndoableCommandName(), this.getLastRedoableCommandName())));
    }

    public void compoundUndo(int undoNumber) {
        int i = 0;
        while (i < undoNumber) {
            this.undo();
            ++i;
        }
    }

    public void compoundRedo(int redoNumber) {
        int i = 0;
        while (i < redoNumber) {
            this.redo();
            ++i;
        }
    }

    public String getLastUndoableCommandName() {
        if (this.history.isEmpty() || this.currentCommandIndex < 0) {
            return "";
        }
        return ((UndoableCommand)this.history.get(this.currentCommandIndex)).getName();
    }

    public String getLastRedoableCommandName() {
        if (this.history.isEmpty() || this.currentCommandIndex == this.history.size() - 1) {
            return "";
        }
        return ((UndoableCommand)this.history.get(this.currentCommandIndex + 1)).getName();
    }

    public void resetHistory() {
        this.history.clear();
        this.currentCommandIndex = -1;
        this.fireHistoryReset(new HistoryBrowserEvent(new Object()));
    }

    public int getState() {
        if (this.commandController != null) {
            return this.commandController.getState();
        }
        return this.state;
    }

    public void addListener(HistoryBrowserListener listener) {
        this.eventListeners.add(class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener == null ? (class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener = HistoryBrowser.class$("org.apache.batik.apps.svgbrowser.HistoryBrowser$HistoryBrowserListener")) : class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener, listener);
    }

    public void fireExecutePerformed(HistoryBrowserEvent event) {
        Object[] listeners = this.eventListeners.getListenerList();
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            if (listeners[i] == (class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener == null ? HistoryBrowser.class$("org.apache.batik.apps.svgbrowser.HistoryBrowser$HistoryBrowserListener") : class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener)) {
                ((HistoryBrowserListener)listeners[i + 1]).executePerformed(event);
            }
            i += 2;
        }
    }

    public void fireUndoPerformed(HistoryBrowserEvent event) {
        Object[] listeners = this.eventListeners.getListenerList();
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            if (listeners[i] == (class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener == null ? HistoryBrowser.class$("org.apache.batik.apps.svgbrowser.HistoryBrowser$HistoryBrowserListener") : class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener)) {
                ((HistoryBrowserListener)listeners[i + 1]).undoPerformed(event);
            }
            i += 2;
        }
    }

    public void fireRedoPerformed(HistoryBrowserEvent event) {
        Object[] listeners = this.eventListeners.getListenerList();
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            if (listeners[i] == (class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener == null ? HistoryBrowser.class$("org.apache.batik.apps.svgbrowser.HistoryBrowser$HistoryBrowserListener") : class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener)) {
                ((HistoryBrowserListener)listeners[i + 1]).redoPerformed(event);
            }
            i += 2;
        }
    }

    public void fireHistoryReset(HistoryBrowserEvent event) {
        Object[] listeners = this.eventListeners.getListenerList();
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            if (listeners[i] == (class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener == null ? HistoryBrowser.class$("org.apache.batik.apps.svgbrowser.HistoryBrowser$HistoryBrowserListener") : class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener)) {
                ((HistoryBrowserListener)listeners[i + 1]).historyReset(event);
            }
            i += 2;
        }
    }

    public void fireDoCompoundEdit(HistoryBrowserEvent event) {
        Object[] listeners = this.eventListeners.getListenerList();
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            if (listeners[i] == (class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener == null ? HistoryBrowser.class$("org.apache.batik.apps.svgbrowser.HistoryBrowser$HistoryBrowserListener") : class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener)) {
                ((HistoryBrowserListener)listeners[i + 1]).doCompoundEdit(event);
            }
            i += 2;
        }
    }

    public void fireCompoundEditPerformed(HistoryBrowserEvent event) {
        Object[] listeners = this.eventListeners.getListenerList();
        int length = listeners.length;
        int i = 0;
        while (i < length) {
            if (listeners[i] == (class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener == null ? HistoryBrowser.class$("org.apache.batik.apps.svgbrowser.HistoryBrowser$HistoryBrowserListener") : class$org$apache$batik$apps$svgbrowser$HistoryBrowser$HistoryBrowserListener)) {
                ((HistoryBrowserListener)listeners[i + 1]).compoundEditPerformed(event);
            }
            i += 2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DocumentCommandController
    implements CommandController {
        protected DOMViewerController controller;
        protected int state = 4;

        public DocumentCommandController(DOMViewerController controller) {
            this.controller = controller;
        }

        public void execute(UndoableCommand command) {
            Runnable r = new Runnable(this, command){
                private final /* synthetic */ UndoableCommand val$command;
                private final /* synthetic */ DocumentCommandController this$0;
                {
                    this.this$0 = this$0;
                    this.val$command = val$command;
                }

                public void run() {
                    this.this$0.state = 1;
                    this.val$command.execute();
                    this.this$0.state = 4;
                }
            };
            this.controller.performUpdate(r);
        }

        public void undo(UndoableCommand command) {
            Runnable r = new Runnable(this, command){
                private final /* synthetic */ UndoableCommand val$command;
                private final /* synthetic */ DocumentCommandController this$0;
                {
                    this.this$0 = this$0;
                    this.val$command = val$command;
                }

                public void run() {
                    this.this$0.state = 2;
                    this.val$command.undo();
                    this.this$0.state = 4;
                }
            };
            this.controller.performUpdate(r);
        }

        public void redo(UndoableCommand command) {
            Runnable r = new Runnable(this, command){
                private final /* synthetic */ UndoableCommand val$command;
                private final /* synthetic */ DocumentCommandController this$0;
                {
                    this.this$0 = this$0;
                    this.val$command = val$command;
                }

                public void run() {
                    this.this$0.state = 3;
                    this.val$command.redo();
                    this.this$0.state = 4;
                }
            };
            this.controller.performUpdate(r);
        }

        public int getState() {
            return this.state;
        }
    }

    public static interface CommandController {
        public void execute(UndoableCommand var1);

        public void undo(UndoableCommand var1);

        public void redo(UndoableCommand var1);

        public int getState();
    }

    public static class CommandNamesInfo {
        private String lastUndoableCommandName;
        private String lastRedoableCommandName;
        private String commandName;

        public CommandNamesInfo(String commandName, String lastUndoableCommandName, String lastRedoableCommandName) {
            this.lastUndoableCommandName = lastUndoableCommandName;
            this.lastRedoableCommandName = lastRedoableCommandName;
            this.commandName = commandName;
        }

        public String getLastRedoableCommandName() {
            return this.lastRedoableCommandName;
        }

        public String getLastUndoableCommandName() {
            return this.lastUndoableCommandName;
        }

        public String getCommandName() {
            return this.commandName;
        }
    }

    public static class HistoryBrowserAdapter
    implements HistoryBrowserListener {
        public void executePerformed(HistoryBrowserEvent event) {
        }

        public void undoPerformed(HistoryBrowserEvent event) {
        }

        public void redoPerformed(HistoryBrowserEvent event) {
        }

        public void historyReset(HistoryBrowserEvent event) {
        }

        public void compoundEditPerformed(HistoryBrowserEvent event) {
        }

        public void doCompoundEdit(HistoryBrowserEvent event) {
        }
    }

    public static interface HistoryBrowserListener
    extends EventListener {
        public void executePerformed(HistoryBrowserEvent var1);

        public void undoPerformed(HistoryBrowserEvent var1);

        public void redoPerformed(HistoryBrowserEvent var1);

        public void historyReset(HistoryBrowserEvent var1);

        public void doCompoundEdit(HistoryBrowserEvent var1);

        public void compoundEditPerformed(HistoryBrowserEvent var1);
    }

    public static class HistoryBrowserEvent
    extends EventObject {
        public HistoryBrowserEvent(Object source) {
            super(source);
        }
    }
}

