package renderer;

import format.SVG;
import format.svg.SVGData;
import format.svg.SVGRenderer;
import openfl.Assets;
import openfl.display.Bitmap;
import openfl.display.BitmapData;
import openfl.display.Shape;

/**
 * ...
 * @author Linus Jakobsson
 */
class VectorAsset
{
	public static function create (image: String, w: Float, h: Float, colour: Int = 0xFFFFFF): bitmapData {
		var data: SVG = new SVG (Assets.getText(image));
		var img = rasterizeSVG (data, Std.int(w), Std.int(h), colour);

		return img;
	}

	private function rasterizeSVG (svg: SVG, width: Int, height: Int, colour: Int = null): BitmapData {
		var shape = new Shape ();
		var bitmapData = new BitmapData (width, height, true, colour);

		svg.render (shape.graphics, 0, 0, width, height);
		bitmapData.draw (shape);

		return bitmapData;
	}
}
