/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.zipio;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kellinwood.logging.LoggerInterface;
import kellinwood.logging.LoggerManager;
import kellinwood.zipio.CentralEnd;
import kellinwood.zipio.ZioEntry;
import kellinwood.zipio.ZipListingHelper;

public class ZipInput {
    static LoggerInterface log;
    public String inputFilename;
    RandomAccessFile in = null;
    long fileLength;
    int scanIterations = 0;
    Map<String, ZioEntry> zioEntries = new LinkedHashMap<String, ZioEntry>();
    CentralEnd centralEnd;
    Manifest manifest;

    public ZipInput(String filename) throws IOException {
        this.inputFilename = filename;
        this.in = new RandomAccessFile(new File(this.inputFilename), "r");
        this.fileLength = this.in.length();
    }

    private static LoggerInterface getLogger() {
        if (log == null) {
            log = LoggerManager.getLogger(ZipInput.class.getName());
        }
        return log;
    }

    public String getFilename() {
        return this.inputFilename;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public static ZipInput read(String filename) throws IOException {
        ZipInput zipInput = new ZipInput(filename);
        zipInput.doRead();
        return zipInput;
    }

    public ZioEntry getEntry(String filename) {
        return this.zioEntries.get(filename);
    }

    public Map<String, ZioEntry> getEntries() {
        return this.zioEntries;
    }

    public Collection<String> list(String path) {
        if (!path.endsWith("/")) {
            throw new IllegalArgumentException("Invalid path -- does not end with '/'");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        Pattern p = Pattern.compile(String.format("^%s([^/]+/?).*", path));
        TreeSet<String> names = new TreeSet<String>();
        for (String name : this.zioEntries.keySet()) {
            Matcher m = p.matcher(name);
            if (!m.matches()) continue;
            names.add(m.group(1));
        }
        return names;
    }

    public Manifest getManifest() throws IOException {
        ZioEntry e;
        if (this.manifest == null && (e = this.zioEntries.get("META-INF/MANIFEST.MF")) != null) {
            this.manifest = new Manifest(e.getInputStream());
        }
        return this.manifest;
    }

    public long scanForEOCDR(int size) throws IOException {
        if ((long)size > this.fileLength || size > 65536) {
            throw new IllegalStateException("End of central directory not found in " + this.inputFilename);
        }
        int scanSize = (int)Math.min(this.fileLength, (long)size);
        byte[] scanBuf = new byte[scanSize];
        this.in.seek(this.fileLength - (long)scanSize);
        this.in.readFully(scanBuf);
        for (int i = scanSize - 22; i >= 0; --i) {
            ++this.scanIterations;
            if (scanBuf[i] != 80 || scanBuf[i + 1] != 75 || scanBuf[i + 2] != 5 || scanBuf[i + 3] != 6) continue;
            return this.fileLength - (long)scanSize + (long)i;
        }
        return this.scanForEOCDR(size * 2);
    }

    private void doRead() {
        try {
            long posEOCDR = this.scanForEOCDR(256);
            this.in.seek(posEOCDR);
            this.centralEnd = CentralEnd.read(this);
            boolean debug = ZipInput.getLogger().isDebugEnabled();
            if (debug) {
                ZipInput.getLogger().debug(String.format("EOCD found in %d iterations", this.scanIterations));
                ZipInput.getLogger().debug(String.format("Directory entries=%d, size=%d, offset=%d/0x%08x", this.centralEnd.totalCentralEntries, this.centralEnd.centralDirectorySize, this.centralEnd.centralStartOffset, this.centralEnd.centralStartOffset));
                ZipListingHelper.listHeader(ZipInput.getLogger());
            }
            this.in.seek(this.centralEnd.centralStartOffset);
            for (int i = 0; i < this.centralEnd.totalCentralEntries; ++i) {
                ZioEntry entry = ZioEntry.read(this);
                this.zioEntries.put(entry.getName(), entry);
                if (!debug) continue;
                ZipListingHelper.listEntry(ZipInput.getLogger(), entry);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public long getFilePointer() throws IOException {
        return this.in.getFilePointer();
    }

    public void seek(long position) throws IOException {
        this.in.seek(position);
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public int readInt() throws IOException {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result |= this.in.readUnsignedByte() << 8 * i;
        }
        return result;
    }

    public short readShort() throws IOException {
        short result = 0;
        for (int i = 0; i < 2; ++i) {
            result = (short)(result | this.in.readUnsignedByte() << 8 * i);
        }
        return result;
    }

    public String readString(int length) throws IOException {
        byte[] buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = this.in.readByte();
        }
        return new String(buffer);
    }

    public byte[] readBytes(int length) throws IOException {
        byte[] buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = this.in.readByte();
        }
        return buffer;
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        return this.in.read(b, offset, length);
    }
}

