/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.zipio;

import java.io.IOException;
import kellinwood.logging.LoggerInterface;
import kellinwood.logging.LoggerManager;
import kellinwood.zipio.ZipInput;
import kellinwood.zipio.ZipOutput;

public class CentralEnd {
    public int signature = 101010256;
    public short numberThisDisk = 0;
    public short centralStartDisk = 0;
    public short numCentralEntries;
    public short totalCentralEntries;
    public int centralDirectorySize;
    public int centralStartOffset;
    public String fileComment;
    private static LoggerInterface log;

    public static CentralEnd read(ZipInput input) throws IOException {
        int signature = input.readInt();
        if (signature != 101010256) {
            input.seek(input.getFilePointer() - 4L);
            return null;
        }
        CentralEnd entry = new CentralEnd();
        entry.doRead(input);
        return entry;
    }

    public static LoggerInterface getLogger() {
        if (log == null) {
            log = LoggerManager.getLogger(CentralEnd.class.getName());
        }
        return log;
    }

    private void doRead(ZipInput input) throws IOException {
        boolean debug = CentralEnd.getLogger().isDebugEnabled();
        this.numberThisDisk = input.readShort();
        if (debug) {
            log.debug(String.format("This disk number: 0x%04x", this.numberThisDisk));
        }
        this.centralStartDisk = input.readShort();
        if (debug) {
            log.debug(String.format("Central dir start disk number: 0x%04x", this.centralStartDisk));
        }
        this.numCentralEntries = input.readShort();
        if (debug) {
            log.debug(String.format("Central entries on this disk: 0x%04x", this.numCentralEntries));
        }
        this.totalCentralEntries = input.readShort();
        if (debug) {
            log.debug(String.format("Total number of central entries: 0x%04x", this.totalCentralEntries));
        }
        this.centralDirectorySize = input.readInt();
        if (debug) {
            log.debug(String.format("Central directory size: 0x%08x", this.centralDirectorySize));
        }
        this.centralStartOffset = input.readInt();
        if (debug) {
            log.debug(String.format("Central directory offset: 0x%08x", this.centralStartOffset));
        }
        short zipFileCommentLen = input.readShort();
        this.fileComment = input.readString(zipFileCommentLen);
        if (debug) {
            log.debug(".ZIP file comment: " + this.fileComment);
        }
    }

    public void write(ZipOutput output) throws IOException {
        boolean debug = CentralEnd.getLogger().isDebugEnabled();
        output.writeInt(this.signature);
        output.writeShort(this.numberThisDisk);
        output.writeShort(this.centralStartDisk);
        output.writeShort(this.numCentralEntries);
        output.writeShort(this.totalCentralEntries);
        output.writeInt(this.centralDirectorySize);
        output.writeInt(this.centralStartOffset);
        output.writeShort((short)this.fileComment.length());
        output.writeString(this.fileComment);
    }
}

