/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.security.zipsigner.optional;

import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import kellinwood.security.zipsigner.ZipSigner;
import kellinwood.security.zipsigner.optional.KeyStoreFileManager;

public class CustomKeySigner {
    public static void signZip(ZipSigner zipSigner, String keystorePath, char[] keystorePw, String certAlias, char[] certPw, String signatureAlgorithm, String inputZipFilename, String outputZipFilename) throws Exception {
        zipSigner.issueLoadingCertAndKeysProgressEvent();
        KeyStore keystore = KeyStoreFileManager.loadKeyStore(keystorePath, keystorePw);
        Certificate cert = keystore.getCertificate(certAlias);
        X509Certificate publicKey = (X509Certificate)cert;
        Key key = keystore.getKey(certAlias, certPw);
        PrivateKey privateKey = (PrivateKey)key;
        zipSigner.setKeys("custom", publicKey, privateKey, signatureAlgorithm, null);
        zipSigner.signZip(inputZipFilename, outputZipFilename);
    }
}

