/*
 * Decompiled with CFR 0.152.
 */
package kellinwood.security.zipsigner;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class ZipSignature {
    byte[] beforeAlgorithmIdBytes = new byte[]{48, 33};
    byte[] algorithmIdBytes = new byte[]{48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0};
    byte[] afterAlgorithmIdBytes = new byte[]{4, 20};
    Cipher cipher;
    MessageDigest md = MessageDigest.getInstance("SHA1");

    public ZipSignature() throws IOException, GeneralSecurityException {
        this.cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
    }

    public void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.cipher.init(1, privateKey);
    }

    public void update(byte[] data) {
        this.md.update(data);
    }

    public void update(byte[] data, int offset, int count) {
        this.md.update(data, offset, count);
    }

    public byte[] sign() throws BadPaddingException, IllegalBlockSizeException {
        this.cipher.update(this.beforeAlgorithmIdBytes);
        this.cipher.update(this.algorithmIdBytes);
        this.cipher.update(this.afterAlgorithmIdBytes);
        this.cipher.update(this.md.digest());
        return this.cipher.doFinal();
    }
}

