#!/bin/bash

PROJECT_PATH="ExampleApp/ExampleApp.xcodeproj"
INFO_PLIST_PATH="Source/Common/Info.plist"

echo "Go to https://your_company.ujet.co/settings/developer-setting and grab key and secret"
echo "Enter app identifier (leave empty to skip): "
read app_id

if [ -z "$app_id" ]; then
    echo `xcodebuild -project $PROJECT_PATH -showBuildSettings | grep PRODUCT_BUNDLE_IDENTIFIER`
else
    sed -i '' -e "/\.CobrowseExtension;$/ s/PRODUCT_BUNDLE_IDENTIFIER = [^;]*;/PRODUCT_BUNDLE_IDENTIFIER = $app_id.CobrowseExtension;/ ; \
    /\.CobrowseExtension;$/! s/PRODUCT_BUNDLE_IDENTIFIER = [^;]*;/PRODUCT_BUNDLE_IDENTIFIER = $app_id;/" "$PROJECT_PATH/project.pbxproj"
    plutil -replace CBIOBroadcastExtension -string $app_id.CobrowseExtension $INFO_PLIST_PATH
fi

while true; do
    echo Enter company key:
    read key

    if [ ! -z "$key" ]; then
        plutil -replace UJETCompanyKey -string $key $INFO_PLIST_PATH
        break
    fi
done

while true; do
    echo Enter company secret:
    read secret

    if [ ! -z "$secret" ]; then
        plutil -replace UJETCompanySecret -string $secret $INFO_PLIST_PATH
        break
    fi
done

while true; do
    echo Enter subdomain:
    read subdomain

    if [ ! -z "$subdomain" ]; then
        plutil -replace UJETSubdomain -string $subdomain $INFO_PLIST_PATH
        break
    fi
done
