require 'sinatra'
require 'sinatra/cross_origin'
require 'json'
require 'jwt'
require 'date'

set :bind, '0.0.0.0'

UJET_COMPANY_SECRET = "bdf0e649847004f8f1e6e29ef9878507ce9382a6020e72e7d40070e5abdb12d3"

configure do
  enable :cross_origin
end

options "*" do
  response.headers["Allow"] = "HEAD,GET,PUT,POST,DELETE,OPTIONS"
  response.headers["Access-Control-Allow-Origin"] = "*"
  response.headers["Access-Control-Allow-Headers"] = "X-Requested-With, X-HTTP-Method-Override, Content-Type, Cache-Control, Accept"
  200
end

post '/api/ujet/sign' do
  # Do user authentication

  content_type :json

  # sign payload with UJET_COMPANY_SECRET
  body = JSON.parse(request.env["rack.input"].read)

  payload = body["payload"]
  payload["identifier"] = "test@email.com"  # required, user identifier
  payload["name"] = "user name"             # optional
  payload["email"] = "test@email.com"       # optional
  payload["phone"] = ""                     # optional
  payload["iss"] = "YOUR_COMPANY_NAME"      # optional
  payload["iat"] = Time.now                 # required
  payload["exp"] = Time.now.to_i + 600000   # required, valid for only 10 minutes from now.

  token = JWT.encode(payload, UJET_COMPANY_SECRET)

  # return signed JWT
  {token: token}.to_json
end

post '/api/ujet/sign/custom_data' do
  content_type :json

  body = JSON.parse(request.env["rack.input"].read)

  custom_data = body["custom_data"]
  custom_data["string_value"] = {"value"=>"asdf", "type"=>"string", "label"=>"String information"}
  custom_data["number_value"] = {"value"=>1234, "type"=>"number", "label"=>"Number information"}
  custom_data["date_value"] = {"value"=>DateTime.now.strftime('%Q').to_i, "type"=>"date", "label"=>"Date information"}
  custom_data["url_value"] = {"value"=>"https://google.com", "type"=>"url", "label"=>"URL information"}

  payload = {"custom_data" => custom_data}
  payload["iat"] = Time.now.to_i                 # creation time, required
  payload["exp"] = Time.now.to_i + 10*60         # expiration time, required

  token = JWT.encode(payload, UJET_COMPANY_SECRET)

  # return signed JWT
  {jwt: token}.to_json
end
