//
//  ViewController.swift
//  ExampleApp
//
//  Copyright © UJET. All rights reserved.
//

import UIKit
import CoreBluetooth
import CoreLocation
#if UJET_INTEGRATED
import UJETKit
#endif

class ViewController: UITableViewController {
    
    let dataSource = ViewDataSource()
    
    public private(set) lazy var locationManager: CLLocationManager = {
        let lm = CLLocationManager()
        lm.delegate = self
        return lm
    }()
    
    private var bluetoothManager: CBCentralManager?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        tableView.dataSource = dataSource
    }
    
    #if UJET_INTEGRATED
    func launchUjet() {
        let options = UJETStartOptions()
        options.skipSplashScreen = true
        UJET.start(with: options)
    }
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        
        switch indexPath.section {
        case 0:
            switch indexPath.row {
            case 0: locationManager.requestWhenInUseAuthorization()
            case 1: bluetoothManager = CBCentralManager(delegate: self, queue: nil)
            default: break
            }
        case 1:
            (UIApplication.shared.delegate as? AppDelegate)?.ujetDelegate.initCustomData()
            launchUjet()
        case 2:
            UJET.clearUserData()
        default: break
        }
    }
    #endif
}

extension ViewController: CLLocationManagerDelegate {
    func locationManager(_ manager: CLLocationManager, didChangeAuthorization status: CLAuthorizationStatus) {
        tableView.reloadRows(at: [IndexPath(row: 0, section: 0)], with: .none)
    }
}

extension ViewController: CBCentralManagerDelegate {
    func centralManagerDidUpdateState(_ central: CBCentralManager) {
        tableView.reloadRows(at: [IndexPath(row: 1, section: 0)], with: .none)
    }
}
