//
//  ViewDataSource.swift
//  ExampleApp
//
//  Created by miles on 3/13/20.
//

import UIKit
import CoreBluetooth
import CoreLocation

class ViewDataSource: NSObject, UITableViewDataSource {
    let sections = [
        SectionViewModel(title: "Grant Permissions",
                         description: "Granted permission will be used an example of Custom Data. See \"Custom Data\" section of document for the detail.",
                         rows: [
                            RowViewModel(title: "Allow Location",
                                         accessoryType: { CLLocationManager.authorizationStatus() == .authorizedWhenInUse ? .checkmark : .none },
                                         isEnabled: { CLLocationManager.authorizationStatus() == .notDetermined }),
                            RowViewModel(title: "Allow Bluetooth",
                                         accessoryType: {
                                            if #available(iOS 13.0, *) {
                                                return CBCentralManager().authorization == .allowedAlways ? .checkmark : .none
                                            } else {
                                                return .checkmark
                                            }
                            },
                                         isEnabled: {
                                            if #available(iOS 13.0, *) {
                                                return CBCentralManager().authorization == .notDetermined
                                            } else {
                                                return false
                                            }
                            }),
        ]),
        SectionViewModel(rows: [
            RowViewModel(title: "Contact Customer Support")
        ]),
        SectionViewModel(rows: [
            RowViewModel(title: "Sign out")
        ])
    ]
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return sections.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return sections[section].rows.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "Cell", for: indexPath)
        let row = sections[indexPath.section].rows[indexPath.row]
        
        cell.textLabel?.text = row.title
        cell.accessoryType = row.accessoryType
        if row.isEnabled {
            cell.selectionStyle = .default
            if #available(iOS 13.0, *) {
                cell.textLabel?.textColor = .label
            } else {
                cell.textLabel?.textColor = .black
            }
        } else {
            cell.selectionStyle = .none
            cell.textLabel?.textColor = .systemGray
        }
        
        return cell
    }
    
    func tableView(_ tableView: UITableView, titleForHeaderInSection section: Int) -> String? {
        return sections[section].title
    }
    
    func tableView(_ tableView: UITableView, titleForFooterInSection section: Int) -> String? {
        return sections[section].description
    }
}
