//
//  ViewController.swift
//  ExampleApp
//
//  Copyright © UJET. All rights reserved.
//

import UIKit
import CoreBluetooth
import CoreLocation
import UJETKit

class ViewController: UITableViewController {
    
    let dataSource = ViewDataSource()
    
    public private(set) lazy var locationManager: CLLocationManager = {
        let lm = CLLocationManager()
        lm.delegate = self
        return lm
    }()
    
    private var bluetoothManager: CBCentralManager?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        tableView.dataSource = dataSource
    }
    
    
    func launchUjet() {
//        do {
//            try self.customizeChatTheme()
//        } catch {
//            print(error.localizedDescription)
//        }

        let options = UJETStartOptions()
        options.skipSplashScreen = true
        UJET.start(with: options)
    }
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        
        switch indexPath.section {
        case 0:
            switch indexPath.row {
            case 0: locationManager.requestWhenInUseAuthorization()
            case 1: bluetoothManager = CBCentralManager(delegate: self, queue: nil)
            default: break
            }
        case 1:
            (UIApplication.shared.delegate as? AppDelegate)?.ujetDelegate.initCustomData()
            launchUjet()
        case 2:
            UJET.clearUserData()
        default: break
        }
    }

    func customizeChatTheme() throws {
        guard let file = Bundle.main.path(forResource: "chat-theme-custom", ofType: "json") else { return }
        let json = try String.init(contentsOfFile: file, encoding: .utf8)

        let chatTheme = UJETChatTheme.init(jsonString: json)

        let consumerAvatar = chatTheme?.consumerMessageBubble.avatar
        consumerAvatar?.image = UJETImageRef(assetName: "consumer_avatar_image")

        let quickReplyTheme = UJETChatQuickReplyButtonTheme()
        quickReplyTheme.style = .individual
        quickReplyTheme.alignment = .right
        quickReplyTheme.backgroundColor = UJETColorRef(assetName: "white_color")
        quickReplyTheme.backgroundColorForHighlightedState = UJETColorRef(assetName: "quick_reply_color")
        quickReplyTheme.textColor = UJETColorRef(assetName: "quick_reply_color")
        quickReplyTheme.textColorForHighlightedState = UJETColorRef(assetName: "white_color")

        let fontTheme = UJETFontTheme()
        fontTheme.family = "Arial Rounded MT Bold"
        fontTheme.size = 14
        quickReplyTheme.font = fontTheme

        chatTheme?.quickReplyButtonTheme = quickReplyTheme

        let globalTheme = UJETGlobalTheme()
        globalTheme.chatTheme = chatTheme
        globalTheme.defaultAgentImage = UIImage(named: "agent_avatar_image")
        globalTheme.font = UIFont(name: "Arial Rounded MT Bold", size: 14)

        UJET.setGlobalTheme(globalTheme)
    }
}

extension ViewController: CLLocationManagerDelegate {
    func locationManager(_ manager: CLLocationManager, didChangeAuthorization status: CLAuthorizationStatus) {
        tableView.reloadRows(at: [IndexPath(row: 0, section: 0)], with: .none)
    }
}

extension ViewController: CBCentralManagerDelegate {
    func centralManagerDidUpdateState(_ central: CBCentralManager) {
        tableView.reloadRows(at: [IndexPath(row: 1, section: 0)], with: .none)
    }
}
