//
//  UJETObject+DeepLink.swift
//  ExampleApp
//
//  Copyright © UJET. All rights reserved.
//

import Foundation
import UJETKit

extension UJETObject {
    func handleRouting(_ url: URL) -> Bool {
        let availableSchema = [
            "ujet", // custom URL scheme
            "https" // universal link
        ]
        let availableHostAndPath = [
            "call",         // custom URL scheme
            "ujet.co/app"   // universal link
        ]
        
        if !(availableSchema.contains(url.scheme ?? "")) {
            return false
        }
        
        let hostAndPath = String.init(format: "%@%@", url.host ?? "", url.path)
        if !(availableHostAndPath.contains(hostAndPath)) {
            return false
        }
        
        // ujet://call?call_id={call_id}&nonce={nonce}
        // https://ujet.co/app?call_id={call_id}&nonce={nonce}
        let urlComponents: URLComponents? = URLComponents(url: url, resolvingAgainstBaseURL: false)
        let queryItems = urlComponents?.queryItems
        let callId = value(forKey: "call_id", fromQueryItems: queryItems)
        
        // validate call id
        if !isValidCallId(callId) {
            return false
        }
        
        guard let nonce = value(forKey: "nonce", fromQueryItems: queryItems) else {
            return false
        }
        
        let options = UJETStartOptions.init(callId: callId!, nonce: nonce)
        
        UJET.start(with: options)
        
        return true
    }
    
    func value(forKey key: String?, fromQueryItems queryItems: [URLQueryItem]?) -> String? {
        let predicate = NSPredicate(format: "name=%@", key ?? "")
        let filtered = (queryItems as NSArray?)?.filtered(using: predicate) as? [URLQueryItem]
        let queryItem: URLQueryItem? = filtered?.first
        
        return queryItem?.value
    }
    
    func isValidCallId(_ callId: String?) -> Bool {
        if (callId ?? "").isEmpty {
            return false
        }
        
        let nonNumbers = CharacterSet.decimalDigits.inverted
        let r = callId?.rangeOfCharacter(from: nonNumbers)
        
        return r == nil
    }
}
