//
//  RowViewModel.swift
//  ExampleApp
//
//  Created by miles on 3/13/20.
//

import UIKit

typealias AccessoryClosure = () -> UITableViewCell.AccessoryType
typealias EnablementClosure = () -> Bool

struct RowViewModel {
    let title: String
    var accessoryType: UITableViewCell.AccessoryType { accessoryClosure?() ?? .none }
    var isEnabled: Bool { enablementClosure?() ?? true }
    
    private let accessoryClosure: AccessoryClosure?
    private let enablementClosure: EnablementClosure?
    
    init(title: String,
         accessoryType: AccessoryClosure? = nil,
         isEnabled: EnablementClosure? = nil) {
        self.title = title
        self.accessoryClosure = accessoryType
        self.enablementClosure = isEnabled
    }
}
