//
//  ViewDelegate.m
//  ExampleApp
//
//  Created by Jaesung Koo on 10/9/19.
//  Copyright © 2019 ujet. All rights reserved.
//

#import "AppDelegate.h"
#import "UJETObject.h"
#import "UJETObject+CustomData.h"
#import "ViewDelegate.h"

@import CoreLocation;
@import CoreBluetooth;

@interface ViewDelegate() <CLLocationManagerDelegate, CBCentralManagerDelegate>

@end

@implementation ViewDelegate {
    CLLocationManager *locationManager;
    CBCentralManager *bluetoothManager;
    UITableView *_tableView;
}

- (instancetype)init {
    self = [super init];
    if (self) {
        locationManager = CLLocationManager.new;
        locationManager.delegate = self;
    }
    return self;
}

- (void)startUJET {
    UJETStartOptions *options = [UJETStartOptions new];
    options.skipSplashScreen = YES; // skip splash screen
    options.unsignedCustomData = [((AppDelegate *)UIApplication.sharedApplication.delegate).ujetDelegate unsignedCustomData]; // Compose the custom data without signing

//    [self customizeChatTheme];

    [UJET startWithOptions:options];

    /// Start with menu key
//    options = [[UJETStartOptions alloc] initWithMenuKey:@"Key"];
//    [UJET startWithOptions:options];
}

- (void)customizeChatTheme {
    NSString *file = [[NSBundle mainBundle] pathForResource:@"chat-theme-custom" ofType:@"json"];
    NSString *json = [NSString stringWithContentsOfFile:file encoding:NSUTF8StringEncoding error:nil];

    UJETChatTheme *chatTheme = [[UJETChatTheme alloc] initWithJSONString:json];

    UJETChatAvatarTheme *consumerAvater = chatTheme.consumerMessageBubble.avatar;
    consumerAvater.image = [[UJETImageRef alloc] initWithAssetName:@"consumer_avatar_image"];

    UJETChatQuickReplyButtonTheme *quickReplyTheme = UJETChatQuickReplyButtonTheme.new;
    quickReplyTheme.style = UJETChatQuickReplyButtonStyleIndividual;
    quickReplyTheme.alignment = UJETChatQuickReplyButtonAlignmentRight;
    quickReplyTheme.backgroundColor = [[UJETColorRef alloc] initWithAssetName:@"white_color"];
    quickReplyTheme.backgroundColorForHighlightedState = [[UJETColorRef alloc] initWithAssetName:@"quick_reply_color"];
    quickReplyTheme.textColor = [[UJETColorRef alloc] initWithAssetName:@"quick_reply_color"];
    quickReplyTheme.textColorForHighlightedState = [[UJETColorRef alloc] initWithAssetName:@"white_color"];

    UJETFontTheme *fontTheme = UJETFontTheme.new;
    fontTheme.family = @"Arial Rounded MT Bold";
    fontTheme.size = 14;
    quickReplyTheme.font = fontTheme;

    chatTheme.quickReplyButtonTheme = quickReplyTheme;

    UJETGlobalTheme *theme = UJETGlobalTheme.new;
    theme.chatTheme = chatTheme;

    theme.defaultAgentImage = [UIImage imageNamed:@"agent_avatar_image"];
    theme.font = [UIFont fontWithName:@"Arial Rounded MT Bold" size:14];

    [UJET setGlobalTheme:theme];
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    _tableView = tableView;
    
    switch (indexPath.section) {
        case 0: {
            switch (indexPath.row) {
                case 0:
                    [locationManager requestWhenInUseAuthorization];
                    break;
                case 1:
                    bluetoothManager = [[CBCentralManager alloc] initWithDelegate:self queue:nil];
                    break;
                default:
                    break;
            }
        }
            break;
        case 1: {
            [((AppDelegate *)UIApplication.sharedApplication.delegate).ujetDelegate initCustomData];
            
            [self startUJET];
        }
            break;
        case 2: {
            [UJET clearUserData];
        }
            break;
        default:
            break;
    }
}

- (void)locationManager:(CLLocationManager *)manager didChangeAuthorizationStatus:(CLAuthorizationStatus)status {
    [_tableView reloadData];
}

- (void)centralManagerDidUpdateState:(CBCentralManager *)central {
    [_tableView reloadData];
}

@end
