//
//  ViewDataSource.m
//  ExampleApp
//
//  Created by Jaesung Koo on 10/9/19.
//  Copyright © 2019 ujet. All rights reserved.
//

#import "ViewDataSource.h"

@import CoreLocation;
@import CoreBluetooth;

@implementation ViewDataSource {
    NSArray *_data;
}

- (instancetype)init {
    self = [super init];
    if (self) {
        _data = @[
            @{
                @"sectionTitle": @"Grant Permissions",
                @"sectionDescription": @"Granted permission will be used an example of Custom Data. See \"Custom Data\" section of document for the detail.",
                @"rows": @[ @{
                                @"title": @"Allow Location",
                                @"accessoryType": ^NSInteger{
                                    return (CLLocationManager.authorizationStatus >= kCLAuthorizationStatusAuthorizedWhenInUse? 3 : 0);
                                },
                                @"enable": ^BOOL{
                                    return CLLocationManager.authorizationStatus == kCLAuthorizationStatusNotDetermined;
                                }
                },
                            @{
                                @"title": @"Allow Bluetooth",
                                @"accessoryType": ^NSInteger{
                                    if (@available(iOS 13, *)) {
                                        return CBCentralManager.new.authorization == CBManagerAuthorizationAllowedAlways? 3 : 0;
                                    } else {
                                        return 3;
                                    }
                                },
                                @"enable": ^BOOL{
                                    if (@available(iOS 13, *)) {
                                        return CBCentralManager.new.authorization == CBManagerAuthorizationNotDetermined;
                                    } else {
                                        return NO;
                                    }
                                }
                            } ]
            },
            @{
                @"rows": @[ @{
                                @"title": @"Contact Customer Support",
                                @"enable": ^BOOL{ return YES; }
                } ],
            },
            @{
                @"sectionDescription": @"Clear cached user data by UJET SDK",
                @"rows": @[
                        @{
                            @"title": @"Sign out",
                            @"enable": ^BOOL { return YES; }
                        }
                ]
            }
        ];
    }
    return self;
}

- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
    return _data[section][@"sectionTitle"];
}

- (NSString *)tableView:(UITableView *)tableView titleForFooterInSection:(NSInteger)section {
    return _data[section][@"sectionDescription"];
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return _data.count;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [_data[section][@"rows"] count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"Cell" forIndexPath:indexPath];
    
    NSDictionary *rowData = _data[indexPath.section][@"rows"][indexPath.row];
    cell.textLabel.text = rowData[@"title"];

    if (rowData[@"accessoryType"]) {
        cell.accessoryType = ((NSInteger (^)(void))rowData[@"accessoryType"])();
    }
    
    if (rowData[@"enable"] && ((BOOL (^)(void))rowData[@"enable"])()) {
        cell.selectionStyle = UITableViewCellSelectionStyleDefault;
        if (@available(iOS 13.0, *)) {
            cell.textLabel.textColor = UIColor.labelColor;
        } else {
            cell.textLabel.textColor = UIColor.blackColor;
        }
    } else {
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.textLabel.textColor = UIColor.systemGrayColor;
    }
    
    return cell;
}

@end
