//
//  UJETObject+DeepLink.m
//  ExampleApp
//
//  Copyright © UJET. All rights reserved.
//

#import "UJETObject+DeepLink.h"

@implementation UJETObject (DeepLink)

- (BOOL)handleRouting:(NSURL *)url {
    NSArray *availableSchema = @[
                                 @"ujet",   // custom URL scheme
                                 @"https"   // universal link
                                 ];
    NSArray *availableHostAndPath = @[
                                      @"call",          // custom URL scheme
                                      @"ujet.co/app"    // universal link
                                      ];
    
    if (![availableSchema containsObject:url.scheme]) {
        return NO;
    }
    
    NSString *hostAndPath = [NSString stringWithFormat:@"%@%@", url.host, url.path];
    if (![availableHostAndPath containsObject:hostAndPath]) {
        return NO;
    }
    
    // ujet://call?call_id={call_id}&nonce={nonce}
    // https://ujet.co/app?call_id={call_id}&nonce={nonce}
    NSURLComponents *urlComponents = [NSURLComponents componentsWithURL:url
                                                resolvingAgainstBaseURL:NO];
    NSArray *queryItems = urlComponents.queryItems;
    NSString *callId = [self valueForKey:@"call_id" fromQueryItems:queryItems];
    // validate call id
    if (![self isValidCallId:callId]) {
        return NO;
    }
    NSString *nonce = [self valueForKey:@"nonce" fromQueryItems:queryItems];
    
    UJETStartOptions *options = [[UJETStartOptions alloc] initWithCallId:callId nonce:nonce];
    
    [UJET startWithOptions:options];
    
    return YES;
}

#pragma mark - Private

- (NSString *)valueForKey:(NSString *)key fromQueryItems:(NSArray *)queryItems {
    NSPredicate *predicate = [NSPredicate predicateWithFormat:@"name=%@", key];
    NSURLQueryItem *queryItem = [[queryItems
                                  filteredArrayUsingPredicate:predicate]
                                 firstObject];
    return queryItem.value;
}

- (BOOL)isValidCallId:(NSString *)callId {
    if (callId.length == 0) {
        return NO;
    }
    
    NSCharacterSet* nonNumbers = [[NSCharacterSet decimalDigitCharacterSet] invertedSet];
    NSRange r = [callId rangeOfCharacterFromSet: nonNumbers];
    return r.location == NSNotFound;
}

@end
