//
//  AppDelegate.m
//  ExampleApp
//
//  Copyright © UJET. All rights reserved.
//

#import "AppDelegate.h"
#import "UJETObject+DeepLink.h"

@import PushKit;
@import UserNotifications;

@interface AppDelegate() <PKPushRegistryDelegate, UNUserNotificationCenterDelegate>

@end

@implementation AppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    [[NSUserDefaults standardUserDefaults] setObject:@{
                                                       @"identifier": @"user id",       // optional
                                                       @"name": @"user name",           // optional
                                                       @"email": @"user@example.com"    // optional
                                                       }
                                              forKey:@"user-data"];
    
    self.ujetDelegate = [UJETObject new];
    
    // Initialize UJET
    NSDictionary *infoDictionary = NSBundle.mainBundle.infoDictionary;
    NSString *companyKey = infoDictionary[@"UJETCompanyKey"];
    NSString *subdomain = infoDictionary[@"UJETSubdomain"];
    
    [UJET initialize:companyKey subdomain:subdomain delegate:self.ujetDelegate];
    [UJET setLogLevel:UjetLogLevelVerbose];
    
    // Register VoIP push
    PKPushRegistry *voipRegistry = [[PKPushRegistry alloc] initWithQueue: dispatch_get_main_queue()];
    voipRegistry.delegate = self;
    voipRegistry.desiredPushTypes = [NSSet setWithObject:PKPushTypeVoIP];
    
    // in case you are using UserNotifications.framework
//    UNUserNotificationCenter.currentNotificationCenter.delegate = self;
    
    return YES;
}

- (BOOL)application:(UIApplication *)app openURL:(NSURL *)url options:(NSDictionary<UIApplicationOpenURLOptionsKey, id> *)options {
    if ([url.scheme isEqualToString:@"ujet"]) {
        return [self.ujetDelegate handleRouting:url];
    }
    
    return NO;
}

- (BOOL)application:(UIApplication *)application continueUserActivity:(NSUserActivity *)userActivity restorationHandler:(void(^)(NSArray<id<UIUserActivityRestoring>> * __nullable restorableObjects))restorationHandler {
    // Universal links
    if ([NSUserActivityTypeBrowsingWeb isEqualToString:userActivity.activityType]) {
        return [self.ujetDelegate handleRouting:userActivity.webpageURL];
        
    } else if ([userActivity.activityType isEqualToString:@"INStartAudioCallIntent"]) {
        // Open app from Call history
        [UJET startWithOptions:nil];
        
        return YES;
    }
    
    return NO;
}

#pragma mark - Push Notification

- (NSString *)tokenFromData:(NSData *)data {
    const char *d = data.bytes;
    NSMutableString *token = [NSMutableString string];
    
    for (NSUInteger i = 0; i < data.length; i++) {
        [token appendFormat:@"%02.2hhX", d[i]];
    }
    
    return [[token copy] lowercaseString];
}

#pragma mark PushKit

- (void)pushRegistry:(PKPushRegistry *)registry didUpdatePushCredentials:(PKPushCredentials *)credentials forType:(PKPushType)type {
    NSLog(@"voip token: %@", [self tokenFromData:credentials.token]);
    
    if ([type isEqual:PKPushTypeVoIP]) {
        [UJET updatePushToken:credentials.token type:UjetPushTypeVoIP];
    }
}

- (void)pushRegistry:(PKPushRegistry *)registry didInvalidatePushTokenForType:(PKPushType)type {
    if ([type isEqual:PKPushTypeVoIP]) {
        [UJET updatePushToken:nil type:UjetPushTypeVoIP];
    }
}

- (void)pushRegistry:(PKPushRegistry *)registry didReceiveIncomingPushWithPayload:(PKPushPayload *)payload forType:(PKPushType)type withCompletionHandler:(void (^)(void))completion {
    if ([type isEqual:PKPushTypeVoIP] && payload.dictionaryPayload[@"ujet"]) {
        [UJET receivedNotification:payload.dictionaryPayload completion:completion];
    } else {
        completion();
    }
}

#pragma mark APNS

- (void)application:(UIApplication *)application didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken {
    NSLog(@"apns token: %@", [self tokenFromData:deviceToken]);
    
    [UJET updatePushToken:deviceToken type:UjetPushTypeAPN];
}

- (void)application:(UIApplication *)application didFailToRegisterForRemoteNotificationsWithError:(nonnull NSError *)error {
    [UJET updatePushToken:nil type:UjetPushTypeAPN];
}

- (void)application:(UIApplication *)application didReceiveRemoteNotification:(NSDictionary *)userInfo fetchCompletionHandler:(void (^)(UIBackgroundFetchResult))completionHandler {
    if (userInfo[@"ujet"]) {
        [UJET receivedNotification:userInfo completion:nil];
        
    } else {
        // handle yours
    }
}

#pragma mark UserNotifications

// handle push received in foreground state
- (void)userNotificationCenter:(UNUserNotificationCenter *)center willPresentNotification:(UNNotification *)notification withCompletionHandler:(void (^)(UNNotificationPresentationOptions))completionHandler {
    NSDictionary *userInfo = notification.request.content.userInfo;
    
   if (userInfo[@"ujet"] != nil) {
       [UJET receivedNotification:userInfo completion:nil];
       
   } else {
       // handle yours
   }
}

// handle push received and tapped in background state
- (void)userNotificationCenter:(UNUserNotificationCenter *)center didReceiveNotificationResponse:(UNNotificationResponse *)response withCompletionHandler:(void (^)(void))completionHandler {
    NSDictionary *userInfo = response.notification.request.content.userInfo;
    
    if (userInfo[@"ujet"] != nil) {
        [UJET receivedNotification:userInfo completion:nil];
        
    } else {
        // yours
    }
}

@end
