from scipy.stats import rice
import matplotlib.pyplot as plt
fig, ax = plt.subplots(1, 1)

# Calculate a few first moments:

b = 0.775
mean, var, skew, kurt = rice.stats(b, moments='mvsk')

# Display the probability density function (``pdf``):

x = np.linspace(rice.ppf(0.01, b),
                rice.ppf(0.99, b), 100)
ax.plot(x, rice.pdf(x, b),
       'r-', lw=5, alpha=0.6, label='rice pdf')

# Alternatively, the distribution object can be called (as a function)
# to fix the shape, location and scale parameters. This returns a "frozen"
# RV object holding the given parameters fixed.

# Freeze the distribution and display the frozen ``pdf``:

rv = rice(b)
ax.plot(x, rv.pdf(x), 'k-', lw=2, label='frozen pdf')

# Check accuracy of ``cdf`` and ``ppf``:

vals = rice.ppf([0.001, 0.5, 0.999], b)
np.allclose([0.001, 0.5, 0.999], rice.cdf(vals, b))
# True

# Generate random numbers:

r = rice.rvs(b, size=1000)

# And compare the histogram:

ax.hist(r, normed=True, histtype='stepfilled', alpha=0.2)
ax.legend(loc='best', frameon=False)
plt.show()
