from scipy.stats import poisson
import matplotlib.pyplot as plt
fig, ax = plt.subplots(1, 1)

# Calculate a few first moments:

mu = 0.6
mean, var, skew, kurt = poisson.stats(mu, moments='mvsk')

# Display the probability mass function (``pmf``):

x = np.arange(poisson.ppf(0.01, mu),
              poisson.ppf(0.99, mu))
ax.plot(x, poisson.pmf(x, mu), 'bo', ms=8, label='poisson pmf')
ax.vlines(x, 0, poisson.pmf(x, mu), colors='b', lw=5, alpha=0.5)

# Alternatively, freeze the distribution and display the frozen ``pmf``:

rv = poisson(mu)
ax.vlines(x, 0, rv.pmf(x), colors='k', linestyles='-', lw=1,
        label='frozen pmf')
ax.legend(loc='best', frameon=False)
plt.show()

# Check accuracy of ``cdf`` and ``ppf``:

prob = poisson.cdf(x, mu)
np.allclose(x, poisson.ppf(prob, mu))
# True

# Generate random numbers:

r = poisson.rvs(mu, size=1000)
