from scipy.stats import pareto
import matplotlib.pyplot as plt
fig, ax = plt.subplots(1, 1)

# Calculate a few first moments:

b = 2.62171653214
mean, var, skew, kurt = pareto.stats(b, moments='mvsk')

# Display the probability density function (``pdf``):

x = np.linspace(pareto.ppf(0.01, b),
              pareto.ppf(0.99, b), 100)
ax.plot(x, pareto.pdf(x, b),
         'r-', lw=5, alpha=0.6, label='pareto pdf')

# Alternatively, freeze the distribution and display the frozen pdf:

rv = pareto(b)
ax.plot(x, rv.pdf(x), 'k-', lw=2, label='frozen pdf')

# Check accuracy of ``cdf`` and ``ppf``:

vals = pareto.ppf([0.001, 0.5, 0.999], b)
np.allclose([0.001, 0.5, 0.999], pareto.cdf(vals, b))
# True

# Generate random numbers:

r = pareto.rvs(b, size=1000)

# And compare the histogram:

ax.hist(r, normed=True, histtype='stepfilled', alpha=0.2)
ax.legend(loc='best', frameon=False)
plt.show()
