from scipy.stats import cosine
import matplotlib.pyplot as plt
fig, ax = plt.subplots(1, 1)

# Calculate a few first moments:

mean, var, skew, kurt = cosine.stats(moments='mvsk')

# Display the probability density function (``pdf``):

x = np.linspace(cosine.ppf(0.01),
              cosine.ppf(0.99), 100)
ax.plot(x, cosine.pdf(x),
         'r-', lw=5, alpha=0.6, label='cosine pdf')

# Alternatively, freeze the distribution and display the frozen pdf:

rv = cosine()
ax.plot(x, rv.pdf(x), 'k-', lw=2, label='frozen pdf')

# Check accuracy of ``cdf`` and ``ppf``:

vals = cosine.ppf([0.001, 0.5, 0.999])
np.allclose([0.001, 0.5, 0.999], cosine.cdf(vals))
# True

# Generate random numbers:

r = cosine.rvs(size=1000)

# And compare the histogram:

ax.hist(r, normed=True, histtype='stepfilled', alpha=0.2)
ax.legend(loc='best', frameon=False)
plt.show()
